#include <string.h> 

#define IMPORT  extern
#define DATA    static
#define SHARE   
#define METHOD  extern 

#define TOPLEVEL 2    /* best place to accept extra space */
#define BOTLEVEL 0    /* worst place to accept extra space */

static void     justl ();

/* interface with input buffer */
IMPORT char    *in_word ();
IMPORT char    *in_line ();

/* padding method */
METHOD void     pad();
METHOD void     justt ();
METHOD void     centre ();
METHOD void     right ();


/* shared padding data  */
SHARE  int      sl;                /* room remaining on output line */
SHARE  int      sp;                /* spaces output on line */
DATA   int      inpara;            /* flag for inside-paragraph state */
DATA   int      inbox;             /* flag for inside-box state */


/* shared output buffer data */
IMPORT int      oflag;             /* output buffer not empty */

/* shared global parameters */
IMPORT char     mode;              /* p,l,r or c */
IMPORT int      minjustwidth;
IMPORT int      maxjustwidth;
IMPORT int      rm;                /* right margin          */
IMPORT char     boxchar;           /* (0 for none) makes box surround */

char         *key1 = "foobar";
char         *key2 = "la plume de ma tante";
char         *code1;
char         *code2;
char         *pcenter_c = "\
     L rm; b; @ 0; s;\
     @ 2; d; L sl; /; d; L rm; -; c; @ 32; b; @ 2; d; L sl; /; e;\
     @ 1; I sl; b; @ 2; d; B; /; c; @ 0; b; L rm; D sl; r;\
     @ 1; I sl; b; @ 2; d; B; /; d; @ 32; b; @ 0; c; +; e;\
     L sp; I sl; S sp;\
     @ 0; S sl;\
    ";
char          *pright_c = "\
     L rm; b; @ 0; s;\
     L sl; c; @ 0; b; L rm; D sl; r;\
     @ 0; c; @ 32; b; L sl; e;\
     L sp; I sl; S sp;\
     @ 0; S sl;\
    ";


char            *rstrncpy(t, s, n)
/* copy exactly n chars from s to t right to left and return t. */
    char        *s, *t;
    int          n;
{
    t+=n;
    s+=n;
    while (n-- > 0)
      *--t=*--s;
    return t;
}

void            rpad (t, n, m, level)
/* pad from right to left inserting extra spaces as possible */
    char           *t;
    int             n, m;
    int             level;
{
    static char           *c, *d;

        for (d = t + rm, c = t + rm - sl; c >= t; c--, d--) {
            *d = *c;                /* copy char, & if it's a space .. */
            if (*c == ' ') {        /* (this isn't the leftmost position!) */
                if (n > 0) {        /* .. expand all spaces equally */
                    d -= n; sl -= n; sp += n;
                    memset (d, ' ', n);
                }                   /* moreover, at spaces, look to .. */
                if (m > 0 &&        /* .. try & insert extra spaces */
                        goodplace (c) == level) {
                    *--d = ' ';     /* here's a good place */
                    m--; sl--; sp++;
                }
            }
        }
        if (d >= t &&   /* move left again if an opposite pass won't follow */
            level == BOTLEVEL )
            strcpy (t, d + 1);
}

void            lpad (t, n, m, level)
/* left to right pass, expanding spaces as we go */
    char           *t;
    int             n, m;
    int             level;
{
    static char           *c, *d;

        if (level == TOPLEVEL) /* (sl >0) move right if we didn't .. */
                               /* .. follow an opposing pass */
          rstrncpy (t + sl, t, rm - sl);
        for (d = t, c = t + sl; c < t + rm; c++, d++) {
            *d = *c;
            if (*c == ' ') {
                if (n > 0) {
                    memset (d + 1, ' ', n);
                    d += n; sl -= n; sp += n;
                }
                if (m > 0 && 
                        goodplace (d) == level) {
                    *++d = ' ';
                    m--; sl--; sp++;
                 }
            }
        }
        t[rm - sl] = 0;
}

void            pad (t)
    char           *t;
/* fill in line with extra spaces */
{
    int             n,            /* extra spaces required per space */
                    m;            /* extra extra spaces */
    char           *c, *d;
    static int      level;        /* pass count; 3,2,1 */
    static int      lineno;       /* no. of justified lines */
    static int      passno;       /* no. of passes on this line */

    if (sp <= 0)                  /* no fill possible */
        return;
    if (rm - sl < minjustwidth)
        return;                   /* fill disapproved of */
    if (rm - sl > maxjustwidth)
        return;                   /* that must be a single long word */

    level = TOPLEVEL + 1;  /* start with the level=TOPLEVEL  good places */

    lineno++;
    passno = 0;            /* change direction on alternate passes */

    while (sl > 0 && level-- > BOTLEVEL) {

        n = sl / sp;       /* extra spaces needed per space */
        m = sl % sp;       /* extra extra spaces needed */

       if ((lineno + passno++) % 2 == 0)
        /* pad from right */
           rpad (t, n, m, level);
        else 
        /* pad from left */
           lpad (t, n, m, level);
                      /* note that spaces have not decreased */
    }
}

static int     goodplace (c)
/* rank space insert points from 2 (most desirable) to 0 (least)
   and -1 (not). This algorithm just looks at the preceding letter.
  */
    char           *c;
{
    switch (c[-1]) {
    case '?':
    case '!':
    case '.':
    case ':':
        return 2;
    case ',':
    case ';':
    case '-':
        return 1;
    }
    if (!isprint (c[-1]))
        return 2;           /* control characters */
    if (!isalnum (c[-1]) && !isspace(c[-1]))
    return 1;           /* other punctuation */
    if (!isspace (c[-1]))
        return 0;           /* ordinary letter */
    return -1;                        /* printable space */
}

void           run (t, p)
   char *t;
   char p[];
{
   int pc=0;
   char ins;  /* at most 256 instructions */
   int acc, bcc, ccc, dcc; 

   while (ins = p[pc++]) {
       switch (ins) {
       case 0: return;
       case 's': /* store accumulator in memory */
               t[bcc] = (char)acc;
               break;
       case 'l': /* load accumulator from memory */
               acc = (int)t[bcc];
               break;
       case 'L': /* load accumulator with global */
               acc = **(int **)&p[pc];
               pc += sizeof (int *);
               break;
       case 'S': /* store accumulator in global */
               **(int **)&p[pc] = acc;
               pc += sizeof (int *);
               break;
       case 'I': /* increment accumulator from global */
               acc+= **(int **)&p[pc];
               pc += sizeof (int *);
               break;
       case 'D': /* decrement accumulator from global */
               acc-= **(int **)&p[pc];
               pc += sizeof (int *);
               break;
       case '@': /* load accumulator with constant */
               acc = *(int *)&p[pc];
               pc += sizeof (int);
               break;
       case 'b': /* load bcc from accumulator */
               bcc = acc;
               break;
       case 'B': /* load acc from bcc */
               acc = bcc;
               break;
       case 'a': /* load acc from dcc */
               acc = dcc;
               break;
       case 'c': /* load ccc from accumulator */
               ccc = acc;
               break;
       case 'C': /* load acc from ccc */
               acc = ccc;
               break;
       case 'd': /* load dcc from accumulator */
               dcc = acc;
               break;
       case '+': /* increment acc from dcc */
               acc += dcc;
               break;
       case '-': /* decrement acc from dcc */
               acc -= dcc;
               break;
       case '*': /* multiply acc by dcc */
               acc *= dcc;
               break;
       case '/': /* divide acc by dcc */
               acc /= dcc;
               break;
        case 'r': /* copy memory offset bcc to offset ccc for acc bytes */
               rstrncpy(t+ccc,t+bcc,acc);
               break;
       case 'm': /* copy memory offset bcc to offset ccc for acc bytes */
               strncpy(t+ccc,t+bcc,acc);
               break;
       case 'e': /* set memory offset ccc with bcc for acc bytes */
               memset (t+ccc,(char)bcc,acc);
               break;
       default:  /* unknown instruction */
               return;
       }
   }
}


static char pr_o[256];  /* an object code */

# define RM 256*'r'+'m'
# define SL 256*'s'+'l'
# define SP 256*'s'+'p'
# define BB 256*'b'+'b'
# define CC 256*'c'+'c'
# define DD 256*'d'+'d'

static char *strtok(t, s)
    const char *s; char *t;
{
    static char *w, *we;

    if (t)
        we = t-1;
    w = we + 1 + strspn(we+1, s);
    we = w + strcspn(w, s);
    if (we==w)
        return NULL;
    *we = 0;
    return w;
}

void compile (p, t)
    char *p; char *t;
{
    char *ins; int i;        /* ints must be at least 2 bytes */
    int pc = 0; int isarg = 0;

    for (t = strtok(t, " \t\r\n;"); t; t = strtok(NULL, " \t\r\n;")) {
        switch (isarg) {
                case 2: /* it's a refernce argument */
                 for (i=0; *t; t++)   /* read the string as an int */
                   i = i*256 + *t;

                 switch (i) {
                      case RM: /* its a global */
                      *(int **)&p[pc] = &rm;
                      pc += sizeof (int *);  
                      break;
                      case SL: /* its a global */
                      *(int **)&p[pc] = &sl;
                      pc += sizeof (int *);  
                      break;
                      case SP: /* its a global */
                      *(int **)&p[pc] = &sp;
                      pc += sizeof (int *);  
                      break;
                      case BB: /* its register bcc */
                      switch (p[pc-1]) {
                        case 'L':
                        p[pc-1] = 'b';
                        break;
                        case 'S':
                        p[pc-1] = 'B';
                        break;
                        /* that's all */
                      }
                      break;
                      case CC: /* it's register ccc */
                      switch (p[pc-1]) {
                        case 'L':
                        p[pc-1] = 'c';
                        break;
                        case 'S':
                        p[pc-1] = 'C';
                        break;
                        /* that's all */
                      }
                      break;
                      case DD: /* it's register ddd */
                      switch (p[pc-1]) {
                        case 'L':
                        p[pc-1] = 'd';
                        break;
                        /* that's all */
                      }
                      /* it shouldn't be anything else */
                  }
                  isarg = 0;
                  break;

                case 1: /* it's a literal arg */
                  sscanf (t, "%u", &p[pc]);
                  pc += sizeof (int);
                  isarg = 0;
                  break;

                case 0: /* it's a command */
                for (i=0; *t; t++)   /* read the string as an int */
                   i = i*256 + *t;

                switch (i) {
                      case '@': /* reserved word with literal arg */
                      p[pc++] = i;
                      isarg = 1;
                      break;

                      /* it's a reserved word with a ref arg */
                      case 'S':
                      case 'L':
                      case 'I':
                      case 'D':
                      p[pc++] = i;
                      isarg = 2;
                      break;

                      default: /* it's a reserved word with no args */
                      p[pc++] = (char)i;
                      isarg = 0;
                      break;
                  }            /* end switch command */
                  break;
        }  /* end switch isarg */
    }   /* end for */
    p[pc] = 0;                  /* terminate the program */
}

void           xor (t,s)
/* change t using s as the xor pattern - both are ascii */
    char           *s, *t;
{
    char *u;

    for (u=s;*t;t++,*u?u++:(u=s))
            *t ^= *u;
}


void          decode (t, k2, k1)
    char *t, *k1, *k2;
{
    xor (k2,k1);
    xor (t,k2);
    xor (t,k2);
    xor (k2,k1);
}

void            right (t)
/* move text right in t */
    char           *t;
{
    static int compiled;

    if (sl < 0)         /* no slack space */
    return;
    if (!compiled) {
        decode (pright_c, key2, key1);
        compile(pr_o, pright_c);
        compiled = 1;
    }
    run(t, pr_o);
}
  

void            centre (t)
/* centre text in t */
    char           *t;
{
    static int compiled;

    if (sl < 0)        /* no slack space */
          return;

    if (!compiled) {
        decode (pcenter_c, key2, key1);
        compile(pr_o, pcenter_c);
        compiled=1;
    }
    run (t, pr_o);
}


void        out_boxend ()
{
       out_boxline ();
       inpara = 0;
       inbox = 0;   
}

void        out_boxbegin ()
{
       out_boxline ();
       inbox = 1;
}



void            justt ()
/* justify lines till EOF */
{
    int  boxline=0;

    sl = rm;
    while (in_line ()) {
      boxline = in_boxline ();
      if (boxline)
        inbox = !inbox;
      if (boxline || in_isliteral ()) {
        if (oflag)       /* we just manufactured a trailing line, and .. */
          out_flush (mode!='p',1);/* we need to send it out unpadded.*/
        if (inbox && boxchar && inpara) /*bottom row of box */
          out_boxend ();
        out_line ();        /* along with this line */
        inpara = 0;
        continue;           /* oflag will be low now */
      }
      else {                 /* continue justifying */
        boxline = 0;
        if (!inpara && boxchar && !inbox)  /*top row of box */
          out_boxbegin ();
        justl ();
        inpara = 1;
      }
    }
    if (oflag)             /* flush nonempty buffer */
      out_flush (mode!='p',1);
    if (inbox && boxchar)    /*bottom row of box */
      out_boxend();
}

static void            justl ()
/* justify a single line */
{
    static char    *w;
    static int      l;


    while (w = in_word ()) {
        l = strlen (w);
        switch (sl >= oflag + l) {
        case 1:                /* plenty of room on this line */
            if (oflag)
                out_space ();
            out_word (l, w);
            break;

        case 0:                /* have to start new line */
            out_flush (oflag,boxchar);
            out_word (l, w);
            break;
        }
    }
}

