;
;			      FLAGS
;

codeseg		segment
		assume	cs:codeseg, ds:codeseg


		org	100h

flags		proc	far

start:		jmp	Main_1

XT_FCB:					; search (extended) FCB
		db	0FFh		; flag byte for	extended FCB
		db	0, 0, 0, 0, 0	; reserved bytes
search_attr	db	27h		; search attribute byte
drive_no	db	0		; drive	number (0 = default)
		db	8 dup(0)	; filename
		db	3 dup(0)	; file extension
		db	25 dup (0)	; various info (we won't need)

DTA_FCB:				; DTA, to receive new FCB from
		db	0FFh		;  Find	First and Find Next
		db	0, 0, 0, 0, 0
f_attr		db	0
f_drive		db	0
f_name		db	8 dup(0)
f_ext		db	3 dup(0)
		db	25 dup (0)

file_count	dw	0
msg_1		db	0Dh, 0Ah, 'FLAGS: File not found$', 0Dh, 0Ah
msg_2		db	0Dh, 0Ah, 'Unable to change flags on file $', 0Dh, 0Ah
msg_3		db	0Dh, 0Ah, 'Invalid flag	value given$', 0Dh, 0Ah
		db	8 dup (0)
flag_chars	db	'R', 1,	'A', 020h, 'S',	4, 'H',	2, 0, 0, 0, 0, 0, 0
    ; (alternate with attribute	bytes)	(0 is used as a	marker here)

pathname:				; ASCIIZ pathname for attr change
drv		db	0		;  goes	here.
		db	':'
file_name	db	13 dup (0)

curr_drive	db	0
new_attr	dw	0


Main_1:
		mov	ah,19h		; get logged drive into	al
		int	21h
		inc	al		; incr (necessary)
		mov	curr_drive,al	; and save it.
		call	get_flags	; gets flags from command line
		jc	Main_2		; error	return
		call	change_attr	; principle function - gets file names
					; using	find first/next	FCB, then
					; changes (or resets) the attributes.

Main_2:
		cmp	file_count,0	; no files found ?
		jne	Exit
		mov	dx,offset msg_1
		mov	ah,9
		int	21h

Exit:
		int	20h

flags		endp


;		SUBROUTINE
;		get flags from command line

get_flags	proc	near
		mov	si,082h		; point	si at 1st arg char
		mov	cl,[si-2]	; load cl with char count
		xor	ch,ch

flagloop1a:
		cmp	byte ptr [si],20h	; look for first non-
		jne	flagloop1b		; space, if not
		inc	si			; already found
		loop	flagloop1a
		jmp	short flags_OK_ret	; no flags ? OK.

flagloop1b:
		cmp	byte ptr [si],0Dh	; check	for eoln
		je	short flags_OK_ret	; no flags is ok.
		cmp	byte ptr [si],20h
		je	flagloop2
		inc	si		; continue - this skips	over the
		loop	flagloop1b	; required file	name argument
					; (if it was given).
		jmp	short flags_OK_ret	; no flags

flagloop2:
		inc	si			; continue to input chars
		cmp	byte ptr [si],20h	; now we skip over spaces
		jne	flags2
		loop	flagloop2
		jmp	short flags_OK_ret	; no more flags
flags2:
		cmp	byte ptr [si],0Dh
		je	flags_OK_ret		; no more flags

flagloop3:
		mov	di,offset flag_chars	; table	of flag	chars
		mov	al,[si]			; si should point to one
		call	upcase
flagsck:
		cmp	al,[di]			; check	first flag
		je	flagfound
		cmp	byte ptr [di],0		; marker for end of flag list
		je	flags_bad_ret		; invalid flag - error return
		inc	di
		inc	di			; skip over attr byte
		jmp	flagsck			; continue
flagfound:
		inc	di			; flag match found
		mov	al,[di]			; incr di to attr byte
		or	byte ptr new_attr,al	; save attr by 'or'ing
flagloop3a:
		inc	si			; move si to next input	char
		cmp	byte ptr [si],0Dh	; check	for eoln
		je	flags_OK_ret		; exit with clc	if found
		cmp	byte ptr [si],020h
		jne	nextflag
		loop	flagloop3a		; loop over spaces
		jmp	short flags_OK_ret	; no more flags
nextflag:
		loop	flagloop3		; continue getting chars

flags_OK_ret:
		clc
		ret
flags_bad_ret:
		mov	dx,offset msg_3		; invalid flag message
		mov	ah,9
		int	21h
		stc				; error	return
		ret

get_flags	endp


;
;		SUBROUTINE
;		Find first and find next using FCB, then change	attributes

change_attr	proc	near
		mov	si,5Ch		; drive	# and file name	in PSP
		mov	di,offset drive_no	; file name offset in search FCB
		mov	cx,25h		; char count (up to 81h)
		cld
		rep	movsb		; xfer drive # and file	name
		mov	dx,offset DTA_FCB	; disk transfer	address
		mov	ah,1Ah		;  set here
		int	21h

		mov	ah,11h		; Find First using FCB
find:
		mov	dx,offset XT_FCB	; point	ds:dx to search	FCB
		int	21h
		or	al,al		; test al for 0	(success)
		jz	chg1
		ret			; return from here when	no more	files
chg1:
		call	xfer_pathname	; xfer file name from the FCB created
					; by Find First	or Find	Next.
		mov	dx,offset pathname	 ; ASCIIZ pathname offset
		mov	ah,43h		; get/set file attribute
		mov	al,1		; al = 1 means 'set'
		mov	cx,new_attr	; new attribute
		int	21h		; doit

		jnc	chg2		; success, jump	over error rtn
		call	flags_err
chg2:
		inc	file_count	; increment file count here
		mov	ah,12h		; Find Next using FCB
		jmp	find		;  continue ...

change_attr	endp


;		SUBROUTINE
;		transfer pathname to ASCIIZ holding area

xfer_pathname	proc	near
		mov	si,offset f_name	 ; file	name from search
		mov	di,offset file_name	 ; ASCIIZ holding area
		mov	cx,8		; filename char	count

xferloop_1:
		lodsb			; load first char into al
		cmp	al,20h		; space	here means end of name
		je	xfer1		; so jump, or
		stosb			; save the char	at es:di
		loop	xferloop_1	; continue

xfer1:
		mov	al,2Eh		; '.' char
		stosb			; insert at holding area
		mov	cx,3		; char count for extension
		mov	si,offset f_ext		; offset for ext

xferloop_2:
		lodsb			; get char into	al
		cmp	al,20h		; if space, done
		je	xfer2
		stosb			; else save it
		loop	xferloop_2	; and continue...

xfer2:
		xor	al,al		; 0 al
		stosb			; place	'null' terminator at the
					; end of the file name
		mov	si,offset f_drive	; drive	designation in created
						; FCB
		mov	al,[si]		; place	in al and compare it with 0
		cmp	al,0		;  (0 indicates	'default drive')
		jne	xfer3		; if not 'default', skip next
		mov	al,curr_drive	; get current drive (saved before)
xfer3:
		add	al,40h		; otherwise, add 040h to make ASCII
		mov	drv,al		; place	drive letter at	start of name
		ret			; and return.
xfer_pathname	endp


;		SUBROUTINE
;		flags_err

flags_err	proc	near
		mov	dx,offset msg_2		; flags	error msg
		mov	ah,9			; output
		int	21h
		mov	si,offset pathname	; pathname (set	up in
						;  xfer_pathname routine)
pname_loop:	lodsb			; [si] into al
		or	al,al		; check	for 0 (null terminator)
		jz	flags_err_ret	; - if found, return
		mov	ah,2		; output file name char	by char
		mov	dl,al
		int	21h
		jmp	pname_loop
flags_err_ret:	ret
flags_err	endp


;		SUBROUTINE
;		upper case

upcase		proc	near
		cmp	al,61h		; is char < 'a'	?
		jb	upcase_ret
		cmp	al,7Ah		; is char > 'z'	?
		ja	upcase_ret
		sub	al,20h		; no, it's a lower case	char,
					;  so fix it.
upcase_ret:
last_line:					; (last	line of	pgm)
		ret
upcase		endp


codeseg		ends

		end	start
