/*-------------------------------------------------------*/
/*                                                       */
/*   Calendar.h: Header file for Calendar.cpp            */
/*-------------------------------------------------------*/

#if ! defined( __CALENDAR_H ) && defined(Uses_TCalendar)
#define __CALENDAR_H


class TRect;
class TEvent;

class TCalendarView : public TView
{

public:

    TCalendarView(TRect & r);
    TCalendarView( StreamableInit ) : TView(streamableInit) { };
    virtual void handleEvent(TEvent& event);
    virtual void draw();

private:

    unsigned days, month, year;
    unsigned curDay, curMonth, curYear;

    virtual const char *streamableName() const
        { return name; }

protected:

    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const name;
    static TStreamable *build();
};

inline ipstream& operator >> ( ipstream& is, TCalendarView& cl )
    { return is >> (TStreamable&) cl; }
inline ipstream& operator >> ( ipstream& is, TCalendarView*& cl )
    { return is >> (void *&) cl; }

inline opstream& operator << ( opstream& os, TCalendarView& cl )
    { return os << (TStreamable&) cl; }
inline opstream& operator << ( opstream& os, TCalendarView* cl )
    { return os << (TStreamable *) cl; }


class TCalendar : public TWindow
{

public:

    TCalendar();
    TCalendar( StreamableInit ) :
        TWindow(streamableInit), TWindowInit(&TCalendar::initFrame) { };

private:

    virtual const char *streamableName() const
        { return name; }

protected:

    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TCalendar& cl )
    { return is >> (TStreamable&) cl; }
inline ipstream& operator >> ( ipstream& is, TCalendar*& cl )
    { return is >> (void *&) cl; }

inline opstream& operator << ( opstream& os, TCalendar& cl )
    { return os << (TStreamable&) cl; }
inline opstream& operator << ( opstream& os, TCalendar* cl )
    { return os << (TStreamable *) cl; }

#endif      // __CALENDAR_H
