#ifndef __cplusplus
#error TVGraph only compiles under C++ - same as TV itself
#endif

#ifndef _TVG_H
#define _TVG_H

#define Uses_TCollection
#define Uses_TEventQueue
#define Uses_TObject
#define Uses_TPoint
#define Uses_TProgram
#define Uses_TRect
#define Uses_TScreen
#define Uses_TSystemError
#define Uses_TView
#define Uses_TWindow
#include <tv.h>

#define GraphXMax 10000
#define GraphYMax  7500

#define Yes 1
#define No 0

#define smVGA320x200x16 0x00D
#define smVGA640x200x16 0x00E
#define smVGA640x350x16 0x010
#define smVGA640x480x16 0x012
#define smVesa800x600x16 0x102
#define smVesa1024x768x16 0x104
#define smVesa1280x1024x16 0x106

#define smUseBGIInterface 0x200
#define smUseTVGInterface 0x000

#define cmGraphDraw 191
#define cmGraphProd 192
#define cmGraphClear 193

typedef unsigned char byte;

struct XYLoc {ushort X;
              ushort Y;
            };

extern int TVGStartMode;
extern byte CurrentGraphWindow;
extern XYLoc GraphMouseLoc;

extern int VESA16;
extern byte Prodable;

extern void cdecl DrawLine(ushort x1, ushort y1,ushort x2,ushort y2, ushort color);
// Draw a Line in screen co-ordinates of color Color
extern void cdecl GlobalToPhysical(TRect R,int X0,int Y0,int *X,int *Y);
// Translate 10000x7500 co-ordinate in R to physical co-ordinate


// New graphics objects

class gObject : public TObject {
public:
    gObject(void)  { Color=0; }
    gObject(byte C) { Color=C; };
    virtual void GraphDraw(TRect& R) = 0;
    virtual void GraphProd() { };
    void ChangeColor(byte C) { Color=C; };

    byte Color;
};

class gLine : public gObject {
public:
    gLine(void) : gObject(0) {Xa=Xb=Ya=Yb=0; };
    gLine(int X1,int Y1,int X2,int Y2,byte C);
    virtual void GraphDraw(TRect& R);
    void ChangeEnds(int X1,int Y1,int X2,int Y2);
    void ChangeEnds(gLine S);
    void DeltaEnds(int X1,int Y1,int X2,int Y2);
    int Xa,Ya,Xb,Yb;
};

class gBox : public gLine {
public:
    gBox(void) : gLine() {};
    gBox(int X1,int Y1,int X2,int Y2,byte C);
    virtual void GraphDraw(TRect& R);
};


// New graphics Views

class gView : public TView {
public:
    gView( const TRect& bounds );
    ~gView();

    void Insert(gObject *P);
    void Delete(gObject *P);
    virtual void GraphProd();
    virtual void GraphDraw();
    void GraphClear();

    virtual void draw();
    virtual void handleEvent(TEvent& event);
    virtual void changeBounds( const TRect& bounds );

    byte GraphWindowId;
    TNSCollection *DisplayList;
};

class gWindow : public TWindow {
public:
    gWindow( const TRect& bounds,
                const char *aTitle,
                short aNumber);
    ~gWindow();

    virtual void handleEvent(TEvent& event);
    virtual void changeBounds( const TRect& bounds );

    void GraphDraw();
    void GraphClear();
    void GraphProd();
};

#endif
