{$A+,B-,D+,E+,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V+,X+}
{$M 16384,0,655360}

{
MAP.PAS
Demonstrates 	- PCX loading
		- palette mapping
		- translucency (transparency)

Notice sprite is loaded only once.  What changes are the map and transparency.
}


uses	crt,uve32;

const	maxspheres=5;

type	spheretype=record
		x,y,
		forcex,forcey:longint;
	end;

var	sphere:array[1..maxspheres] of spheretype;

procedure init;
var	i:integer;
begin
	ia_inituve;
	ia_loadpcx(background,'wacky.pcx',255);
	ia_loadspr('3ball.uvs',1);
	ia_powerup;
	ia_setpalette(pcxpal);
	ia_setcycletime(40);
	ia_makeshadowmap(pcxpal,70,maparray[1]);
	ia_makeshadowmap(pcxpal,130,maparray[2]);
	for i:=1 to maxspheres do with sphere[i] do begin
		x:=longint(random(320))*256;
		y:=longint(random(180))*256;
		forcex:=(longint(random(10))-5)*256;
		forcey:=(longint(random(10))-5)*256;
		spr[i].n:=1;
	end;
	spr[2].map:=1;
	spr[3].map:=1;
	spr[3].transparent:=true;
	spr[4].map:=2;
	spr[5].map:=2;
	spr[5].transparent:=true;
end;

procedure deinit;
begin
	ia_shutdown;
	halt;
end;


procedure movespheres;
var	i:integer;
begin
	for i:=1 to maxspheres do with sphere[i] do begin
		inc(x,forcex);
		inc(y,forcey);
		if (y>200*256) and (forcey>0) then
			forcey:=-forcey
			else inc(forcey,64);
		if (x<0) and (forcex<0) then forcex:=-forcex;
		if (x>320*256) and (forcex>0) then forcex:=-forcex;
		ia_center(i,x div 256,y div 256,2);
	end;
end;

begin
	init;
	repeat
		movespheres;
		ia_doframe;
	until keypressed;
	deinit;
end.