(*****************************************************************************

  Program:  Window demonstration

  Purpose:
    This program demonstrates the various abilities of the windows unit.

  Features:
    This program displays how the windows may operate and how they move about
      the screen.

  Copyright 1990, All rights reserved.
    P. Renaud.

  Compilers:
    Turbo Pascal versions 4.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2

*****************************************************************************)

Program Window_Demonstration_Program( Input, Output );

  Uses
    CRT, Windows;

  Var
    Counter: Word;
    Flag: Boolean;

  Begin
    WriteLn( 'Demonstration program for Windows unit.' );
    WriteLn( 'Copyright 1990, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program demonstrates some of the abilities of the Window unit.' );
    WriteLn( 'A series of windows will open up on the screen followed by a dancing.' );
    WriteLn( 'window which will eventually stop.  Another window will pop up, allowing' );
    WriteLn( 'you to browse through it.  Pressing Enter or Escape will close the' );
    WriteLn( 'window and the others will follow.' );
    WriteLn;
   {$IFNDEF OS2}
    WriteLn( 'Note:  This program will execute rapidly on a fast system so don''t blink.' );
   {$ENDIF}
    WriteLn;
    WriteLn( 'Please press [enter] to continue.' );
    ReadLn;

    Delay_Amount := 1;
    DirectVideo := True;

   {$IFNDEF OS2}
    TextAttr := Yellow_Character + Blue_Background;
   {$ELSE}
    TextColor( Yellow_Character );
    TextBackground( Blue_Background );
   {$ENDIF}

    For Counter := 1 to 200 do
      Write( 'Background ' );

    If Open_Window( Frame_1, Window_Pop, 7, 5, 16, 14, Black_Character + Green_Background )
     then
      Begin
       Label_Window( Green_Character + Black_Background, ' Pop ' );
       For Counter := 1 to 100 do
         Write( 'Pop ');
       If Open_Window( Frame_2, Window_Down, 10, 10, 20, 20, Magenta_Character + Yellow_Background )
        then
         Begin
          Label_Window( Yellow_Character + Magenta_Background, ' Down ' );
          For Counter := 1 to 100 do
            Write( 'Down ');
          If Open_Window( Frame_3, Window_Up, 17, 6, 23, 12, Red_Character + White_Background )
           then
            Begin
             Label_Window( White_Character + Red_Background, ' Up ' );
             For Counter := 1 to 100 do
               Write( 'Up ');
             If Open_Window( Frame_4, Window_Right, 2, 4, 67, 13, Blue_Character + Yellow_Background )
              then
               Begin
                Label_Window( Yellow_Character + Blue_Background, ' Right ' );
                For Counter := 1 to 100 do
                  Write( 'Right ' );
                If Open_Window( Frame_5, Window_Left, 6, 8, 16, 20, Black_Character + Red_Background )
                 then
                  Begin
                   Label_Window( Red_Character + Black_Background, ' Left ' );
                   For Counter := 1 to 100 do
                     Write( 'Left ' );
                   If Open_Window( Frame_6, Window_Horizontal, 7, 11, 56, 15, Cyan_Character + Yellow_Background )
                    then
                     Begin
                      Label_Window( Yellow_Character + Cyan_Background, ' Horizontal ' );
                      For Counter := 1 to 100 do
                        Write( 'Horizontal ' );
                      If Open_Window( Frame_7, Window_Vertical, 15, 11, 36, 19, Blue_Character + Red_Background )
                       then
                        Begin
                         Label_Window( Red_Character + Blue_Background, ' Vertical ' );
                         For Counter := 1 to 100 do
                           Write( 'Vertical ' );
                         If Open_Window( Frame_8, Window_Down_Left, 19, 6, 60, 24, Green_Character + White_Background )
                          then
                           Begin
                            Label_Window( White_Character + Green_Background, ' Down left ' );
                            For Counter := 1 to 100 do
                              Write( 'Down-Left ' );
                            If Open_Window( Frame_9, Window_Down_Right, 15, 11, 65, 20, Black_Character + Red_Background )
                             then
                              Begin
                               Label_Window( Red_Character + Black_Background, ' Down Right ' );
                               For Counter := 1 to 100 do
                                 Write( 'Down-Right ' );
                               If Open_Window( Frame_10, Window_Up_Left, 40, 7, 68, 17, Blue_Character + Black_Background )
                                then
                                 Begin
                                  Label_Window( Black_Character + Blue_Background, ' Up Left ' );
                                  For Counter := 1 to 100 do
                                    Write( 'Up-Left ' );
                                  If Open_Window( Frame_11, Window_Up_Right, 5, 5, 60, 19, Red_Character + Yellow_Background )
                                   then
                                    Begin
                                     Label_Window( Yellow_Character + Red_Background, ' Up Right ' );
                                     For Counter := 1 to 100 do
                                       Write( 'Up-Right ' );
                                     If Open_Window( Frame_12, Window_Explode, 1, 1, 80, 25, Black_Character +
                                                     Red_Background )
                                      then
                                       Begin
                                        Label_Window( Red_Character + Black_Background, ' Explode ' );
                                        For Counter := 1 to 410 do
                                          Write( 'Explode ' );
                                        If Open_Window( No_Frame, Window_Explode, 7, 4, 35, 20, Green_Character +
                                                        White_Background )
                                         then
                                          Begin
                                           For Counter := 1 to 100 do
                                             Write( 'Invisible ' );
                                           If Open_Window( Frame_13, Window_Horizontal_Right, 20, 2, 40, 24, Flashing +
                                                           Red_Character + Black_Background )
                                            then
                                             Begin
                                              Label_Window( Black_Character + Red_Background, ' Horizontal Right ' );
                                              For Counter := 1 to 100 do
                                                Write( 'Horizontal-Right ' );
                                              If Open_Window( Frame_14, Window_Vertical_Up, 2, 8, 79, 18, Green_Character +
                                                              Yellow_Background )
                                               then
                                                Begin
                                                 Label_Window( Yellow_Character + Green_Background, ' Vertical Up ' );
                                                 For Counter := 1 to 100 do
                                                   Write( 'Vertical_Up ' );
                                                 If Open_Window( Frame_15, Window_Horizontal_Left, 50, 2, 70, 24,
                                                                 Red_Character + Cyan_Background )
                                                  then
                                                   Begin
                                                    Label_Window( Cyan_Character + Red_Background, ' Horizontal Left ' );
                                                    For Counter := 1 to 100 do
                                                      Write( 'Horizontal-Left ' );
                                                    If Open_Window( Frame_16, Window_Vertical_Down, 2, 6, 79, 20,
                                                                    White_Character + Blue_Background )
                                                     then
                                                      Begin
                                                       Label_Window( Blue_Character + White_Background, ' Vertical Down ' );
                                                       For Counter := 1 to 100 do
                                                         Write( 'Vertical_Bottom ' );
                                                       If Open_Window( Frame_17, Window_Pop, 8, 6, 16, 14, Red_Character +
                                                                       Green_Background )
                                                        then
                                                         Begin
                                                          Label_Window( Green_Character + Red_Background, ' Demonstration ' );
                                                          For Counter := 1 to 100 do
                                                            Write( 'Initialized ' );
                                                          For Counter := 1 to 5 do
                                                            Begin;
                                                              Flag := Expand_Window_Up;
                                                              Write( 'Initialized ' );
                                                              Flag := Expand_Window_Down;
                                                              Write( 'Initialized ' );
                                                            End;
                                                          For Counter := 1 to 100 do
                                                            Write( 'Window expanded horizontally ');
                                                          For Counter := 1 to 5 do
                                                            Begin;
                                                              Flag := Expand_Window_Left;
                                                              Write( 'Window expanded horizontally ');
                                                              Flag := Expand_Window_Right;
                                                              Write( 'Window expanded horizontally ');
                                                            End;
                                                          For Counter := 1 to 100 do
                                                            Write( 'Window expanded vertically ' );
                                                          For Counter := 1 to 5 do
                                                            Begin;
                                                              Flag := Reduce_Window_Up;
                                                              Write( 'Window expanded Vertically ' );
                                                              Flag := Reduce_Window_Down;
                                                              Write( 'Window expanded Vertically ' );
                                                            End;
                                                          For Counter := 1 to 100 do
                                                            Write( 'Window reduced ' );
                                                          For Counter := 1 to 5 do
                                                            Begin;
                                                              Flag := Reduce_Window_Right;
                                                              Write( 'Window reduced ' );
                                                              Flag := Reduce_Window_Left;
                                                              Write( 'Window reduced ' );
                                                            End;
                                                          For Counter := 1 to 100 do
                                                            Write( 'Window reduced ' );
                                                          For Counter := 1 to 50 do
                                                            Flag := Move_Window_Right;
                                                          For Counter := 1 to 100 do
                                                            Write( 'Window moved right ');
                                                          For Counter := 1 to 10 do
                                                            Flag := Move_Window_Down;
                                                          For Counter := 1 to 100 do
                                                            Write( 'Window moved down ');
                                                          For Counter := 1 to 50 do
                                                            Flag := Move_Window_Left;
                                                          For Counter := 1 to 100 do
                                                            Write( 'Window moved left ');
                                                          For Counter := 1 to 10 do
                                                            Flag := Move_Window_Up;
                                                          For Counter := 1 to 100 do
                                                            Write( 'Window moved up ');
                                                          If Open_Window( Frame_18, Window_Pop, 30, 8, 50, 18, $20 )
                                                           then
                                                            Begin
                                                             If VW_Create( 15, 25 )
                                                              then
                                                               Begin
                                                                {$IFNDEF OS2}
                                                                For Counter := 1 to 50 do
                                                                 Write( VW, ' Virtual window ' );
                                                                {$ENDIF}
                                                                VW_Browse;
                                                               End;
                                                             Close_Window( Window_Pop );
                                                            End;

                                                          Close_Window( Window_Pop );
                                                          Close_Window( Window_Vertical_Down );
                                                         End;
                                                      End;
                                                    Close_Window( Window_Horizontal_Left );
                                                   End;
                                                 Close_Window( Window_Vertical_Up );
                                                End;
                                              Close_Window( Window_Horizontal_Right );
                                             End;
                                           Close_Window( Window_Explode );
                                          End;
                                        Close_Window( Window_Explode );
                                       End;
                                     Close_Window( Window_Up_Right );
                                    End;
                                  Close_Window( Window_Up_Left );
                                 End;
                               Close_Window( Window_Down_Right );
                              End;
                            Close_Window( Window_Down_Left );
                           End;
                         Close_Window( Window_Vertical );
                        End;
                      Close_Window( Window_Horizontal );
                     End;
                   Close_Window( Window_Left );
                  End;
                Close_Window( Window_Right );
               End;
             Close_Window( Window_Up );
            End;
          Close_Window( Window_Down );
         End;
       Close_Window( Window_Pop );
      End;

  End.

