(*****************************************************************************

  Program: Fraction demonstration.

  Purpose:
    This program demonstrates the fraction unit.

  Features:
    This program uses the fraction routines to do operations on the fractions.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compilers:
    Turbo Pascal versions 4.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2

*****************************************************************************)

Program Fraction_Demonstration( Input, Output );

  Uses
    CRT,
    Fraction;

  Var
   { These variables hold the fractional numbers. }
    Number1,
    Number2,
    Number3: Number_Type;

  Begin
    ClrScr;
    WriteLn( 'Fraction unit demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program demonstrates the ability of the Fraction unit.' );
    WriteLn( 'Basically it performs a few simple calculations to demonstrate it''s' );
    WriteLn( 'accuracy with fraction values.' );
    WriteLn;
    WriteLn( 'Please press [enter] to continue.' );
    ReadLn;

   { Set number1 to 1/8. }
    Number1 := Equals( 1, 8 );
   { Set number2 to 3/5. }
    Number2 := Equals( 3, 5 );
   { Number3 equals 1/8 plus 3/5. }
    Number3 := Add( Number1, Number2 );
    WriteLn( Convert_To_String( Number1 ), ' + ', Convert_To_String( Number2 ),
             ' = ', Convert_To_String( Number3 ) );
    Number3 := Subtract( Number1, Number2 );
    WriteLn( Convert_To_String( Number1 ), ' - ', Convert_To_String( Number2 ),
             ' = ', Convert_To_String( Number3 ) );
    Number3 := Multiply( Number1, Number2 );
    WriteLn( Convert_To_String( Number1 ), ' * ', Convert_To_String( Number2 ),
             ' = ', Convert_To_String( Number3 ) );
    Number3 := Divide( Number1, Number2 );
    WriteLn( Convert_To_String( Number1 ), ' / ', Convert_To_String( Number2 ),
             ' = ', Convert_To_String( Number3 ) );
    WriteLn( 'Press enter to continue.' );
    ReadLn;
  End.

