
(*
** Func. #  Description
** -------  ---------------------------
**     00h  horz total
**     01h  horz displayed
**     02h  blank start
**     03h  blank end
**     04h  retrace start
**     05h  retrace end
**     06h  vertical total
**     07h  overflow register
**     08h  preset row scan
**     09h  max scan line/char height
**     10h  v retrace start
**     11h  v retrace end
**     12h  v displayed
**     14h  underline location
**     15h  v blank start
**     16h  v blank end
**     17h  mode control
** -------  ---------------------------
** Remember: function number is in HEX!
*)

const
  max_regs=17;
  {nof_regs:array[0..pred(mdx_lastmode)] of byte=
    (2,10,8,16,17,3,10,9,17,15,17,17,8,17,16,17);}

  { syntax: # of regs, width, height, dot clock, CRTC regs ... }
  crtc_regs:array[0..pred(mdx_lastmode),0..pred(max_regs+4)] of word=(
    (2,320,200,0, { 320x200x256 }
     $0014,$e317,
     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),

    (10,320,240,$e3, { 320x240x256 }
     $0d06,$3e07,$4109,$ea10,$ac11,$df12,$0014,$e715,$0616,$e317,
     0,0,0,0,0,0,0),

    (8,360,200,$e7, { 360x200x256 }
     $6b00,$5901,$5a02,$8e03,$5e04,$8a05,$0014,$e317,
     0,0,0,0,0,0,0,0,0),

    (16,360,240,$e7, { 360x240x256 }
     $6b00,$5901,$5a02,$8e03,$5e04,$8a05,$0d06,$3e07,$4109,$ea10,
     $ac11,$df12,$0014,$e715,$0616,$e317,
     0),

    (17,376,282,$e7, { 376x282x256 }
     $6e00,$5d01,$5e02,$9103,$6204,$8f05,$6206,$f007,$6109,$3710,
     $8911,$3312,$2f13,$0014,$3c15,$5c16,$e317),

    (3,320,400,$e3, { 320x400x256 }
     $4009,$0014,$e317,
     0,0,0,0,0,0,0,0,0,0,0,0,0,0),

    (10,320,480,$e3, { 320x480x256 }
     $0d06,$3e07,$4009,$ea10,$ac11,$df12,$0014,$e715,$0616,$e317,
     0,0,0,0,0,0,0),

    (9,360,400,$e7, { 360x400x256 }
     $6b00,$5901,$5a02,$8e03,$5e04,$8a05,$4009,$0014,$e317,
     0,0,0,0,0,0,0,0),

    (17,360,480,$e7, { 360x480x256 }
     $6b00,$5901,$5a02,$8e03,$5e04,$8a05,$0d06,$3e07,$4009,$ea10,
     $ac11,$df12,$2d13,$0014,$e715,$0616,$e317),

    (15,360,360,$e7, { 360x360x256 }
     $6b00,$5901,$5a02,$8e03,$5e04,$8a05,$4009,$8810,$8511,$6712,
     $2d13,$0014,$6d15,$ba16,$e317,
     0,0),

    (17,376,308,$e7, { 376x308x256 }
     $6e00,$5d01,$5e02,$9103,$6204,$8f05,$6206,$0f07,$4009,$3710,
     $8911,$3312,$2f13,$0014,$3c15,$5c16,$e317),

    (17,376,564,$e7, { 376x564x256 }
     $6e00,$5d01,$5e02,$9103,$6204,$8f05,$6206,$f007,$6009,$3710,
     $8911,$3312,$2f13,$0014,$3c15,$5c16,$e317),

    (8,256,200,$e3, { 256x200x256 }
     $5f00,$3f01,$4202,$9f03,$4c04,$0005,$0014,$e317,
     0,0,0,0,0,0,0,0,0),

    (17,256,224,$e3, { 256x224x256 }
     $5f00,$3f01,$4002,$8203,$4a04,$9a05,$0b06,$3e07,$4109,$da10,
     $9c11,$bf12,$2013,$0014,$c715,$0416,$e317),

    (16,256,240,$e3, { 356x240x256 }
     $5f00,$3f01,$4202,$9f03,$4c04,$0005,$0d06,$3e07,$4109,$ea10,
     $ac11,$df12,$0014,$e715,$0616,$e317,
     0),

    (17,256,256,$e3, { 256x256x256 - Mode-Q unchained }
     $5f00,$3f01,$4002,$8203,$4e04,$9a05,$2306,$b207,$0008,$6109,
     $0a10,$ac11,$ff12,$4014,$0715,$1716,$a317));

  crtc_ptr:pointer=@crtc_regs;
