{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Memory/Allocat5.pas              [x] Protected mode

  This program demonstrates the capabilities of DPMI memory allocation
  that EFLIB delivers.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFMEMORY;


{ This program can be compiled in real and protected mode }

var Block1, Block2 : tAllocation;
    Data1, Data2   : string;

begin
     Data1 := 'Testing the DPMI capabilities ... ';

     with Block1 do begin
          Initialize (65528); { Allocate some huge memory blocks! }

          MoveIn (@Data1[0], SizeOf(Data1), 0);

          with Block2 do begin

               Duplicate (@Block1);

               MoveOut (@Data2[0], SizeOf(Data1), 0);

               Write (Data2);
               if Data1 = Data2 then WriteLn ('and they work fine.')
                  else WriteLn ('and they doesn''t work (this can''t happen)!');

               Intercept;
          end;

          Intercept;
     end;
end.