{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Overall.pas             [x] Protected mode

  This example shows the variaty of data types that EFLIB provides.
  It also illustrates how flexible, fast and easy they are.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFBASIC, EFADT, EFARRAY, EFLIST, EFDATA, CRT, EFTEST;


const NumberOfElements = 1000;

var { Instances; tX = type, pX = ^type }
    Data : array [1..4] of pLinearADT;
    Current : pLinearADT; Timer : tTimer;
    { Other variables }
    Index : word; Number : real; MemoryUsage : longint;


procedure TestElementAddition;
begin
     RandSeed := 0; { Control random seed }
     Timer.Initialize;
     for Index := 1 to NumberOfElements do begin
         Number := Pi * (Succ(Random(100))/Succ(Random(100)));
         Current^.Store (Number);
     end;
     Write (MemoryUsage - MemAvail:8);
     Write (Timer.ElapsedMS:17:0);
     Timer.Intercept;
end;

procedure TestElementAccess;
begin
     Timer.Initialize;
     for Index := 1 to NumberOfElements do
         Current^.Retrieve (Number, Index);
     Write (Timer.ElapsedMS:25:0);
     Timer.Intercept;
end;

procedure Test;
begin
     TestElementAddition;
     TestElementAccess;
end;

begin
     MemPush; { EFTEST }

     { This program will test the performance of different data types.
       Not all data types are tested. The remaining data types are
       descendants or close relatives to the tested data types.

       Each data type is tested in 1) element adding and 2) sequential
       access. Each test is measured in duration and the results are
       displayed. Also, the testing involve memory usage check. }

     WriteLn; TextBackground (Blue);
     Write ('Datatype', '':12, 'Memory usage .... Element adding ...... Seq. access [ms] ');
     TextBackground (Black); WriteLn;

     Write ('Array               '); MemoryUsage := MemAvail;
     Data[1] := New(pArray, Initialize(NumberOfElements, SizeOf(Number)));
     Current := Data[1]; Test; WriteLn;

     Write ('Virtual array       '); MemoryUsage := MemAvail;
     Data[2] := New(pVirtualArray, Initialize(0, Succ(NumberOfElements div 100), SizeOf(Number)));
     Current := Data[2]; Test; WriteLn;

     Write ('Linked list         '); MemoryUsage := MemAvail;
     Data[3] := New(pList, Initialize (SizeOf(Number)));
     Current := Data[3]; Test; WriteLn;

     Write ('Linked cursor list  '); MemoryUsage := MemAvail;
     Data[4] := New(pCursorList, Initialize (SizeOf(Number)));
     Current := Data[4]; Test; WriteLn;


     WriteLn ('Checking data type integrity ...');

     { Certify that all data structures contains exactly the same data. Uses
       the IsEqual method that compares polymorphic data types. }

     for Index := 1 to Pred(SizeOf(Data) div SizeOf(pADT)) do
         if Data[Index]^.IsInitialized and Data[Succ(Index)]^.IsInitialized and
            not Data[Index]^.IsEqual(Data[Succ(Index)]) then
            WriteLn ('Data type ', Index, ' has errors.');

     WriteLn ('Done.');

     { Dispose all data structures }
     for Index := 1 to SizeOf(Data) div SizeOf(pADT) do
         if Data[Index]^.IsInitialized then Data[Index]^.Free;

     MemPop; { EFTEST }
end.