{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Elements/Linkage5.pas   [x] Protected mode

  Some ADT's use a special packaging for their elements, for example
  lists and trees. These ADT require links between their elements,
  these links are implemented in the packaging - the container
  class. This is an advanced demonstration of tLinkage, the
  packaging of linked lists, that is, descendants of tList.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFLIST, EFELEM;


var Element1, Element2,
    Element3, Element4, SomeNode : pLinkage;
    SomeString : string; Index : word;


begin
     { Create a container for doubly linked data structures,
       and place a generic element inside. }
     SomeString := 'Some basic data for the first element';
     Element1 := New (pLinkage, Initialize (New (pGenericElement,
                 Initialize (@SomeString, SizeOf(SomeString))), NIL));

     { Notice the somewhat complex initialization. The NIL
       parameter is for (optional) nested successor containers. }

     { Create one more container with element ... }
     SomeString := 'Even more data for another element';
     Element2 := New (pLinkage, Initialize (New (pGenericElement,
                 Initialize (@SomeString, SizeOf(SomeString))), NIL));

     { Create a container with an empty element }
     Element3 := New (pLinkage, Initialize (New (pGenericElement,
                 InitializeEmpty), NIL));

     { Duplicate the second element into a forth element, and
       place inside a container. }
     Element4 := New (pLinkage, Initialize (New (pGenericElement,
                 Duplicate (Element2^.Element)), NIL));

     if Element4^.Element^.IsAllocated then { Verify that we actually duplicated an element }
        WriteLn ('Duplicated an element');


     { Put "elements" together in a simple structure of linked
       elements. (We often refer to containers as if they were
       elements, even though an element actually is the "content"
       of the container (tElement inside tLinkage). }

     Element1^.AttachAfter (Element2); { Attach second node after first }
     Element2^.AttachAfter (Element3); { ... and the third after the second }
     Element2^.AttachBefore (Element4); { ... and the forth element before the second }

     { Now we've got a very simple linked data structure without any
       implementation into an advanced ADT. }

     SomeNode := Element1; { Start with first node }
     for Index := 1 to 4 do begin
         { One node will not be showed, hence it isn't allocated! }
         if SomeNode^.Element^.IsAllocated then
            WriteLn (Index:0, ': ', String(SomeNode^.Element^.Data(0)^));
         SomeNode := pLinkage(SomeNode^.Successor); { Go to the successor }
     end;

     WriteLn ('Three nodes should be displayed, since the last node is empty.');

     { When elements are disposed, they're automatically detached
       from any linked structure (they can be intercepted in any order). }

     Element4^.Free; Element1^.Free; Element2^.Free; Element3^.Free;

     { We could replace the above statement with e.g.
       Element2^.First^.FreeAll; }

     { And a final comment: you normally do not have to
       handle tLinkage containers in this low level. All
       this work is done in tList with descendants. }
end.