{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Elements/Linkage1.pas   [x] Protected mode

  Some ADT's use a special packaging for their elements, for example
  lists and trees. These ADT require links between their elements,
  these links are implemented in the packaging - the container
  class. This is a demonstration of tLinkage, the packaging of
  linked lists, that is, descendants of tList.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFKERNEL, EFLIST;


var Chain, Package : pLinkage;


begin
     WriteLn ('tLinkage - an introduction.');

     { Let us connect two empty packages! They then
       form a chain. The constructor requires two
       parameters: (i) the element to package and
       (ii) the successor node. Both can be NIL,
       but be may want to nest out initializations
       to create simple structures like: }

     Chain := New ( pLinkage, Initialize ( NIL,
               New ( pLinkage, Initialize ( NIL, NIL ) )) );

     { We have chain:   NIL <== [1] <==> [2] ==> NIL }

     Package := pLinkage (Chain^.Predecessor^.Predecessor);

     { Now package points to the successor of [2], but
       there is no such, so we say we have a NIL link. }

     if (Package = NIL) then WriteLn ('We were right.');

     { Now, let us add one more "package" to this chain!
       First, we let Package be a pointer to the last
       node. Note that we use the words node, package and
       container for the same thing! }


     Package := pLinkage (Chain^.Last); { Points to [2]. }

     { Secondly, let us create and attach a new node "[*]"
       by calling the method "AttachBefore": }

     Package^.AttachBefore ( { [*] } New (pLinkage, Initialize (NIL, NIL)) );

     { We have chain:   NIL <== [1] <==> [*] <==> [2] ==> NIL }

     Chain^.FreeAll;

     writeln ('We are done.');
end.