	.ident "@(#)probe.s	1.0 94#03!18"

	.data				# Data section

	.align	4
cx_flags_mask:		.long	0x08d5	# Mask to isolate the undefined bits
					# masks all but OF, SF, ZF, AF, PF, CF
cx_flags_before:	.long	0	# Flags before div
cx_flags_after:		.long	0	# Flags after div
cx_dividend:		.long	0xffff	# Dividend
cx_divisor:		.long	0x4	# Divisor
cx_result:		.long	0	# Results of flags compare
					# 0=different (Intel), 1=same (Cyrix)

	.text				# Text section


#
#	int cx_iscyrix(void)
#
#	This routine returns 1 if we are running on a 486DLC/SLC CPU.
#	Otherwise, it returns 0.
#
	.align	4
	.globl	_cx_iscyrix
_cx_iscyrix:
	pushl	%ebp
	movl	%esp, %ebp

	pushal				# Save processor state
	pushfl

	movl	$0, %eax		# Set flags to known state	
	cmpl	%eax, %eax

	pushfl				# Load flags into eax
	popl	%eax
	movl	%eax, cx_flags_before	# Save flags to mem

	# Do a div instruction so that the signature of the undefined flags
	# can be observed
	movl	cx_dividend, %eax
	movl	$0, %edx
	movl	cx_divisor, %ebx
	divl	%ebx

	pushfl				# Load flags into eax
	popl	%eax

	movl	%eax, cx_flags_after	# Save flags to mem

	# Recall cx_flags_before and clear unwanted bits
	movl	cx_flags_mask, %eax
	andl	cx_flags_before, %eax

	# Recall cx_flags_after and clear unwanted bits
	movl	cx_flags_mask, %ebx
	andl	cx_flags_after, %ebx

	# Compare the signature of the undefined bits before and after
	cmpl	%ebx, %eax
	jnz	cx_not_cyrix
	movl	$1, cx_result		# Set if flag bits are unchanged
					# Cyrix part found
	jmp	cx_detect_done
cx_not_cyrix:
	movl	$0, cx_result		# Clear if flag bits are changed
					# Cyrix part not found
cx_detect_done:
	popfl				# Restore processor state
	popal

	movl	cx_result, %eax		# Return value

	popl	%ebp
	ret
