/*
CHKWRD.C by Robert Morein.  10/26/86
(215)-646-4894

Purpose: to read and set the word-added checksum of a .bin file 
to any desired value, by adjusting the last word of the file. 
*/


#include "STDIO.H"
long atoi();
main( argc, argv ) 
int argc; char *argv[]; {
FILE *source;
unsigned cha *base;
unsigned long i, count;
int eofcond;
unsigned sum, oldsum, newsum, ckword;

if( !( argc > 1 ) ) {
  printf("\n16 bit rom object code checksum calculator and setter program.");
  printf("\nLast word is assumed to hold checksum.");
  printf("\narg1 = object code to be patched: patched at last word.");
  printf("\narg2 = decimal word count (optional, defaults to 32768.");
  printf("\narg3 = desired checksum (optional, if not given, source");
  printf("\n  will not be patched.");
  exit();
  }
if( argc == 3 ) {
  if( !(count = atoi( argv[2] )) ) {
    printf("\nByte count must be a number > 0\n");
    exit();
    }
  printf("\nYou have selected a word count of: %lu\n", count );
  count -= 2;
  }
else count = 32767;

if( argc == 4 ) {
  newsum = atoi( argv[3] );
  printf("\nYou have selected a new checksum of: %d\n", newsum );
  }

source = fopen( argv[1], "rwb" );
/* The last byte is reserved for the checksum: */
for( i = 0, sum = 0; i < count; i++ ) {
  sum += (unsigned)getw( source);
  }
oldsum = sum + (unsigned)getw( source );
printf("\nCurrent checksum (including last byte): (decimal) %u, (hex) %lx",
  oldsum, (long)oldsum );

/*  sum + ckbyte = newsum */

ckword = newsum - sum;

if( argc == 4 ) {
  printf("\nPatching last word for a checksum of: (decimal) %u, (hex) %lx", 
    newsum, (long)newsum );
  fseek( source, (long)(2 * count), 0L );
  putw( ckword, source );
  }

fclose( source );
}

