Unit EMS;
{$R-,S-,A+,D-,L-}
INTERFACE
{  Stellt grundlegende Funktionen zum Umgang mit dem EMS zur Verfgung.
   Alle boolschen Funktionen liefern FALSE, falls die Operation fehl schlgt }

VAR  EMSPageFrame : Word;   { Segment des PageFrame }
     EMSPage0 : Pointer;    { Zeiger auf erste  phys. Seite im PageFrame }
     EMSPage1 : Pointer;    { Zeiger auf zweite phys. Seite im PageFrame }
     EMSPage2 : Pointer;    { Zeiger auf dritte phys. Seite im PageFrame }
     EMSPage3 : Pointer;    { Zeiger auf vierte phys. Seite im PageFrame }

Function  EMS_Avail: Boolean;
            { TRUE, falls EMS vorhanden; mu am Anfang aufgerufen werden !!! }

Function  GetEMSVersion: Word;
            { Hi = Hherer Teil, Lo = Niederer Teil der Versionsnummer }

Procedure GetEMSSize(var Size, Free : Integer);
            { Size = Gesamtzahl EMS-Pages, Free = noch freie Anzahl }

Function  GetEMSHandles: Integer;
            { Anzahl vergebener Handles }

Function  GetEMSMem(Size: Integer; var Handle: Integer): Boolean;
            { fordert n Seiten EMS-Speicher an -> rck: Handle zum Zugriff }

Function  GetEMSPages(Handle: Integer):Integer;
            { Anzahl Seiten dieses Handles }

Function  SetEMSMapping(Handle, PhysPage, LogPage: Integer): Boolean;
            { Ldt eine log. Seite des Handles auf eine phys. Seite im PageFrame }

Function  FreeEMSMem(Handle: Integer): Boolean;
            { gibt den zum Handle gehrenden EMS-Speicher frei }

IMPLEMENTATION  { ---------------------------------------------------- }

CONST EMMString : String[9] = 'EMMXXXX0'#0;

Function EMS_Avail: Boolean; assembler; { TRUE, falls EMS vorhanden }
asm
  mov  dx,offset EMMString  { dazu 'File' 'EMMXXXX0' ffnen }
  inc  dx
  mov  ax,03D00h            { ffne File }
  int  21h
  mov  bx,ax                { BX := FileHandle }
  mov  al,0
  jc   @End
  mov  ah,03Eh              { wieder schlieen ! }
  int  21h
  {}
  mov  ah,$041              { PageFrame lesen }
  int  $67
  mov  al,0
  or   ax,ax
  jnz  @End         { Fehler }
  mov  EMSPageFrame,bx
  mov  word ptr [EMSPage0],0
  mov  word ptr [EMSPage0 + 2],bx  { Segmentadresse in Pointer }
  add  bx,$0400
  mov  word ptr [EMSPage1],0
  mov  word ptr [EMSPage1 + 2],bx  { Segmentadresse in Pointer }
  add  bx,$0400
  mov  word ptr [EMSPage2],0
  mov  word ptr [EMSPage2 + 2],bx  { Segmentadresse in Pointer }
  add  bx,$0400
  mov  word ptr [EMSPage3],0
  mov  word ptr [EMSPage3 + 2],bx  { Segmentadresse in Pointer }
  dec  al           { TRUE }
@End:
end;

Function  GetEMSVersion: Word; assembler;  { Hi = Hherer Teil, Lo = Niederer Teil }
asm
  mov  ah,$046
  int  $67
  mov  ah,al
  and  al,$00F
  mov  cl,4
  shr  ah,cl
end;

Procedure GetEMSSize(var Size, Free : Integer); assembler;
asm
  mov  ah,$042
  int  $67
  les  di,Size
  mov  ES:[di],DX  { Gesamtzahl }
  les  di,Free
  mov  ES:[di],BX  { davon noch frei }
end;

Function  GetEMSHandles: Integer; assembler;  { Anzahl vergebener Handles }
asm
  mov  ah,$04B
  int  $67
  mov  ax,bx
end;

Function  GetEMSPages(Handle: Integer):Integer; assembler;  { Anzahl Seiten des Handles }
asm
  mov  ah,$04C
  mov  dx,Handle
  int  $67
  or   ah,ah
  mov  ax,0
  jnz  @End
  mov  ax,bx
@End:
end;

Function  GetEMSMem(Size: Integer; var Handle: Integer): Boolean; assembler;
asm
  mov  ah,$043
  mov  bx,Size     { Anzahl Seiten }
  int  $67
  mov  al,0
  or   ah,ah
  jnz  @End        { Fehler }
  les  di,Handle
  mov  ES:[di],DX  { Handle }
  dec  al          { TRUE }
@End:
end;

Function  SetEMSMapping(Handle, PhysPage, LogPage: Integer): Boolean; assembler;
asm
  mov  ax,PhysPage
  cmp  al,4
  mov  ah,al
  jae  @Fail      { phys. Seite nur 0..3 !!! }
  mov  dx,Handle
  mov  bx,LogPage
  mov  ah,$044
  int  $67
@Fail:
  mov  al,0
  or   ah,ah
  jnz  @End        { Fehler }
  dec  al          { TRUE }
@End:
end;

Function  FreeEMSMem(Handle: Integer): Boolean; assembler;
asm
  mov  ah,$045
  mov  dx,Handle
  int  $67
  mov  al,0
  or   ah,ah
  jnz  @End        { Fehler }
  dec  al          { TRUE }
@End:
end;
end.
