: Profile, The 1D Scientific Spreadsheet 
: by Gertjan L. Ouwerling, Electrical Materials Lab, Delft University
: -------------------------------------------------------------------
: Example 1: Processing measurement data
:
: Execute this example by typing:  prof example1.pro <enter>
: 
: NOTE: some steps may be slow without a co-processor!
:
: Previously acquired measurement data (Capacitance-Voltage, C(V)) is
: read from the file <example1.dat> and an N(x) curve is computed by
: the traditional CV method. An analytical expression (defined as 
: <implant>) is than fitted to the (noisy) measurement data by non-
: linear optimization of the parameters [dose,difl,range]. The fit is
: not perfect because the model <implant> does not closely correspond
: to the physical reality.
: -------------------------------------------------------------------

pause
:
: Declare Profile variables
:
type v c dcdv x nmeas nstart nmodel $
var real eps area dose difl range $
:
: Set variables, read data and do the C(V) method
:
eps = eps0*epssi
area = pi*sqr(130e-04)
get example1.dat v c $
diff num c v dcdv
nmeas  = (c@3)/(q*sqr(area)*eps*dcdv)
x      = eps*area/c
:
pause
:
: Define a non-linear model <implant> to be fit to the measurement
:
define topdope = dose/(sqrt(2*pi)*difl)
define exparg  = -1*sqr((x-range)/difl)
define implant = topdope*exp(exparg)
:
: Give starting values to the parameters 
:
dose   = 1.0e12
difl   = 1.0e-04
range  = 0.5e-04
:
nstart = implant
:
: Look at the measurement and the starting guess
: Give <enter> to  leave the Picture!
:
pause
:
view x nmeas nstart $
:
: Set the error sum weight function and call the optimizer <levmar>
:
weight = 1/(nmeas+5e14)
setlm talk 2
:
pause
:
levmar def implant nmeas x nmodel 
       dose difl range $
:
: Look at the difference between measured data, starting guess and
: final fit. Give <enter> to leave the picture.
:
pause
:
view x nmeas nstart nmodel $
:
: Give  quit <enter>  to leave Profile.
: Or continue playing around a little
:
: Some interesting commands not treated in this example are:
: ---------------------------------------------------------
:
: help     - get information from the help file
: fit      - do a polynomial curve-fit on data   
: map      - map data from one x-axis to another 
: reduce   - reduce the number of data lines
: remove   - remove indicated data lines
: show     - show variables, data types and predefined expressions
: assign   - give values to individual data type elements
:
: default variable ndata  - contains the active number of data lines
: default data type count - counts from 0 to ndata-1
:
: give  help help <enter>  for a full overview of all commands
:

