/*
 *  Graphics function remaps for Borland's BGI drivers
 *
 *  Copyright (C) 1995  Philip VanBaren
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <dos.h>
#include <conio.h>
#include <graphics.h>
#include <string.h>

#include "freq.h"
#include "display.h"

int _font_color;
int _font_width;
int _font_height;

extern int done;

int ctrlcfunc(void)
{
   /* Function called whenever Ctrl-C is pressed (Borland C only) */
   done=1;
   return 1;
}

void setup_graphics(void) 
{
   int gdriver=VGA,gmode=VGAHI;
   registerbgidriver(EGAVGA_driver);
   initgraph(&gdriver,&gmode,"");
   setlinestyle(SOLID_LINE,0,1);
   settextjustify(LEFT_TEXT,TOP_TEXT);
   settextstyle(DEFAULT_FONT,HORIZ_DIR,1);
   _font_height=8;
   _font_width=8;
   _font_color=TEXT_COLOR;
}

void draw_text_left(int x,int y,char *string)
{
   setcolor(_font_color);
   outtextxy(x,y,string);
}

void draw_text_centered(int x,int y,char *string)
{
   setcolor(_font_color);
   outtextxy(x-strlen(string)*_font_width/2,y,string);
}

void draw_text_right(int x,int y,char *string)
{
   setcolor(_font_color);
   outtextxy(x-strlen(string)*_font_width,y,string);
}

void draw_text_vertical(int x,int y,char *string)
{
   settextstyle(DEFAULT_FONT,VERT_DIR,1);
   setcolor(_font_color);
   outtextxy((x)+_font_width,y,string);
   settextstyle(DEFAULT_FONT,HORIZ_DIR,1);
}

void draw_fontcolor(int c)
{
   _font_color=c;
}

void draw_rectangle(int x1,int y1,int x2,int y2,int c)
{
   setcolor(c); 
   rectangle(x1,y1,x2,y2); 
}

void draw_line(int x1,int y1,int x2,int y2,int c)
{
   setcolor(c);
   moveto(x1,y1);
   lineto(x2,y2); 
}

void draw_bar(int x1,int y1,int x2,int y2,int c)
{ 
   setfillstyle(SOLID_FILL,c); 
   bar(x1,y1,x2,y2); 
}

void draw_setpalatte(int n,int r,int g,int b)
{
   setrgbpalette(n,r,g,b);
}
  
int draw_getch()
{
   register int c=getch();
   if(c>0)
      return(c);
   else
      return(0x100+getch());
}

int draw_getkey()
{
   if(kbhit())
   {
      register int c=getch();
      if(c>0)
	 return(c);
      else
	 return(0x100+getch());
   }
   else
      return(0);
}
