/*
 *  Global variable definitions
 */

/* Soundcard function pointers */
extern void (*reset_soundcard)(void);
extern void (*halt_soundcard)(void);
extern void (*cleanup_soundcard)(void);
extern void (*recordblock)(void FAR *);
extern void (*set_mixer)(int,int);

extern char *audio_device; /* Unix audio input device */
extern char *mixer_device; /* Unix audio mixer device */
extern char *output_device; /* Output echoing device */

extern int mixers;      /* Flag for mixer available */
extern int sample_size; /* Sample size, in bits (8 or 16) */
extern int mic_level;   /* Storage for mic input mixer level (0-100) */
extern int ext_level;   /* Storage for ext input mixer level (0-100) */
extern int int_level;   /* Storage for int input mixer level (0-100) */
extern int sb_irq;      /* IRQ used by the Soundblaster card */
extern int sb_dma;      /* DMA channel used by the Soundblaster card */
extern int sb_addr;     /* I/O address of the Soundblaster card */
extern int Soundcard;   /* Soundcard number (as defined in freq.h) */
extern char device[];   /* Linux PCM audio device name */

/* Data for display updates */
extern int x[];         /* Array of bin numbers's displayed */
extern int x2[];        /* Final bin for lines on which multiple bins lie */
extern int lasty[];     /* Memory for the last display location */
extern long *lastval;   /* Memory for the last uniform averaging value */
extern float *lastval_f; /* Memory for the last exp. averaging value */
extern long *displayval; /* Memory for the current display value */
extern long *ybase;      /* Scaling offset for log calculations */
extern unsigned int yscale[]; /* Scaling factors */
extern long FAR **databuf; /* Memory used for averaging mode */
extern int shift;         /* Number of bits for gain shift */
extern double shiftscale; /* Multiplication factor that does this shift */
extern int logfreq;     /* Flag set to 1 for log-based frequency scale */
extern int logamp;      /* Flag set to 1 for log-based amplitude scale */
extern int logs;        /* Max level for log-amplitude display */
extern int log_base;    /* Base level for log-amplitude display */
extern float ys;        /* Peak display value for linear-amplitude display */
extern int gain;        /* Flag indicating the total dB/octave gain */
extern int gain3db;     /* Flag indicating a 3db/octave scale factor gain */
extern int deriv;       /* Flag for doing differencing for 6db/octave gain */
extern long ref_freq;   /* Frequency at which the gain is 0dB */
extern float maxfreq;   /* Maximum frequency displayed */
extern float disp_scalefactor; /* Scale factor used for displaying log(amp) */
extern float log_scalefactor;  /* Scale factor used for computing log(amp) */
extern float freq_scalefactor; /* Scale factor for frequency axis */
extern float freq_base; /* Lowest frequency displayed */
extern int equalizer_mode; /* Flag for tuning on equalizer-type display */
extern int decay_mode;  /* Flag for decay mode on/off */
extern float decay_factor; /* Geometric decay factor (0 to 1) */
extern int decay_count; /* Count for averaging factor (1 through MAX_DECAY_COUNT) */
extern int decay_count_actual; /* Number of samples actually averaged */
extern int max_decay_count; /* Maximum value allowed for decay_count */
extern int decay_ptr;    /* Index to the current averaging mode buffer */
extern int display_peak; /* Flag for displaying the peak information */
extern int freeze;       /* Flag for freeze-frame mode */
extern int barmode;      /* Flag indicating bar display or line display */

/* Data for the FFT routines */
extern short *fftdata;    /* Output data from the FFT routine */
extern short *wind;       /* Array storing windowing function */
extern int windfunc;    /* Flag indicating the windowing function */

/* Buffers for sampling new data */
extern volatile int flag[];   /* Array of flags indicating fullness of buffers */
extern void FAR *buffer[];    /* Buffers for gathering data */
extern int queue_buffer;  /* Pointer to the next buffer to be queued */
extern volatile int record_buffer; /* Pointer to the next buffer to be recorded */
extern int process_buffer;/* Pointer to the next buffer to be processed */
extern long SampleRate;   /* Sampling rate in Hz */
extern double fudgefactor; /* Correction factor for errors in sampling rate */
extern int fftlen;        /* Length of the FFT performed */

extern int help_mode;       /* Flag indicating when the help display is active */
extern char ini_file[];     /* Filename for the INI file */
extern char *window_name[]; /* Descriptive names for the window functions */

extern struct rgb background,warn,graph,tick,label,border,text,darkhl,lighthl;

/* Miscellaneous variables */
extern int _font_height;
extern int _font_width;
extern int _font_color;


