TITLE	TIMER	6-30-88	[2-7-89]
PAGE	,132

;Usage:
;	toadtime progname [parameters]

;Use your program's normal command line, with any parameters it might need.
;Just prefix it with this program's name!

;Measures the amount of time it takes a program to run,
;announces to STDERR.
;Really only works with DOS programs from the command line
;because the time displays are on the monochrome screen.
;(You couldn't see them in Windows.)
;Probably wouldn't time accurately if you did this right around midnight.
;(No provisions for the midnight wraparound clock bug.)

;A tweak of an even more ancient program.
;This version given to the public domain.
;David Kirschbaum
;Toad Hall
;kirschd@hq.ljl.com

LF	EQU	0AH
CR	EQU	0DH
STDERR	equ	2
;
CSEG	SEGMENT
	ASSUME DS:CSEG, SS:CSEG ,CS:CSEG ,ES:CSEG
	org	0
CSTART	=	$

	ORG	100H

Timer	proc	near
	MOV	SP,OFFSET STAK

	mov	bx,PROGEND
	MOV	AH,4AH			;free memory
	INT	21H

	MOV	AX,DS:2CH		;environment
	MOV	cmdblock,AX		;stuff into EXEC block
	MOV	AX,CS
	MOV	cs_244,AX
	MOV	cs_248,AX
	MOV	cs_24C,AX

	MOV	SI,80H			;PSP cmd line
	MOV	DI,OFFSET execname	;target program name buffer
	XOR	AX,AX
	CLD

	LODSB
	OR	AX,AX			;any command line?
	JZ	L0137			;nope

	MOV	CX,AX			;cmdline length
	INC	AX			;add for length, terminator
	INC	AX
	STOSB				;stuff length
	INC	DI
	INC	DI
	REPZ	MOVSB			;copy in to EXEC name buffer

L0137:	CALL	Get_Start_Time

	MOV	DX,OFFSET startmsg	;'Start: '
IFNDEF	STDERR
	MOV	AH,9
	INT	21H
ELSE
	mov	cx,STARTLEN		;msg length
	call	Write_StdErr		;display to StdErr
ENDIF
	MOV	DX,OFFSET timebuff	;'00:00:00.00'
IFNDEF	STDERR
	MOV	AH,9
	INT	21H
ELSE
	mov	cx,TIMELEN		;time string length
	call	Write_StdErr		;display to StdErr
ENDIF
	MOV	DX,OFFSET cmdname	;'COMMAND.COM'
	MOV	BX,OFFSET cmdblock
	MOV	AX,4B00H		;EXEC
	PUSH	DS			;save before the EXEC
	PUSH	ES
	MOV	saveSS,SS
	MOV	saveSP,SP
	INT	21H

	MOV	SP,CS:saveSP		;restore after the EXEC
	MOV	SS,CS:saveSS
	POP	ES
	POP	DS

	PUSH	AX			;save EXEC results
	CLD				;insure fwd
	CALL	Get_End_Time

	MOV	DX,OFFSET endmsg	;'End: ', elapsed, etc.
IFNDEF	STDERR
	MOV	AH,9
	INT	21H
ELSE
	mov	cx,ENDLEN		;msg length
	call	Write_StdErr		;display to StdErr
ENDIF
	POP	AX			;EXEC results
	MOV	AH,4CH			;Terminate process
	INT	21H
Timer	endp


IFDEF	STDERR
Write_StdErr	proc	near
	mov	bx,STDERR		;StdErr output
	mov	ah,40H			;write to file/dev
	int	21H
	ret
Write_StdErr	endp
ENDIF

Get_End_Time	proc	near
	MOV	AH,2CH			;get current time
	INT	21H
	MOV	BX,timeDX		;old time's seconds/deciseconds
	MOV	AH,3CH			;constant
	MOV	AL,DL			;current deciseconds
	SUB	AL,BL			;minus old deciseconds
	JNB	L018E			;didn't go minus
	 ADD	AL,64H			;bump 100
	 INC	BH			;bump seconds
L018E:	MOV	DL,AL			;DL=deciseconds difference
	MOV	BL,minutes		;starting minutes
	MOV	AL,DH			;current seconds
	SUB	AL,BH			;minus old seconds
	JNB	L01A0			;didn't go minus
	 ADD	AL,AH			;+ 60
	 INC	BL			;bump minutes
	 JMP	SHORT L01A8

L01A0:	CMP	AL,AH			;60?
	JB	L01A8			;nope, less
	 SUB	AL,AH			;-60
	 DEC	BL			;decr minutes
L01A8:	MOV	DH,AL			;DH=seconds difference
	MOV	BH,hours		;starting hour
	MOV	AL,CL			;current minutes
	SUB	AL,BL			;current - starting
	JNB	L01BA			;didn't go minus
	 ADD	AL,AH			;+60
	 INC	BH			;bump hours
	 JMP	SHORT L01C2		;skip

L01BA:	CMP	AL,AH			;minutes < 60?
	JB	L01C2			;yep
	 SUB	AL,AH			;-60
	 DEC	BH			;decr hour
L01C2:	MOV	CL,AL			;CL= minutes diff
	MOV	AL,CH			;current hour
	SUB	AL,BH			;- starting hour
	MOV	CH,AL			;CH=hour diff
	JMP	SHORT Stuff_TimeBuff	;convert the difference
Get_End_Time	endp


Get_Start_Time	proc	near
	MOV	AH,2CH			;get current time
	INT	21H
	MOV	timeCX,CX		;save hour/minutes as a word
	MOV	timeDX,DX		;save seconds/deciseconds

Stuff_TimeBuff:
;	mov	bp,3030H		;'00' constant
	MOV	DI,OFFSET timebuff
	XOR	AX,AX
	MOV	BL,0AH
	MOV	AL,CH
	MOV	BH,':'			;separator
	CALL	Asciify
	MOV	AL,CL
	CALL	Asciify
	MOV	AL,DH
	MOV	BH,'.'			;separator
	CALL	Asciify
	MOV	AL,DL
	XOR	BH,BH			;no separator
	CALL	Asciify
	RET
Get_Start_Time	endp


Asciify	proc	near
	OR	AX,AX		;no dividing 0's
	JZ	L0200
	 DIV	BL
L0200:	add	ax,'00'
;	ADD	AX,bp		;'00' Asciify lsb,msb
	STOSW
	OR	BH,BH		;any separator?
	JZ	L020B		;nope
	 MOV	AL,BH
	 STOSB			;stuff the separator
L020B:	XOR	AX,AX		;clear AX
	RET
Asciify	endp


timeCX	label	word
minutes	db	0
hours	db	0
timeDX	DW	0

startmsg	DB	'Start: '
IFDEF	STDERR
STARTLEN	=	$-startmsg
ELSE
	db	'$'
ENDIF

endmsg	DB	'End: '
timebuff	DB	'00:00:00.00',CR,LF

IFDEF	STDERR
ENDLEN	=	$-endmsg
TIMELEN	=	$-timebuff
ELSE
	DB	'$'
ENDIF

saveSS	DW	0
saveSP	DW	0

cmdname	DB	'C:\COMMAND.COM',0
cmdblock dw	0
	dw	execname
cs_244	dw	0
	dw	005CH
cs_248	dw	0
	dw	006CH
cs_24C	dw	0

IP	=	$

execname DB	11H			;exec filename length
	DB	'/C C:\COMMAND.COM',CR

IP	=	IP + 128
STAK	=	IP
IP	=	IP + 15
PROGEND	=	(IP-CSTART) / 16	;convert to paras

CSEG	ENDS
	END	Timer
