/****************************************************************************/
/* CLEANMSG module for RBBSMNT, a maintenance utility for RBBS-PC           */
/* NOTICE ͸*/
/*  A limited license is granted to all users of this program to make     */
/*  copies if this program and distribute those copies to other users     */
/*  on the following three conditions:                                    */
/*                                                                        */
/*    1.   This notice is NOT altered, bypassed or removed,               */
/*    2.   The program is not to be distributed to others in modified     */
/*         form. You may make changes for your own non-commercial use     */
/*    3.   No fee is to be charged (or any other consideration received)  */
/*         for copying or distributing these programs without an express  */
/*         written agreement with J. Terpstra, Bamestra RBBS, PO Box 66,  */
/*         Beemster, The Netherlands.                                     */
/*                                                                        */
/*Copyright (C) 1991, 1992 - Jan Terpstra, Bamestra RBBS, The Netherlands.*/
/*;*/
/****************************************************************************/

#include "rbbsmnt.h"                    /* definitions for this program     */
#include "externs.h"                    /* external data references         */
#include "dos.h"
int rcount;                             /* # msgs read                      */
int wcount;                             /* # msgs written                   */
int last_one;

  /**************************************************************************/
  /* clean a message file                                                   */
  /**************************************************************************/

void cleanmsg(void)
{
   char far *b;
   long msgpos;                         /* file position                    */
   int msg,wrk;                         /* file handles                     */
   int newnum;                          /* new msg number after renum       */
   int j;
   int tot_msgs;
   int do_pip = FALSE;
   int keeps = 0;
   size_t bufsize;                      /* buffer size                      */
   char *p;
   int kills = 0;

   sprintf(logbuf, "Processing %s.", msgfile);
   writelog(logbuf, 1, 3);

   if (use_wrk)
   {
      sprintf(wrkfile, "%s\\RBBSMNT.$$M", wkf);
   }

   else
   {
      strcpy(wrkfile, msgfile);

      if ((p = strrchr(wrkfile, '.')) == NULL)
      {
         p = wrkfile+strlen(wrkfile);
      }
      sprintf(p, ".$$M");
   }

   /*************************************************************************/
   /* open msg file                                                         */
   /*************************************************************************/


   if ((msg = open(msgfile, O_RDWR|O_BINARY, S_IREAD|S_IWRITE)) == ERROR)
   {
      sprintf(logbuf, "Error opening %s.", msgfile);
      writelog(logbuf, 1, 0);
      return ;
   }

   /*************************************************************************/
   /* see if any work to do                                                 */
   /*************************************************************************/

   get_rbbs_hdr(msg);

   if ((tot_msgs = makelist(msg)) == ERROR)/* build list of msgs            */
   {
      close(msg);
      return ;
   }

   if (!tot_msgs)                       /* any messages?                    */
   {
      close(msg);
      printf("\r\33[K");
      sprintf(logbuf, "Msgfile is empty.");
      writelog(logbuf, 1, 4);
      close(msg);
      return ;
   }

   /*************************************************************************/
   /* first, flag messages to kill by by age                                */
   /*************************************************************************/


   for (j = 0; j < lives; j++)
   {

      if (mlist[j].msg_age > max_age || mlist[j].msg_age < 0)
      {

         if (!quiet)
         {
            printf("\r  Msg %05d by date", mlist[j].old_num);
         }
         mlist[j].old_num = -1;         /* set invalid msg number as flag   */
         kills++;
      }

      else
      {
         keeps++;                       /* increase keep counter            */
      }
   }
   printf("\r\33[K");

   /*************************************************************************/
   /* See if we have left more than the maximum                             */
   /*************************************************************************/

   j = 0;

   while (keeps > max_msgs && j < lives)
   {

      if (mlist[j].old_num != -1)       /* not yet killed?                  */
      {

         if (!quiet)
         {
            printf("\r  Msg %05d by amount", mlist[j].old_num);
         }
         mlist[j].old_num = -1;         /* set invalid msg number as flag   */
         kills++;
         keeps--;
      }
      j++;
   }
   printf("\r\33[K");

   /*************************************************************************/
   /* any maintenance to do?                                                */
   /*************************************************************************/


   if (!deads && !bads && !kills && !do_renum && !fixhdr)
   {
      sprintf(logbuf, "Msgs: 00000 deleted, %05d active.", lives);
      writelog(logbuf, 1, 4);
      close(msg);
      return ;
   }

   /*************************************************************************/
   /* renumber msgs                                                         */
   /*************************************************************************/


   if (do_renum || fixhdr)
   {

      if (quiet)
      {
         printf("\r  Renumbering msgs");
      }
      newnum = 0;

      for (j = 0; j < lives; j++)
      {

         if (mlist[j].old_num != -1)
         {
            mlist[j].new_num = ++newnum;

            if (!quiet)
            {
               printf("\r  Renumber %05d -> %05d", mlist[j].old_num, newnum)
               ;
            }
         }
      }

      /**********************************************************************/
      /* adjust high water marker                                           */
      /**********************************************************************/

      j = lives-1;

      while (j && mlist[j].old_num > last_done)
      {
         j--;
      }
      last_done = mlist[j].new_num;
      printf("\r\33[K");
   }

   /*************************************************************************/
   /* open tmp file or same file if PIP                                     */
   /*************************************************************************/


   if (pip && !bads && !fixhdr)
   {
      do_pip = TRUE;

      if ((wrk = open(msgfile, O_RDWR|O_BINARY, S_IREAD|S_IWRITE)) == ERROR)
      {
         sprintf(logbuf, "Error opening %s.", msgfile);
         writelog(logbuf, 1, 0);
         return ;
      }
   }

   else
   {

      if (!access(wrkfile, 0))
      {
         unlink(wrkfile);
      }

      if ((wrk = open(wrkfile, O_BINARY|O_RDWR|O_CREAT, S_IREAD|S_IWRITE))
      == ERROR)
      {
         sprintf(logbuf, "Error opening temporary MESSAGES file.");
         writelog(logbuf, 1, 0);
         return ;
      }
   }

   /*************************************************************************/
   /* copy the messages file header if not PIP                              */
   /*************************************************************************/


   if (do_pip)
   {
      lseek(wrk, (first_rec-1)*128L, SEEK_SET);/* seek workfile to first msg*/
   }

   else
   {
      msgpos = 0L;
      bufsize = (size_t)((first_rec-1)*128);

      if ((b = (char far *)malloc((size_t)bufsize *sizeof(char))) == NULL)
      {
         sprintf(logbuf, "%s messages buffer.", no_memory);
         writelog(logbuf, 1, 0);
         exit(2);
      }
      lseek(msg, 0L, SEEK_SET);
      lseek(wrk, 0L, SEEK_SET);
      read(msg, b, bufsize);
      write(wrk, b, bufsize);
      free(b);
   }
   next_rec = first_rec;

   /*************************************************************************/
   /* need to save old msgs to archive file?                                */
   /*************************************************************************/


   if (save_em && kills)
   {
      dump_old(msg);
   }

   /*************************************************************************/
   /* read all kept messages                                                */
   /*************************************************************************/

   wcount = 0;
   rcount = 0;

   if (quiet)
   {
      printf("\r\33[K\r  Reading ");
   }

   while (rcount < lives)
   {

      if (quiet)
      {

         if (rcount%32 == 0)
         {
            printf(".");
         }
      }

      if (mlist[rcount].old_num == -1)  /* if live msg                      */
      {
         rcount++;
      }

      else
      {
         bufsize = mlist[rcount].num_recs *128;/* size of buffer            */

         if ((mlist[rcount].buf = (char far *)malloc(bufsize *sizeof(char)))
         != NULL && rcount < lives)     /* allocate buffer                  */
         {
            lseek(msg, mlist[rcount].msg_pos, SEEK_SET);/* seek to msg      */
            read(msg, mlist[rcount].buf, bufsize);/* read msg               */

            if (!quiet)
            {
               printf("\r  Reading %05d", mlist[rcount].new_num);
            }
            rcount++;
         }

         else
         {
            dump_em(wrk);

            if (quiet)
            {
               printf("\r\33[K\r  Reading ");
            }
         }
      }
   }
   dump_em(wrk);

   /*************************************************************************/
   /* update msg file header & close files                                  */
   /*************************************************************************/

   high_msg = mlist[wcount-1].new_num;

   if (!do_pip)
   {
      last_rec = next_rec-1;
   }

   else
   {

      /**********************************************************************/
      /* truncate msgfile after last msg?                                   */
      /**********************************************************************/


      if (trunc)
      {
         printf("--> trunc\n");
         last_rec = next_rec-1;
#ifdef OS_2

   printf("\nDosWrite: %lx, %d\n",  DosWrite((HFILE) wrk, "",0L,&j),j);

#else
         _dos_write(wrk, "", 0, &j);
#endif

         /*******************************************************************/
         /* put_rbbs_hdr(wrk); close(msg); close(wrk);                      */
         /*******************************************************************/

      }

      else

         /*******************************************************************/
         /* or pad msgfile with empty recs                                  */
         /*******************************************************************/

      {
         printf("--> fill\n");
         memset(logbuf, ' ', 128);

         for (j = next_rec; j <= last_rec; j++)
         {
            write(wrk, logbuf, 128);
         }

         /*******************************************************************/
         /* put_rbbs_hdr(wrk); close(msg); close(wrk);                      */
         /*******************************************************************/

      }
   }
   put_rbbs_hdr(wrk);
   close(msg);
   close(wrk);

   /*************************************************************************/
   /* statistics                                                            */
   /*************************************************************************/

   printf("\r\33[K");
   sprintf(logbuf, "Msgs: %05d deleted, %05d active.", kills, keeps);
   writelog(logbuf, 1, 4);

   /*************************************************************************/
   /* if PIP, rename or copy workfile to org file                           */
   /*************************************************************************/


   if (!do_pip)
   {

      if (use_wrk)
      {
         sprintf(logbuf, "copy %s %s > nul", wrkfile, msgfile);
         system(logbuf);
         unlink(wrkfile);
      }

      else
      {
         unlink(msgfile);
         rename(wrkfile, msgfile);
      }
   }
}


  /**************************************************************************/
  /* dump this block to disk                                                */
  /**************************************************************************/

void dump_em(int fh)
{
   size_t bufsize;


   if (quiet)
   {
      printf("\r  Writing ");
   }

   while (wcount < rcount)
   {

      if (quiet)
      {

         if (wcount%32 == 0)
         {
            printf("o");
         }
      }

      if (mlist[wcount].old_num != -1)
      {

         if (!quiet)
         {
            printf("\r  Writing %05d", mlist[wcount].new_num);
         }

         /*******************************************************************/
         /* write one msg                                                   */
         /*******************************************************************/


         if (do_renum)
         {
            itos(mlist[wcount].new_num, mlist[wcount].buf+1, 4);
         }
         last_one = mlist[wcount].new_num;
         next_rec += mlist[wcount].num_recs;
         bufsize = mlist[wcount].num_recs *128;
         write(fh, mlist[wcount].buf, bufsize);/* write                     */
         free(mlist[wcount].buf);       /* free buffer                      */
      }
      wcount++;
   }
}


/*--------------------------------------------------------------------------*/

