/* 
  Winvue file open routines.

  Most of the routines here are taken from the Microsoft TEMPLATE
  Application.  Minor adaptations have been made to suit the
  Winvue program.
*/

#define NOCOMM		
#define NOKANJI
#define NOATOM
#define NOBITMAP
#define NOMINMAX
#include <windows.h>
#include "longstr.h"
#include "winvue.h"

/* local function declarations */
static VOID NEAR DlgCheckOkEnable (HWND, int, unsigned);
static void NEAR DlgAddCorrectExtension (char *, BOOL);
static BOOL NEAR DlgCheckFilename (char *);
static BOOL NEAR DlgSearchSpec (char *);

#define ATTRDIRLIST 0x4010  /* include directories and drives in listbox */

static char *szExtSave = "\\*.TXT";	/* default extension */
int cbRootNameMax = MAX_FNAME_LEN -CBEXTMAX - 1;
	
/* This is the window proc for the about box when it is displayed */
BOOL FAR PASCAL AboutBoxProc(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{

    switch (message) {

      /* nothing to initialize */
	case WM_INITDIALOG:
	    break;

      /* this dialog box has only an OK button */
	case WM_COMMAND:
	    switch (wParam) {
		case IDOK:
		case IDCANCEL:
		/* destroy the dialog box */
		    EndDialog(hDlg,TRUE);
		    break;
		default:
		    return FALSE;		/* we did not process */
	    }
	    break;
	    
	default:
	    return FALSE;
    }
    return TRUE;		/* we processed message */
}

/*=============================================================================
 DLGFNOPEN controls the Open dialog box.  The dialog box handles input, allows
 user to change directories, checks for legal filenames, opens specified files,
 appends default extension if needed, and returns the file's name and ofstruct.
 This routine correctly parses filenames containing KANJI characters.
=============================================================================*/
int FAR PASCAL DlgFnOpen(hwnd, msg, wParam, lParam)
HWND hwnd;
unsigned msg;
WORD wParam;
LONG lParam;
{

    char rgch[256];
    int cchFile, cchDir;
    char *pchFile;
    BOOL    fWild;

    switch (msg) {
    case WM_INITDIALOG:
	/* Set edit field with default search spec */
	SetDlgItemText(hwnd, IDD_EDIT, (LPSTR)(szExtSave+1));
	/* Don't let user type more than cbRootNameMax bytes in edit ctl. */
	SendDlgItemMessage(hwnd, IDD_EDIT, EM_LIMITTEXT, cbRootNameMax, 0L);

	/* fill list box with filenames that match spec, and fill static
	   field with path name */
	if (!DlgDirList(hwnd,(LPSTR)(szExtSave+1),
					IDD_LISTBOX,IDD_PATH,ATTRDIRLIST))
	    EndDialog(hwnd, FALSE);
	break;

    case WM_COMMAND:
	switch (wParam) {
	case IDOK:
	    if (IsWindowEnabled(GetDlgItem(hwnd, IDOK))) {
		/* Get contents of edit field */
		/* Add search spec if it does not contain one. */
		GetDlgItemText(hwnd,IDD_EDIT,(LPSTR)szFileNameSave,
								cbRootNameMax);
		lstrcpy((LPSTR)rgch, (LPSTR)szFileNameSave);

		/* Append appropriate extension to user's entry */
		DlgAddCorrectExtension(rgch, TRUE);
		/* Try to open directory.  If successful, fill listbox with
		   contents of new directory.  Otherwise, open datafile. */
		if (DlgSearchSpec(rgch)) {
		    if (DlgDirList(hwnd, (LPSTR)rgch, 
					IDD_LISTBOX, IDD_PATH, ATTRDIRLIST)){
			lstrcpy((LPSTR)szFileNameSave, (LPSTR)rgch);
			SetDlgItemText(hwnd, IDD_EDIT, (LPSTR)szFileNameSave);
			break;
		    }
		}

		DlgAddCorrectExtension(szFileNameSave, FALSE);
		/* If no directory list and filename contained search spec,
		   honk and don't try to open. */
		if (DlgSearchSpec(szFileNameSave)) {
		    MessageBeep(0);
		    break;
		}
LoadIt:
		/* Make filename upper case and if it's a legal dos
		   name, try to open the file. */
		AnsiUpper((LPSTR)szFileNameSave);
		if (!DlgCheckFilename(szFileNameSave)) {
		    /* illegal filename */
		    ShowMessage(hwnd, szFileNameSave, IDS_IFN,
				MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL);
		    break;
		}
		EndDialog(hwnd, TRUE);
		break;
	    }
	    break;

	case IDCANCEL:
	    /* User pressed cancel.  Just take down dialog box. */
	    EndDialog(hwnd, FALSE);
	    break;

	/* User single clicked or doubled clicked in listbox -
	   Single click means fill edit box with selection.
	   Double click means go ahead and open the selection. */
	case IDD_LISTBOX:
	    switch (HIWORD(lParam)) {

	    /* Single click case */
	    case 1:
		GetDlgItemText(hwnd, IDD_EDIT, (LPSTR)rgch, cbRootNameMax);

		/* Get selection, which may be either a prefix to a new search
		   path or a filename. DlgDirSelect parses selection, and
		   appends a backslash if selection is a prefix */
		if (DlgDirSelect(hwnd, (LPSTR)szFileNameSave, IDD_LISTBOX)) {
		    cchDir = lstrlen((LPSTR)szFileNameSave);
		    cchFile = lstrlen((LPSTR)rgch);
		    pchFile = rgch+cchFile;

		    /* Now see if there are any wild characters (* or ?) in
		       edit field.  If so, append to prefix. If edit field
		       contains no wild cards append default search spec
		       which is  "*.TXT" for notepad. */
		    fWild = (*pchFile == '*' || *pchFile == ':');
		    while (pchFile > rgch) {
			pchFile = (char *)AnsiPrev((LPSTR)(rgch),
								(LPSTR)pchFile);
			if (*pchFile == '*' || *pchFile == '?')
			    fWild = TRUE;
			if (*pchFile == '\\' || *pchFile == ':') {
			    pchFile = (char *)AnsiNext((LPSTR)pchFile);
			    break;
			}
		    }
		    if (fWild)
			lstrcpy((LPSTR)szFileNameSave + cchDir, (LPSTR)pchFile);
		    else
			lstrcpy((LPSTR)szFileNameSave + cchDir,
							(LPSTR)(szExtSave+1));
		}

		/* Set edit field to entire file/path name. */
		SetDlgItemText(hwnd, IDD_EDIT, (LPSTR)szFileNameSave);
		break;

	    /* Double click case - first click has already been processed
	       as single click */
	    case 2:
		/* Basically the same as ok.  If new selection is directory,
		   open it and list it.  Otherwise, open file. */
		if (DlgDirList(hwnd, (LPSTR)szFileNameSave, 
				IDD_LISTBOX, IDD_PATH, ATTRDIRLIST)) {
		    SetDlgItemText(hwnd, IDD_EDIT, (LPSTR)szFileNameSave);
		    break;
		}
		goto LoadIt;	/* go load it up */
	    }
	    break;

	case IDD_EDIT:
	    DlgCheckOkEnable(hwnd, IDD_EDIT, HIWORD(lParam));
	    break;

	default:
	    return(FALSE);
	}
    default:
	return FALSE;
    }
    return(TRUE);

} /* end dlgfnopen */

/*=============================================================================
 DLGCHECKOKENABLE enables the ok button in dialog box if and only if the edit
 field contains text.
=============================================================================*/
static VOID NEAR DlgCheckOkEnable(hwnd, idEdit, message)
HWND	hwnd;
int	idEdit;
unsigned message;
{
    if (message == EN_CHANGE) {
	EnableWindow(GetDlgItem(hwnd, IDOK),
	     (BOOL)SendMessage(GetDlgItem(hwnd,idEdit),WM_GETTEXTLENGTH,0,0L));
    }
}

/*=============================================================================
 DLGADDCORRECTEXTENSION adds appropriate extension to filename, partial filename,
 search spec, or partial search spec.
==============================================================================*/
static void NEAR DlgAddCorrectExtension(szEdit, fSearching)
char	*szEdit;
BOOL	fSearching;
{
    register char    *pchLast;
    register char    *pchT;
    int ichExt;
    BOOL    fDone = FALSE;
    int     cchEdit;

    pchT = pchLast = (char *)AnsiPrev((LPSTR)szEdit, 
			(LPSTR)(szEdit + (cchEdit = lstrlen((LPSTR)szEdit))));

    if ((*pchLast == '.' && *(AnsiPrev((LPSTR)szEdit, (LPSTR)pchLast)) == '.') 
								&& cchEdit == 2)
	ichExt = 0;
    else if (*pchLast == '\\' || *pchLast == ':')
	ichExt = 1;
    else {
	ichExt = fSearching ? 0 : 2;
	for (; pchT > szEdit;pchT=(char *)AnsiPrev((LPSTR)szEdit,(LPSTR)pchT)) {
	    /* If we're not searching and we encounter a period, don't add
	       any extension.  If we are searching, period is assumed to be
	       part of directory name, so go ahead and add extension. However,
	       if we are searching and find a search spec, do not add any
	       extension. */
	    if (fSearching) {
		if (*pchT == '*' || *pchT == '?')
		    return;
	    } else if (*pchT == '.'){
		return;
	    }
	    /* Quit when we get to beginning of last node. */
	    if (*pchT == '\\')
		break;
	}
	/* Special case hack fix since AnsiPrev can not return value less than
	   szEdit. If first char is wild card, return without appending. */
	if (fSearching && (*pchT == '*' || *pchT == '?'))
	    return;
    }
    lstrcpy((LPSTR)(pchLast+1), (LPSTR)(szExtSave+ichExt));

} /* end dlgaddcorrectextension */

/*=====	check for legal filename =====*/
static BOOL near DlgCheckFilename(pch)
register char	*pch;
{
    OFSTRUCT	ofT;
    return (OpenFile((LPSTR)pch, (LPOFSTRUCT)&ofT, OF_PARSE) == 0);
}

/*====== return TRUE iff 0 terminated str contains  '*' or '?' ======*/
static BOOL NEAR DlgSearchSpec(sz) 
register char	 *sz;
{
    for (; *sz;sz++) {
	if (*sz == '*' || *sz == '?')
	    return TRUE;
    }
    return FALSE;
}
