{$Z63,S3,V+,E1,W-,F1,T0}

(*  copyright 1987, John J. Newlin
    Z63 = full optimization
     S3 = allow Pascal extensions
     V+ = allow variable length strings
     E1 = use actual procedure names for linking
     W- = suppress warnings about unused variables
     F1 = optimize for speed
     T0 = do not generate symbol table info
*)

program shell(input,output);
import sheltool;

const
  win1_beg = 5;
  win2_beg = win1_beg + 10;
  win_col = 2;
  win3_beg = 5;
  win3_col = 61;

var
  paragraphs,action,code,i : integer;
  total,count,x,y,curr_page,last_page,index : array[1..windows] of integer;
  root_dir,current_dir,default_dir,str : string;
  dir : array[1..windows] of str64;
  beg_y,max_y : array[1..windows] of integer;
  copy_flag,window_flag : boolean;
  key,last_drive : char;
  drive_list : array[1..26] of char;

procedure terminate;
begin
  code := chdir(default_dir);
  rest_cursor;
  cls(15);
  halt;
end;

procedure rename_file(oldfile,newfile : string);
var f : text;
begin
  reset(f,oldfile);
  close(f);
  rename(f,newfile);
end;

function user_entry(prompt : string) : string;
var temp,blank : string;
    i : integer;
begin
  screenwrite(4,2,main_color,prompt);
  setxy(4,3);
  rest_cursor;
  readln(temp);
  hide_cursor;
  fillstr(blank,70,chr(32));
  screenwrite(4,2,main_color,blank);
  screenwrite(4,3,main_color,blank);
  for i := 1 to length(temp) do temp[i] := upcase(temp[i]);
  user_entry := temp;
end;

procedure get_drive_list;
var regs : regtype;
    i : integer;
begin
  regs.ax := 16#0E00#;
  regs.dx := ord(current_dir[1]) - 65;
  msdos(regs);
  last_drive := chr(lo(regs.ax) + 64);
  for i := 65 to ord(last_drive) do drive_list[i-64] := chr(i);
  drive_list[ord(last_drive)-63] := chr(0);
end;

procedure copy_file(index,win : integer; var files : file_array);
var cmd : string;
    dest : integer;
begin
  if win = 1 then dest := 2 else dest := 1;
  cmd := concat('COPY ',files[index].name," ",dir[dest],' > NUL');
  cmd := concat(" ",cmd," ");
  cmd[length(cmd)] := chr(13);
  cmd[1] := chr(length(cmd));
  exec(cmd);
  copy_flag := true;
end;

procedure scroll_it(y,lines,dir : integer);
begin
  scroll(3,y,46,y+7,lines,main_color,dir);
end;

procedure drive_menu;
var i,code,index,last,keystat,ascii,scan : integer;
        str : string;

function drive_str(indx : integer) : string;
begin
  drive_str := 'Drive  ';
  drive_str[7] := drive_list[indx];
end;

begin
  last := ord(last_drive) - 64;
  draw_box(win3_col,win3_beg,10,last+1);
  scroll(win3_col+1,win3_beg+1,win3_col+8,win3_beg+last,last,main_color,0);
  for i := 1 to last do
    begin
      str := drive_str(i);
      screenwrite(win3_col+1,i+win3_beg,main_color,str);
    end;
  index := ord(current_dir[1]) - 64;
  loop
    str := drive_str(index);
    fx(8,curs_color,win3_col+1,index+win3_beg,main_color,str);
    repeat until keycode(keystat,ascii,scan);
    if scan = 1 then terminate;
    if scan = 28 then
      begin
        str[1] := drive_list[index];
        str[2] := ':';
        str[3] := chr(0);
        code := chdir(str);
        return;
      end;
    if (scan = down) then
      begin
        fx(0,curs_color,win3_col+1,index+win3_beg,main_color,str);
        if index < last then index := succ(index)
          else if index = last then index := 1;
      end;
    if (scan = up) then
      begin
        fx(0,curs_color,win3_col+1,index+win3_beg,main_color,str);
        if index > 1 then index := pred(index)
          else if index = 1 then index := last;
      end;
    if scan = tab then return;
  end;
end;

procedure top_line(y : integer; var dir : str64);
var line : string;
    i : integer;
begin
  fillstr(line,44,chr(196));
  for i := 1 to length(dir) do line[i+2] := dir[i];
  screenwrite(win_col+1,y,main_color,line);
end;

function show(index:integer; var files : file_array) : string;
var ftime,fdate : string[14];
    st : string;
    fname : str12;
    num : string;
    long : longint;
begin
   with files[index] do
     begin
       if desig = 255 then fname := '[ DELETED  ]' else
          fname := convert(name);
       long[0] := losize;
       long[1] := hisize;
       case attr of
         chr(8),chr(40)  : num := '  <VOL>';
         chr(16),chr(48) : num := '  <DIR>';
         otherwise num := format_num(long,7);
       end;
       ftime := filetime(time);
       fdate := filedate(date);
       st := concat(fname,'  ',fdate,'  ',ftime,'  ',num);
     end;
  show := st;
end;

function executable(var filename : str12) : boolean;
begin
  executable := ( (pos('.EXE',filename) > 0) or (pos('.COM',filename) > 0) or
                  (pos('.BAT',filename) > 0) );
end;

procedure view_dir(var files : file_array; win : integer; flag : boolean);
var keystat,ascii,code,scan,ytop,ymax : integer;
    name,s4,mask : string[14];
    key : char;
    ft : boolean;
    command,filedat,oldname,newname : string;
    label 88,99;

begin
  ytop := beg_y[win];
  ymax := max_y[win];
  if copy_flag then
    begin
      copy_flag := false;
      flag := true;
    end;
  88: scan := 0;
  code := chdir(dir[win]);
  top_line(ytop,dir[win]);
  if not flag then goto 99;
  scroll_it(ytop+1,8,0);
  mask := '*.*';
  get_files(mask,files,total[win]);
  if total[win] = 0 then goto 99;
  sort_files(files,total[win]);
  index[win] := 0;
  count[win] := 0;
  x[win] := 3;
  y[win] := ytop;
  last_page[win] := (total[win] div 8) + 1;
  if total[win] mod 8 = 0 then last_page[win] := pred(last_page[win]);
  curr_page[win] := 1;
  if (index[win] < total[win]) then
    loop
      count[win] := succ(count[win]);
      index[win] := succ(index[win]);
      y[win] := succ(y[win]);
      filedat := show(index[win],files);
      screenwrite(x[win],y[win],main_color,filedat);
      if  (count[win] > 7) or (index[win] >= total[win]) or (total[win] = 0) then
        begin
          y[win] := ytop + 1;
          index[win] := (curr_page[win] * 8) - 7;
      99: repeat
            curr_page[win] := (index[win] div 8);
            if index[win] mod 8 <> 0 then
               curr_page[win] := succ(curr_page[win]);
            filedat := show(index[win],files);
            if total[win] = 0 then 
              begin
                filedat := 'No files present';
                y[win] := ytop + 1;
              end;
            fx(length(filedat)+1,curs_color,x[win],
                      y[win],main_color,filedat);
            repeat until keycode(keystat,ascii,scan);
            if scan = del then
              begin
                purge(files[index[win]].name);
                files[index[win]].desig := 255;
              end;
            if scan = ins then
              begin
                oldname := files[index[win]].name;
                newname := user_entry('Enter new file name');
                rename_file(oldname,newname);
                files[index[win]].name := newname;
              end;
            if (ascii = 0) and (scan = ctrl_home) then
              begin
                dir[win] := root_dir;
                flag := true;
                goto 88;
              end;
            if (ascii = 0) and (scan = ctrl_end) then
              begin
                dir[win] := default_dir;
                flag := true;
                goto 88;
              end;
            if (ascii = 0) and (scan = ctrl_pgup) then
              begin
                s4 := '..';
                code := chdir(s4);
                getdir(dir[win]);
                flag := true;
                goto 88;
              end;
            if total[win] = 0 then return;
            if scan = 46 then copy_file(index[win],win,files);  {'c'}
            if scan = 32 then                                   {'d}
              begin
                drive_menu;
                getdir(dir[win]);
                flag := true;
                goto 88;
              end;
            if (scan = retkey) and (files[index[win]].attr = chr(16)) then
              begin
                flag := true;
                if dir[win][length(dir[win])] <> '\' then
                dir[win] := concat(dir[win],"\",files[index[win]].name) else
                  dir[win] := concat(dir[win],files[index[win]].name);
                goto 88;
              end;
            if (scan = retkey) and executable(files[index[win]].name) then
              begin
                command := files[index[win]].name;
                execute(command);
                scan := 0;
              end;
            if scan = esc then terminate;
            if scan = tab then
              begin
                screenwrite(x[win],y[win],main_color,filedat);
                return;
              end;
            if (scan in [home,down,up,pgdn,pgup,endkey]) then
              begin
                 screenwrite(x[win],y[win],main_color,filedat);
                 case scan of
                  home : if curr_page[win] > 1 then 
                           begin
                             index[win] := 0;
                             curr_page[win] := 1;
                           end else scan := 0;
                endkey : if curr_page[win] < last_page[win] then
                           begin
                             curr_page[win] := last_page[win];
                             index[win] := (last_page[win]  * 8) - 8;
                             scroll_it(ytop+1,8,0);
                           end else scan := 0;
                  down : begin
                           if index[win] = total[win] then
                             begin
                               index[win] := 
                                 index[win] - (y[win] - ytop) + 1;
                               y[win] := ytop + 1;
                             end else
                           if index[win] + 1 <= total[win] then
                             begin
                               index[win] := succ(index[win]);
                               if y[win] + 1 <= ymax then
                                 y[win] := succ(y[win]) else 
                                   scroll_it(ytop+1,1,0);
                             end;
                         end;
                    up : begin
                           if index[win] = 1 then
                             begin
                               if total[win] > 8 then
                                 begin
                                   y[win] := ymax;
                                   index[win] := index[win] + 7;
                                 end
                               else
                                 begin
                                   y[win] := ytop + total[win];
                                   index[win] := total[win];
                                 end
                             end 
                           else if index[win] - 1 >= 0 then
                             begin
                               index[win] := pred(index[win]);
                               if y[win] - 1 >= ytop + 1
                                 then y[win] := pred(y[win])
                                  else scroll_it(ytop+1,1,1);
                              end;
                          end;
                   pgup : if curr_page[win] > 1 then
                            begin
                              curr_page[win] := pred(curr_page[win]);
                              index[win] := curr_page[win] * 8 - 8;
                            end 
                          else index[win] := 0;
                   pgdn : if curr_page[win] <= last_page[win] then
                            begin
                              if curr_page[win] < last_page[win] then
                                begin
                                  index[win] := curr_page[win] * 8;
                                  curr_page[win] := succ(curr_page[win]);
                                  scroll_it(ytop+1,8,0);
                                end else scan := 0;
                            end;
                end; {of case}
              end;  {of if scan in []}
          until scan in [home,endkey,pgup,pgdn];
          y[win] := ytop;
          count[win] := 0;
        end;  {of if count[win]}
    end;  {of loop}
end;


procedure initialize;
begin
  window_flag := true;
  getdir(current_dir);
  root_dir := copy(current_dir,1,3);
  draw_box(win_col,win1_beg,46,9);
  draw_box(win_col,win2_beg,46,9);
  draw_box(1,1,78,3);
  dir[1] := current_dir;
  dir[2] := root_dir;
  beg_y[1] := win1_beg;
  beg_y[2] := win2_beg;
  max_y[1] := win1_beg + 8;
  max_y[2] := win2_beg + 8;
end;

begin
  paragraphs := set_mem;
  get_drive_list;
  cls(15);
  save_cursor;
  hide_cursor;
  getdir(default_dir);
  initialize;
  str := ' The Shell Game - by John Newlin ';
  screenwrite(6,1,main_color,str);
  loop
    view_dir(files[1],1,window_flag);
    view_dir(files[2],2,window_flag);
    if window_flag then window_flag := false;
  end;
end.

