;   ____________________________________________________
;  |                                                    |
;  |  Project:     POWER VIEW INTERFACE                 |
;  |  File:        PVHGR_.ASM                           |
;  |  Compiler:    32-bit Turbo Assembler               |
;  |                                                    |
;  |  Subject:     Fast line drawing function           |
;  |                                                    |
;  |  Author:      Emil Dotchevski                      |
;  |____________________________________________________|
; 
;  E-mail: zajo@geocities.com
;  URL:    http://www.geocities.com/SiliconValley/Bay/3577

                .386p
                model   flat

                .code
                public  draw_line_bin_

;---------------------------------------------------------------------------
; Description:
;   draws a line
; Entry:
;   edi - x1
;   esi - y1
;   ebx - x2
;   eax - y2
;   edx - plane 0 address, plane4 address==mul_table
;   cl  - ....xxxx color
;   ecx - planes step (rest of ecx)
;   ebp - xl
; Exit:
;   none
; Destroys:
;   all
;---------------------------------------------------------------------------
mul_table       dd      ?
draw_line_bin_: mov     word ptr nr_fix0,08408h ; or  p0[esi+ecx],al
                mov     word ptr nr_fix1,08408h ; or  p1[esi+ecx],al
                mov     word ptr nr_fix2,08408h ; or  p2[esi+ecx],al
                mov     word ptr nr_fix3,08408h ; or  p3[esi+ecx],al
                mov     word ptr nc_fix0,08408h ; or  p0[esi+ecx],al
                mov     word ptr nc_fix1,08408h ; or  p1[esi+ecx],al
                mov     word ptr nc_fix2,08408h ; or  p2[esi+ecx],al
                mov     word ptr nc_fix3,08408h ; or  p3[esi+ecx],al
                shr     ecx,1
                jc      dl_0010
                mov     word ptr nr_fix0,0A420h ; and p0[esi+ecx],ah
                mov     word ptr nc_fix0,0A420h ; and p0[esi+ecx],ah
dl_0010:        shr     ecx,1
                jc      dl_0020
                mov     word ptr nr_fix1,0A420h ; and p1[esi+ecx],ah
                mov     word ptr nc_fix1,0A420h ; and p1[esi+ecx],ah
dl_0020:        shr     ecx,1
                jc      dl_0030
                mov     word ptr nr_fix2,0A420h ; and p2[esi+ecx],ah
                mov     word ptr nc_fix2,0A420h ; and p2[esi+ecx],ah
dl_0030:        shr     ecx,1
                jc      dl_0040
                mov     word ptr nr_fix3,0A420h ; and p3[esi+ecx],ah
                mov     word ptr nc_fix3,0A420h ; and p3[esi+ecx],ah
dl_0040:        mov     dword ptr nr_fix0+3,edx ; or/and edx[esi+ecx],al/ah
                mov     dword ptr nc_fix0+3,edx ; (set up planes offsets)
                add     edx,ecx
                mov     dword ptr nr_fix1+3,edx
                mov     dword ptr nc_fix1+3,edx
                add     edx,ecx
                mov     dword ptr nr_fix2+3,edx
                mov     dword ptr nc_fix2+3,edx
                add     edx,ecx
                mov     dword ptr nr_fix3+3,edx
                mov     dword ptr nc_fix3+3,edx
                add     edx,ecx
                mov     mul_table,edx
                sub     ebx,edi                 ; delta x (signed)
                mov     ecx,ebx
                mov     byte ptr nc_fix4+1,0CCh ; ror ah,1
                mov     byte ptr nc_fix5+1,0C8h ; ror al,1
                mov     byte ptr nc_fix6+1,0D1h ; adc ecx,0
                jge     dl_0050
                mov     byte ptr nc_fix4+1,0C4h ; rol ah,1
                mov     byte ptr nc_fix5+1,0C0h ; rol al,1
                mov     byte ptr nc_fix6+1,0D9h ; sbb ecx,0
                neg     ecx                     ; delta x (unsigned)
dl_0050:        sub     eax,esi                 ; delta y (signed)
                mov     edx,eax
                jge     dl_0060
                neg     edx                     ; delta y (unsigned)
                neg     ebp                     ; xl (signed)
dl_0060:        cmp     ecx,edx
                jae     dl_draw_hor             ; optimize line loop

dl_draw_ver:    mov     eax,ebx                 ; delta x (signed)
                mov     ebx,edx                 ; delta y (unsigned) (ok)
                sal     eax,16                  ; 16.16 delta x (signed)
                cdq                             ; 48.16 delta x (signed)
                idiv    ebx                     ; 16.16 x step (signed)
                xchg    eax,esi
                imul    ebp
                mov     edx,esi                 ; (ok)
                or      eax,eax
                jns     dldv_0010
                neg     eax
dldv_0010:      mov     esi,eax                 ; (ok)
                sal     edi,16                  ; (ok)
                add     edi,8000h               ; 1/2
                or      ebx,ebx
                jz      dl_done
;---------------------------------------------------------------------------
; esi     - start row base
; edi     - 16.16 start column
; edx     - 16.16 column step
; ebp     - xl/-xl
; ebx     - delta_y (unsigned)
; nr_fix0 - or/and plane0[esi+edi],al/ah
; nr_fix1 - or/and plane1[esi+edi],al/ah
; nr_fix2 - or/and plane2[esi+edi],al/ah
; nr_fix3 - or/and plane3[esi+edi],al/ah
;---------------------------------------------------------------------------
next_row:       xor     ecx,ecx
                shld    ecx,edi,16
                add     edi,edx
                mov     al,80h
                ror     al,cl
                shr     ecx,3
                mov     ah,al
                not     ah
nr_fix0:        or      1111h[esi+ecx],al
nr_fix1:        or      2222h[esi+ecx],al
nr_fix2:        or      3333h[esi+ecx],al
nr_fix3:        or      4444h[esi+ecx],al
                add     esi,ebp
                dec     ebx
                jnz     next_row
                jmp     dl_done

dl_draw_hor:    sal     eax,16                  ; 16.16 delta y (signed)
                jecxz   dldh_0010
                cdq                             ; 48.16 delta_y (signed)
                idiv    ecx                     ; 16.16 y step (signed)
dldh_0010:      mov     edx,eax
                mov     ebx,esi
                sal     ebx,16                  ; (ok)
                add     ebx,8000h               ; 1/2
                mov     ebp,mul_table
                xchg    ecx,edi
                mov     al,80h
                ror     al,cl
                mov     ah,al
                not     ah
                shr     ecx,3
                or      edi,edi
                jz      dl_done
;---------------------------------------------------------------------------
; ebx     - 16.16 start row
; edx     - 16.16 row step
; ecx     - start column
; edi     - delta_x (unsigned)
; ebp     - mul table
; nc_fix0 - or/and plane0[esi+ecx],al/ah
; nc_fix1 - or/and plane1[esi+ecx],al/ah
; nc_fix2 - or/and plane2[esi+ecx],al/ah
; nc_fix3 - or/and plane3[esi+ecx],al/ah
; nc_fix4 - ror/rol ah,1
; nc_fix5 - ror/rol al,1
; nc_fix6 - adc/sbb edi,0
;---------------------------------------------------------------------------
next_col:       xor     esi,esi
                shld    esi,ebx,16
                add     ebx,edx
                mov     esi,[ebp+esi*4]
nc_fix0:        or      1111h[esi+ecx],al
nc_fix1:        or      2222h[esi+ecx],al
nc_fix2:        or      3333h[esi+ecx],al
nc_fix3:        or      4444h[esi+ecx],al
nc_fix4:        ror     ah,1
nc_fix5:        ror     al,1
nc_fix6:        adc     ecx,0
                dec     edi
                jnz     next_col

dl_done:        ret

                end
