  {
   INVADERS - D.G. Sureau - Example for Artist Of Virtuality

   Demo of how a simple loop can make the core of a game!
   Require MCGALIB, ANIMLIB and MCGAPLUS
   May work without MCGAPLUS with some changes and limitations

   Exemple montrant comment une simple boucle constitue la base d'un jeu!
   Ncessite MCGALIB, ANIMLIB et MCGAPLUS
   Peut marcher sans MCGAPLUS avec des changements et limitations
  }

Program Invaders;

Uses Dos, Crt, Memory, MCGALIB, ANIMLIB, MCGAPLUS;

Const

 ESCAPE  = '';
 VGA256  = 19;
 TEXT    = 3;
 REALSEG = $A000;

 { Max size for monster path / Taille maximale du chemin du monstre }
 { Format is:   Number: 1 integer
 {              x     : 1 integer
 {              y     : 1 integer
 {              etc...
 { Max size in integer: number of location * 2 + 1; }

 MAXPATH = 1024;

 { Series }

 SHIP_SERIES =    1;
 MONSTER_SERIES = 2;
 SCENERY_SERIES = 3;

 { Types of sprites }

 SPRITE_16 = 5;
 SPRITE_256 = 1;
 SPRITE_PACKED = 4;


Type
  ObjectPath = Array[0..MAXPATH * 2 + 1] of integer;

Var
 PALETTE : Pointer;            { Palette buffer }
 VIRTUALSCREEN : Pointer;      { Buffer for virtual screen }
 VIRTUALSEG : Word;            { segment of the virtual screen }
 MONSTER_PATH : ^ObjectPath;   { Buffer for path }
 XPATH, YPATH : Integer;       { Location in path }
 MONSTER_PATH_POS: Integer;    { Level in the path array }

   { Error messages / Messages d'erreur }

Procedure NoFound(name : string);
Begin
 Writeln('File no found ',name);
 Halt(1);
End;

Procedure NoMemory;
Begin
 Writeln('Not enough memory');
 Halt(1);
End;

    { Function for loading any binary file }
    { Fonction qui charge tout fichier binaire }

Function Bload(fname: string; buffer : Pointer; fsize : word): integer;
Var
 Result: Integer;
 FP : File;
Begin
  Assign(FP, fname);
  Reset(FP, 1);
  BlockRead(FP, buffer^, fsize, result);
  Close(FP);
  Bload := result;
End;


   { GET PATH }
   { Return the location in a path }
   { Donne la position dans un chemin }

Procedure GetPath(PathPtr : ObjectPath; Level: integer);
Var
 Number : Integer;
Begin
 Number := Level * 2 + 1;
 XPATH  := PathPtr[Number];
 YPATH  := PathPtr[Number + 1];
End;

  { Local variables }

Var
 x, y   : integer;
 SPRMAX : integer;
 ch     : char;
 K      : integer;                 { Key pressed, integer }
 i      : integer;
 monster_first: integer;           { Alien first sprite of animation }
 ship_first: integer;              { First sprite of ship animation }
 monster_animation_size: integer;  { Number of frames of monster animation}
 ship_animation_size: integer;     { Number of frames of player's ship animation }
 ship_frame: integer;              { Frame number, for player's ship }
 monster_frame: integer;           { Frame number, for alien }
 ship_cycling: integer;            { Cycle counter to slow animation }
 monster_cycling: integer;
 xscenery: integer;                { To scroll scenery / Dfilement dcor }
 yscenery: integer;
 scenery_cycling: integer;
 scenery_sprite: integer;

Begin

   { First, allocation of memory buffer }
   { D'abord, allocation des tampons en mmoire }

  if Sprite_Alloc(65512) = False Then NoMemory;

  GetMem(MONSTER_PATH, MAXPATH * 4 + 2);
  GetMem(PALETTE, 1024);

   {
    Allocating an alternate screen. This is allocated in far heap
    A 0 offset is required as for the real screen and the segment
    is calculated by setvirtual() for that

    On alloue un tampon pour un ecran virtuel qui sera dans la
    "far heap". Un offset de 0 est requis comme pour l'ecran reel
    aussi setvirtual() calcule le segment en consequence
   }

 VIRTUALSCREEN := MemAllocSeg(64000);
    VIRTUALSEG := SEG(VIRTUALSCREEN^);

   { Displaying allocation }
   { Prsentation de l'allocation    }

  writeln('Buffer ',  SEG(VIRTUALSCREEN^),':', OFS(VIRTUALSCREEN^));

   { Loading sprites  }
   { Chargement des sprites }

 write('Loading sprites...');

 SPRMAX := Sprites_Load('invaders.dat', 65512);
 if(SPRMAX = 0) Then NoFound('invaders.dat')
 else writeln('Ok');

 writeln(SPRMAX, ' sprites');
 writeln(FRAMESIZE,' frames max./animation');

   { Loading monster's paths }
   { On charge les chemins des monstres }

 write('Loading monster''s path...');

 i := Bload('invaders.pth', MONSTER_PATH, FileLength('invaders.pth') );
 writeln('ok ',i,' bytes loaded');
 writeln(MONSTER_PATH^[0], ' locations in path');


    { Loading palette }

 write('Loading palette...');
 i := bload('invaders.pal', PALETTE, 768);
 writeln('Ok ', i, ' bytes loaded');

 writeln('< Press a key to continue >');

 if(Readkey = ESCAPE) Then Halt(1);

  {
   Setting VGA 256 colors screen and setting the
   loaded palette to the system, in this order.
   Ecran en mode VGA 256 couleurs et changement de palette,
   dans cet ordre.
  }

 selectscreen(VGA256);
 writeRGB(PALETTE);

   { Setting a full screen window }
   { On utilise une fentre plein cran }

 VGASCREEN := REALSEG;
 window19(0, 0, 319, 199);

 xscenery        := 200;
 yscenery        := 100;
 scenery_cycling := 0;

 scenery_sprite := get_first(SCENERY_SERIES) + 1;

    { Get start or animation and size - series 2 for player sprites }
    { Dbut d'animation et taille - la srie 2 est celle du vaisseau }

 ship_first          := get_first(SHIP_SERIES);
 ship_animation_size := get_frame_number(SHIP_SERIES);
 ship_frame          := 0;
 ship_cycling        := 0;
 x                   := 140;        { Starting location of the ship }
 y                   := 25;

    { Series 1 for ship sprites }
    { La srie 1 est celle des sprites des monstres }

 MONSTER_PATH_POS       := 1;
 monster_first          := get_first(MONSTER_SERIES);
 monster_animation_size := get_frame_number(MONSTER_SERIES);
 monster_frame          := 0;
 monster_cycling        := 0;

    { Working on virtual screen   }
    { On agit sur l'cran virtuel }

 VGASCREEN := VIRTUALSEG;

 Repeat Begin

    { Make background with scrolling tiles }
    { Cration fond avec dcor dfilant }

  cls19(0);
  csprite256c(xscenery, yscenery, SPVECTOR[scenery_sprite]);


    { Setting X/YPATH to next location in the invaders's path }
    { On affecte  X/YPATH la position suivante de l'envahisseur }

  GetPath(MONSTER_PATH^, MONSTER_PATH_POS);
  Inc(MONSTER_PATH_POS);
  if( MONSTER_PATH_POS > MONSTER_PATH^[0]) Then
    MONSTER_PATH_POS := 0;

    { Player's ship / Vaisseau du joueur }

  sprite256(x , y, SPVECTOR[ship_first + ship_frame]);

    { Alien's sprite / Sprite de l'envahisseur }

  sprite256c(XPATH, YPATH, SPVECTOR[monster_first + monster_frame]);

    { Wait refresh and copy virtual screen over real one }
    { Attente rafraichissement et recopie de l'cran virtuel sur le rel }

  Synchro;
  copyscreen(VIRTUALSEG, REALSEG);

   { Scrolling background }
   { Scrolling du dcor }

  Inc(scenery_cycling);
  if(scenery_cycling = 4) Then
   Begin
    Dec(yscenery);
    scenery_cycling := 0;
   End;

    { Next image of the alien animation }
    { Image suivante dans l'animation de l'envahisseur }

  Inc(monster_cycling);
  if (monster_cycling = 4) Then
  Begin
   Inc(monster_frame);
   if( monster_frame >= monster_animation_size) Then monster_frame := 0;
   monster_cycling := 0;
  End;

    { Next image of the ship animation }
    { Image suivante dans l'animation du vaisseau }

  Inc(ship_cycling);
  if(ship_cycling = 1) Then
  Begin
   Inc(ship_frame);
   if (ship_frame >= ship_animation_size) Then ship_frame := 0;
   ship_cycling := 0;
  End;

    { Keyboard input / Entre clavier }

  if(KeyPressed) Then
   Begin
    ch := Readkey;
    if ch = Chr(0) Then  K := 1000 + Ord(Readkey)
                    else K := Ord(ch);
    CASE K OF
     1075: Dec(x);
     1077: Inc(x);
    End;

   if(x < 20) Then  x := 20;
   if(x > 300) Then x := 300;
  End;

  Delay(5);

 End;
 Until (ch = ESCAPE) OR (yscenery = 0);

    { Restore DOS text screen and exit program }
    { Retour  l'cran texte du DOS et sortie du programme }

 selectscreen(TEXT);
 Halt(1);

End.
