.model tiny
.186
.code
org 100h

start:      mov   ax, 13h           ; set video mode 13h (320x200x256)
            int   10h

            mov   ax, 40h           ; seed random number with clock timer
            mov   ds, ax
            mov   bp, ds:[06Ch]

            mov   ax, cs            ; ds, es = segment of the working buffer
            add   ax, 1000h         ; here we use the 64K segment immediately
            mov   ds, ax            ; following the code segment
            mov   es, ax

            xor   ax, ax            ; clear the buffer
            xor   di, di
            mov   cx, 8000h
            rep   stosw

            mov   ax, 0A000h        ; es = video memory (at 0A000h)
            mov   es, ax

            xor   bx, bx            ; bx = 0
                                    ; random number generation loop:
rand:       imul  bp, 9421          ;  generate random number using linear
            inc   bp                ;  congruential formula 9421*n+1
            mov   ax, bp            ;  ax = high bit of bp
            shr   ax, 15
            mov   [bx], al          ;  set this byte in the buffer, then
            inc   bx                ;  loop back to do next byte
            cmp   bx, 64000
            jb    rand

life:       xor   si, si            ; si = 0
                                    ; calculation loop:
calc:       mov   al, [si-1]        ;  al = number of surrounding
            add   al, [si+1]        ;  pixels that are on.
            add   al, [si-319]
            add   al, [si+319]
            add   al, [si-320]
            add   al, [si+320]
            add   al, [si-321]
            add   al, [si+321]
            and   al, 7Fh           ;  mask off high bit

            cmp   al, 2             ;  2 neighbors = stay
            je    stay
            cmp   al, 3             ;  3 neighbors = birth
            jne   cdone             ;  all others = die

birth:      mov   al, 80h           ;  new pixel value = 1
            or    [si], al
            jmp   cdone

stay:       mov   al, [si]          ;  new pixel value = old pixel value
            shl   al, 7
            or    [si], al

cdone:      inc   si                ;  loop back to do next byte
            cmp   si, 64000
            jb    calc

            xor   si, si            ; si, di = 0
            xor   di, di
                                    ; clearing loop:
clear:      mov   al, [si]          ;  load this byte
            shr   al, 7             ;  shift down, setting new pixel value
            mov   [si], al          ;  store in buffer

            neg   al                ;  0 --> 0, 1 --> 0Fh
            and   al, 0Fh
            stosb                   ;  write to screen
            inc   si                ;  loop back to do next byte
            cmp   si, 64000
            jb    clear

            mov   ah, 1             ; check for keypress
            int   16h
            jz    life              ; loop while no key has been pressed

            mov   ax, 3             ; restore text mode
            int   10h
            int   20h               ; return to dos

end start
