/*
*
* poly.h -- defines for the Polyphonic Music functions
*
****************/

/* note values of octave which contains middle C on my TURBO XT cloane */
#define CNAT_M 390 
#define CSHA_M 413
#define DNAT_M 438
#define DSHA_M 462
#define ENAT_M 490
#define ESHA_M 519
#define FNAT_M 519
#define FSHA_M 550
#define GNAT_M 583
#define GSHA_M 618
#define ANAT_M 655
#define ASHA_M 694
#define BNAT_M 736
#define BSHA_M 779

/* 
   note: to find a note value, newval, ONE HALF STEP above a value x:
   			newval = x / 0.94365
   ONE HALF STEP below: 
   			newval = x * 0.94365
*/

/* defines for voice, tempo, values, etc. */

#define TCHANGE	16384   /* constant values to use in poly() and tritone() */
#define V1	32768
#define V2 	40960
#define V3	49152
#define V4  	53744   /* note: this is only in prototype stages, poly() will interpret as V3 */
#define DUR	8192
#define KBCHECK 24576
#define STOP	0

/* function definitions: */

int playpoly(char *, int);
int looppoly(char *, int);
int playpolykb(char *, int);
int looppolykb(char *, int);

unsigned *sngopen(char *plyfilename, int defaulttempo);
int sngclose(unsigned *tune);

unsigned plytempo( int, int, unsigned, unsigned );

void poly( unsigned * );
void polykb( unsigned * );
