/*
 * File: fxwindw.r - X-Icon RTL interface (see also fxgrafx.r, fxwicon.r)
 *
 * Contents: XAttrib, XBg, XBind, XClearArea,
 *  XColor, XCopyArea, XDefault, XEraseArea, XEvent, XFg, XFlush, XFont,
 *  XGotoRC, XGotoXY, XMoveWindow, XNewColor, XPending, XQueryPointer,
 *  XReadImage, XSetStipple, XSync, XTextWidth, XWarpPointer, XWriteImage
 */

#ifdef XIcon

/*
 * This does not really belong here, but here it goes; a poll counter
 * for use in interp.c
 */
int pollctr;

/*
 * These do not really belong here, but here they are: global variables
 *  to hold &col, &row, &x, &y, &interval, timestamp, and modifier keys.
 */
#ifndef MultiThread
struct descrip amperX = {D_Integer};
struct descrip amperY = {D_Integer};
struct descrip amperCol = {D_Integer};
struct descrip amperRow = {D_Integer};
struct descrip amperInterval = {D_Integer};
uword prevtimestamp;
uword xmod_control, xmod_shift, xmod_meta;
#endif


"XActive() - produce the next active window"

function{0,1} XActive()
   abstract {
      return file
      }
   body {
#ifndef PresentationManager
      static int last = 0;
      int i,first=last,nwindows=0,j;
      wdp wd;
      wsp ws;

      if (wdsplys == NULL || wstates == NULL) fail;
      for(ws = wstates; ws; ws=ws->next) nwindows++;

      if (first >= nwindows)
	 first = nwindows - 1;

      if (wdsplys->next == NULL) {
	 /*
	  * Only one display is open; should special case this to
	  * directly call XNextEvent.
	  */
         }

      /*
       * In the more general case there may be several displays open, and
       * we can't block on any one of them, so instead we must infinite
       * loop, checking for an event somewhere, sleeping in between.
       */
      while (1) {
	 for(wd = wdsplys; wd; wd = wd->next) {
	    int hm;
	    if ((hm = handle_misc(wd, NULL)) < 1) {
	       if (hm == 0)
		  fail;
	       else runerr(141);
	       }
            }
         do {
	    last = (last+1)%nwindows;
	    for(ws = wstates, j=0; j<=last && ws; ws=ws->next, j++) {
	       if (BlkLoc(ws->listp)->list.size > 0) {
		  return ws->filep;
		  }
		}
	  } while (first != last);
/*
 * The following code is operating-system dependent [@fxwindw.01].  Delay for
 * XICONSLEEP microseconds.
 */
#if UNIX
	/*
	 * call select() to delay, as in the delay() function
	 */
#ifdef FD_SET
#define FD_NULL ((fd_set *) 0)
#else					/* FD_SET */
#define FD_NULL ((long *) 0)
#endif					/* FD_SET */
	 {
         struct timeval t;
         t.tv_sec = 0;
         t.tv_usec = XICONSLEEP;
         select(1, FD_NULL, FD_NULL, FD_NULL, &t);
	 }
#else					/* UNIX */
#if VMS
/* nothing ?? */
#else					/* VMS */
Deliberate syntax error
#endif					/* VMS */
#endif					/* UNIX */

/*
 * end of operating-system dependent code
 */
         }
#else					/* PresentationManager */
      static LONG next = 0;
      LONG i, j;
      wstate *ptr, *ws, *stdws;

      /* make sure we are still in bounds */
      next %= NumWindows;
      /* position ptr on the next window to get events from */
      for (ptr = wstates, i = 0; i < next; i++, ptr = ptr->next);
      /* make sure we are up-to-date */
      ObtainEvents(NULL, NO_WAIT_EVT);
      stdws = (ConsoleBinding) ? ((wbinding *)ConsoleBinding)->window : NULL;
      for (;;) {
        /* go through windows, looking for one with an event pending */
        for (ws = ptr, i = 0, j = next + 1; i < NumWindows;
             (ws = (ws->next) ? ws->next : wstates), i++, j++)
          if (ws != stdws && BlkLoc(ws->listp)->list.size > 0) {
            next = j;
            return ws->filep;
            } /* End of if - found a window with an event pending */
        /* couldn't find a pending event - wait for an event */
        ObtainEvents(NULL, WAIT_EVT);
        } /* End of for - loop until we get an event */
      /* should never get out here */
      fail;
#endif					/* PresentationManager */
      }
end


"XAttrib(argv[]) - read/write window attributes"

function{*} XAttrib(argv[argc])

   abstract {
      return file++string
      }

   body {
      wbp _w_;
      word n;
      tended struct descrip sbuf;
      char answer[128], *answerp = NULL;
      long answerlen;
      int  pass;
      int noneread=1;
      int warg = 0;

      OptWindow

      /*
       * Loop through the arguments.
       */
      for (pass = 1; pass <= 2; pass++)
         for (n = warg; n < argc; n++) {
            if (is:file(argv[n])) {/* Current argument is a file */
               /*
                * Switch the current file to the file named by the
                *  current argument providing it is a file.  argv[n]
                *  is made to be a empty string to avoid a special case.
                */
               if (!(BlkLoc(argv[n])->file.status & Fs_Window))
                  runerr(140,argv[n]);
               _w_ = (wbp)BlkLoc(argv[n])->file.fd;
               argv[n] = emptystr;
               }
            else {	/* Current argument is a string */
               /*
                * Convert the argument to a string, defaulting
		*  to a empty string.
                */
               if (is:null(argv[n]))
                  argv[n] = emptystr;
               if (!cnv:tmp_string(argv[n], sbuf)) 
                  runerr(109, argv[n]);
               /*
                * Read/write the attribute
                */
               if((pass == 1) &&
		  strnchr(StrLoc(argv[n]), '=', StrLen(argv[n]))) {
                  /*
                   * pass 1: perform attribute assignments, ignore result
                   */
                  if (wattrib(_w_, StrLoc(argv[n]), StrLen(argv[n]),
			      answer) != Succeeded) fail;
		  answerp = answer;
                  }
               else if((pass==2) &&
		       !strnchr(StrLoc(argv[n]),'=',StrLen(argv[n]))){
                  /*
                   * pass 2: perform attribute queries, suspend result(s)
                   */
                  noneread = 0;
                  if (wattrib(_w_, StrLoc(argv[n]), StrLen(argv[n]),
			      answer) != Succeeded) fail;
		  answerp = answer;
                  if (argc-warg==1) while(*answerp && (*answerp++!='=')) ;

                  answerlen = strlen(answerp);
		  Protect(answerp = alcstr(answerp,answerlen), runerr(0));
                  suspend string(answerlen,answerp);
                  }
               }
            }
      if (answerp && noneread)
         return nulldesc;
      else
         fail;
      }
end


"XBg(w,x,g,b) - background color"

function{0,1} XBg(argv[argc])

   abstract {
      return string
      }

   body {
      wbp _w_;
      int _x_, _g_, _b_;
      char sbuf1[MaxCvtLen];
      int len;
      tended char *tmp;
      int warg = 0;
      int ac = argc;
#ifdef PresentationManager
      LONG rgb;
#endif					/* PresentationManager */

      OptWindow

      /*
       * trim trailing null arguments
       */
      while (is:null(argv[ac-1])) ac--;
      /*
       * If there are 3 (non-window) arguments we are setting by
       * r, g, b decimal
       */
      if (ac - warg == 3) {
	 CnvCInteger(argv[warg], _x_)
	 CnvCInteger(argv[warg + 1], _g_)
	 CnvCInteger(argv[warg + 2], _b_)
#ifndef PresentationManager
         sprintf(sbuf1, "%d,%d,%d", _x_, _g_, _b_);
	 if(!setbg(_w_, sbuf1)) fail;
#else					/* PresentationManager */
         /* no sense in putting them in a string if we'll just
            have to break them out again */
         RGB16TO8(_x_); RGB16TO8(_g_); RGB16TO8(_b_);
         rgb = MAKERGB(_x_, _g_, _b_);
         if (!setbg(_w_, rgb)) fail;
#endif					/* PresentationManager */
         }

      /*
       * If there is 1 (non-window) argument we are setting by
       * either a mutable color (negative int) or a string name.
       */
      else if (ac - warg == 1) {
#ifndef PresentationManager
	 if (is:integer(argv[warg])) {    /* check for neg int */
	    if (!isetbg(_w_, IntVal(argv[warg]))) fail;
	    }
	 else {
	    if (!cnv:C_string(argv[warg], tmp))
	       runerr(103,argv[warg]);
	    if(!setbg(_w_, tmp)) fail;
	    }
         }

      /*
       * In any event, this function returns the current background color.
       */
      len = strlen(_w_->context->bg->name);
      Protect(tmp = alcstr(_w_->context->bg->name, len), runerr(0));
#else					/* PresentationManager */
         /* must be a string name for a color */
         if (!cnv:C_string(argv[warg], tmp))
           runerr(103, argv[warg]);
         if (((rgb = ParseRGBValue(tmp)) < 0 &&
              (rgb = si_s2i(siColorNames, tmp)) < 0) || !setbg(_w_, rgb)) 
           fail;
         } /* End of if - string name */
      /* get the name to return */
      GetColorName(_w_->context->charBundle.lBackColor, sbuf1, MaxCvtLen);
      len = strlen(sbuf1);
      Protect(tmp = alcstr(sbuf1, len), runerr(0));
#endif					/* PresentationManager */
      return string(len, tmp);
      }
end

/*
 *	Bind the window associated with w to the graphics context
 *	associated with w2.  If w2 is omitted, create a new graphics context.
 *	Produces a NEW file variable.  Accepts any number of additional
 *	arguments which are passed to wattrib as in open().
 */
#ifdef PresentationManager
"XBind(w,w2,attribs[argc]) - bind window to context"

function{0,1} XBind(w,w2,attribs[argc])

   abstract {
      return file
      }

   body {
     tended struct descrip sbuf;
     tended struct b_list *hp;
     tended struct b_lelem *bp;
     wbinding *wb, *wb_new;
     char answer[128];
     wcontext *wc;
     wstate *ws;
     int i, n;
     SIZEL size = {0, 0};     

     /* make the new binding */
     Protect(wb_new = alc_wbinding(), runerr(0));
     /* if w is a file, then we bind to an existing window */
     if (is:file(w) && (BlkLoc(w)->file.status & Fs_Window)) {
       wb = (wbp)(BlkLoc(w)->file.fd);
       wb_new->window = ws = wb->window;
       if (is:null(w2) || is:string(w2)) {
         Protect(wb_new->context = wc = clone_context(wb), runerr(0));
         } /* End of if - clone context from w2 */
       else if (is:file(w2) && (BlkLoc(w)->file.status & Fs_Window)) {
         /* get the context */
         wb = (wbp)(BlkLoc(w2)->file.fd);
         wb_new->context = wc = wb->context;
         /* another reference to wc */
         wc->refcount++;
         /* Make sure font and such are loaded for that window */
         /* pattern ... */
         AddPatternToWindow(ws, wc->currPattern);
         /* font .. */
         AddFontToWindow(ws, wc->charBundle.usSet);
         } /* End of else - bind existing context */
       else 
         runerr(140, w2);
       /* bump up refcount to ws */
       ws->refcount++;
       /* make the dependencies */
       if (!AddWindowDep(ws, wc) || !AddContextDep(ws, wc))
         runerr(0);
       } /* End of if - window already exists */
     else if (is:file(w) && !(BlkLoc(w)->file.status & Fs_Window))
       runerr(140, w);
     else {
       /* have to make a bitmap */
       wb_new->context = wc = alc_context(wb_new);
       wb_new->window = ws = alc_winstate();
       /* make the dependencies */
       if (!AddWindowDep(ws, wc) || !AddContextDep(ws, wc))
         runerr(0);
       /* build the presentation space and DC for the bitmap */
       ws->hdcBitmap = DevOpenDC(HInterpAnchorBlock, OD_MEMORY, "*", 0, NULL,
                                 NULLHANDLE);
       ws->hpsBitmap = GpiCreatePS(HInterpAnchorBlock, ws->hdcBitmap, &size,
                                   PU_PELS | GPIA_ASSOC | GPIT_MICRO);
       /* load the default attributes */
       LoadDefAttrs(wb_new, ws, wc);
       SETINITIAL(wb_new);
       } /* End of else - no window, just a backing bitmap */

     /* run through the attributes */
     if (is:string(w) && (wattrib(wb_new, StrLoc(w), StrLen(w), answer)
     != Succeeded)) fail;
     if (is:string(w2) && (wattrib(wb_new, StrLoc(w2), StrLen(w2), answer)
     != Succeeded)) fail;
     for (n = 0; n < argc; n++){
       if (!is:null(attribs[n])) {
         if (!cnv:tmp_string(attribs[n], sbuf))
           runerr(109, attribs[n]);
         if (wattrib(wb_new, StrLoc(attribs[n]), StrLen(attribs[n]), answer)
         != Succeeded)  fail;
         } /* End of if - attribute not null */
       } /* End of for - go through attributes */

     /* have to finish up some bitmap stuff */
     if (is:null(w) || is:string(w)) {
       CLRINITIAL(wb_new);
       /* allocate a dummy event queue for the bitmap 'window' */
       Protect(hp = alclist(0), runerr(0));
       Protect(bp = alclstb(MinListSlots, (word)0, 0), runerr(0));
       hp->listhead = hp->listtail = (union block *) bp;
       ws->listp.dword = D_List;
       BlkLoc(ws->listp) = (union block *)hp;
       /* make the bitmap */
       ResizeBackingBitmap(ws, ws->width, ws->height);
       } /* End of if - dealing with a backing bitmap */

     /* make the file descriptor to return */
     Protect(BlkLoc(result) =
            (union block *)alcfile((FILE *)wb_new,Fs_Window|Fs_Read|Fs_Write,
                                   &emptystr),runerr(0));
     result.dword = D_File;
     return result;
     } /* End of body */
end
#else					/* PresentationManager */
"XBind(w,w2,attribs[argc]) - bind window to context"

function{0,1} XBind(w,w2,attribs[argc])

   abstract {
      return file
      }

   body {
      wbp _w_, _w2_;			/* new binding will be in _w2_ */
      tended struct descrip sbuf;
      tended struct b_list *hp;
      tended struct b_lelem *bp;
      int i,n;
#ifdef XWindows
      char dispchrs[256], answer[128];
      char *display = NULL;
      XGCValues gcv;
      int gcmask = GCFont | GCForeground | GCBackground |
        GCFillStyle | GCLineWidth | GCLineStyle;
#endif					/* XWindows */

      if (is:file(w) && (BlkLoc(w)->file.status & Fs_Window)) {
         _w_ = (wbp)(BlkLoc(w)->file.fd);
         if (is:null(w2) || is:string(w2)) {

	    for(i=0;i<argc;i++) {
	       if (is:string(attribs[i]) &&
		   (StrLen(attribs[i])>8) &&
		   !strncmp("display=",StrLoc(attribs[i]),8)) {
		  fail;
		  }
	       }

	    /*
	     * create a new context for an existing window
	     */
            Protect(_w2_ = alc_wbinding(), runerr(0));
            _w2_->window = _w_->window;
            _w2_->window->refcount++;
            Protect(_w2_->context = clone_context(_w_), runerr(0));
	    if (_w2_->context->clipx || _w2_->context->clipy ||
		_w2_->context->clipw || _w2_->context->cliph)
	       setclip(_w2_);
            }
         else if (is:file(w2) && (BlkLoc(w2)->file.status & Fs_Window)) {
	    /*
	     * bind an existing window to an existing context
	     */
            wbp w3;

	   for(i=0;i<argc;i++) {
	      if (is:string(attribs[i]) &&
		  (StrLen(attribs[i])>8) &&
		  !strncmp("display=",StrLoc(attribs[i]),8)) {
		 fail;
	         }
	      }

            w3 = (wbp)(BlkLoc(w2)->file.fd);

	    if (_w_->window->display != w3->context->display) {
	       fail;
	       }

            Protect(_w2_ = alc_wbinding(), runerr(0));
            _w2_->window = _w_->window;
            _w2_->window->refcount++;
            _w2_->context = w3->context;
            _w2_->context->refcount++;
            }
         else {
            runerr(140,w2);
            }
         }
      else {
	 /*
	  * create a new binding with no actual window, just a pixmap
	  */
         wsp ws;

	 for(i=0;i<argc;i++) {
	    if (is:string(attribs[i]) &&
		(StrLen(attribs[i])>8) &&
		!strncmp("display=",StrLoc(attribs[i]),8)) {
	       mystrncpy(dispchrs,StrLoc(attribs[i])+8,StrLen(attribs[i])-8);
	       display = dispchrs;
	       }
	    }

         Protect(_w2_ = alc_wbinding(), runerr(0));
         Protect(ws = _w2_->window = alc_winstate(), runerr(0));

	 if (display != NULL) {
	    Protect(_w2_->window->display = alc_display(display),
		   {_w2_->window->refcount=0; fail;});
	    }
	 else {
	    Protect(_w2_->window->display = alc_display(NULL),
		   {_w2_->window->refcount=0; fail;});
	    }
         Protect(_w2_->context = alc_context(_w2_), runerr(0));

         ws->win = (Window) NULL;
         ws->height = _w2_->context->font->height * 12 + (MARGIN << 1);
         ws->width  = _w2_->context->font->fsp->max_bounds.width * 80 +
		      (MARGIN << 1);
         ws->y = MARGIN + _w2_->context->font->fsp->max_bounds.ascent;
         ws->x = MARGIN;
         }

      /*
       * Loop through any remaining arguments.
       */
      if (is:string(w))
         if (wattrib(_w2_, StrLoc(w), StrLen(w), answer) != Succeeded) {
            fail;
            }
      if (is:string(w2))
         if (wattrib(_w2_, StrLoc(w2), StrLen(w2), answer) != Succeeded) {
            fail;
            }
      for (n = 0; n < argc; n++){
         if (!is:null(attribs[n])) {
            if (!cnv:tmp_string(attribs[n], sbuf))
               runerr(109, attribs[n]);
            /*
             * write the attribute
             */
     if (wattrib(_w2_, StrLoc(attribs[n]), StrLen(attribs[n]), answer)
               != Succeeded) {
               fail;
               }
            }
         }
      if (is:file(w) && BlkLoc(w)->file.status & Fs_Window) {
         Protect(BlkLoc(result) =
            (union block *)alcfile((FILE *)_w2_,Fs_Window | Fs_Read | Fs_Write,
                                   &(BlkLoc(w)->file.fname)), runerr(0));
	 result.dword = D_File;
         }
      else {
	 /*
	  * If this binding has no window, create a backing pixmap for it.
	  */
#ifdef XWindows
         XGCValues gcv;
         int gcmask = GCFont | GCForeground | GCBackground;
#endif					/* XWindows */
         STDLOCALS(_w2_);

         gcv.foreground = wc->fg->c;
         gcv.background = wc->bg->c;
         gcv.font       = wc->font->fsp->fid;

         ws->pixwidth = ws->width;
         ws->pixheight = ws->height;
         if(ws->prepix) {
            ws->pix = ws->prepix;
            stdpix = ws->pix;
	    }
         else {
#ifdef XWindows
            ws->pix = XCreatePixmap(stddpy,DefaultRootWindow(stddpy),
                                    ws->width, ws->height,
                                    DefaultDepth(stddpy,wd->screen));
#endif					/* XWindows */
            stdpix = ws->pix;
            }

         if(stdgc == NULL) {
#ifdef XWindows
	    wc->gc = XCreateGC(stddpy, stdpix, gcmask, &gcv);
#endif					/* XWindows */
	    stdgc = wc->gc;
	    if (stdgc == NULL) fail;
            }
         else {
#ifdef XWindows
            XChangeGC(stddpy, stdgc, gcmask, &gcv);
#endif					/* XWindows */
            }

	 ws->winbg = wc->bg;
	 ws->winbg->refcount++;

         if (ws->prepix) ws->prepix = (Pixmap) NULL;
         else eraseArea(_w2_, 0, 0, 0, 0);

#ifdef XWindows
         if(wc->fillstyle) {
	    XSetFillStyle(stddpy,stdgc,wc->fillstyle);
            }
         else wc->fillstyle = FillSolid;
         if(wc->linestyle || wc->linewidth) {
	    XSetLineAttributes(stddpy, stdgc, wc->linewidth, wc->linestyle,
	                       CapButt, JoinRound);
            }
         else wc->linestyle = LineSolid;
#endif					/* XWindows */

         Protect(BlkLoc(result) =
            (union block *)alcfile((FILE *)_w2_,Fs_Window|Fs_Read|Fs_Write,
				   &emptystr),runerr(0));
	 result.dword = D_File;
         /*
	  * allocate a dummy event queue for the window
	  */
	 Protect(hp = alclist(0), runerr(0));
	 Protect(bp = alclstb(MinListSlots, (word)0, 0), runerr(0));
	 hp->listhead = hp->listtail = (union block *) bp;
	 _w2_->window->listp.dword = D_List;
	 BlkLoc(_w2_->window->listp) = (union block *)hp;
         }
      return result;
      }
end
#endif

"XClearArea(w,x,y,width,height) - clear an area of the window"

function{1} XClearArea(argv[argc])

   abstract {
      return file
      }

   body {
      wbp _w_;
      int warg = 0, i, n;
      int x = 0, y = 0, width = 0, height = 0;
      int dx, dy;

      OptWindow

      dx = _w_->context->dx;
      dy = _w_->context->dy;

      if (argc-warg < 4) {
	 switch (argc-warg) {
	 case 3: {
	   CnvCInteger(argv[warg + 2], width) /* fall through */
	     }
	 case 2: {
	   CnvCInteger(argv[warg + 1], y)     /* fall through */
	     }
	 case 1: {
	   CnvCInteger(argv[warg], x)
	     }
	 }
	 x += dx;
	 y += dy;
	 clearArea(_w_, x, y, width, height);
	 ReturnWindow;
         }

      CheckArgMultiple(4)

      for ( i = 0; i < n; i++) {
	 int base = warg + i * 4;
	 DefCInteger(argv[base], 0, x)
	 DefCInteger(argv[base + 1], 0, y)
	 DefCInteger(argv[base + 2], 0, width)
	 DefCInteger(argv[base + 3], 0, height)
	 x += dx;
         y += dy;
         clearArea(_w_, x, y, width, height);
         }

      ReturnWindow;
      }
end


"XClip(w, x, y, w, h) - set context clip rectangle"

function{1} XClip(argv[argc])
   abstract {
      return file
      }
   body {
      wbp _w_;
      int warg = 0;
      wcp wc;

      OptWindow

      wc = _w_->context;
      if (argc-warg > 0) CnvCShort(argv[warg], wc->clipx)
      else wc->clipx = 0;
      if (argc-warg > 1) CnvCShort(argv[warg+1], wc->clipy)
      else wc->clipy = 0;
      if (argc-warg > 2) CnvCShort(argv[warg+2], wc->clipw)
      else wc->clipw = 0;
      if (argc-warg > 3) CnvCShort(argv[warg+3], wc->cliph)
      else wc->cliph = 0;

      wc->clipx += wc->dx;
      wc->clipy += wc->dy;

      setclip(_w_);

      ReturnWindow;
      }
end


#ifndef PresentationManager
"XColor(w,i,x,g,b) - return or set color map entry i"

function{0,1} XColor(argv[argc])

   abstract {
      return file ++ string
      }

   body {
      wbp _w_;
      wdp dp;
      int _i_, _x_, _g_, _b_, ac = argc;
      int warg = 0;
      int i, len;
      char *colorname;
      tended char *tmp;
#ifdef XWindows
      XColor colorcell;
      Display *d;
#endif					/* XWindows */

      OptWindow

      /*
       * trim trailing null arguments
       */
      while (is:null(argv[ac-1])) ac--;

      dp = _w_->window->display;
      d = dp->display;

      if (ac - warg == 0) runerr(101);

      CnvCInteger(argv[warg],_i_)
      for (i = 2; i < DMAXCOLORS; i++)
	 if (dp->colors[i].type == MUTABLE && dp->colors[i].c == -_i_ - 1)
	    break;
      if (i == DMAXCOLORS)
	 fail;
      colorname = dp->colors[i].name;			/* color name field */
      colorname = colorname + strlen(colorname) + 1;	/* set value follows */

      if (ac - warg == 1) {			/* if this is a query */
         len = strlen(colorname);
         Protect(tmp = alcstr(colorname, len), runerr(0));
         return string(len, colorname);
         }

      warg++;

      if (ac - warg == 3) {			/* r, g, b triple */

	 CnvCInteger(argv[warg], _x_)
	 CnvCInteger(argv[warg + 1], _g_)
	 CnvCInteger(argv[warg + 2], _b_)

#ifdef XWindows
         colorcell.red   = _x_;
         colorcell.green = _g_;
         colorcell.blue  = _b_;
         colorcell.flags = DoRed | DoGreen | DoBlue;
         colorcell.pixel = -_i_ - 1;
         XStoreColor(d, dp->cmap, &colorcell);
#endif					/* XWindows */
	 sprintf(colorname, "%d,%d,%d", _x_, _g_, _b_);
	 }

      else if (ac - warg != 1) {    /* wrong number of arguments */
	 runerr(101);
         }

      else if (is:integer(argv[warg])) {    /* check for color cell */

	 if (IntVal(argv[warg]) >= 0)
	    runerr(205);        /* must be negative */

#ifdef XWindows
	 colorcell.pixel = -IntVal(argv[warg]) - 1;
	 XQueryColor(d, dp->cmap, &colorcell);
	 colorcell.pixel = -_i_ - 1;
	 XStoreColor(d, dp->cmap, &colorcell);
	 sprintf(colorname, "%d,%d,%d",
	    colorcell.red, colorcell.green, colorcell.blue);
#endif					/* XWindows */
	 }

      else {
	 tended char *tmp;
	 if (!cnv:C_string(argv[warg],tmp))
	    runerr(103,argv[warg]);

#ifdef XWindows
	 if (!lookup_color(_w_, tmp, &colorcell))
	    fail;                            /* invalid color specification */
	 colorcell.pixel = -_i_ - 1;
	 XStoreColor(d, dp->cmap, &colorcell);
#endif					/* XWindows */
	 strcpy(colorname, tmp);
         }
      ReturnWindow;
      }
end
#endif					/* PresentationManager */


"XCopyArea(w,w2,x,y,width,height,x2,y2) - copy area"

function{0,1} XCopyArea(w,w2,x,y,width,height,x2,y2)

   declare {
      int _x_, _y_, _width_, _height_, _x2_, _y2_;
      }
   abstract {
      return file
      }

   if !is:file(w) then
      runerr(140,w)
   if !is:file(w2) then
      runerr(140,w2)

   if !def:C_integer(x,0,_x_) then
      runerr(101,x)
   if !def:C_integer(y,0,_y_) then
      runerr(101,y)
   if !def:C_integer(x2,0,_x2_) then
      runerr(101,x2)
   if !def:C_integer(y2,0,_y2_) then
      runerr(101,y2)

   body {
      wbp _w_, _w2_;

      if (!(BlkLoc(w)->file.status & Fs_Window))
         runerr(140,w);
      if (!(BlkLoc(w2)->file.status & Fs_Window))
         runerr(140,w2);
      _w_ = (wbp)BlkLoc(w)->file.fd;
      _w2_ = (wbp)BlkLoc(w2)->file.fd;

      _x_ += _w_->context->dx;
      _y_ += _w_->context->dy;
      _x2_ += _w2_->context->dx;
      _y2_ += _w2_->context->dy;

      /*
       * width and height must be integers; they default to the
       * rest of the source window.
       */
      if (!def:C_integer(width, _w_->window->width - _x_, _width_))
         runerr(101,width);
      if (!def:C_integer(height, _w_->window->height - _y_, _height_))
         runerr(101,height);

#ifndef PresentationManager
      if (_w_->window->display->display != _w2_->window->display->display) {
	 wsp ws1 = _w_->window;
	 wdp wd1 = ws1->display;
	 wclrp cp;
	 unsigned long c;
#ifdef XWindows
	 int i, j, rv;
	 Display *d1 = wd1->display;
	 wclrp cp2 = NULL;
	 XColor clr;
	 XImage *xim;
	 STDLOCALS(_w2_);

	 if (_x_ + _width_ > ws1->pixwidth || _y_ + _height_ > ws1->pixheight)
	    fail;
	 xim = XGetImage(d1, ws1->pix, _x_, _y_, _width_, _height_,
			 (1<<DefaultDepth(d1,wd1->screen))-1,XYPixmap);
	 XSetFunction(stddpy, stdgc, GXcopy);
	 for (i=_x_; i < _x_ + _width_; i++) {
	    for (j=_y_; j < _y_ + _height_; j++) {
	       clr.pixel = XGetPixel(xim, i, j);
	       if (cp2 != NULL && c == clr.pixel) {
		  XSetForeground(stddpy, stdgc, cp2->c);
		  RENDER2(XDrawPoint, i + _x2_, j + _y2_);
		  continue;
		  }
	       c = clr.pixel;
	       cp2 = NULL;
	       for ( cp = wd1->colors; cp < wd->colors + wd->numColors; cp++) {
		  if (cp->c == c) {
		     if (cp->name[0]=='\0') {
			XQueryColor(d1, wd1->cmap, &clr);
			cp->r = clr.red;
			cp->g = clr.green;
			cp->b = clr.blue;
			sprintf(cp->name,"%d,%d,%d",cp->r,cp->g,cp->b);
			}
		     cp2 = alc_rgb(_w2_, cp->name, cp->r, cp->g, cp->b);
		     if (cp2 == NULL) fail;
		     break;
		     }
		  }
	       if (cp2 == NULL) {
		  XQueryColor(d1, wd1->cmap, &clr);
		  cp2 = alc_rgb(_w2_, "unknown", clr.red, clr.green, clr.blue);
		  }
	       if (cp2 == NULL) fail;
	       XSetForeground(stddpy, stdgc, cp2->c);
	       RENDER2(XDrawPoint, i + _x2_, j + _y2_);
	       }
	    }
	 XSetForeground(stddpy, stdgc,
			wc->fg->c ^ (ISXORREVERSE(_w2_) ? wc->bg->c : 0));
	 XSetFunction(stddpy, stdgc, wc->drawop);
	 XSync(stddpy,False);
	 XDestroyImage(xim);
#endif					/* XWindows */
         }
      else {
#endif					/* PresentationManager */
	 copyArea(_w_,_w2_,_x_,_y_,_width_,_height_,_x2_,_y2_);
#ifndef PresentationManager
         }
#endif					/* PresentationManager */
      return w;
      }
end


"XDefault(w,program,option) - get a default value from the environment"

function{0,1} XDefault(argv[argc])

   abstract {
      return string
      }

   body {
      wbp _w_;
      int warg = 0;
      tended char *prog, *opt;

      OptWindow

      if (argc-warg < 2)
	 runerr(103);
      if (!cnv:C_string(argv[warg],prog))
	 runerr(103,argv[warg]);
      if (!cnv:C_string(argv[warg+1],opt))
	 runerr(103,argv[warg+1]);

#ifdef PresentationManager
      fail;
#else					/* PresentationManager */
      {
	 char *p;
	 long l;

	 STDLOCALS(_w_);

	 p = XGetDefault(stddpy,prog,opt);
	 if (p != NULL) {
	    l = strlen(p);
	    Protect(p = alcstr(p,l),runerr(0));
	    return string(l,p);
	    }
	 else
	    fail;
	 }
#endif					/* PresentationManager */
      }
end


"XEraseArea(w,x,y,width,height) - clear an area of the window"

function{1} XEraseArea(argv[argc])

   abstract {
      return file
      }
   body {
      wbp _w_;
      int warg = 0;
      int x = 0, y = 0, width = 0, height = 0;

      OptWindow

      /*
       * x, y, width, and height must be integers; they default to 0
       * (entire window).
       */
      if (warg < argc) {
	 DefCInteger(argv[warg], 0, x)
	 if (warg+1 < argc) {
	    DefCInteger(argv[warg + 1], 0, y)
	    if (warg + 2 < argc) {
	       DefCInteger(argv[warg + 2], 0, width)
	       if (warg + 3 < argc)
		  DefCInteger(argv[warg + 3], 0, height)
	       }
	    }
	 }

      x += _w_->context->dx;
      y += _w_->context->dy;
      eraseArea(_w_, x, y, width, height);
      ReturnWindow;
      }
end


"XEvent(w) -- return an event from a window"

function{1} XEvent(w)

   abstract {
      return string ++ integer
      }

   body {
      wbp _w_;
      C_integer i;
      unsigned char c;
      tended struct descrip d;

#if COMPILER
      if (!is:file(w) || !(BlkLoc(w)->file.status & Fs_Window))
	 runerr(140,w);
      _w_ = (wbp)BlkLoc(w)->file.fd;
#else					/* COMPILER */
      if (is:null(w)) {
	 if (!(is:file(kywd_xwin[XKey_Window]) &&
	       (BlkLoc(kywd_xwin[XKey_Window])->file.status & Fs_Window)))
	    runerr(140,kywd_xwin[XKey_Window]);
	 _w_ = (wbp)BlkLoc(kywd_xwin[XKey_Window])->file.fd;
         }
      else {
	 if (!(BlkLoc(w)->file.status & Fs_Window))
	    runerr(140,w);
	 _w_ = (wbp)BlkLoc(w)->file.fd;
         }
#endif					/* COMPILER */
      d = nulldesc;
      i = wgetevent(_w_,&d);
      if (i == 0)
      return d;
      else if (i == -1)
	 runerr(141);
      else
	 runerr(143);
      }
end


"XFg(w,x,g,b) - foreground color"

function{0,1} XFg(argv[argc])

   abstract {
      return string
      }

   body {
      wbp _w_;
      int _x_,_g_,_b_;
      char sbuf1[MaxCvtLen];
      int len;
      tended char *tmp;
      int warg = 0;
      int ac = argc;
#ifdef PresentationManager
      LONG rgb;
#endif					/* PresentationManager */

      OptWindow

      /*
       * trim trailing null arguments
       */
      while (is:null(argv[ac - 1])) ac--;
      /*
       * If there are 3 (non-window) arguments we are setting by
       * r, g, b decimal
       */
      if (ac - warg == 3) {
	 CnvCInteger(argv[warg], _x_)
	 CnvCInteger(argv[warg + 1], _g_)
	 CnvCInteger(argv[warg + 2], _b_)

#ifndef PresentationManager
         sprintf(sbuf1, "%d,%d,%d", _x_, _g_, _b_);
	 if(!setfg(_w_, sbuf1)) fail;
#else					/* PresentationManager */
         /* no sense in putting them in a string if we'll just
            have to break them out again */
         RGB16TO8(_x_); RGB16TO8(_g_); RGB16TO8(_b_);
         rgb = MAKERGB(_x_, _g_, _b_);
         if (!setfg(_w_, rgb)) fail;
#endif					/* PresentationManager */
         }

      /*
       * If there is 1 (non-window) argument we are setting by
       * either a mutable color (negative int) or a string name.
       */
      else if (ac - warg == 1) {
#ifndef PresentationManager
	 if (is:integer(argv[warg])) {    /* check for neg int */
	    if (!isetfg(_w_, IntVal(argv[warg]))) fail;
	    }
	 else {
	    if (!cnv:C_string(argv[warg], tmp))
	       runerr(103,argv[warg]);
	    if(!setfg(_w_, tmp)) fail;
	    }
         }
      /*
       * In any event, this function returns the current foreground color.
       */
      len = strlen(_w_->context->fg->name);
      Protect(tmp = alcstr(_w_->context->fg->name,len), runerr(0));
#else					/* PresentationManager */
         /* must be a string name for a color */
         if (!cnv:C_string(argv[warg], tmp))
           runerr(103, argv[warg]);
         if (((rgb = ParseRGBValue(tmp)) < 0 &&
              (rgb = si_s2i(siColorNames, tmp)) < 0) || !setfg(_w_, rgb))
           fail;
         } /* End of if - must be a color name */
      /* in any event, get the color name */
      GetColorName(_w_->context->charBundle.lColor, sbuf1, MaxCvtLen);
      len = strlen(sbuf1);
      Protect(tmp = alcstr(sbuf1, len), runerr(0));
#endif					/* PresentationManager */
      return string(len, tmp);
      }
end


"XFlush(w) - flush all output to window w"

function{1} XFlush(w)

   abstract {
      return file
      }

   body {
#ifndef PresentationManager
      wbp _w_;

#if COMPILER
      if (!is:file(w) || !(BlkLoc(w)->file.status & Fs_Window))
	 runerr(140,w);
      _w_ = (wbp)BlkLoc(w)->file.fd;
#else					/* COMPILER */
      if (is:null(w)) {
	 if (!(is:file(kywd_xwin[XKey_Window]) &&
	       (BlkLoc(kywd_xwin[XKey_Window])->file.status & Fs_Window)))
	    runerr(140,kywd_xwin[XKey_Window]);
	 _w_ = (wbp)BlkLoc(kywd_xwin[XKey_Window])->file.fd;
         }
      else {
	 if (!(BlkLoc(w)->file.status & Fs_Window))
	    runerr(140,w);
	 _w_ = (wbp)BlkLoc(w)->file.fd;
         }
#endif					/* COMPILER */

      wflush(_w_);
#if !COMPILER
      if (is:null(w)) return kywd_xwin[XKey_Window];
      else
#endif					/* COMPILER */
#endif					/* PresentationManager */
	 return w;
       }
end


"XFont(w,s) - get/set font"

function{0,1} XFont(argv[argc])

   abstract {
      return string
      }

   body {
      tended char *tmp;
      int len;
      wbp _w_;
      int warg = 0;
#ifdef PresentationManager
      LONG flags, size;
      char buf[64];
#endif					/* PresentationManager */

      OptWindow

      if (warg < argc) {
         if (!cnv:C_string(argv[warg],tmp))
            runerr(103,argv[warg]);
#ifndef PresentationManager
         if (!(setfont(_w_,&tmp))) fail;
         }
      len = strlen(_w_->context->font->name);
      Protect(tmp = alcstr(_w_->context->font->name,len), runerr(0));
#else					/* PresentationManager */
        /* Parse the name and size info and make the font */
        if (!ParseFontSpec(tmp, buf, &flags, &size) ||
            !SetFont(_w_->context, buf, flags, size))
          fail;
        } /* End of if - requesting a new font */
      len = GetFontName(_w_->context->charBundle.usSet, buf, 64);
      Protect(tmp = alcstr(buf, len), runerr(0));
#endif					/* PresentationManager */
      return string(len,tmp);
      }
end


"XGotoRC(w,r,c) - move cursor to a particular text row and column"

function{1} XGotoRC(argv[argc])

   abstract {
      return file
      }
   body {
      int r, c;
      wbp _w_;
      int warg = 0;

      OptWindow

      if (argc - warg < 1)
	 r = 1;
      else
	 CnvCInteger(argv[warg], r)
      if (argc - warg < 2)
	 c = 1;
      else
	 CnvCInteger(argv[warg + 1], c)

#ifdef PresentationManger
      /* turn the cursor off */
      HideCursor(_w_->window);
#endif					/* PresentationManager */
      _w_->window->y = ROWTOY(_w_, r);
      _w_->window->x = COLTOX(_w_, c);
      _w_->window->x += _w_->context->dx;
      _w_->window->y += _w_->context->dy;
#ifdef PresentationManager
      /* turn it back on at new location */
      UpdateCursorPos(_w_->window, _w_->context);
      ShowCursor(_w_->window);
#endif					/* PresentationManager */
      ReturnWindow;
      }
end


"XGotoXY(w,x,y) - move cursor to a particular pixel location"

function{1} XGotoXY(argv[argc])

   abstract {
      return file
      }
   body {
      wbp _w_;
      int _x_, _y_;
      int warg = 0;

      OptWindow

      if (argc - warg < 1)
	 _x_ = 0;
      else
	 CnvCInteger(argv[warg], _x_)
      if (argc - warg < 2)
	 _y_ = 0;
      else
	 CnvCInteger(argv[warg + 1], _y_)

      _x_ += _w_->context->dx;
      _y_ += _w_->context->dy;

#ifdef PresentationManager
      HideCursor(_w_->window);
#endif					/* PresentationManager */
      _w_->window->x = _x_;
      _w_->window->y = _y_;
#ifdef PresentationManager
      UpdateCursorPos(_w_->window, _w_->context);
      ShowCursor(_w_->window);
#endif					/* PresentationManager */
      ReturnWindow;
      }
end


"XMoveWindow(w,x,y,width,height) - move/resize window"

function{1} XMoveWindow(argv[argc])

   abstract {
      return file
      }
   body {
      wbp _w_ = NULL;
      C_integer _x_, _y_, _width_, _height_;
      int warg = 0;

      OptWindow

#ifndef PresentationManager
      /*
       * x and y must be integers; they default to 0.
       */
      DefCInteger(argv[warg], 0, _x_)
      DefCInteger(argv[warg + 1], 0, _y_)

      {
      STDLOCALS(_w_);

      if (argc - warg == 4) {
	 /*
	  * width and height must be integers, default to current width/height
	  */
	 DefCInteger(argv[warg + 2], ws->width, _width_)
	 DefCInteger(argv[warg + 3], ws->height, _height_)

	 if (resizePixmap(_w_, _width_, _height_) == 0) fail;
	 if (stdwin)
#ifdef XWindows
	    XMoveResizeWindow(stddpy, stdwin, _x_, _y_, _width_, _height_);
#endif					/* XWindows */
         }
      else if (argc - warg != 2) runerr(101);

      else {
	 if (stdwin)
#ifdef XWindows
	    XMoveWindow(stddpy, stdwin, _x_, _y_);
#endif					/* XWindows */
         }
#ifdef XWindows
      XSync(stddpy, False);
#endif					/* XWindows */
      }
#else					/* PresentationManager */
      {
      STDLOCALS(_w_);

      if (argc - warg == 4) {
        /* width and height default to window width and height */
        DefCInteger(r_args[1 + warg + 2], ws->width, _width_)
        DefCInteger(r_args[1 + warg + 3], ws->height, _height_)
        } /* End of if - width and height specified */
      else if (argc - warg != 2)
        runerr(101);
      else {
        _width_ = ws->width;
        _height_ = ws->height;
        } /* End of else - width and height not spec'd, but pos was */

      /* position defaults to 0,0 */
      DefCInteger(r_args[1 + warg], 0, _x_)
      DefCInteger(r_args[1 + warg + 1], 0, _y_)

      /* if there even is a window */
      if (stdwin) {
        int height = _height_ + (BORDERHEIGHT << 1) + TITLEHEIGHT;

        if (WinIsWindowVisible(ws->hwndFrame))
          WinSetWindowPos(ws->hwndFrame, 0, _x_,
                          ScreenHeight - _y_ - height,
                          _width_ + (BORDERWIDTH << 1), height,
                          SWP_SIZE | SWP_MOVE);
        else {
          ws->width = _width_;
          ws->height = _height_;
          ws->posx = _x_;
          ws->posy = _y_;
          } /* End of else - window is not visible */
        } /* End of if - window was actually created */
      else
        ResizeBackingBitmap(_w_->window, _width_, _height_);
      } /* matches scope above STDLOCALS */
#endif					/* PresentationManager */
      ReturnWindow;
      }
end


#ifndef PresentationManager
"XNewColor(w,x,g,b) - allocate an entry in the color map"

function{0,1} XNewColor(argv[argc])

   abstract {
      return integer
      }

   body {
      wbp    _w_;
      int    i, ac = argc;
      int warg = 0;
      unsigned long plane_masks[1], pixels[1];
      wdp    wd;
      char   *colorname;
#ifdef XWindows
      XColor colorcell;
#endif					/* XWindows */

      OptWindow

      /*
       * trim trailing null arguments
       */
      while (is:null(argv[ac-1])) ac--;

      {
      STDLOCALS(_w_);

      /*
       * X11 Bug Warning:  some old versions of the X server, but not X11R5,
       * will crash sometime after a failed call to XNewColor.  This happens
       * only if a virtual colormap has been allocated and completely filled
       * and then XNewColor is called to allocate a new, unshared entry.  The
       * request fails, as it should, but when the program eventually exits
       * the X server crashes.  This has been seen on OpenWindows 3.0,
       * Irix 4.0.1, and HP-UX 7.0.
       */

      if (!XAllocColorCells(stddpy,wd->cmap,False,plane_masks,0,pixels,1)) {
	 /* try again with a virtual colormap */
	 if (!go_virtual(_w_) ||
	     !XAllocColorCells(stddpy,wd->cmap,False,plane_masks,0,pixels,1))
	    fail;                             /* cannot allocate an entry */
	    }

         /* allocate a slot in wdisplay->colors and wstate->theColors arrays */
	 i = alc_centry(wd);
	 if (i == 0)
	    fail;
         wd->colors[i].type = MUTABLE;
         wd->colors[i].c = pixels[0];

	 /* save color index as "name", followed by a null string for value */
	 colorname = wd->colors[i].name;
         sprintf(colorname, "%d", -pixels[0] - 1);	/* index is name */
	 colorname = colorname + strlen(colorname) + 1;
	 *colorname = '\0';				/* value unknown */

         if (ws->numColors < WMAXCOLORS)
            ws->theColors[ws->numColors++] = i;

         if (warg < ac) {                     /* set the color */
	    /*
	     * If there are 3 (non-window) arguments we are setting by
	     * r, g, b decimal
	     */
            if (ac - warg == 3) {
#ifdef XWindows
               CnvCUShort(argv[warg],colorcell.red)
               CnvCUShort(argv[warg + 1],colorcell.green)
               CnvCUShort(argv[warg + 2],colorcell.blue)
               colorcell.flags = DoRed | DoGreen | DoBlue;
	       sprintf(colorname, "%d,%d,%d", 
        	  colorcell.red, colorcell.green, colorcell.blue);
#endif					/* XWindows */
               }
	    else if (ac - warg != 1) runerr(101);
	    /* old-style check for C integer */
            else if (argv[warg].dword == D_Integer) {/* check for color cell */
               if (IntVal(argv[warg]) >= 0) fail;        /* must be negative */
#ifdef XWindows
               colorcell.pixel = -IntVal(argv[warg]) - 1;
               XQueryColor(stddpy, wd->cmap, &colorcell);
	       sprintf(colorname, "%d,%d,%d", 
        	  colorcell.red, colorcell.green, colorcell.blue);
#endif					/* XWindows */
               }
            else {
               tended char  *str;
               if (!cnv:C_string(argv[warg],str))
	          runerr(103,argv[warg]);
#ifdef XWindows
	       if (!lookup_color(_w_, str, &colorcell)) {
                  free_color(_w_, pixels[0]);
                  fail;                        /* invalid color specification */
                  }
#endif					/* XWindows */
	       strcpy(colorname, str);
               }
#ifdef XWindows
            colorcell.pixel = pixels[0];
            XStoreColor(stddpy, wd->cmap, &colorcell);
#endif					/* XWindows */
            }
	 }

      return C_integer (-pixels[0] - 1);
      }
end


"XParseColor(w,s) - produce RGB components from string color name"

function{0,3} XParseColor(w,s)
   abstract {
      return integer
      }
   if !cnv:C_string(s) then
      runerr(103,s)
   body {
      wbp _w_;
#ifdef XWindows
      XColor clr;
#endif					/* XWindows */

      if (!(BlkLoc(w)->file.status & Fs_Window))
         runerr(140,w);
      _w_ = (wbp)BlkLoc(w)->file.fd;
#ifdef XWindows
      if (lookup_color(_w_,s,&clr)) {
         C_integer tmp;
	 tmp = clr.red;
	 suspend C_integer tmp;
	 tmp = clr.green;
	 suspend C_integer tmp;
	 tmp = clr.blue;
	 suspend C_integer tmp;
         }
#endif					/* XWindows */
      fail;
      }
end
#endif					/* PresentationManager */


"XPending(w,x[]) - produce a list of events pending on window"

function{0,1} XPending(argv[argc])

   abstract {
      return list
      }

   body {
      wbp _w_;
      int warg = 0;
      wsp ws;
#ifndef PresentationManager
      wdp wd;
#endif					/* PresentationManager */
      int i;

      OptWindow;

      ws = _w_->window;

      /*
       * put additional arguments to XPending on the pending list in
       * guaranteed consecutive order.
       */
      for (i = warg; i<argc; i++) {
         c_put(&(ws->listp), &argv[i]);
         }

#ifndef PresentationManager
      /*
       * retrieve any events that might be relevant before returning the
       * pending queue.
       */
      for (wd = wdsplys; wd; wd = wd->next) {
	 int hm;
         if ((hm = handle_misc(wd, NULL)) < 1) {
	    if (hm == 0)
	       fail;
	    else runerr(141);
	    }
         }
#else					/* PresentationManager */
      ObtainEvents(NULL, NO_WAIT_EVT);
#endif					/* PresentationManager */
      return ws->listp;
      }
end



"XPixel(w,x,y,width,height) - produce the contents of some pixels"

function{3} XPixel(argv[argc])
   abstract {
      return integer
      }
   body {
      int x = 0, y = 0, width = 0, height = 0;
      wbp _w_;
      int warg = 0;
#ifndef PresentationManager
      XImage *im;
      C_integer tmp;
      XColor clr;
#endif					/* PresentationManager */

      OptWindow

      /*
       * x, y, width, and height must be integers; they default
       * to 0 (the entire window)
       */
      if (argc - warg > 0)
	 CnvCInteger(argv[warg], x)
      if (argc - warg > 1)
	 CnvCInteger(argv[warg + 1], y)
      if (argc - warg > 2)
	 CnvCInteger(argv[warg + 2], width)
      if (argc - warg > 3)
	 CnvCInteger(argv[warg + 3], height)

      x += _w_->context->dx;
      y += _w_->context->dy;

      {
	int i, j, k;
#ifndef PresentationManager
	C_integer rv;
	wclrp cp;
#else					/* PresentationManager */
      POINTL pt;
      LONG clrindex, rgb;
#endif					/* PresentationManager */
	unsigned long c;
	STDLOCALS(_w_);

      if (width == 0) width = ws->width - x;
      if (height == 0) height = ws->height - y;
#ifndef PresentationManager
	if (x + width > ws->pixwidth || y + height > ws->pixheight)
#else					/* PresentationManager */
        if (x + width > ws->width || y + height > ws->height)
#endif					/* PresentationManager */
	   fail;
#ifndef PresentationManager
#ifdef XWindows
	im = XGetImage(stddpy,stdpix,x,y,width,height,
		       (1<<DefaultDepth(stddpy,wd->screen))-1,XYPixmap);
#endif					/* XWindows */
	for (i=0; i < width; i++) {
	   for (j=0; j < height; j++) {
#ifdef XWindows
	      c = clr.pixel = XGetPixel(im,i,j);
	      rv = 0xff000000;
	      for( cp=wd->colors ; cp < wd->colors + wd->numColors; cp++) {
		 if (cp->c == c) {
		    if (cp->type == MUTABLE)
		       rv = -c - 1;
		    else
		       rv = ((((cp->r>>8)<<8) + (cp->g>>8)) << 8) + (cp->b>>8);
		    break;
		    }
		 }
	      if (rv == 0xff000000) {
		 XQueryColor(stddpy, wd->cmap, &clr);
		 rv = ((clr.red<<8) + clr.green) << 8 + clr.blue;
		 }
	      suspend C_integer rv;
#endif					/* XWindows */
	      }
	   }
#else					/* PresentationManager */
        /* flip y */
        y = ws->bitHeight - y;
        /* do the queries */
        for (pt.x = x; pt.x < x + width; pt.x++)
          for (pt.y = y; pt.y > y - height; pt.y--) {
            /* this will give us the color index */
            clrindex = GpiQueryPel(stdbit, &pt);
            /* match index to rgb value */
            GpiQueryLogColorTable(stdbit, 0, clrindex, 1, &rgb);
            suspend C_integer rgb;
            } /* End of for - traverse the bands */
#endif					/* PresentationManager */
	fail;
        } /* subscope */
      }
end



"XQueryPointer(w) - produce mouse position"

function{0,2} XQueryPointer(w)

#ifndef PresentationManager
   declare {
#ifdef XWindows
      Display *theDisplay;
      Window theWindow;
      Window garbage1, garbage2;
#endif					/* XWindows */
      int root_x, root_y, win_x, win_y;
      }
#endif					/* PresentationManager */
   abstract {
      return integer
      }
#ifndef PresentationManager
   if is:null(w) then body {
      int i;
      wdp wd;
#ifdef XWindows
      if (wdsplys == NULL) {
	 /*
	  * Initialize the window system
	  */
	 Protect(wd = alc_display(NULL), fail);
	         
	 theDisplay = wd->display;
	 theWindow  = DefaultRootWindow(wd->display);
         }
      else {
	 wd = wdsplys;
	 theDisplay = wd->display;
	 theWindow  = DefaultRootWindow(wd->display);
         }
#endif					/* XWindows */
    }
   else {
      if !is:file(w) then
         runerr(140,w)
      body {
         wbp _w_ = NULL;
         if (!(BlkLoc(w)->file.status & Fs_Window))
            runerr(140,w);
         _w_ = (wbp)BlkLoc(w)->file.fd;

#ifdef XWindows
         theDisplay = _w_->window->display->display;
         theWindow  = _w_->window->win;
         if (theWindow == (Window) NULL) fail;
#endif					/* XWindows */
         }
      }

   body {
      wbp _w_ = NULL;
      unsigned int key_buttons;

      pollevent();

      if (is:file(w))
         _w_ = (wbp)BlkLoc(w)->file.fd;

#ifdef XWindows
      XQueryPointer(theDisplay, theWindow, &garbage1, &garbage2,
		    &root_x, &root_y, &win_x, &win_y, &key_buttons);
#endif					/* XWindows */
      if (_w_ && _w_->window) {
         _w_->window->pointerx = win_x;
         _w_->window->pointery = win_y;
         }

      if (is:null(w)) {
         suspend C_integer root_x;
         suspend C_integer root_y;
         }
      else {
         suspend C_integer win_x;
         suspend C_integer win_y;
         }
#else					/* PresentationManager */
    body {
      wbinding *wb = NULL;
      wstate *ws;
      POINTL pt;

      /* get the current pointer position */
      WinQueryPointerPos(HWND_DESKTOP, &pt);
      /* if a window was passed in, check it, transform the coords and
         save them in the state */
      if (!is:null(w)) {
        if (!is:file(w) || !(BlkLoc(w)->file.status & Fs_Window))
          runerr(140, w);
        wb = (wbinding *)BlkLoc(w)->file.fd;
        ws = wb->window;
        /* if this binding is not really a window... */
        if (ws->hwnd == NULLHANDLE) fail;
        /* map the points to the window */
        WinMapWindowPoints(HWND_DESKTOP, ws->hwnd, &pt, 1);
        pt.y = ws->height - pt.y;
        /* save the state */
        ws->pointerx = pt.x;
        ws->pointery = pt.y; /* have to do the flip flop */
        } /* End of if - a window has been specified */
      else  /* have to do the flip for the screen instead */
        pt.y = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) - pt.y;
      /* suspend the results */
      suspend C_integer pt.x;
      suspend C_integer pt.y;
#endif					/* PresentationManager */
      fail;
      }
end
  

"XReadImage(w, s, x, y) - load image file"

function{0,1} XReadImage(w,s,x,y)
   declare {
      int _x_, _y_;
      }
   abstract {
      return integer
      }

   if !cnv:C_string(s) then
      runerr(103,s)

   /*
    * x and y must be integers; they default to 0.
    */
   if !def:C_integer(x,0,_x_) then
      runerr(101,x)
   if !def:C_integer(y,0,_y_) then
      runerr(101,y)

   body {
      wbp _w_;
      char filename[MaxFileName];
#ifdef XWindows
      Pixmap p;
#endif					/* XWindows */
#ifdef PresentationManager
      HBITMAP hbm;
      POINTL pt;
#endif					/* PresentationManager */
      int width, height, status;

      if (!(BlkLoc(w)->file.status & Fs_Window))
         runerr(140,w);
      _w_ = (wbp)BlkLoc(w)->file.fd;
      _x_ += _w_->context->dx;
      _y_ += _w_->context->dy;
      strncpy(filename, s, MaxFileName);	/* copy to loc that won't move*/
      {
	 STDLOCALS(_w_);

	 /*
	  * if new image might fill entire window (origin at 0,0), let
	  * loadimage know it may be able to free current colors
	  */
#ifndef PresentationManager
#ifdef XWindows
	 if (!_x_ && !_y_)
            p = loadimage(_w_, filename, &height, &width, 1, &status);
	 else
            p = loadimage(_w_, filename, &height, &width, 0, &status);
         if (p == (Pixmap) NULL) fail;

         if (stdwin)
            XCopyArea(stddpy, p, stdwin, stdgc, 0, 0, width, height, _x_, _y_);
         XCopyArea(stddpy, p, stdpix, stdgc, 0, 0, width, height, _x_, _y_);

         /*
          * Make sure previous ops on p are complete, then free it.
          */
         XSync(stddpy, False);
         XFreePixmap(stddpy, p);
#endif					/* XWindows */
      return C_integer (word)status;
#else					/* PresentationManager */
         if (hbm = loadimage(_w_, s, &height, &width)) {
           pt.x = _x_;
           pt.y = ws->height - _y_ - height;
           MutexOn(ws);
           if (stdwin)
             WinDrawBitmap(stdwin, hbm, NULL, &pt, CLR_WHITE, CLR_BLACK, DBM_NORMAL);
           pt.y = ws->bitHeight - _y_ - height;
           WinDrawBitmap(stdbit, hbm, NULL, &pt, CLR_WHITE, CLR_BLACK, DBM_NORMAL);
           MutexOff(ws);
           GpiDeleteBitmap(hbm);
           return C_integer (word)0;
           } /* End of if - load suceeded */
         else fail;
#endif					/* PresentationManager */

	 }
      }
end


#ifndef PresentationManager
"XSetStipple(w,width,bits[]) - sets the GC stipple pattern"

function{1} XSetStipple(w,width,bits[argc])

   declare {
      int _width_;
   }
   abstract {
      return file
      }

   if !cnv:C_integer(width,_width_) then
      runerr(101,width)

   body {
      wbp _w_;
#ifdef XWindows
      Pixmap p;
#endif					/* XWindows */
      char data[MAXXOBJS];
      char *buf = data;
      int i, j, v;

      if (!(BlkLoc(w)->file.status & Fs_Window))
         runerr(140,w);
      _w_ = (wbp)BlkLoc(w)->file.fd;

      if ((_width_<1) || (_width_ > 32)) {
         runerr(205,width);
         }
      if(argc>1024) {
         runerr(0);
         }

      for(i=0;i<argc;i++) {
         CnvCInteger(bits[i],v)
         for(j=0; j<_width_; j+=8){
            *buf++ = v;
            v >>= 8;
            }
         }

      {
	 STDLOCALS(_w_);

#ifdef XWindows
         p = XCreateBitmapFromData(stddpy, stdpix, data, _width_, argc);
         XSetStipple(stddpy, stdgc, p);
         XSync(stddpy, False);
         XFreePixmap(stddpy, p);
#endif					/* XWindows */
	 }
      return  w;
      }
end
#else					/* PresentationManager */
"XSetStipple(w, args[]) - sets the context fill pattern"

function{1} XSetStipple(w, args[argc])
  abstract {
    return file
    }
  body {
    wbinding *wb;

    /* make sure first arg is a window pointer (file) */
    if (!(BlkLoc(w)->file.status & Fs_Window))
      runerr(140,w);
    wb = (wbp)BlkLoc(w)->file.fd;

    /* check if we have a pattern name instead of bits */
    if (argc < 2 && is:string(r_args[2 + 0])) {
      if (!SetPattern(wb->context, StrLoc(r_args[2 + 0]), StrLen(r_args[2 + 0])))
        runerr(0);
      } /* End of if - string pattern name */
    else {
      BYTE data[32];
      int i, j, val;

      /* zero out the bits */
      memset(data, 0, sizeof(data));
      /* fill in the bits, flipping over because of PM way of doing things */
      for (i = 0, j = ((argc - 1) << 2); j >= 0; j -= 4, i++) {
        CnvCInteger(r_args[2 + i], val)
        data[j] = (BYTE)val;
        } /* End of for - fill in the bits */
      /* this function will do all the work */
      if (!SetNewBitPattern(wb->context, data))
        runerr(0);
      } /* End of else - have to make a hard-coded bitmap pattern */
    return w;
    }
end
#endif					/* PresentationManager */



"XSync(w,s) - synchronize with X server"

function{1} XSync(w,s)
#ifndef PresentationManager
   declare {
      wdp wd;
      int i;
      }
   if !def:tmp_string(s,blank) then
      runerr(103, s)

   abstract {
      return file++null
      }
   body {
      i = (StrLen(s)==4 && !strncmp(StrLoc(s),"true",4));
      if (is:null(w)) {
#ifdef XWindows
	 for (wd = wdsplys; wd != NULL; wd = wd->next)
	    XSync(wd->display, i);
#endif					/* XWindows */
	 result = nulldesc;
	 return result;
         }
      else if (!is:file(w)) runerr(140,w);
      else {
	 wbp _w_;
         if (!(BlkLoc(w)->file.status & Fs_Window))
            runerr(140,w);
         _w_ = (wbp)BlkLoc(w)->file.fd;
#ifdef XWindows
	 XSync(_w_->window->display->display, i);
#endif					/* XWindows */
	 return w;
         }
      }
#else					/* PresentationManager */
   abstract {
      return file++null;
      }
   body {
      return w;
      }
#endif					/* PresentationManager */
end


"XUnbind(w) - unbind window"

function{1} XUnbind(w)
   abstract {
      return file
      }
   body {
      wbp _w_;
      if (!is:file(w)) runerr(140,w);
      if ((BlkLoc(w)->file.status & Fs_Window) == 0) runerr(140,w);
      if ((BlkLoc(w)->file.status & (Fs_Read|Fs_Write)) == 0) runerr(142,w);
      _w_ = (wbp)BlkLoc(w)->file.fd;
      BlkLoc(w)->file.status = Fs_Window;
#ifndef PresentationManager
      if (_w_->window->refcount == 1) {
	 wclose(_w_);
         }
      else {
	 free_binding(_w_);
         }
#else 					/* PresentationManager */
      /* when the window state gets down to 0, it will close itself */
      free_binding(_w_);
#endif					/* PresentationManager */
      return w;
      }
end


"XTextWidth(w,s) - compute text pixel width"

function{1} XTextWidth(argv[argc])
   abstract {
      return integer
      }
   inline {
      wbp _w_;
      int warg=0;
      C_integer i;

      OptWindow

      if (warg == argc) runerr(103,nulldesc);
      else if (!cnv:tmp_string(argv[warg],argv[warg]))
	 runerr(103,argv[warg]);
       
#ifndef PresentationManager
#ifdef XWindows
      i = XTextWidth(_w_->context->font->fsp,
		     StrLoc(argv[warg]), StrLen(argv[warg]));
#endif					/* XWindows */
#else					/* PresentationManager */
      i = GetTextWidth(_w_, StrLoc(argv[warg]), StrLen(argv[warg]));
#endif					/* PresentationManager */
      return C_integer i;
      }
end


"XWarpPointer(w,x,y) - move mouse to window position x,y"

function{0,1} XWarpPointer(w,x,y)
   declare {
#ifdef XWindows
      Display *theDisplay;
      Window theWindow;
#endif					/* XWindows */
      int _x_, _y_;
      }

   /*
    * If w is omitted, x and y are relative to the root window
    */
   if is:null(y) && def:C_integer(w,0,_x_) && def:C_integer(x,0,_y_) then {
      abstract {
         return null
         }
      body {
#ifndef PresentationManager
         wdp wd;
         int i;
	 if (wdsplys == NULL) {
            /*
             * Initialize the window system
             */
            Protect(wd = alc_display(NULL), fail);
#ifdef XWindows
            theDisplay = wd->display;
            theWindow  = DefaultRootWindow(wd->display);
#endif					/* XWindows */
            }
         else {
	    wd = wdsplys;
#ifdef XWindows
            theDisplay = wd->display;
            theWindow  = DefaultRootWindow(wd->display);
#endif					/* XWindows */
            }
#ifdef XWindows
         XWarpPointer(theDisplay, None, theWindow, 0, 0, 0, 0, _x_, _y_);
#endif					/* XWindows */
#else					/* PresentationManager */
         _y_ = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) - _y_;
         WinSetPointerPos(HWND_DESKTOP, _x_, _y_);
#endif					/* PresentationManager */
	 return nulldesc;
         }
      }
   else {
      if !is:file(w) then
         runerr(140,w)
      abstract {
         return file
         }
      /*
       * x and y must be integers; they default to 0.
       */
      if !def:C_integer(x,0,_x_) then
         runerr(101,x)
      if !def:C_integer(y,0,_y_) then
         runerr(101,y)
      body {
         wbp _w_;
#ifdef PresentationManager
         POINTL pt;
#endif					/* PresentationManager */

         if (!(BlkLoc(w)->file.status & Fs_Window))
            runerr(140,w);
         _w_ = (wbp)BlkLoc(w)->file.fd;
	 _x_ += _w_->context->dx;
	 _y_ += _w_->context->dy;
#ifndef PresentationManager
#ifdef XWindows
	 theDisplay = _w_->window->display->display;
	 theWindow =  _w_->window->win;
         XWarpPointer(_w_->window->display->display, None, _w_->window->win,
		      0, 0, 0, 0, _x_, _y_);
#endif					/* XWindows */
#else					/* PresentationManager */
         pt.x = _x_;
         /* fixup the _y_ with respect to the window - ie. flip it */
         pt.y = _w_->window->height - _y_;
         /* map it out to the desktop */
         WinMapWindowPoints(_w_->window->hwnd, HWND_DESKTOP, &pt, 1);
         /* set the pointer position */
         WinSetPointerPos(HWND_DESKTOP, pt.x, pt.y);
#endif					/* PresentationManager */
         return w;
         }
      }
end


"XWriteImage(w,filename,x,y,width,height) - write an image to a file"

function{0,1} XWriteImage(w,filename,x,y,width,height)

   declare {
      int _x_, _y_;
      }
   abstract {
      return file
      }

   if !cnv:C_string(filename) then
      runerr(103,filename)

   /*
    * x and y must be integers; they default to 0.
    * width and height must be integers; they default to the
    * _width_ and _height_ of the window.
    */
   if !def:C_integer(x,0,_x_) then
      runerr(101,x)
   if !def:C_integer(y,0,_y_) then
      runerr(101,y)
   body {
      wbp _w_;
      C_integer _width_, _height_;

      if (!(BlkLoc(w)->file.status & Fs_Window))
         runerr(140,w);
      _w_ = (wbp)BlkLoc(w)->file.fd;
      _x_ += _w_->context->dx;
      _y_ += _w_->context->dy;

      if (!def:C_integer(width, _w_->window->width, _width_))
         runerr(101,width);
      if (!def:C_integer(height, _w_->window->height, _height_))
         runerr(101,height);

#ifndef PresentationManager
      if ((_width_ + _x_ > _w_->window->pixwidth) ||
	  (_height_ + _y_ > _w_->window->pixheight)) fail;
#else					/* PresentationManager */
      if ((_width_ + _x_ > _w_->window->bitWidth) ||
          (_height_ + _y_ > _w_->window->bitHeight)) fail;
#endif					/* PresentationManager */

      if(!dumpimage(_w_,filename,_x_,_y_,_width_,_height_)) fail;

      return w;
      }
end
#else					/* XIcon */
static char x;			/* avoid empty module */
#endif					/* XIcon */
