/*
 * MultiMail offline mail reader
 * conversion tables ISO 8859-1 <-> IBM codepage 437

 Copyright (c) 1996 Peter Karlsson <dat95pkn@idt.mdh.se>,
                    Toth Istvan <stoty@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

/* Original tables by Peter Karlsson, modified by William McBrine after 
   DOSEmu's video/terminal.h, by Mark D. Rejhon. */

#include "isoconv.h"

int isoconvert;

const char dos2isotab[] = {
  "\0\001\002\003\004\005\006\007\010\011\012\013\014\015\016\017"
  "\020\021\022\023\024\025\026\027\030\031\032\033\034\035\036\037"
  " !\"#$%&'()*+,-./" "0123456789:;<=>?" "@ABCDEFGHIJKLMNO"
  "PQRSTUVWXYZ[\\]^_" "`abcdefghijklmno" "pqrstuvwxyz{|}~^"
  "\307\374\351\342\344\340\345\347\352\353\350\357\356\354\304\305"
  "\311\346\306\364\366\362\373\371\377\326\334\242\243\245\120\146"
  "\341\355\363\372\361\321\252\272\277\055\254\275\274\241\253\273"
  ":%&|{{{..{I.'''." "``+}-+}}`.**}=**" "+*+``..**'.#_][~"
  "a\337\254\266{\363\265t\330\364\326\363o\370En"
  "=\261><()\367=\260\267\267%\140\262= "
};

const char iso2dostab[] = {
      0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
    ' ','!','\"','#','$','%','&','\'','(',')','*','+',',','-','.','/',
    '0','1','2','3','4','5','6','7','8','9',':',';','<','=','>','?',
    '@','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O',
    'P','Q','R','S','T','U','V','W','X','Y','Z','[','\\',']','^','_',
    '`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
    'p','q','r','s','t','u','v','w','x','y','z','{','|','}','~','',
    '','','','','','','','','','','','','','','','',
    '','','','','','','','','','','','','','','','',
    ' ','','','','$','','|', 21,'"','c','','','','-','r','-',
    '','','','3','\'','', 20,'',',','1','','','','','/','',
    'A','A','A','A','','','','','E','','E','E','I','I','I','I',
    'D','','O','O','O','O','','x','','U','U','U','','Y',' ','',
    '','','','a','','','','','','','','','','','','',
    ' ','','','','','o','','','','','','','','y',' ',''
};

char *charconv(char *buf, int cdir)
{
	char *p;
	const char *ct;
	switch (cdir) {
	case CC_ISOTO437:
		ct = iso2dostab;
		break;
	case CC_437TOISO:
		ct = dos2isotab;
		break;
	default:
		return buf;
	}

	for (p = buf; *p; p++)
		*p = ct[*((unsigned char *) p)];

	return buf;
}

char *charconv_in(char *buf)
{
	return (isoconvert ? charconv(buf, CC_437TOISO) : buf);
}

char *charconv_out(char *buf)
{
	return (isoconvert ? charconv(buf, CC_ISOTO437) : buf);
}
