#************************************************************************
#* MODULE INFORMATION*
#*********************
#*     FILE     NAME:       DP.MAK
#*     SYSTEM   NAME:       BEHOLDER
#*     ORIGINAL AUTHOR(S):  Jan van Oorschot
#*     VERSION  NUMBER:     1.00
#*     CREATION DATE:       16-10-90
#*
#* DESCRIPTION: Global makefile for the Network DisPatcher's
#*              Packet Driver Handling Library.
#************************************************************************
#* CHANGES INFORMATION **
#************************
#* REVISION:    $Revision:   1.3  $
#* WORKFILE:    $Workfile:   DP.mak  $
#* LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/NPD/DP/VCS/DP.MAV  $
#  
#     Rev 1.3   01 Feb 1991 14:23:34   etstjan
#  No explicit note
#  
#     Rev 1.2   01 Feb 1991 14:21:56   etstjan
#  
#     Rev 1.1   26 Oct 1990 14:56:48   etstjan
#  
#     Rev 1.0   26 Oct 1990 12:30:40   etstjan
#  Initial revision.
#  
#     Rev 1.2   25 Oct 1990 14:59:06   etstjan
#  
#     Rev 1.1   25 Oct 1990 14:50:50   etstjan
#  Improved .exe generation
#  
#     Rev 1.0   25 Oct 1990 14:34:52   etstjan
#  Initial revision.
#************************************************************************
HOMEDIR=..\..
NEWTREE=.^\
MODEL=L
MODE=r
CFLAGS=/W4 /Ox /A$(MODEL) /L$(MODE) /I$(HOMEDIR)\INCLUDE /I..\INCLUDE /DCLERR
LFLAGS=/STACK:8000
MFLAGS = HOMEDIR=$(HOMEDIR) CFLAGS="$(CFLAGS)" LFLAGS="$(LFLAGS)" MODE=$(MODE) MODEL=$(MODEL)
ID=$(HOMEDIR)\INCLUDE
LD=$(HOMEDIR)\LIB
PUTNOTE="No explicit note"

SYSTEM=DP
LIBS=$(LD)\$(MODEL)$(SYSTEM)$(MODE).lib
CS=dp.c dptime.c dprec.c dpbuf.c dpdev.c dpapps.c dpfilt.c dpkey.c dptype.c
AS=clock.asm dprcv.asm
CTS=
HS=dpinc.h dpdef.h clock.h dp.h dpdcl.h 
MAKS=$(SYSTEM).mak
DOCS=
SRCS=$(CS) $(AS) $(HS) $(DOCS) $(CTS) dpman.cmd dpevent.xmp
OBJS=dp.obj dptime.obj dprec.obj dpbuf.obj dpdev.obj dpapps.obj dpfilt.obj dpkey.obj dptype.obj clock.obj dprcv.obj
TOBJS=
EXES=
TEXES= 
EXPORTS=$(ID)\dp.h $(ID)\clock.h\
        $(LD)\$(MODEL)$(SYSTEM)$(MODE).lib
#************************************************************************
#*  Supported make commands:
#*
#*      all     -->     do a full make of this system part
#*      compile -->     do a compile of all c-files
#*      lib     -->     collect all obj's in a lib
#*      exe     -->     make exe's
#*      clean   -->     throw out all garbage
#*      collect -->     copy all .lib and .h files to global directories
#*      put     -->     do a PVCS put of the sources 
#*      get     -->     do a PVCS get of the sources
#*      getlock -->     do a PVCS get of the sources and put a lock on them
#*      makedir -->     Make all subdirectories in the given
#*                      tree $(NEWTREE)
#************************************************************************
all:  lib
    @echo ....Ready  $(MODEL)$(SYSTEM)$(MODE).lib


compile:    $(OBJS)

lib: $(MODEL)$(SYSTEM)$(MODE).lib

exe:   $(EXE) $(TEXES)

clean:
    @-del *.obj 2>nul
    @-del *.lib 2>nul
    @-del *.bak 2>nul
    @-del *.err 2>nul
    @-del *.exe 2>nul


collect: $(EXPORTS)
    !-copy $(**F) $**


put:    $(SRCS)
    !@-PUT -l -n -m$(PUTNOTE) $**
    @-PUT -l -n -m$(PUTNOTE) $(SYSTEM).mak

getlock:    $(SRCS)
    !-GET -l -n $**


get:    $(SRCS)
    !-GET  $**

makedir:
    mkdir $(NEWTREE)\VCS

#************************************************************************
#*  actual components and relations
#************************************************************************
$(MODEL)$(SYSTEM)$(MODE).lib : $(OBJS)
    !LIB $@ -+$**;
    copy $(MODEL)$(SYSTEM)$(MODE).lib $(LD)

clock.obj: clock.asm
    masm /W2 /Ml /DMODEL_$(MODEL) $**,$@;

dprcv.obj: dprcv.asm
    masm /W2 /Ml /DMODEL_$(MODEL) $**,$@;

# /Aw Tells compiler SS!=DS, but do not load DS
dprec.obj: dprec.c
    CL /c /Aw $(CFLAGS) $*.c

$(SRCS) :

$(EXPORTS) :










