#************************************************************************
#* MODULE INFORMATION*
#*********************
#*     FILE     NAME:       DPAPC.MAK
#*     SYSTEM   NAME:       BEHOLDER
#*     ORIGINAL AUTHOR(S):  Tirza van Rijn
#*     VERSION  NUMBER:     1.00
#*     CREATION DATE:       2-9-91
#*
#* DESCRIPTION: Makefile for the online packet capture application
#*             
#************************************************************************
#* CHANGES INFORMATION **
#************************
#* REVISION:    $Revision:   1.0  $
#* WORKFILE:    $Workfile:   DPAPC.MAK  $
#* LOGINFO:     $Log:   I:/TIRZA/CPROG/BEHOLDER/BAPS/DPAPC/VCS/DPAPC.MAV  $
#  
#     Rev 1.0   2 Sep 1991 13:06:18  tirza
#  No explicit note
#************************************************************************
HOMEDIR=..\..
NEWTREE=.^\
MODEL=L
MODE=r
CFLAGS=/DIPS_DOS /W4 /Ox /A$(MODEL) /L$(MODE) /I$(HOMEDIR)\INCLUDE /I..\INCLUDE -DPRD
LFLAGS=/STACK:8000
MFLAGS = HOMEDIR=$(HOMEDIR) CFLAGS="$(CFLAGS)" LFLAGS="$(LFLAGS)" MODE=$(MODE) MODEL=$(MODEL)
ID=$(HOMEDIR)\INCLUDE
LD=$(HOMEDIR)\LIB
PUTNOTE="No explicit note"

SYSTEM=DPAPC
LIBS=$(LD)\$(MODEL)$(SYSTEM)$(MODE).lib
CS= DPAPC.C
AS=
CTS=
HS=
MAKS=$(SYSTEM).MAK
DOCS=
SRCS=$(CS) $(AS) $(HS) $(DOCS) $(CTS) 
OBJS=DPAPC.OBJ
TOBJS=
EXES=
TEXES= 
EXPORTS=$(LD)\$(MODEL)$(SYSTEM)$(MODE).lib
#************************************************************************
#*  Supported make commands:
#*
#*      all     -->     do a full make of this system part
#*      compile -->     do a compile of all c-files
#*      lib     -->     collect all obj's in a lib
#*      exe     -->     make exe's
#*      clean   -->     throw out all garbage
#*      collect -->     copy all .lib and .h files to global directories
#*      put     -->     do a PVCS put of the sources 
#*      get     -->     do a PVCS get of the sources
#*      getlock -->     do a PVCS get of the sources and put a lock on them
#*      makedir -->     Make all subdirectories in the given
#*                      tree $(NEWTREE)
#************************************************************************
all:  lib 
    @echo --->  Ready  $(MODEL)$(SYSTEM)$(MODE).lib


compile:    $(OBJS)

lib: $(MODEL)$(SYSTEM)$(MODE).lib

exe:   $(EXE) $(TEXES)

clean:
    @-del *.obj 2>nul
    @-del *.lib 2>nul
    @-del *.bak 2>nul
    @-del *.err 2>nul


collect: $(EXPORTS)
    !-copy $(**F) $**


put:    $(SRCS)
    !@-PUT -l -n -m$(PUTNOTE) $**
    @-PUT -l -n -m$(PUTNOTE) $(SYSTEM).mak

getlock:    $(SRCS)
    !-GET -l $**


get:    $(SRCS)
    !-GET  $**

makedir:
    mkdir $(NEWTREE)\VCS

#************************************************************************
#*  actual components and relations
#************************************************************************
$(MODEL)$(SYSTEM)$(MODE).lib : $(OBJS)
    !LIB $@ -+$**;
    copy $(MODEL)$(SYSTEM)$(MODE).lib $(LD)

$(SRCS) :

$(EXPORTS) :


