#************************************************************************
#* MODULE INFORMATION*
#*********************
#*     FILE     NAME:       GOBBLER.MAK
#*     SYSTEM   NAME:       GOBBLER
#*     ORIGINAL AUTHOR(S):  Tirza van Rijn
#*     VERSION  NUMBER:     1.00
#*     CREATION DATE:       11-11-91
#*
#* DESCRIPTION: Makefile for the local GOBBLER
#************************************************************************
#* CHANGES INFORMATION **
#************************
#* REVISION:    $Revision:   1.0  $
#* WORKFILE:    $Workfile:   LGOBBLER.mak  $
#* LOGINFO:     $Log: $
#  
#     Rev 1.0   11 Nov 1991 16:37:34   tirza
#  No explicit note
#************************************************************************
HOMEDIR = ..\..
NEWTREE = .^\
MODEL=L
MODE=r
V=2
CFLAGS=/W4 /Ox /Zi /A$(MODEL) /L$(MODE) /I$(HOMEDIR)\INCLUDE /I..\INCLUDE /FmLGOBBLER.MAP -DPRD 
LFLAGS=/MAP
MFLAGS=HOMEDIR="$(HOMEDIR)" CFLAGS="$(CFLAGS)" LFLAGS="$(LFLAGS)" MODE=$(MODE) MODEL=$(MODEL)
ID=$(HOMEDIR)\INCLUDE
LD=$(HOMEDIR)\LIB
LIB=$(LD);$(LIB)
ED=$(HOMEDIR)\EXE
PUTNOTE="No explicit note"
STACKSIZE=5500

SYSTEM=GOBBLER

ALIBS = $(MODEL)POWER3$(MODE).LIB 

BLIBS= $(MODEL)PKT$(MODE).LIB    $(MODEL)DP$(MODE).LIB \
       $(MODEL)ML$(MODE).LIB     $(MODEL)DpaIP$(MODE).LIB \
       $(MODEL)IP$(MODE).LIB     $(MODEL)UDP$(MODE).LIB \
       $(MODEL)IFACE$(MODE).LIB  $(MODEL)SOCK$(MODE).LIB \
       $(MODEL)TFTP$(MODE).LIB   $(MODEL)SDM$(MODE).LIB \
       $(MODEL)FUTIL$(MODE).LIB  $(MODEL)BUFM$(MODE).LIB \
       $(MODEL)PING$(MODE).LIB   $(MODEL)ECHO$(MODE).LIB \
       $(MODEL)DPERR$(MODE).LIB  $(MODEL)ASN1$(MODE).LIB \
       $(MODEL)SNMP$(MODE).LIB   $(MODEL)MIB2$(MODE).LIB \
       $(MODEL)DSNMP$(MODE).LIB  $(MODEL)CONTROL$(MODE).LIB \
       $(MODEL)LOAD$(MODE).LIB   $(MODEL)DPU$(MODE).LIB
#       $(MODEL)DOG$(MODE).LIB    $(MODEL)DISP$(MODE).LIB

#BLIBS= $(MODEL)PKT$(MODE).LIB    $(MODEL)DP$(MODE).LIB \
#       $(MODEL)DpaIP$(MODE).LIB  $(MODEL)BUFM$(MODE).LIB \
#       $(MODEL)IP$(MODE).LIB     $(MODEL)UDP$(MODE).LIB \
#       $(MODEL)IFACE$(MODE).LIB  $(MODEL)SOCK$(MODE).LIB \
#       $(MODEL)FUTIL$(MODE).LIB  $(MODEL)DPERR$(MODE).LIB \
#       $(MODEL)DPU$(MODE).LIB    $(MODEL)UDP$(MODE).LIB

MYLIBS= $(MODEL)DPAPC$(MODE).LIB $(MODEL)DPFPKT$(MODE).LIB \
        $(MODEL)DPAFV$(MODE).LIB

LIBS = $(ALIBS) $(BLIBS) $(MYLIBS)

CS=GOBBLER.C LINK.C
AS=
CTS=
HS=
MAKS=GOBBLER.MAK
DOCS=
SRCS=$(CS) $(AS) $(HS) $(DOCS) $(CTS) 
OBJS=GOBBLER.OBJ LINK.OBJ
TOBJS=
EXES=$(SYSTEM).EXE
TEXES= 
EXPORTS= $(ED)\$(SYSTEM).EXE
#************************************************************************
#*  Supported make commands:
#*
#*      all     -->     do a full make of this system part
#*      compile -->     do a compile of all c-files
#*      lib     -->     collect all obj's in a lib
#*      exe     -->     make exe's
#*      clean   -->     throw out all garbage
#*      collect -->     copy all .lib and .h files to global directories
#*      put     -->     do a PVCS put of the sources 
#*      get     -->     do a PVCS get of the sources
#*      getlock -->     do a PVCS get of the sources and put a lock on them
#*      makedir -->     Make all subdirectories in the given
#*                      tree $(NEWTREE)
#************************************************************************
all:  exe 
    @echo (3) Ready


compile:    $(OBJS)

lib: $(MODEL)$(SYSTEM)$(MODE).lib

exe:   $(EXES) $(TEXES)

clean:
    @-del *.obj 2>nul
    @-del *.lib 2>nul
    @-del *.bak 2>nul
    @-del *.err 2>nul
    @-del *.exe 2>nul


collect: $(EXPORTS)
    !-copy $(**F) $**


put:    $(SRCS)
    !@-PUT -l -n -m$(PUTNOTE) $**
    @-PUT  -l -n -m$(PUTNOTE) $(SYSTEM).mak

getlock:    $(SRCS)
    !-GET -l $**


get:    $(SRCS)
    !GET  $**

makedir:
    mkdir $(NEWTREE)\VCS

#************************************************************************
#*  actual components and relations
#************************************************************************
$(SYSTEM).exe : $(OBJS)
    cl $(CFLAGS) /F $(STACKSIZE) /Fe$@ $** $(LIBS) /link
    copy gobbler.exe ..\..\exe

$(SRCS) :

$(EXPORTS) :

#$(LIBS) :
#    @$(MAKE) /NOLOGO $(MFLAGS) -f "$(HOMEDIR)\beholder.mak"  $@

$(LD)\$(MODEL)DPAPC$(V)$(MODE).LIB : ..\..\baps\dpapc\dpapc$(V).c 
    cd ..\..\baps\dpapc
    make$(V)
    cd ..\..\aps\gobbler

$(LD)\$(MODEL)DPFPKT$(V)$(MODE).LIB : ..\..\bfilt\dpfpkt\dpfpkt$(V).c
    cd ..\..\bfilt\dpfpkt
    make$(V)
    cd ..\..\aps\gobbler


