{==============================================================}
{                         KEYPAD_5.PAS                         }
{                     Pat Anderson, Sysop                      }
{        Pascal Alley, Fidonet 343/52, (206) 222-6224          }
{                                                              }
{ Hook into the BIOS Int $09 interrupt service routine to      }
{ detect a keypress that ReadKey ignores - the [5] key on the  }
{ numeric keypad.  Easily expanded to handle many other keys   }
{ for "event driven" programming.  Based on Ohlsen & Stoker    }
{ Turbo Pascal Advanced Techniques, Chapter 7                  }
{==============================================================}

unit KeyPad_5;

interface

uses
  Dos,
  Crt;

const
  Key_5_Pressed : boolean = false;

var
  OldInt09,
  NewInt09  : pointer;

implementation

var
  OldExit : pointer;

procedure JmpOldISR ( OldISR: pointer );
  Inline ( $5B/$58/$87/$5E/$0E/$87/$46/$10/$89/
           $EC/$5D/$07/$1F/$5F/$5E/$5A/$59/$CB );

{$F+}
Procedure Int09_ISR; Interrupt;
  begin
    If ( Port[$60] = 76 ) Then
      begin
        Key_5_Pressed := true;
        Inline ( $E4/$61/$8A/$E0/$0C/$80/$E6/$61/   { Clean up as the    }
                 $86/$E0/$E6/$61/$B0/$20/$E6/$20 ); { Bios would         }
       Exit;
      end;
    JmpOldISR( OldInt09 );       {Jump to Old Keyboard handler }
  end;

Procedure Exitit;
  begin
    ExitProc := OldExit;        { Restore Old ExitProc pointer }
    SetIntVec ( 9, OldInt09 );  { Restore Old Int9 Handler     }
  end;
{$F-}

begin
  OldExit := ExitProc;           { Save old ExitProc pointer }
  ExitProc := @Exitit;           { Set new ExitProc pointer  }
  GetIntVec ( 9, OldInt09 );     { Get Current Int9  Vector  }
  NewInt09 := @Int09_ISR;
  SetIntVec ( 9, NewInt09 );     { Set Int9 to our routine   }
end.
