bufstart  equ 80h
bufhead   equ 1ah
buftail   equ 1ch

          jmp robokey

keybuf    dw 200 dup(?)
keyptr    dw ?
hour      db ?
sec       dw ?
keynum    db ?
intflag   db ?
org1c     dd 0


int1c:    push ds
          pushf
          push cs
          pop ds
          test intflag
          jg fillbuf
          jl finint2
          dec sec
          jnz finint2
          dec hour
          jnz finint2
          mov intflag,1
          push ax
          lea ax,keybuf
          mov keyptr,ax
          pop ax
fillbuf:  push ax,bx,es
          mov ax,40h
          mov es,ax
          mov bx,es:[bufhead]
          cmp bx,es:[buftail]
          jnz finint1
          mov bx,es:[bufstart]
          cli
          mov es:[bufhead],bx
          mov es:[buftail],bx
          sti
          lea bx,keyptr
          mov bx,[bx]
          mov ax,[bx]
          mov bx,es:[buftail]
          mov es:[bx],ax
          add es:[buftail],2
          add keyptr,2
          dec keynum
          jnz finint1
          mov intflag,-1
finint1:  pop es,bx,ax
finint2:  popf
          pop ds
          jmp cs:[org1c]

timebuf   db 9,11 dup(?)
alarmstr  db 10,13,'Alarm is set for $'
clockstr  db 10,13,'Current time is '
dhours    dw ?
          db ':'
dmins     dw ?
          db ' '
ampm      db 'A'
          db 'M',10,13,'$'
timestr   db 'Time for alarm: ','$'
kbdstr    db 10,13,10,13,'Enter characters to be sent to keyboard. (0-200)'
lfcr      db 10,13,'$'
dgterr    db 10,13,'*** DIGIT EXPECTED ***',10,13,10,13,'$'
rngerr    db 10,13,'*** TIME OUT OF RANGE ***',10,13,10,13,'$'
bksp      db 8
ec        db 32,8,'$'
cuf       db 27,'[C$'
chr       db ?
crsrsav   db ?
escnum    db ?
ttime     dw ?
thour     db ?
tsec      dw ?

robokey:  call sound
          call setalarm
          call setkbd
          call timedif
          jmp setint

sound:    mov al,0b6h
          out 43h,al
          mov al,84h
          out 42h,al
          mov al,0
          out 42h,al
          in al,61h
          push ax
          or al,3
          out 61h,al
          mov cx,2710h
s1:       loop s1
          pop ax
          out 61h,al
          ret

print:    mov ah,9
          int 21h
          ret

ckdgt:    cmp b[di],'0'
          jl cderr
          cmp b[di],'9'
          jg cderr
          clc
          ret
cderr:    lea dx,dgterr
          call print
          stc
          ret

asctime:  mov al,ch
          cmp al,12
          jl at1
          mov ampm,'P'
          jz at2
          sub al,12
          jmp at2
at1:      mov ampm,'A'
          jnz at2
          mov al,12
at2:      test al
          jnz at3
          mov al,12
at3:      aam
          add ax,'00'
          xchg ah,al
          mov dhours,ax
          mov al,cl
          aam
          add ax,'00'
          xchg ah,al
          mov dmins,ax
          ret

setalarm: mov ah,2ch
          int 21h
          mov ttime,cx
          call asctime
          lea dx,clockstr
          call print
          lea dx,timestr
          call print
          lea dx,timebuf
          mov ah,0ah
          int 21h
          lea di,timebuf+2
          call ckdgt
          mov al,[di]
          jc setalarm
          inc di
          sub al,'0'
          cmp b[di],':'
          jz  sa4
          call ckdgt
          jc setalarm
          mov dl,10
          mul dl
          add al,[di]
          inc di
          sub al,'0'
sa4:      inc di
          mov cl,al
          call ckdgt
          jc setalarm
          mov al,[di]
          inc di
          call ckdgt
          jc setalarm
          sub al,'0'
          mov dl,10
          mul dl
          add al,[di]
          sub al,'0'
          mov ah,cl
          cmp ah,12
          jg sa9
          cmp al,60
          jl sa5
sa9:      lea dx,rngerr
          call print
          jmp setalarm
sa5:      inc di
          cmp b[di],' '
          jz sa5
          mov cx,ttime
          mov dl,b[di]
          or dl,32
          cmp dl,'a'
          jz saam
          cmp dl,'p'
          jz sapm
          cmp ah,ch
          jg sa11
          jl sa12
          cmp al,cl
          jg finsa
sa12:     add ah,12
sa11:     jmp finsa
saam:     cmp ah,12
          jnz finsa
          xor ah,ah
          jmp finsa
sapm:     cmp ah,12
          jz finsa
          add ah,12
finsa:    mov ttime,ax
          mov hour,ah
          cbw
          mov sec,ax
          mov ax,1092
          mul sec
          add ax,115
          mov sec,ax
          ret

setkbd:   lea dx,kbdstr
          call print
          mov escnum,0
          mov keynum,0
          mov crsrsav,0
          lea di,keybuf
readkbd:  xor ah,ah
          int 16h
          mov chr,al
          cmp al,8
          jnz sk1
          mov ah,2
          int 16h
          test al,3
          jnz sk1
          test keynum
          jz readkbd
          mov ah,3
          xor bh,bh
          int 10h
          cmp dl,0
          jg sk4
          dec dh
          mov dl,255
sk5:      inc dl
          mov ah,2
          int 10h
          cmp dl,79
          je sk10
          mov ah,8
          int 10h
          cmp al,255
          jnz sk5
sk10:     mov ah,10
          mov al,32
          xor bh,bh
          mov cx,1
          int 10h
          jmp sk6
sk4:      lea dx,bksp
          call print
          mov crsrsav,0
sk6:      sub keynum,2
          sub di,2
          mov al,chr
          jmp escck
sk1:      mov [di],ax
          add di,2
prtkbd:   mov ah,10
          mov al,chr
          cmp al,126
          jg sk11
          cmp al,31
          jg sk12
          cmp al,13
          jnz sk11
          mov al,255
          jmp sk12
sk11:     mov al,46
sk12:     xor bh,bh
          mov cx,1
          int 10h
          mov al,chr
          cmp al,13
          jnz sk8
          lea dx,lfcr
          call print
          jmp escck
sk8:      lea dx,cuf
          call print
          mov ah,3
          xor bh,bh
          int 10h
          cmp dl,crsrsav
          mov crsrsav,dl
          jnz escck
          cmp dl,2
          jl escck
          lea dx,lfcr
          call print
escck:    cmp chr,27
          jnz sk2
          inc escnum
          jmp sk3
sk2:      mov escnum,0
sk3:      inc keynum
          cmp escnum,3
          jz finsk
          cmp keynum,200
          jz finsk
          jmp readkbd
finsk:    mov al,escnum
          sub keynum,al
          mov keyptr,di
          ret

timedif:  mov cx,ttime
          call asctime
          lea dx,alarmstr
          call print
          lea dx,dhours
          call print

          mov ah,0
          int 1ah
          mov thour,cl
          mov tsec,dx
          mov al,hour
          cmp al,thour
          jg td7
          jl td8
          mov ax,sec
          cmp ax,tsec
          jl td8
td7:      mov ax,tsec
          sub sec,ax
          mov al,thour
          sbb hour,al
          jmp fintd
td8:      mov ax,sec
          sub ax,tsec
          mov sec,ax
          mov al,hour
          sbb al,thour
          mov hour,al
fintd:    inc sec,hour
          ret

setint:   mov intflag,0
          push es
          mov ah,35h
          mov al,1ch
          int 21h
          lea di,org1c
          mov [di],bx
          mov [di+2],es
          pop es
          mov ah,25h
          mov al,1ch
          lea dx,int1c
          int 21h
          lea dx,timebuf
          int 27h
