/******************************************************************************
* Bzr-Wrt.c - Bezier handling routines - write to file.			      *
*******************************************************************************
* Written by Gershon Elber, Mar. 90.					      *
******************************************************************************/

#ifdef __MSDOS__
#include <stdlib.h>
#endif /* __MSDOS__ */

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include "cagd_loc.h"

/******************************************************************************
* Writes a bezier curve(s) list into file. Returns TRUE if succesful, FALSE   *
* otherwise.								      *
* If Comment is NULL, no comment is printed, if "" only internal coment.      *
******************************************************************************/
int BzrCrvWriteToFile(CagdCrvStruct *Crvs, char *FileName, int Indent,
						 char *Comment,	char **ErrStr)
{
    int i;
    FILE *f;

    if ((f = fopen(FileName, "w")) == NULL) {
	*ErrStr = "Fail to open file";
	return FALSE;
    }
    i = BzrCrvWriteToFile2(Crvs, f, Indent, Comment, ErrStr);

    fclose(f);

    return i;
}

/******************************************************************************
* Writes a bezier curve(s) list into file. Returns TRUE if succesful, FALSE   *
* otherwise. The file is not closed.					      *
* If Comment is NULL, no comment is printed, if "" only internal coment.      *
******************************************************************************/
int BzrCrvWriteToFile2(CagdCrvStruct *Crvs, FILE *f, int Indent, char *Comment,
								char **ErrStr)
{
    int i, j, MaxCoord;

    if (Comment != NULL) {
	_CagdFprintf(f, Indent, "#\n");
	_CagdFprintf(f, Indent, "# cagd_lib - bezier curve(s) dump.\n");
	_CagdFprintf(f, Indent, "#\n");
	_CagdFprintf(f, Indent, "# %s\n", Comment);
	_CagdFprintf(f, Indent, "#\n");
    }

    *ErrStr = NULL;

    while (Crvs) {
	MaxCoord = CAGD_NUM_OF_PT_COORD(Crvs -> PType);

	if (Crvs -> GType != CAGD_CBEZIER_TYPE) {
	    *ErrStr = "Given curve(s) is (are) not BEZIER curve(s)";
	    break;
	}
	_CagdFprintf(f, Indent, "[CURVE BEZIER %d %c%c\n",
		Crvs -> Length,
		CAGD_IS_RATIONAL_PT(Crvs -> PType) ? 'P' : 'E',
		MaxCoord + '0');
	Indent += 4;

	for (i = 0; i < Crvs -> Length; i++) {
	    _CagdFprintf(f, Indent, "[");
	    if (CAGD_IS_RATIONAL_PT(Crvs -> PType))
		_CagdFprintf(f, 0, "%s ", _CagdReal2Str(Crvs -> Points[0][i]));
	    for (j = 1; j <= MaxCoord; j++) {
		_CagdFprintf(f, 0, "%s", _CagdReal2Str(Crvs -> Points[j][i]));
		if (j < MaxCoord) _CagdFprintf(f, 0, " ");
	    }
	    _CagdFprintf(f, 0, "]\n");
	}

	Indent -= 4;
	_CagdFprintf(f, Indent, "]\n\n");

	Crvs = Crvs -> Pnext;
    }

    return *ErrStr == NULL;
}

/******************************************************************************
* Writes a bezier curve(s) list into file. Returns TRUE if succesful, FALSE   *
* otherwise.								      *
* If Comment is NULL, no comment is printed, if "" only internal coment.      *
******************************************************************************/
int BzrSrfWriteToFile(CagdSrfStruct *Srfs, char *FileName, int Indent,
						 char *Comment,	char **ErrStr)
{
    int i;
    FILE *f;

    if ((f = fopen(FileName, "w")) == NULL) {
	*ErrStr = "Fail to open file";
	return FALSE;
    }
    i = BzrSrfWriteToFile2(Srfs, f, Indent, Comment, ErrStr);

    fclose(f);

    return i;
}

/******************************************************************************
* Writes a bezier curve(s) list into file. Returns TRUE if succesful, FALSE   *
* otherwise. The file is not closed.					      *
******************************************************************************/
int BzrSrfWriteToFile2(CagdSrfStruct *Srfs, FILE *f, int Indent, char *Comment,
								char **ErrStr)
{
    int i, j, MaxCoord;

    if (Comment != NULL) {
	_CagdFprintf(f, Indent, "#\n");
	_CagdFprintf(f, Indent, "# cagd_lib - bezier srf(s) dump.\n");
	_CagdFprintf(f, Indent, "#\n");
	_CagdFprintf(f, Indent, "# %s\n", Comment);
	_CagdFprintf(f, Indent, "#\n");
    }

    *ErrStr = NULL;

    while (Srfs) {
	MaxCoord = CAGD_NUM_OF_PT_COORD(Srfs -> PType);

	if (Srfs -> GType != CAGD_SBEZIER_TYPE) {
	    *ErrStr = "Given surface(s) is (are) not BEZIER surface(s)";
	    break;
	}
	_CagdFprintf(f, Indent, "[SURFACE BEZIER %d %d %c%c\n",
		Srfs -> ULength, Srfs -> VLength,
		CAGD_IS_RATIONAL_PT(Srfs -> PType) ? 'P' : 'E',
		MaxCoord + '0');
	Indent += 4;

	for (i = 0; i < Srfs -> VLength * Srfs -> ULength; i++) {
	    if (i && i % Srfs -> ULength == 0)
		_CagdFprintf(f, 0, "\n");    /* Put empty lines between raws. */

	    _CagdFprintf(f, Indent, "[");
	    if (CAGD_IS_RATIONAL_PT(Srfs -> PType))
		_CagdFprintf(f, 0, "%s ", _CagdReal2Str(Srfs -> Points[0][i]));
	    for (j = 1; j <= MaxCoord; j++) {
		_CagdFprintf(f, 0, "%s", _CagdReal2Str(Srfs -> Points[j][i]));
		if (j < MaxCoord) _CagdFprintf(f, 0, " ");
	    }
	    _CagdFprintf(f, 0, "]\n");
	}

	Indent -= 4;
	_CagdFprintf(f, Indent, "]\n\n");

	Srfs = Srfs -> Pnext;
    }

    return *ErrStr == NULL;
}
