/**<vch.c>***************************************************
*                       V O U C H                           *
*   VOUCH 1.1  Copyright (c) 1993, 1994  Awais M Hussain    *
*                   All rights reserved                     *
*************************************************************/
/* Consult <vch.man> for documentation. 
*/
#include "vch.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <mem.h>
#include <io.h>
#include <conio.h>
#include <time.h>
#include <dos.h>
#include <dir.h>
#include "gen.h"

extern long unsigned key[4] ;
extern unsigned Nres ;
extern ptrLN  rs[380] ;  /* 1..379 */
extern lenLN  Lrs[380] ; /* 1..379 */

/* ID strings */
char hashLine[200] = "vch 1.1 :hash standard [nist] :file=" ,
     sigLine[200]  = "vch 1.1 :digital signature [nist] :" ,
     sgnLine[200]  = "vch 1.1 :digital signature msg [nist] :" ,
     cphLine[200]  = "vch 1.1 :cipher (feal-x/64/2) :" ;
const char cdlim[] = " :" ;

unsigned pLen = 16 ;
unsigned bLen = 180 ;
 /*  4*[  2 * ( word_length_of_number + p_sor_overhead ) + 1 ]  bytes */

float tm ;

lenLN  Lpp, Lqq, Lgg, LrSign, LsSign, Lmhash,
            LkSec=0, LxSec=0, LyPub, Lh1=0, Lh2=0, Lh3=0 ;
ptrLN  pp, qq, gg, rSign, sSign, mhash, kSec, xSec, yPub, h1, h2, h3 ;

char fPubKey[80], fSecKey[80] ;
char  pswd[64], opswd[64], epswd[64] ;
char inFile[80], outFile[80], rFile[80], keyWfile[80] ;
char wline[200], idStr[100] ;
int  init_ed ;
unsigned qLen ;
FILE *flog ;

void exit_proc( char *fn, int err ) ;
void logI( const char *line ) ;
void logF( void )  ;
void readPrime( void ) ;
void genKeys( char *fnpub, char *fnsec ) ;
void rSignature( void ) ;
int sSignature( void ) ;
int verify( void ) ;
void encrypt( char *plnFile, char *encFile ) ;
int decrypt( char *encFile, char *plnFile ) ;
void init( char *fn ) ;
void init_auth( void ) ;

/************************************/
void exit_proc( char *fn, int err )
{
  int i ;

  if ( strlen(fn) ) {
    printf("** File <%s> error: %i\n", fn, err ) ;
    fprintf( flog, "** File <%s> error: %i\n", fn, err ) ;
    switch (err) {
      case 2: perror("File not found.") ; break ;
      case 3: perror("Path not found.") ; break ;
      case 5: perror("Access denied.") ; break ;
      case 41: puts("Invalid format for long_hex_number.") ; break ;
      case 40:
      case 30: puts("Long_hex_number not found.") ; break ;
      case 31: puts("File write error.") ; break ;
      case 33: puts("File corrupt.") ; break ;
      case 50: puts("Long_hex_number too long.") ; break ;
      case 51: puts("Signature too long.") ; break ;
      case 45: puts("Invalid format for signature.") ; break ;
      case 72:
      case 70: puts("File read error.") ; break ;
      case 55: puts("Public_key length less than 128 bits.") ; break ;
    }
  }
  memset( pswd, 0, LPSWD_MAX ) ;
  memset( opswd, 0, LPSWD_MAX ) ;
  memset( epswd, 0, LPSWD_MAX ) ;
  memset( xSec, 0, 4*LxSec ) ;
  memset( kSec, 0, 4*LkSec ) ;
  memset( h1, 0, 4*Lh1 ) ;
  memset( h2, 0, 4*Lh2 ) ;
  memset( h3, 0, 4*Lh3 ) ;
  free( pp ) ;
  free( qq ) ;
  free( gg ) ;
  free( rSign ) ;
  free( sSign ) ;
  free( mhash ) ;
  free( kSec ) ;
  free( xSec ) ;
  free( yPub ) ;
  free( h1 ) ;
  free( h2 ) ;
  free( h3 ) ;
  if (Nres>Lpp)
    for (i=1; i<=Nres-Lpp; ++i)  free( rs[i] ) ;
  fclose( flog ) ;
  while (kbhit()) getch() ;
  exit( err ) ;
}/* exit_proc */


/*********************************/
void logI( const char *line )
{
  cputs( line ) ;
  fputs( line, flog ) ;
  timeI() ;
}/* logI */

/******************************/
void logF( void )
{
  timeF( &tm ) ; 
  printf( "%.2f seconds\n", tm ) ;
  fprintf( flog,  "%.2f seconds\n", tm ) ;
}/* logF */


/* read public_key parameters (Lpp,pp), (Lqq,qq), (Lgg,gg) */
/***********************************************************/
void readPrime( void )
{
  int err ;
  
  Lpp = pLen;
  if ((err = readLN( 2, fPubKey, &Lpp, pp )) != 0 )
    exit_proc( fPubKey, err ) ;
  Lqq = pLen ;
  if ((err = readLN( 3, fPubKey, &Lqq, qq )) != 0 )
    exit_proc( fPubKey, err ) ;
  qLen = Lqq ;
  Lgg = pLen;
  if ((err = readLN( 4, fPubKey, &Lgg, gg )) != 0 )
    exit_proc( fPubKey, err ) ;
  Nres = Lpp ;
}/* readPrime */


/* generate new private_key (LxSec,xSec) and public_key (LyPub,yPub) */
/********************************************************************/
void genKeys( char *fnpub, char *fnsec )
{
  int err ;
  char fno[80] ;

  fExt( fnpub, ".old", fno ) ;   /* backup <myPublic.key> */
  if ( (err = copyFile( fnpub, fno, 1 )) != 0 ) {
    printf("File %s - %s error\n", fnpub, fno ) ;  
    fprintf(flog, "File %s - %s error\n", fnpub, fno ) ;  
    exit_proc("myPublic",err) ;
  }
  fExt( fnsec, ".old", fno ) ;   /* backup <myPrivat.key>, if exists */
  if ( access(fnsec,0)==0 )
    if ( (err=copyFile( fnsec, fno, 1 )) != 0 )
      exit_proc("myPrivat",err) ;
  if ( (err = trunc( 4, fnpub )) != 0 )  /* delete (LyPub, yPub), if there */
     exit_proc( fnpub, err ) ;

  logI("Generating keys....May take a while.... " ) ;
  do {                            /* generate the keys */
    do {
      LxSec = Lqq ; *(xSec+LxSec-1) = *(qq+Lqq-1) ;
      randomLN( &LxSec, xSec ) ;
      if (!isGreater( Lqq, qq, LxSec, xSec ))
	subt( Lqq, qq, &LxSec, xSec ) ;
    } while ( (LxSec==1) && (*xSec<16) ) ;
    dexp( Lgg, gg, LxSec, xSec, Lpp, pp, &LyPub, yPub ) ;
  } while ( (LyPub==1) && (*yPub<16) ) ;
  logF() ;
  if ( (err = writeLN( 0, fnpub, LyPub, yPub )) != 0 )
    exit_proc( fnpub, err ) ;
  if ( (err = write_prvKey( fnsec, pswd )) != 0 )
    exit_proc( fnsec, err ) ;
}/* genKeys */


/* generate r_component (LrSign,rSign) of the signature */
/*************************************************************/
void rSignature( void ) 
{
  logI("Computing r_signature.....May take a while..." ) ;
  do {
    LkSec = Lqq ; *(kSec+LkSec-1) = *(qq+Lqq-1) ;
    randomLN( &LkSec, kSec ) ;
    if (!isGreater( Lqq, qq, LkSec, kSec ) )
      subt( Lqq, qq, &LkSec, kSec ) ;
  } while ( (LkSec==1) && (*kSec<16) ) ;
  dexp( Lgg, gg, LkSec, kSec, Lpp, pp, &Lh1, h1 ) ;
  modR( Lh1, h1, Lqq, qq, &LrSign, rSign ) ;
  inverse( LkSec, kSec, Lqq, qq, &Lh1, h1 ) ;
  LkSec = Lh1 ; movmem( h1, kSec, 4*Lh1 ) ; /* kSec = inverse( kSec ) */
  logF() ;
}/* rSignature */


/* compute s_component (LsSign,sSign) of the signature */
/* return(1), if sSign=0 */
/*************************************************************/
int sSignature( void )
{
  logI("Now computing s_signature....." ) ;
  mult( LxSec, xSec, LrSign, rSign, &Lh1, h1 ) ;
  accum( Lmhash, mhash, &Lh1, h1 ) ;
  modR( Lh1, h1, Lqq, qq, &LsSign ,sSign ) ;
  if ( (LsSign==1) && (*sSign==0) ) {
    logF() ;
    return(1) ;
  }
  mult( LkSec, kSec, LsSign, sSign, &Lh1, h1 ) ;
  modR( Lh1, h1, Lqq, qq, &LsSign, sSign ) ;
  setmem( kSec, 4*LkSec, 0 ) ;
  logF() ;
  return(0) ;
}/* sSignature */


/* verify signature (r,s) */
/* return(1), if the signature verifies */
/*******************************************************/
int verify( void ) 
{
  logI("Verifying signature.....May take a while..." ) ;
  if ( ((LrSign==1) && (*rSign==0)) || /* check (r,s) for reasonability */
       ((LsSign==1) && (*sSign==0)) ||
     !isLess( LrSign, rSign, Lqq, qq ) ||
     !isLess( LsSign, sSign, Lqq, qq ) )
  {
    logF() ;  return(0) ;
  }
  inverse( LsSign, sSign, Lqq, qq, &Lh1, h1 ) ; /* now the check */
  mult( Lh1, h1, LrSign, rSign, &Lh2, h2 ) ;
  modR( Lh2, h2, Lqq, qq, &Lh3, h3 ) ;
  mult( Lh1, h1, Lmhash, mhash, &Lh2, h2 ) ;
  modR( Lh2, h2, Lqq, qq, &Lh1, h1 ) ;
  dexp2( Lgg, gg, Lh1, h1, LyPub, yPub, Lh3, h3, Lpp, pp, &Lh2, h2 ) ;
  modR( Lh2, h2, Lqq, qq, &Lh1, h1 ) ;
  logF() ;
  return( isEqual( Lh1, h1, LrSign, rSign) ) ;
}/* verify */


/********************************************************/
void encrypt( char *plnFile, char *encFile )
{
  int i, err ;

  logI("Generating key for encryption....May take a while...") ;
  do {
    do {
      LkSec = Lqq+1 ; *(kSec+LkSec-1) = 1 ;
      randomLN( &LkSec, kSec ) ;
    } while ( (LkSec==1) && (*kSec<16) ) ;
    dexp( Lgg, gg, LkSec, kSec, Lpp, pp, &Lh1, h1 ) ;
    dexp( LyPub, yPub, LkSec, kSec, Lpp, pp, &Lh2, h2 ) ;
  } while ( Lh2<4 ) ;
  logF() ;
  for (i=1; i<Lh2; ++i)  *h2 ^= *(h2+i) ;
  movmem( h2, key, 16 ) ; /* fill encrypting key */
  strcat( cphLine, idStr ) ;
  strcat( cphLine, cdlim ) ;
  err = writeS( 1, encFile, cphLine ) ;
  if (err) exit_proc( encFile, err ) ;
  err = writeLN( 0, encFile, Lh1, h1 ) ;
  if (err) exit_proc( encFile, err ) ;
  logI("Encrypting file... " ) ;
  err = fecrypt( plnFile, encFile ) ;
  if (err) exit_proc( "plain/cipher", err ) ;  
  setmem( h2, 4*Lh2, 0 ) ;
  setmem( key, 16, 0 ) ;
  logF() ;
  printf("Cipher file <%s> written.\n", encFile ) ;
  fprintf(flog, "Cipher file <%s> written.\n", encFile ) ;
}/* encrypt */


/* return( nonzero ), if error reading input file */
/****************************************************/
int decrypt( char *encFile, char *plnFile )
{
  int i, err ;

  Lh1 = Lpp ;
  err = readLN( 2, encFile, &Lh1, h1 ) ;
  if (err) return( err ) ;
  logI("Computing key for decryption....May take a while...") ;
  dexp( Lh1, h1, LxSec, xSec, Lpp, pp, &Lh2, h2 ) ;
  for (i=1; i<Lh2; ++i)  *h2 ^= *(h2+i) ;
  movmem( h2, key, 16 ) ; /* fill encrypting key */
  logF() ;
  logI("Decrypting file...") ;
  err = fdcrypt( encFile, plnFile ) ;
  if (err) exit_proc("cipher/plain", err) ;
  logF() ;
  setmem( h2, 4*Lh2, 0 ) ;
  setmem( key, 16, 0 ) ;
  printf("Plaintext file <%s> written.\n", plnFile ) ;
  fprintf( flog, "Plaintext file <%s> written.\n", plnFile ) ;
  return(0) ;
}/* decrypt */


/********************************************/
void init( char *fn )
{
  FILE *ff ;
  unsigned ovhd ;
  char *buff ;

  if ( (ff = fopen( fn, "r" )) == (FILE*) NULL ) {
    printf("File %s not found.\n", fn ) ;
    exit(errno) ;
  }  
  buff = (char*) malloc(2048) ;
  if ( fgets( buff, 2048, ff ) == (char*) NULL ) {
    free(buff) ; exit(70) ;
  }
  fclose( ff ) ;
  sscanf( buff, "%u%80s", &pLen, idStr ) ;
  free(buff) ;
  if (pLen<5)  pLen = 5 ;
  if (pLen>250) {
    printf("Length parameter in Public-key is too large. \n") ;
    exit(11) ;
  }
  ovhd = 6 ;
  bLen = 4 * (2*(pLen+ovhd) + 1 ) ;
  qLen = pLen ;
  pp    = (ptrLN) malloc( bLen ) ;
  qq    = (ptrLN) malloc( bLen ) ;
  gg    = (ptrLN) malloc( bLen ) ;
  rSign = (ptrLN) malloc( bLen ) ;
  sSign = (ptrLN) malloc( bLen ) ;
  mhash = (ptrLN) malloc( bLen ) ;
  kSec  = (ptrLN) malloc( bLen ) ;
  xSec  = (ptrLN) malloc( bLen ) ;
  yPub  = (ptrLN) malloc( bLen ) ;
  h1    = (ptrLN) malloc( bLen ) ;
  h2    = (ptrLN) malloc( bLen ) ;
  h3    = (ptrLN) malloc( bLen ) ;
  init_ed = 1 ;
}/* init */

/**********************************************************/

main( int argc, char *argv[] )
{

long nb, maxnb ;
int Lpswd, Lepswd ;
int i, err, option, quit ;
char chk, *cDirx ;
char dirf[68], extf[5], nfPubKey[9], drv[3], LppStr[4], LqqStr[4], cDir[80] ;

/*1
  if (test8086()<2) {
    puts("Requires a 386-processor.") ; 
    exit(386) ;
  }
*/

/*2*/
  init_ed = 0 ;
  if (argc==1) {
    puts("        V O U C H  1.1  Copyright (c) 1993, 1994  Awais M Hussain " ) ;
    puts("        Digital Signature Authentication   ") ;
    puts(" Vch /?   for help." ) ;
    exit(1) ;
  }

/*3*/
  for (i=1; i<argc; ++i) strlwr( argv[i] ) ;
/*4*/
  if (strcmp(argv[1],"/?")==0) {
    helpScr() ; exit(1) ;
  }

/*5*/
  if (strcmp(argv[1],"/sgn")==0) {
    option = 10 ;
    if ((argc<4) || (argc>5)) exit_hlp( option ) ;
  } else
  if (strcmp(argv[1],"/sig")==0) {
    option = 11 ;
    if ((argc<4) || (argc>5)) exit_hlp( option ) ;
  } else
  if (strcmp(argv[1],"/fsgn")==0) {
    option = 20 ;
    if ((argc<4) || (argc>5)) exit_hlp( option ) ;
  } else
  if (strcmp(argv[1],"/fsig")==0) {
    option = 21 ;
    if ((argc<4) || (argc>5)) exit_hlp( option ) ;
  } else
  if (strcmp(argv[1],"/vsgn")==0) {
    option = 30 ;
    if (argc!=4) exit_hlp( option ) ;
  } else
  if (strcmp(argv[1],"/vsig")==0) {
    option = 31 ;
    if (argc!=4) exit_hlp( option ) ;
  } else
  if (strcmp(argv[1],"/z")==0) {
    option = 32 ;
    if (argc!=3) exit_hlp( option ) ;
  } else  
  if (strcmp(argv[1],"/h")==0) {
    option = 40 ;
    if ((argc<4) || (argc>5)) exit_hlp( option ) ;
  } else 
  if (strcmp(argv[1],"/c")==0) {
    option = 50 ;
    if (argc!=5) exit_hlp( option ) ;
  } else
  if (strcmp(argv[1],"/d")==0) {
    option = 60 ;
    if ((argc<4) || (argc>5)) exit_hlp( option ) ;
  } else
  if (strcmp(argv[1],"/k")==0) {
    option = 70 ;
    if (argc!=2)  exit_hlp( option ) ;
  } else
  if (strcmp(argv[1],"/r")==0) {
    option = 80 ;
    if ((argc<3) || (argc>4)) exit_hlp( option ) ;
  } else
  if (strcmp(argv[1],"/p")==0) {
    option = 90 ;
    if (argc!=2) exit_hlp( option ) ;
  } else
  if (strcmp(argv[1],"/i")==0) {
    option = 100 ;
    if (argc!=2) exit_hlp( option ) ;
  } else 
  if (strcmp(argv[1],"/?")==0) {
    option = 110 ;
    if (argc!=2) exit_hlp( option ) ;
  }
  else exit_hlp( 0 ) ;

/*6*/
  cDirx = getenv( "VCH" ) ;
  if (cDirx==NULL) strcpy(cDir,"") ; else  strcpy(cDir,cDirx) ;
  if (strlen(cDir)>0) strcat( cDir, "\\") ;
  strcpy( fPubKey, cDir ) ;
  strcat( fPubKey, "myPublic.key" ) ;
  strcpy( fSecKey, cDir ) ;
  strcat( fSecKey, "myPrivat.key" ) ;
  strcpy( rFile, cDir ) ;
  strcat( rFile, "r_sign.vch" ) ;
  strcpy( keyWfile, cDir ) ;
  strcat( keyWfile, "init.vch" ) ;
  if ( access( keyWfile, 0 )==0)
    read_keyW( keyWfile) ;
  else
    init_keyW( keyWfile ) ;
  flog = fopen( "vch.log", "a" ) ;
  randomize() ;

/*7*/
  switch (option) {
    case 100: /* /i      individualization string */
      break ;
    case  70: /* /k      generate keys         */
      puts("\n WARNING: A new set of public- and private-keys will be generated. \n") ;
      while (kbhit()) getch() ;
      puts(" Continue: (Y/N) ? ") ;
      chk = getch() ;
      if ((chk=='y') || (chk=='Y')) {
        puts("\n Your private-key file <myPrivat.key> will be encrypted with " ) ;
        puts(" a password. \n") ;
        do {
          puts(" SET Password. Press <return> for no encryption. ") ;
          puts(" <backspace> deletes.  <cntrl-D> interrupts. ") ;
          if ( getPswd( pswd, &Lpswd ) ) exit(1) ;
          if (Lpswd>0) {
            puts(" Re-enter Password for confirmation. ") ;
            delay(50) ;
            while (kbhit()) getch() ;
            if ( getPswd( epswd, &Lepswd ) ) exit(1) ;
            if (strcmp(pswd,epswd)) puts("Do not match! " ) ;
          }
        } while ( (Lpswd>0) && strcmp(pswd,epswd) ) ;
	init( fPubKey ) ;
        init_rndm() ;
        readPrime() ;
	genKeys( fPubKey, fSecKey ) ;
        printf( "The new public key created in <%s>\n", fPubKey ) ;
        printf( "The new private key created in <%s>\n", fSecKey ) ;
        fprintf(flog, "The new public key created in <%s>\n", fPubKey ) ;
        fprintf(flog, "The new private key created in <%s>\n", fSecKey ) ;
	if (access( rFile, 0 )==0) {
          _chmod( rFile, 1, 0x20 ) ;
          remove( rFile ) ;
          puts( "Precomputed r_signatures file deleted." ) ;
          fputs("Precomputed r_signatures file deleted.", flog ) ;
        }
      } else exit(0) ;
      break ;

    case 10: /*       /sgn      sign message    */
    case 11: /*       /sig      signature       */
    case 20: /*       /fsgn     fast sign       */
    case 21: /*       /fsig     fast signature   */
      strcpy( inFile, argv[2] ) ;
      strcpy( outFile, argv[3] ) ;
      if (argc==5) strcpy( pswd, argv[4] ) ;
      if ( (argc==4) || (strlen(pswd)<LPSWD_MIN) ) 
        if (getPswd( pswd, &Lpswd )) exit(1) ;
      if (stricmp(inFile, outFile)==0) {
        logI("Input filename same as output filename.\n") ;
        exit(1) ;
      }
      if (access(inFile,0)) {
        printf("** File <%s> not found: %i\n", inFile, errno ) ;
        exit(errno) ;
      }
      init( fPubKey ) ;
      readPrime() ;
      read_prvKey( fSecKey, pswd ) ;
      if ((option==20) || (option==21)) if (access(rFile,0)) {
        puts("use  Vch /r  " ) ;
        exit_proc( rFile, 2 ) ;
      }
      if ( (option==10) || (option==20) ) {
        logI("Hashing....") ;
        err = hash( 0, inFile, &Lmhash, mhash ) ;
        logF() ;
      } else {
	Lmhash = 5 ; err = readLN( 2, inFile, &Lmhash, mhash ) ;
      }
      if (err) exit_proc( inFile, err ) ;
      init_rndm() ;
      do {
        if ( (option==10) || (option==11) )
	  rSignature() ;
	else
	  read_rFile( rFile, pswd ) ;
        err = sSignature() ;
      } while (err) ;
      itoa( Lpp, LppStr, 10 ) ;
      itoa( Lqq, LqqStr, 10 ) ;
      if ( (option==10) || (option==20) )
        strcpy( wline, sgnLine ) ;
      else
        strcpy( wline, sigLine ) ;
      strcat( wline, LppStr ) ;
      strcat( wline, cdlim ) ;
      strcat( wline, LqqStr ) ;
      strcat( wline, cdlim ) ;
      strcat( wline, idStr ) ;
      strcat( wline, cdlim ) ;
      err = writeS( 1, outFile, wline ) ;
      if (err) exit_proc( outFile, err ) ;
      err = writeLN( 0, outFile, LrSign, rSign ) ;
      if (err) exit_proc( outFile, err ) ;
      err = writeLN( 0, outFile, LsSign, sSign ) ;
      if (err) exit_proc( outFile, err ) ;
      err = copyFile( inFile, outFile, 0 ) ;
      if (err) exit_proc( outFile, err ) ;
      if ( (option==10) || (option==20) ) {
        printf("Signed message created in <%s>\n", outFile ) ;
        fprintf(flog, "Signed message created in <%s>\n", outFile ) ;
      } else
      {
        printf("Signature written in <%s>\n", outFile ) ;
        fprintf(flog, "Signature written in <%s>\n", outFile ) ;
      }
      break ;

    case 30: /* vsgn     verify signed message   */
    case 31: /* vsig     verify signature        */
      strcpy( inFile, argv[2] ) ;
      strcpy( fPubKey, cDir ) ;
      strcat( fPubKey, argv[3] ) ;
      fnsplit( fPubKey, drv, dirf, nfPubKey, extf ) ;
      if (strcmp(extf,"")==0)  strcat( fPubKey, ".key") ;
      if ( access(inFile,0) ) {
        printf("** File <%s> not found: %i\n", inFile, errno ) ;
        exit( errno ) ;
      }
      init( fPubKey ) ;
      readPrime() ;
      LyPub = pLen ;  err = readLN( 5, fPubKey, &LyPub, yPub ) ;
      if (err)  exit_proc( fPubKey, err ) ;
      LrSign = qLen ; err = readLN( 2, inFile, &LrSign, rSign ) ;
      if (err)  exit_proc( inFile, err ) ;
      LsSign = qLen ; err = readLN( 3, inFile, &LsSign, sSign ) ;
      if (err) exit_proc( inFile, err ) ;
      if (option==30) {
        logI("Hashing..." ) ;
        err = hash( 1, inFile, &Lmhash, mhash ) ;
        logF() ;
      }
      else {
	Lmhash = 5 ; err = readLN( 5, inFile, &Lmhash, mhash ) ;
      }
      if (err) exit_proc( inFile, err ) ;
      if ( verify() ) {
        if (option==30) {
          printf("Signed_message <%s> VERIFIED to be from <%s>\n", inFile, nfPubKey ) ;
          fprintf(flog, "Signed_message <%s> VERIFIED to be from <%s>\n", inFile, nfPubKey ) ;
        }
        else {
          printf("Signature <%s> VERIFIED to be from <%s>\n", inFile, nfPubKey ) ;
          fprintf(flog, "Signature <%s> VERIFIED to be from <%s>\n", inFile, nfPubKey ) ;
        }
      } else {
        if (option==30) {
	  printf("Signed_message <%s> *NOT* authentic! <%s>\n", inFile, nfPubKey ) ;
	  fprintf(flog, "Signed_message <%s> *NOT* authentic! <%s>\n", inFile, nfPubKey ) ;
        } else {
          printf("Signature <%s> does *NOT* verify. <%s>\n", inFile, nfPubKey ) ;
          fprintf(flog, "Signature <%s> does *NOT* verify. <%s>\n", inFile, nfPubKey ) ;
        }
	exit_proc( "", 111 ) ;
      }
      break ;

    case 32: /* z     verify author's signed message   */
      puts("Not implemented in this version.") ;
      break ;      

    case 80:/*  /r    pre-compute the r_signature component  */
      if ((maxnb = atoi( argv[2] )) == 0 ) exit(1) ;
      if (argc==4) strcpy( pswd, argv[3] ) ;
      if ( (argc==3) || (strlen(pswd)<LPSWD_MIN) ) 
        if (getPswd( pswd, &Lpswd )) exit(1) ;
      init( fPubKey ) ;
      init_rndm() ;
      readPrime() ;
      LyPub = pLen ; err = readLN( 5, fPubKey, &LyPub, yPub ) ;
      if (err) exit_proc( fPubKey, err ) ;
      read_prvKey( fSecKey, pswd ) ;
      logI("Checking if password valid....May take a while...") ;
      dexp( Lgg, gg, LxSec, xSec, Lpp, pp, &Lh1, h1 ) ; /* Y ?= g^X mod p */
      logF() ;
      if (!isEqual( Lh1, h1, LyPub, yPub )) {
        puts(" Password incorrect! " ) ;
	exit_proc("", 0 ) ;
      }
      puts("Press ^D to quit.\n") ;
      quit = 0 ;
      do {
        rSignature() ;
	while ( kbhit() )
          if (getch()==4) quit = 1 ; /* break by ^D */
        write_rFile( rFile, &nb, pswd ) ;
        printf(" <%s> updated. Number of r_signatures = %i\n", rFile, nb ) ;
        fprintf( flog, " <%s> updated. Number of r_signatures = %i\n", rFile, nb ) ;
      } while ((nb<maxnb) && !quit ) ;
      break ;

    case 90:/*   /p     password      */
      puts("\nYour private-key file <myPrivat.key> and the pre-computed ") ;
      puts("r_signature file <r_sign.vch> (if exists) are encrypted with ") ;
      puts("a password.\n") ;
      while (kbhit()) getch() ;
      puts("Your CURRENT password. Press <return> if no password was set.") ;
      puts(" <backspace> deletes.  <cntrl-D> interrupts. ") ;      
      if (getPswd( pswd, &Lpswd )) exit(1) ;
      init( fPubKey ) ;
      readPrime() ;
      LyPub = pLen ; err = readLN( 5, fPubKey, &LyPub, yPub ) ;
      if (err) exit_proc( fPubKey, err ) ;
      read_prvKey( fSecKey, pswd ) ;
      logI("Checking if password valid....May take a while...") ;
      dexp( Lgg, gg, LxSec, xSec, Lpp, pp, &Lh1, h1 ) ; /* Y ?= g^X mod p */
      logF( ) ;
      if (!isEqual( Lh1, h1, LyPub, yPub )) {
        logI(" Password INCORRECT! ;\n (or <myPublic.key> / <myPrivat.key> corrupt.)\n") ;
	exit_proc("", 115) ;
      }
      logI("Testing integrity of <myPublic.key>....May take a while...") ;
      Lh1 = Lpp ; movmem( pp, h1, 4*Lpp ) ;  /* q divides (p-1) ? */
      Lh2 = 1 ; *h2 = 1 ;
      subt( Lh2, h2, &Lh1, h1 ) ;
      modR( Lh1, h1, Lqq, qq, &Lh2, h2 ) ;
      if (!( (Lh2==1) && (*h2==0) )) {
        logI("\n\n <myPublic.key> CORRUPT. \n Restore <myPublic.key> and <myPrivat.key>\n ") ;
	exit_proc("", 115 );
      }
      dexp( Lgg, gg, Lqq, qq, Lpp, pp, &Lh1, h1 ) ;  /* g^q mod p ?= 1 */
      logF() ;
      if (!( (Lh1==1) && (*h1==1) )) {
        logI("\n\n <myPublic.key> CORRUPT. \n Restore <myPublic.key> and <myPrivat.key>\n") ;
	exit_proc("", 115 );
      }
      puts("") ;
      while (kbhit()) getch() ;
      cputs(" Set new password: (Y/N) ? ") ;
      strcpy( opswd, pswd ) ;
      chk = getch() ;
      if ((chk=='y') || (chk=='Y')) {
	puts("\n") ;
        do {
          puts(" Enter NEW password. Press <return> for no encryption. ") ;
          puts(" <backspace> deletes.  <cntrl-D> interrupts. ") ;
          if (getPswd( pswd, &Lpswd )) exit_proc("",1) ;
          if (Lpswd) {
            puts(" Re-enter Password for confirmation. ") ;
            delay(50) ;
            while (kbhit()) getch() ;
            if (getPswd( epswd, &Lepswd )) exit_proc("",1) ;
	    if (strcmp(pswd, epswd)) puts(" Do not match! " ) ;
          }
        } while ( (Lpswd!=0) && strcmp(pswd, epswd) ) ;
	if ( (err=write_prvKey( fSecKey, pswd )) != 0 )  exit_proc(fSecKey,err) ;
        if (access(rFile,0)==0)  re_enc_rFile( rFile, opswd, pswd ) ;
        logI("NEW password has taken effect.\n ") ;
      }
      break ;

    case 40:/*   /h    hash        */
      strcpy(inFile,argv[2]) ;
      strcpy(outFile,argv[3]) ;
      if (stricmp(inFile, outFile)==0) {
        logI("Input filename same as output filename.\n") ;
        exit(1) ;
      }
      if (access(inFile,0)) {
        printf("** File <%s> not found: %i\n", inFile, errno ) ;
        exit(errno) ;
      }
      mhash = (ptrLN) malloc( 20 ) ;
      logI("Hashing....") ;
      err = hash( 0, inFile, &Lmhash, mhash ) ;
      if (err) {
        free( mhash ) ;
        printf("** File error <%s>: %i\n", inFile, err ) ;
        fprintf(flog, "** File error <%s>: %i\n", inFile, err ) ;
        fclose(flog) ;
        exit( err ) ;
      }
      logF() ;
      strcpy( wline, hashLine ) ;
      strcat( wline, inFile ) ;
      strcat( wline, cdlim ) ;
      err = writeS( 1, outFile, wline ) ;
      if (err) {
        free( mhash ) ; fclose(flog) ; exit( err ) ;
      }
      err = writeLN( 0, outFile, Lmhash, mhash ) ;
      if (err) {
        free( mhash ) ; fclose(flog) ; exit( err  ) ;
      }
      printf("Hash file <%s> created.\n", outFile ) ;
      fprintf(flog, "Hash file <%s> created.\n", outFile ) ;
      if (argc==5) strcpy( outFile, argv[4] ) ;
	  else fExt( inFile, ".sig", outFile ) ;
      if (access(outFile,0)==0) {
	h1 = (ptrLN) malloc( 20 ) ;
	Lh1 = 5 ; err = readLN( 5, outFile, &Lh1, h1 ) ;
        if (err) {
          printf("** File error <%s>: %i\n", outFile, err) ;
          fprintf(flog, "** File error <%s>: %i\n", outFile, err) ;
          free( h1 ) ;  free( mhash ) ; fclose(flog) ;
          exit( err );
        }
        if (isEqual( Lh1, h1, Lmhash, mhash )) err = 0 ; else err = 113 ;
        if (err==0) {
          printf(" Hash of <%s> MATCHES that in <%s>\n", inFile, outFile ) ;
          fprintf(flog, " Hash of <%s> MATCHES that in <%s>\n", inFile, outFile ) ;
        } else {
          printf(" Hash of <%s> does *NOT* match that in <%s>\n", inFile, outFile ) ;
          fprintf(flog, " Hash of <%s> does *NOT* match that in <%s>\n", inFile, outFile ) ;
        }
        free( h1 ) ;
      }
      free( mhash ) ;
      fclose(flog);
      exit( err ) ;
      break ;
      
    case 50:/*    /c     encipher     */
      strcpy( inFile, argv[2] ) ;
      strcpy( outFile, argv[3] ) ;
      strcpy( fPubKey, cDir ) ;
      strcat( fPubKey, argv[4] ) ;
      fnsplit( fPubKey, drv, dirf, nfPubKey, extf ) ;
      if (strcmp(extf,"")==0) strcat( fPubKey, ".key") ;
      if (stricmp(inFile, outFile)==0) {
        logI("Input filename same as output filename.\n") ;
        exit(1) ;
      }
      if (access( inFile, 0 )) {
        printf("** File <%s> not found: %i\n", inFile, errno  ) ;
        exit(errno) ;
      }
      init( fPubKey ) ;
      init_rndm() ;
      readPrime() ;
      if (Lpp<4) exit_proc( fPubKey, 55 ) ;
      LyPub = pLen ; err = readLN( 5, fPubKey, &LyPub, yPub ) ;
      if (err)  exit_proc( fPubKey, err ) ;
      printf("%d :%d : %s :\n", Lpp, Lqq, idStr ) ;
      fprintf(flog, "%d :%d : %s :\n", Lpp, Lqq, idStr ) ;
      encrypt( inFile, outFile ) ;
      break ;

    case 60:/*  /d      decipher   */
      strcpy( inFile, argv[2] ) ;
      strcpy( outFile, argv[3] ) ;
      if (argc==5) strcpy( pswd, argv[4] ) ;
      if ( (argc==4) || (strlen(pswd)<LPSWD_MIN) )
        if (getPswd( pswd, &Lpswd )) exit(1) ;
      if (stricmp(inFile, outFile)==0) {
        logI("Input filename same as output filename.\n") ;
        exit(1) ;
      }
      if (access( inFile, 0 )) {
        printf("** File <%s> not found:%i\n", inFile, errno ) ;
        exit(errno) ;
      }
      init( fPubKey ) ;
      readPrime() ;
      if (Lpp<4) exit_proc( fPubKey, 55 ) ;
      read_prvKey( fSecKey, pswd ) ;
      err = decrypt( inFile, outFile ) ;
      if (err) exit_proc( inFile, err ) ;
      break ;
  }/*switch*/
/*8*/
  if (init_ed) exit_proc( "", 0 ) ;
  fclose(flog) ;
  while (kbhit()) getch() ;
}