/*

	eb1.cpp
	7-31-91
	Electronic Book


	Copyright 1991
	John W. Small
	All rights reserved

	Licensed users of FlexList may use and modify this
	tool for use in their programs.


	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	Voice: (703) 759-3838
	CIS: 73757,2233


	Notes:  The Electronic Book was coded to demonstrate
	the various uses of FlexList.


*/

#include <eb1.hpp>
#include <ctype.h>
#include <pcdir.hpp>


char * parseLinks(const char * inOutLinks)
{
	static char buf[MAX_HYPER_LINE] = "";
	static int i = 0;
	int j;

	if (inOutLinks)  {
		buf[i=0] ='\0';
		for (j = 0; isspace(inOutLinks[j]); j++)
			/* null statement */;
		switch (inOutLinks[j++])  {
		case HYPER_INLINKS_BEGIN:
		case HYPER_OUTLINKS_BEGIN:
			break;
		default:
			return (char *)0;
		}
		if (inOutLinks[j++] != HYPER_LINKS_DELIMIT)
			return (char *)0;
		if (strlen(&inOutLinks[j]) >= MAX_HYPER_LINE)
			return (char *)0;
		strcpy(buf,&inOutLinks[j]);
	}
	switch (buf[i])  {
		case '\0':
		case HYPER_INLINKS_END:
		case HYPER_OUTLINKS_END:
			buf[i=0] = '\0';
			return (char *)0;
	}
	for (j = i; buf[i]; i++)
		if (buf[i] == HYPER_LINKS_DELIMIT)
			break;
	if (buf[i])  {
		buf[i++] = '\0';
		return &buf[j];
	}
	buf[i=0] = '\0';
	return (char *)0;
}

char * extractLinksDup(const char *inOutLinks, int inOut)
{
	int i, j, l;
	char *s, lbegin, lend;


	if (!inOutLinks) return (char *)0;
	for (i = 0; isspace(inOutLinks[i]); i++)
		/* null statement */;
	if (inOut)  {
		lbegin = HYPER_INLINKS_BEGIN;
		lend = HYPER_INLINKS_END;
	}
	else  {
		lbegin = HYPER_OUTLINKS_BEGIN;
		lend = HYPER_OUTLINKS_END;
	}
	if (inOutLinks[i] == lbegin &&
		inOutLinks[i+1] == HYPER_LINKS_DELIMIT)
		for (j = i + 2; inOutLinks[j]; j++)
			if (inOutLinks[j] == HYPER_LINKS_DELIMIT
				&& inOutLinks[j+1] == lend) {
				s = new char[l=j-i+3];
				if (s)  {
					strncpy(s,&inOutLinks[i],l);
					s[l-1] = '\0';
					return s;
				}
			}
	return (char *)0;
}


enum HYPER_TARGETS TargetParser::parse(const char *target)
{
	if (!target) return ttype;
	reset();
	if (strlen(target) >= MAX_HYPER_LINE)
		return ttype;
	strcpy(buf,target);
	for (int i = 0; buf[i]; i++)
		if (buf[i] == HYPER_TARGET_SPLIT)
			break;
	if (buf[i] == HYPER_TARGET_SPLIT)  {
		buf[i] = '\0';
		switch (buf[++i])  {
		case HYPER_TARGET_SYSTEM:
			if (buf[++i])  {
				ttype = FAR_SYSTEM;
				pm = &buf[i];
			}
			break;
		case HYPER_TARGET_SPAWN:
			if (buf[++i])  {
				ttype = FAR_SPAWN;
				pm = &buf[i];
			}
			break;
		case HYPER_LINKS_DELIMIT:
		case '\0':
			break;
		default:
			if (i > 1)  {
				ttype = FAR_TOPIC;
				tp = buf;
			}
			else
				ttype = FAR_DEFAULT;
			pm = &buf[i];
			break;
		}
	}
	else if (i)  {
		ttype = NEAR_TOPIC;
		tp = buf;
	}
	else
		ttype = NEAR_DEFAULT;
	return ttype;
}


HyperTextTarget::HyperTextTarget(const char *fname,
	const char *topic, unsigned startColumn,
	unsigned startRow, unsigned cursorColumn,
	unsigned cursorRow)
{
	constructOK = 0;
	this->fname = (char *) 0;
	this->topic = (char *) 0;
	if (!fname) return;
	if ((this->fname = strdup(fnexpand(fndefault(fname,
		(char *)0,(char *)0,(char *)0,".htx"))))
		== (char *) 0) return;
	if (topic) if ((this->topic = strdup(topic))
		== (char *) 0)  {
		delete this->fname;
		this->fname = (char *) 0;
		return;
	}
	this->startColumn = startColumn;
	this->startRow = startRow;
	this->cursorColumn = cursorColumn;
	this->cursorRow = cursorRow;
	constructOK = 1;
}

int HyperTextTarget::setView(unsigned startColumn,
	unsigned startRow, unsigned cursorColumn,
	unsigned cursorRow)
{
	this->startColumn = startColumn;
	this->startRow = startRow;
	this->cursorColumn = cursorColumn;
	this->cursorRow = cursorRow;
	return 1;
}


int   HyperStack::FNdestruct(void *ND, void *D)
{
	HyperTextTargeT HTT = (HyperTextTargeT) ND;
	if (D) return 0;
	HTT->HyperTextTarget::~HyperTextTarget();
	return 1;
}

HyperTextTargeT HyperStack::pushTarget(const char *fname,
	const char *topic)
{
	HyperTextTargeT HTT;
	void *getter = &getter; // gimmick for FNnew()


	if ((HTT = new(pushD(getter)) HyperTextTarget
		(fname,topic)) != HyperTextTargeT0)
		if (!HTT->ConstructOK())  {
			popD();
			return HyperTextTargeT0;
		}
	return HTT;
}

int HyperStack::setTopView(unsigned startColumn,
	unsigned startRow, unsigned cursorColumn,
	unsigned cursorRow)
{
	if (Nodes())
		return ((HyperTextTargeT)topD())->setView
		(startColumn,startRow,cursorColumn,cursorRow);
	return 0;
}
