/**************************************
 * TAGCASE.C - ANSI.C
 *
 * Text filter to convert HTML tags to uppercase
 * preserving the contents of quoted things
 *
 * Use: TAGCASE +|- < inputfile [>outputfile]
 *
 * NOTES: 1. Comments will be converted
 *        2. You're on your own about this code, and so am I.
 *
 * Joao C de Magalhaes, 1997-03-19
 * jcm@individual.EUnet.pt
 */

#include <stdio.h>
#include <ctype.h>

int main(int argc, char ** argv)
   {
   int Opt, C, InBracket, Convert;

   if (argc != 2)
      {
      puts("Converts the case of HTML tags.");
      puts("Comments will also be converted, "
	"but not attribute values.");
      puts("Use as a filter. Basic syntax is:");
      puts("TAGCASE +|- < infile [>outfile]");
      puts("\t+ converts tags to upper case");
      puts("\t- converts tags to lower case");
      return(1);
      }

   Opt = *argv[1];

   if (Opt == '-') Opt = 1;
   else Opt = 0;

   C = InBracket = Convert = 0;

   while((C=getchar()) != EOF)
      {
      if (C == '<')
	 {
	 InBracket = 1;
	 Convert = 1;
	 }
      if (C == '>')
	 {
	 InBracket = 0;
	 Convert = 0;
	 }
      if (InBracket)
	 {
	 if (C == '\"')
	    if (Convert) Convert = 0;
	    else Convert =1;
	 }
      if (Convert)
	 {
	 if (Opt == 1) putchar(tolower(C));
	 else putchar(toupper(C));
	 }
      else putchar(C);
      }
   return 0;
   }
