/*******************************************************************************

			HTMLCRunch	- by Markus Stengel

				This is FREEWARE.
			      USE AT YOUR OWN RISK!

*******************************************************************************/

/*					includes 			      */
#include <stdio.h>
#include <string.h>
#include <ctype.h>

/*					defines 			      */
#define  _BufSize	30000
#define	 _NameLength	513
#define	 _ExtLength	  5
#define  _Extension	".hcr\0"

#define	 _True		  1
#define  _False		  0

#define	 _CBlank	  ' '
#define	 _CCRT	 	 '\n'
#define  _CLF            '\t'
#define	 _CStrEnd	 '\0'
#define  _CPthsDbl	 '"'
#define  _CPthsHC	 '\''
#define	 _CDash 	 '-'
#define	 _CSwitch      _CDash

#define  _SReplace       "-O"
#define  _SKeep		 "-K"
/*					structures			      */

struct   KpTr {					// KeepTrack structure
   int	 pths;				     	// paranthesis
   int	 hc;					// high commas
   int	 cmts;					// comments
   int	 blanks;				// blanks
   int	 dashs;					// dashs
};

struct	 Flags {				// Flag/Parameter structure
   int	 replace;				// replacing original files
};

/*					prototypes 			      */
void StrParse(char*, char*, struct KpTr*);
void PrintHeader();
void PrintUsage();
int  DotPosRight(char*);
int  FindCloseCmts(char*);
int  CheckParam(char*, struct Flags*);
 	
/*					functions 			      */

void StrParse(char* spIn, char* spOut, struct KpTr* stpKT) {

   int		iI, iJ, iK, iH;
   int		iLength;
   int		iDecOutOne;
   char		cAct;

   iDecOutOne = _False;				// don't decrease by one
   iJ	      = 0;				// target pointer
   iLength    = strlen(spIn);			// gather input length

   for (iI = 0; iI < iLength; iI++) {		// work on the chars
      cAct = spIn[iI];				// get present char
      if (iDecOutOne) {				// reduce output pointer
	 iJ--;
	 iDecOutOne = _False;			// reset switch
      }
      if (cAct == _CBlank) {			// check for blanks
	 (*stpKT).blanks++;			// increase counter
      }
      else {					// a new char popped up
	 if ((!(*stpKT).pths) &&
	     ((*stpKT).blanks)) {     		// the previous blanks weren't in parenthesis
	    (*stpKT).blanks = 1;		// reduce superfluous blanks
	 }
	 if ((*stpKT).blanks > 0) {		// were there blanks?
	    for (iK=0;iK<(*stpKT).blanks;iK++) {// store the blanks
	       spOut[iJ] = _CBlank;
	       iJ++;				// increase target pointer
	    }
	    (*stpKT).blanks = 0;
	 }
	 if (cAct == _CDash) {			// dash encountered
	    (*stpKT).dashs++;			// increase counter
	       spOut[iJ] = _CDash;		// store dash
	       iJ++;				// increase target pointer
	 }
	 else {
	    if ((*stpKT).dashs >= 2) 		// check if we're in a comment line
	       if (iI >= ((*stpKT).dashs+3))	// enough chars in spIn
		  if (spIn[iI-(*stpKT).dashs-1]
		     == '!') 			// if we are in a comment line
		     if (spIn[iI-(*stpKT).dashs-2]
			== '<') {		// if we are in a comment line
			iH = FindCloseCmts (spIn); // check for ending comment
			if (iH < 0) {		// no ending found
			   spOut[iJ] = _CCRT;	// cut it
			   iJ++;		// increase target pointer
			   spOut[iJ] = _CStrEnd;// signal eostr
			   return;		// exit function
			}
			else {			// otherwise set starting pos
			   iDecOutOne = _True;	// reduce output by one
			   iI 	      = iH-1;
			}
		  }


	    (*stpKT).dashs = 0;			// reset counter
	    if (cAct == _CPthsDbl) {		// parenthesis found
	       if (!(*stpKT).pths)
		  (*stpKT).pths = _True;	// starting parenthesis
	       else
		  (*stpKT).pths = _False;	// ending parenthesis
	       spOut[iJ] = _CPthsDbl;		// store parenthesis
	       iJ++;				// increase target pointer
	    }
	    else
	    if ((cAct != _CCRT) && (cAct != _CLF)){// ignore CRT and LF
	       spOut[iJ] = cAct;		// store char
	       iJ++;				// increase target pointer
	    }
	 }
      }
   }
   spOut[iJ] = _CStrEnd;			// signal eostr
};

void PrintHeader() {				// print header
   printf("\n");
   printf(" ******************************************************************************\n");
   printf(" *                  HTMLCRunch v0.1 by Markus Stengel                         *\n");
   printf(" ******************************************************************************\n");
   printf("\n");
}

void PrintUsage() {				// print usage information
   printf(" ==============================================================================\n");
   printf(" =   USAGE    : htmlcr [-switch] file1 file2 ... [-switch] file ...           =\n");
   printf(" =   switches : -K     keep original files (default) --> output to *.hcr      =\n");
   printf(" =              -O     overwrite mode                                         =\n");
   printf(" =   example  : htmlcr -o urgent.htm start.htm -k index.htm                   =\n");
   printf(" ==============================================================================\n");
   printf("\n");
}

int  DotPosRight(char* spStr) {			// find extension-dot, starting right

   int iI;
   int iLength;

   iLength = strlen(spStr);			// gather string length
   for (iI = (iLength-1); iI >= 0; iI--) {	// starting right
       if (spStr[iI] == '.')			// extension found
	  return iI;				// return position
   }
   return (-1);
}

int  FindCloseCmts(char *spIn) {		// find out position of closing comment

   int iI;
   int iLength;

   iLength = strlen(spIn);			// gather length
   for (iI = (iLength-1); iI >= 2; iI--) {	// check for it
      if (spIn[iI] == '>')
	 if (spIn[iI-1] == _CDash)
	    if (spIn[iI -2] == _CDash)		// comment end found
	       return (iI-2);			// return starting pos
   }
   return (-1);					// not found
};

int  CheckParam(char* spParam,			// check for a parameter
		struct Flags* stpFlags) {
   int iI;
   int iLength;
   if (spParam[0] == _CSwitch) {		// check for switch char.
      iLength= strlen(spParam);
      for (iI = 0; iI < iLength; iI++)		// convert chars to upper ones
	 spParam[iI] = toupper(spParam[iI]);
      if (!strcmp(spParam, _SReplace)) {	// files are to be replaced
	 (*stpFlags).replace = _True;		// set flag
	 return _True;				// yes it was a parameter
      }
      else if (!strcmp(spParam, _SKeep)) {	// files should be kept
	 (*stpFlags).replace = _False;		// set flag
	 return _True;                          // yes it was a parameter
      }
   }
   return _False;
}
/*					  MAIN	 			      */
int  main(int argc, char *argv[]) {

   int 		iI;
   int		iRet;
   int		iDone;
   int		iSLength;
   FILE*        Source;
   FILE*	Target;
   char		sBufIn[_BufSize];
   char		sBufOut[_BufSize];
   char		sTargetName[_NameLength];
   char*	sRet;
   struct KpTr	stTrack;
   struct Flags stFlags;


   stTrack.pths    = _False;			// initialize variables
   stTrack.hc	   = _False;
   stTrack.cmts    = _False;
   stTrack.blanks  = 	  0;
   stTrack.dashs   =	  0;

   stFlags.replace = _False;			// --------------------

   PrintHeader();				// print header text

   if (argc < 2) {				// no arguments?
      PrintUsage();				// print how to use this program
      return 1;
   }

   for (iI = 1; iI < argc; iI++) {
    if (CheckParam(argv[iI], &stFlags)) {	// is it a parameter or a file?

    }
    else {
      Source = fopen(argv[iI], "r");		// open source file
      iSLength = DotPosRight(argv[iI]);
      if (iSLength < 0)				// no extension found
	 iSLength=strlen(argv[iI]);
      strncpy(sTargetName, argv[iI], iSLength);
      sTargetName[iSLength] = _CStrEnd;
      strncat(sTargetName, _Extension, _ExtLength);
      if (stFlags.replace)
	 printf("   %35s <-> %35s\n", argv[iI], argv[iI]);
      else
	 printf("   %35s <-> %35s\n", argv[iI], sTargetName);
      Target = fopen(sTargetName, "wb");	// open target file

      iDone  = _False;				// keep the loop going
      if (Source && Target) {			// proceed only if both files were opened successfully
	 while (!iDone) {			// as long as Source is not finished
	    sRet = fgets(sBufIn,
			 _BufSize,
			 Source);		// read next (first) line
	    if (feof(Source) || (!sRet))	// check if we're done
	       iDone = _True;			// yes
	    else {                      	// no, process line
	       StrParse(sBufIn,
			sBufOut,
			&stTrack);		// parse string
	       fputs(sBufOut, Target);
	    }
	 }

      }

      fclose(Target);				// close target file
      fclose(Source);				// close source file

      if (stFlags.replace) {			// replace the original files
	 iRet = remove (argv[iI]);		// delete original file
	 if (iRet) {				// an error occurred
	    printf("\n ERROR: couldn't delete source file -> file is kept!\n");
	 }
	 else {
	    iRet = rename(sTargetName,argv[iI]);// rename file
	    if (iRet) {				// an error occurred
	       printf("\n ERROR: couldn't rename target file -> file is kept!\n");
	    }
	 }
      }
    }
   }

   return 0;
}
