Unit dosfunks;
{ a collection of DOS functions }

{ Adapted from dosfils.pas, which used DOS function calls to open, close,
  read, and write files, and which was written primarily for use with the
  IBM PSL. This version also opens and checks devices to prevent programs
  from hanging or halting if the user specifies an invalid port or incorrect
  serial port parameters or if an I/O device is not ready.  It also is
  called by Unit FilUtil4 to check the validity of file names. dl }

{ Copyright 1993-1996 East Carolina University, Greenville, NC, USA. }
{ Author: David Lunney, Professor of Chemistry, ECU }

(*      ADDRESS: Department of Chemistry
                 East Carolina University
                 Greenville, NC 27858-4353
                 USA


        INQUIRIES REGARDING THIS PROGRAM SHOULD BE DIRECTED
        TO DAVID LUNNEY AT chlunney@ecuvm.cis.ecu.edu OR
        LUNNEY@DELPHI.COM                                            *)

(*  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    A COPY OF THE GNU GENERAL PUBLIC SOFTWARE LICENSE HAS BEEN
    PROVIDED WITH THIS PROGRAM IN THE FILE "LICENSE.TXT"       *)

   { No Warranty.  EAST CAROLINA UNIVERSITY DISCLAIMS AND MAKES NO
   REPRESENTATIONS AND EXTENDS NO WARRANTIES, EITHER EXPRESS OR
   IMPLIED. THERE ARE NO EXPRESS OR IMPLIED WARRANTIES OF
   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  The User
   shall assume all liability for all damages whatsoever that may or
   do arise from the User's use, inability to use, performance, or
   storage of DOSFUNKS.  East Carolina University shall not be
   liable to the User for any loss, claims, damages or demands
   whatsoever made by the User or made against the User by any other
   party, due to or arising from the performance of, use of, and/or
   inability to use DOSFUNKS by the User and/or anyone else. }


Interface

Uses DOS;

Type
  String2 = String[2];

Procedure CreateDOSFile(FilNam: String; Var Handl: Word; Var Filerr: Boolean);
Procedure OpenDOSFile(FilNam: String; AcCode: String2; Var Handl: Word;
                                          Var Filerr: Boolean);
Procedure WriteDOSFile2(Handl, BufSeg, BufOfs, Nbytes: Word;
                                          Var Filerr: Boolean);
Function CheckDev(Handl: Word): Boolean;
Function CheckDevOutReddy(Handl: Word): Boolean;
Function CheckDevInReddy(Handl: Word): Boolean;
Procedure CloseDOSFile(Handl: Word);
Function IsDevice(Name: string): Boolean;
Procedure CheckPslDrv(Handl, BufSeg, BufOfs, Nbytes: Word);
Function CheckDOSRaw2(Handl: Word): Boolean;
Procedure SetDOSRaw(Handl: Word; Raw: Boolean);

Implementation

Procedure CreateDOSFile(FilNam: String; Var Handl: Word; Var Filerr: Boolean);
{ Creates a file for I/O and returns its DOS file handle }
{ adapted in part from function GetFileHandle in "Turbo Pascal 6:
  the Complete Reference,"  by Stephen O'Brien, p. 289, Osborne-
  McGraw Hill, 1991, dl 6/27/92.  }

Var
  CPUregs: Registers;
  i: Byte;

Begin
  FilNam := FilNam + Chr(0);  { add NUL (BINARY 0) to end of string
                                 to make an ASCIIZ STRING. }
  { put zeroes in regs just in case }
  FillChar(CPUregs, SizeOf(CPUregs), 0);  { fill CPU regs with zeroes }
  CPUregs. AH := $3C;               { function 3CH is "create a file" }
  CPUregs. DS := Seg(FilNam);
  CPUregs. DX := Ofs(FilNam) + 1;   { why the + 1?  First byte of
                                       a TP string is its length }
  MsDos(CPUregs);  { DOS function call }
  handl := CPUregs. AX;   { AX contains file handle }
  { check for errors }
  If Lo((CPUregs. Flags) And $01) > 0 Then Filerr := True
  Else Filerr := False;
End;

Procedure OpenDOSFile(FilNam: String; AcCode: String2; Var Handl: Word;
                          Var Filerr: Boolean);
{ Opens a file for I/O and returns its DOS file handle }
{ adapted in part from function GetFileHandle in "Turbo Pascal 6:
  the Complete Reference,"  by Stephen O'Brien, p. 289, Osborne-
  McGraw Hill, 1991, dl 6/27/92.  }
{ the variable AcCode determines access to the file.  AcCode = 'RO'
  gives read only; AcCode = 'WO'  gives write only;  AcCode = RW
  gives read/write. All these codes put the file in "compatibility
  mode" }

Var
  CPUregs: Registers;
  i, AcByte: Byte;

Begin
  { convert access code to caps }
  For i := 1 To 2 Do AcCode[i] := UpCase(AcCode[i] );
  FilNam := FilNam + Chr(0);  { add NUL (BINARY 0) to end of string
  to make an ASCIIZ STRING. }
  { make access byte }
  If AcCode = 'RO' Then AcByte := $00;  { read only, compatibility mode }
  If AcCode = 'WO' Then AcByte := $01;  { write only }
  If AcCode = 'RW' Then AcByte := $02;  { read/write }
  { put zeroes in regs just in case }
  FillChar(CPUregs, SizeOf(CPUregs), 0);  { fill CPU regs with zeroes }
  CPUregs. AH := $3D;               { function 3DH is "open a file" }
  CPUregs. AL := AcByte;            { access byte }
  CPUregs. DS := Seg(FilNam);
  CPUregs. DX := Ofs(FilNam) + 1;   { why the + 1?  First byte of
                                        a TP string is its length }
  MsDos(CPUregs);  { DOS function call }
  handl := CPUregs. AX;   { AX contains file handle }
  { check for errors }
  If Lo((CPUregs. Flags) And $01) > 0 Then Filerr := True
  Else Filerr := False;
End;

Procedure WriteDOSFile2(Handl, BufSeg, BufOfs, Nbytes: Word;
                                     Var Filerr: Boolean);
{ was WriteDOSFile. Modified to return error code to check
  devices }
{ Writes Nbytes bytes to the file whose handle is Handl.  BufSeg
  and BufOfs are the segment and offset respectively of the
  buffer holding the data. }

Var
  CPUregs: Registers;
  errcode: word;

Begin
  { put zeroes in regs just in case }
  FillChar(CPUregs, SizeOf(CPUregs), 0);  { fill CPU regs with zeroes }

  CPUregs. AH := $40;     { function 40H is "write to a device" }
  CPUregs. BX := Handl;
  CPUregs. DS := BufSeg;
  CPUregs. DX := BufOfs;
  CPUregs. CX := NBytes;
  MsDos(CPUregs);  { DOS function call }
  { check carry flag }
  If Lo((CPUregs. Flags) And $01) > 0 Then Filerr := True
  Else Filerr := False;
  errcode := CPUregs. AX;
End;

Function CheckDev(Handl: Word): Boolean;
{ returns TRUE if the handle applies to a valid device;
   otherwise FALSE. }
Var
  CPUregs: Registers;
  status: Word;
  Deverr: Boolean;

Begin
  { put zeroes in regs just in case }
  FillChar(CPUregs, SizeOf(CPUregs), 0);  { fill CPU regs with zeroes }

  CPUregs. AX := $4400;    { function 4400H is "get device data" }
  CPUregs. BX := Handl;
  MsDos(CPUregs);  { DOS function call }
  { check carry flag }
  If Lo((CPUregs. Flags) And $01) > 0 Then Deverr := True
  Else Deverr := False;
  If deverr Then
  Begin
    CheckDev := False;
    Exit;
  End
  Else
  Begin
    status := CPUregs. DX;
    { check for device, not file }
    If status And $80 > 0 Then CheckDev := True
    Else CheckDev :=  False;
  End;
End;

Function CheckDevOutReddy(Handl: Word): Boolean;
{ checks to see if a DOS device is ready for output.}
Var
  CPUregs: Registers;
  status: Word;
  Deverr: Boolean;

Begin
  { put zeroes in regs just in case }
  FillChar(CPUregs, SizeOf(CPUregs), 0);  { fill CPU regs with zeroes }
  CPUregs. AX := $4407;    { function 4407H is "get device output status" }
  CPUregs. BX := Handl;
  MsDos(CPUregs);  { DOS function call }
  { check carry flag }
  If Lo((CPUregs. Flags) And $01) > 0 Then Deverr := True
  Else Deverr := False;
  If deverr Then
  Begin
    CheckDevOutReddy := False;
    Exit;
  End
  Else
  Begin
    status := CPUregs. AL;
    { check for device ready }
    If status = $0FF Then CheckDevOutReddy := True
    Else CheckDevOutReddy :=  False;
  End;
End;

Function CheckDevInReddy(Handl: Word): Boolean;
{ checks to see if a DOS device is ready for input.}
Var
  CPUregs: Registers;
  status: Word;
  Deverr: Boolean;

Begin
  { put zeroes in regs just in case }
  FillChar(CPUregs, SizeOf(CPUregs), 0);  { fill CPU regs with zeroes }

  CPUregs. AX := $4406;    { function 4406H is "get device input status" }
  CPUregs. BX := Handl;
  MsDos(CPUregs);  { DOS function call }
  { check carry flag }
  If Lo((CPUregs. Flags) And $01) > 0 Then Deverr := True
  Else Deverr := False;
  If deverr Then
  Begin
    CheckDevInReddy := False;
    Exit;
  End
  Else
  Begin
    status := CPUregs. AL;
    { check for device ready }
    If status = $0FF Then CheckDevInReddy := True
    Else CheckDevInReddy :=  False;
  End;
End;

Procedure CloseDOSFile(handl: Word);
{ Closes a file or device using its DOS file handle }
{ adapted from CloseFileHandle, in "Turbo Pascal 6: the
  Complete Reference," by Stephen O'Brien, p. 289, Osborne-
  McGraw Hill, 1991.  dl 6/27/92 }

Var
  CPUregs: Registers;

Begin
  { put zeroes in regs just in case }
  FillChar(CPUregs, SizeOf(CPUregs), 0);  { fill CPU regs with zeroes }
  CPUregs. AH := $3E;  { function 3EH is "close a file" }
  CPUregs. BX := handl; { BX contains file handle }
  MsDos(CPUregs);  { DOS function call }
End;

Function IsDevice(Name: string): Boolean;
{ returns TRUE if the name applies to a valid device;
   otherwise FALSE. }
Var
  CPUregs: Registers;
  status: Word;
  Deverr: Boolean;
  Handl: word;

Begin
  OpenDOSFile(Name, 'WO', Handl, Deverr);
  if Deverr then
    begin
      IsDevice := False;
      exit;
    end;
  if CheckDev(Handl) then IsDevice := TRUE else
	              IsDevice := False;
  CloseDOSFile(Handl);
End;

Procedure CheckPslDrv(Handl, BufSeg, BufOfs, Nbytes: Word);
{ Gets Nbytes status bytes for the device whose handle is Handl.
  BufSeg and BufOfs are the segment and offset respectively of the
  buffer for the status bytes. }

Var
  CPUregs: Registers;

Begin
  { put zeroes in regs just in case }
  FillChar(CPUregs, SizeOf(CPUregs), 0);  { fill CPU regs with zeroes }

  CPUregs. AH := $44;      { function 44H is "I/O control of devices" }
  CPUregs. AL := $02;      { read from character device }
  CPUregs. BX := Handl;
  CPUregs. DS := BufSeg;
  CPUregs. DX := BufOfs;
  CPUregs. CX := NBytes;
  MsDos(CPUregs);  { DOS function call }
End;

Function CheckDOSRaw2(Handl: Word): Boolean;
{ was procedure CheckDOSRaw: changed to function 7-7-96 dl }
{ Checks to see if DOS is using "raw"(binary) or "cooked"(ASCII) data. }

Var
  CPUregs: Registers;
  StatByte: Byte;

Begin
  { WriteLn('CheckDOSRaw called..'); }
  { put zeroes in regs just in case }
  FillChar(CPUregs, SizeOf(CPUregs), 0);  { fill CPU regs with zeroes }
  CPUregs. AH := $44;               { function 44H is IOCTL }
  CPUregs. AL := $00;               { get data }
  CPUregs. BX := Handl;             { device handle }
  MsDos(CPUregs);  { DOS function call }
  StatByte :=  CPUregs. DL;
  { WriteLn('Status byte = ', StatByte); }
  If(StatByte And $20) > 0 Then CheckDOSRaw2 := True
  Else CheckDOSRaw2 := False;
End;

Procedure SetDOSRaw(Handl: Word; Raw: Boolean);
{ Changes DOS mode to use "raw"(binary) or "cooked"(ASCII) data. }
Var
  CPUregs: Registers;
  InfoByte: Byte;

Begin
  { WriteLn('SetDOSRaw called..'); }
  { put zeroes in regs just in case }
  FillChar(CPUregs, SizeOf(CPUregs), 0);  { fill CPU regs with zeroes }
  CPUregs. AH := $44;               { function 44H is IOCTL }
  CPUregs. AL := $00;               { get device data }
  CPUregs. BX := Handl;             { device handle }
  MsDos(CPUregs);  { DOS function call }
  InfoByte := CPUregs. DL;
  { WriteLn('infobyte = ', infobyte); }
  If Raw Then InfoByte := InfoByte Or $20  {set bit 5 }
  Else InfoByte := InfoByte And(Not $20); { clear bit 5 }
  { WriteLn('infobyte = ', infobyte); }
  { put zeroes in regs just in case }
  FillChar(CPUregs, SizeOf(CPUregs), 0);  { fill CPU regs with zeroes }
  CPUregs. AH := $44;               { function 44H is IOCTL }
  CPUregs. AL := $01;               { set device info }
  CPUregs. BX := Handl;             { device handle }
  CPUregs. DL := InfoByte;          { set or clear bit 5 }
  MsDos(CPUregs);  { DOS function call }
End;
End.
