

pgm(5)                     Unix Programmer's Manual                     pgm(5)


NAME
     pgm - portable graymap file format

DESCRIPTION
     The portable graymap format is a lowest common denominator grayscale file
     format.  The definition is as follows:

     - A "magic number" for identifying the file type.   A  pgm  file's  magic
       number is the two characters "P2".

     - Whitespace (blanks, TABs, CRs, LFs).

     - A width, formatted as ASCII characters in decimal.

     - Whitespace.

     - A height, again in ASCII decimal.

     - Whitespace.

     - The maximum gray value, again in ASCII decimal.

     - Whitespace.

     - Width * height gray values, each in ASCII decimal, between  0  and  the
       specified  maximum value, separated by whitespace, starting at the top-
       left corner of the graymap, proceeding in normal English reading order.
       A value of 0 means black, and the maximum value means white.

     - Characters from a "#" to the next end-of-line are ignored (comments).

     - No line should be longer than 70 characters.

     Here is an example of a small graymap in this format:
     P2
     # feep.pgm
     24 7
     15
     0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
     0  3  3  3  3  0  0  7  7  7  7  0  0 11 11 11 11  0  0 15 15 15 15  0
     0  3  0  0  0  0  0  7  0  0  0  0  0 11  0  0  0  0  0 15  0  0 15  0
     0  3  3  3  0  0  0  7  7  7  0  0  0 11 11 11  0  0  0 15 15 15 15  0
     0  3  0  0  0  0  0  7  0  0  0  0  0 11  0  0  0  0  0 15  0  0  0  0
     0  3  0  0  0  0  0  7  7  7  7  0  0 11 11 11 11  0  0 15  0  0  0  0
     0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0

     Programs that  read  this  format  should  be  as  lenient  as  possible,
     accepting anything that looks remotely like a graymap.

     There is also a variant on the format, available by setting  the  RAWBITS
     option at compile time.  This variant is different in the following ways:

     - The "magic number" is "P5" instead of "P2".





                              12 November 1991                               1



pgm(5)                     Unix Programmer's Manual                     pgm(5)


     - The gray values are stored as plain bytes, instead of ASCII decimal.

     - No whitespace is allowed in  the  grays  section,  and  only  a  single
       character  of  whitespace  (typically  a  newline) is allowed after the
       maxval.

     - The files are smaller and many times faster to read and write.

     Note that this raw format can only be used for maxvals less than or equal
     to 255.  If you use the pgm library and try to write a file with a larger
                             ---
     maxval, it will automatically fall back on the slower  but  more  general
     plain format.

SEE ALSO
     fitstopgm(1),  fstopgm(1),  hipstopgm(1),  lispmtopgm(1),   psidtopgm(1),
     rawtopgm(1),   pgmbentley(1),  pgmcrater(1),  pgmedge(1),  pgmenhance(1),
     pgmhist(1),    pgmnorm(1),    pgmoil(1),    pgmramp(1),    pgmtexture(1),
     pgmtofits(1),  pgmtofs(1),  pgmtolispm(1),  pgmtopbm(1),  pnm(5), pbm(5),
     ppm(5)

AUTHOR
     Copyright (C) 1989, 1991 by Jef Poskanzer.




































                              12 November 1991                               2

