
#include <float.h>
#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>
#include <conio.h>
#include <dos.h>
#include "fdestria.h"
#include "fdesign.h"
#include "fdesequa.h"
#include "fdesfile.h"
#include "fdesmenu.h"
#include "fdesmous.h"
#include "fdeshres.h"
#include "fdesvirt.h"

#define plot_small_left 420
#define plot_small_bottom 140
#define CONV_ITS 100			/* iterations required for convergence */

int pal_switch;
int plot_type;                  /* types are:   0 big 16 color
                                                1 small 16 color
                                                2 big 256 color
                                                3 big 256 color hi-res
                                                4 virtual big 1000 x 1500
                                                5 FRACTINT ifs screen size
                                                6 16 color w/increment
                                                */
int last_plot_type = 0;
int IFS_changed;
float x,y;
float xscale,yscale,xoffset,yoffset,maxx,maxy;
float a[MAXFUNC],b[MAXFUNC],c[MAXFUNC],d[MAXFUNC],e[MAXFUNC],f[MAXFUNC];
float p[MAXFUNC];
int n;
/************************************************************************
        PLOT SOME POINTS USING THE IFS CODES
************************************************************************/
void plotabunch(int howmany)
{
int m,j,k;
float pk,newx,newy;

        k = 0;
	for (m=0; m<howmany; m++) {
		pk = rand()/32767.0;
		for (j=0; j<n; j++)
		{
			if (pk < p[j])
			{
				k=j;
				break;
			}
		}
                newx = a[k] * x + b[k] * y + e[k];
                newy = c[k] * x + d[k] * y + f[k];
                x = newx;
                y = newy;
                putpixel((int)x,(int)y,colors[k%MAXCOLORS_]);
	}
}
void plotabunch16(int howmany)
{
int m,j,k;
float pk,newx,newy;

        k = 0;
	for (m=0; m<howmany; m++) {
		pk = rand()/32767.0;
		for (j=0; j<n; j++)
		{
			if (pk < p[j])
			{
				k=j;
				break;
			}
		}
                newx = a[k] * x + b[k] * y + e[k];
                newy = c[k] * x + d[k] * y + f[k];
                x = newx;
                y = newy;
                putpixel((int)x,(int)y,(getpixel((int)x,(int)y)+1)%maxcolor);
	}
}
void plotabunchs(int howmany)
{
int m,j,k;
float pk,newx,newy;
int temp_x, temp_y;

        k = 0;
	for (m=0; m<howmany; m++) {
		pk = rand()/32767.0;
		for (j=0; j<n; j++)
		{
			if (pk < p[j])
			{
				k=j;
				break;
			}
		}
                newx = a[k] * x + b[k] * y + e[k];
                newy = c[k] * x + d[k] * y + f[k];
                x = newx;
                y = newy;
                temp_x = (int)x;
                temp_y = (int)y;
                if ((temp_x >= plot_small_left) && (temp_y < plot_small_bottom))
                        putpixel(temp_x,temp_y,colors[k%MAXCOLORS_]);
	}
}
/*
void plotabunch_inc(int howmany)
{
int m,j,k;
int oldpixel;
float pk,newx,newy;
float screenx, screeny;

        k = 0;
	for (m=0; m<howmany; m++) {
		pk = rand()/32767.0;
		for (j=0; j<n; j++)
		{
			if (pk < p[j])
			{
				k=j;
				break;
			}
		}
                newx = a[k] * x + b[k] * y + e[k];
                newy = c[k] * x + d[k] * y + f[k];
                x = newx;
                y = newy;
                screenx = x;
                screeny = y;
		oldpixel = getpixel256(screenx,screeny);

                if (oldpixel == 255) putpixel256(screenx, screeny, 1);
                else putpixel256(screenx, screeny, oldpixel+1);
	}
}
*/
/*
        virtual plot fractal plotter
*/
void vplotabunch(int howmany)
{
int m,j,k;
float pk,newx,newy;

        k = 0;
	for (m=0; m<howmany; m++) {
		pk = rand()/32767.0;
		for (j=0; j<n; j++)
		{
			if (pk < p[j])
			{
				k=j;
				break;
			}
		}
                newx = a[k] * x + b[k] * y + e[k];
                newy = c[k] * x + d[k] * y + f[k];
                x = newx;
                y = newy;
                vputpixel((int)x,(int)y);
	}
}
/*
        *** *** *** *** *** *** *** *** *** *** *** *** *** ***
        Rescale IFS codes using xscale,xoffset,yscale,yoffset
        *** *** *** *** *** *** *** *** *** *** *** *** *** ***
        rel = 0         if relative to original triangles
        rel = 1         if relative to already scaled triangles
*/
triangle ttriangle0;                    /* re-scaled reference triangle */
triangle ttriangles[MAXFUNC];           /* re-scaled triangle data stores */
void IFS_rescale(float xscale, float xoffset, float yscale, float yoffset, int rel)
{
int i,j,k,m;
float pt,pk,newx,newy;

        /* Now generate scaled copies of the triangles using the just
           computed scale and offset factors */
        if (rel == 0)
        {
                for (i=0; i<3; i++)
                {
                        ttriangle0.row[i] = triangle0.row[i]*yscale+yoffset;
                        ttriangle0.col[i] = triangle0.col[i]*xscale+xoffset;
                }
                for (j=0; j<num_triangles; j++)
                {
                        for (i=0; i<3; i++)
                        {
                                ttriangles[j].row[i] = triangles[j].row[i]*yscale+yoffset;
                                ttriangles[j].col[i] = triangles[j].col[i]*xscale+xoffset;
                        }
                }
        } else
        {
                for (i=0; i<3; i++)
                {
                        ttriangle0.row[i] = ttriangle0.row[i]*yscale+yoffset;
                        ttriangle0.col[i] = ttriangle0.col[i]*xscale+xoffset;
                }
                for (j=0; j<num_triangles; j++)
                {
                        for (i=0; i<3; i++)
                        {
                                ttriangles[j].row[i] = ttriangles[j].row[i]*yscale+yoffset;
                                ttriangles[j].col[i] = ttriangles[j].col[i]*xscale+xoffset;
                        }
                }
        }
        /* Re-compute the IFS codes using the scaled triangles */
        IFS_compute_all(num_triangles,ttriangles,&ttriangle0);
        pt = 0;
        for (i=0; i<num_triangles; i++)
	{
                a[i] = IFS[1+(i*7)];
                b[i] = IFS[2+(i*7)];
                c[i] = IFS[3+(i*7)];
                d[i] = IFS[4+(i*7)];
                e[i] = IFS[5+(i*7)];
                f[i] = IFS[6+(i*7)];
                pt += IFS[7+(i*7)];
		p[i] = pt;
	}

	/* do iterations so (x,y) is on new attractor */
        k = 0;
        for (m=0; m<CONV_ITS; m++) {
		pk = rand()/32767.0;
		for (j=0; j<n; j++)
		{
			if (pk < p[j])
			{
				k=j;
				break;
			}
		}
                newx = a[k] * x + b[k] * y + e[k];
                newy = c[k] * x + d[k] * y + f[k];
                x = newx;
                y = newy;
	}

}
/* *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***
                copy scaled triangles from ttriangle*
                to the input triangle array
   *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** */
void triangles_use_temp(void)
{
int i,j;
        for (i=0; i<3; i++)
        {
                triangle0.row[i] = ttriangle0.row[i];
                triangle0.col[i] = ttriangle0.col[i];
        }
        for (j=0; j<num_triangles; j++)
        {
                for (i=0; i<3; i++)
                {
                        triangles[j].row[i] = ttriangles[j].row[i];
                        triangles[j].col[i] = ttriangles[j].col[i];
                }
        }
        IFS_changed = 1;
}


/*
        Compute the limits of the IFS codes by executing several iterations
        and storing the min and max values.
*/
void plotlimits(unsigned int scale_its)
{
int m,j,k,i;
float pk,newx,newy,pt;
float xmin,xmax,ymin,ymax;
float *frac;                            /* not necessary */

        area_scaled = 1.0;               /* zooming area scaling is 1.0 */
        frac = IFS;
	IFS_compute_all(num_triangles,triangles,&triangle0);

	n = frac[0];
        pt = 0;
	for (i=0; i<n; i++)
	{
		a[i] = frac[1+(i*7)];
		b[i] = frac[2+(i*7)];
		c[i] = frac[3+(i*7)];
		d[i] = frac[4+(i*7)];
		e[i] = frac[5+(i*7)];
		f[i] = frac[6+(i*7)];
		pt += frac[7+(i*7)];
		p[i] = pt;
	}
	x = 0.0;
	y = 0.0;

        k = 0;
        for (m=0; m<scale_its; m++) {
		if (m==CONV_ITS) {
                    ymax = (ymin = y);
                    xmax = (xmin = x); }
		pk = rand()/32767.0;
		for (j=0; j<n; j++)
		{
			if (pk < p[j])
			{
				k=j;
				break;
			}
		}
                newx = a[k] * x + b[k] * y + e[k];
                newy = c[k] * x + d[k] * y + f[k];
                x = newx;
                y = newy;
		if (m > CONV_ITS) {
                        if (newx<xmin) xmin = newx;
                        if (newx>xmax) xmax = newx;
                        if (newy<ymin) ymin = newy;
                        if (newy>ymax) ymax = newy; }
	}
	if ((plot_type == 0) || (plot_type == 2) || (plot_type == 3) || (plot_type == 6))
        {
                /* set scaling here */
                if (xmax == xmin) xscale = 1;
		else xscale = 0.95 * maxx / (xmax - xmin);
                if (ymax == ymin) yscale = 1;
		else yscale = 0.95 * maxy / (ymax - ymin);
                if (xscale > yscale) xscale = yscale;
                else yscale = xscale;
		xoffset = -((xmax+xmin)/2.0)*xscale + maxx/2.0;
		yoffset = -((ymax+ymin)/2.0)*yscale + maxy/2.0;
	}
        else if (plot_type == 4)
        {
                /* set scaling here */
                if (xmax == xmin) xscale = 1;
		else xscale = 0.95 * VWIDTH / (xmax - xmin);
                if (ymax == ymin) yscale = 1;
		else yscale = 0.95 * VHEIGHT / (ymax - ymin);
                if (xscale > yscale) xscale = yscale;
                else yscale = xscale;
		xoffset = -((xmax+xmin)/2.0)*xscale + VWIDTH/2.0;
		yoffset = -((ymax+ymin)/2.0)*yscale + VHEIGHT/2.0;
        }
        else if (plot_type == 1)
        {
                /* set scaling for small plot in upper right corner */
                if (xmax == xmin) xscale = 1;
		else xscale = 0.9 * (maxx - plot_small_left) / (xmax - xmin);
                if (ymax == ymin) yscale = 1;
		else yscale = 0.9 * plot_small_bottom / (ymax - ymin);
                if (xscale > yscale) xscale = yscale;
                else yscale = xscale;
		xoffset = -((xmax+xmin)/2.0)*xscale +
			(plot_small_left + maxx)/2.0;
		yoffset = -((ymax+ymin)/2.0)*yscale + plot_small_bottom/2.0;
	}
        else if (plot_type == 5)        /* FRACTINT screen size */
        {
                /*
                   Fractint's screen size is x=0 to x=16
                   and y=-6 to y=6.
                   approximately.
                */
                if (xmax == xmin) xscale = 1;
		else xscale = 14.0 / (xmax - xmin);
                if (ymax == ymin) yscale = 1;
                else yscale = 10.0 / (ymax - ymin);
                if (xscale > yscale) xscale = yscale;
                else yscale = xscale;
                yscale = -yscale;
                xoffset = -(((xmin+xmax)/2.0)*xscale);
                yoffset = -(((ymin+ymax)/2.0)*yscale) + 5.0;
        }

        /* scale relative to originally input triangles */
        IFS_rescale(xscale,xoffset,yscale,yoffset,0);

        last_plot_type = plot_type;
}

/************************************************************************
        BIG PLOT: PLOT FRACTAL UNTIL MOUSE CLICK
        SMALL PLOT: PLOT A SMALL # OF POINTS
************************************************************************/
int doIFSrand(void)   /* plot_type are commented at top of this file */
{
int rcode;
long count;
mouse_state m;
char sbuf[80];

        /* re-compute limits if new IFS or plot type changed */
        if (IFS_changed || (last_plot_type != plot_type)) {
                if (plot_type == 1) {
                        setfillstyle(SOLID_FILL,BLACK);
                        bar(plot_small_left,0,maxx,plot_small_bottom);
                        plotlimits(300);
                }
                else if ((plot_type == 0) || (plot_type == 6))
                {
			putmsg(150,175,"Wait...Computing Plot limits",DARKGRAY,LIGHTCYAN);
                        plotlimits(3000);
                        clrmsg();
                }
                else if ((plot_type == 2) || (plot_type == 3))
                {
/*
			putmsg(150,175,"Wait...Computing Plot limits",0,128);
*/
			plotlimits(3000);
/*
			clrmsg();
*/
		}
                else if (plot_type == 4)
                {
			putmsg(150,175,"Scaling Main Display",DARKGRAY,LIGHTCYAN);
                        delay(1000);
                        clrmsg();
                }
		IFS_changed = 0;
        }
        if (plot_type == 1)
        {
                plotabunchs(10);                /* small plot plots 10 then */
                                                /* leaves. */
                return(0);
        }
        else if (plot_type == 0)
        {
                do
                {
                        plotabunch(500);        /* plots 500 points */
                        rcode = mouse_press(&m);
                } while ((!rcode) && (!kbhit()));
                if (kbhit()) getch();
                return(rcode);
        }
	else if (plot_type == 6)
        {
                do
                {
                        plotabunch16(500);        /* plots 500 points */
                        rcode = mouse_press(&m);
                } while ((!rcode) && (!kbhit()));
                if (kbhit()) getch();
                return(rcode);
        }
        else if (plot_type == 4)                /* virtual screen plot */
        {
                putmsg_d(200,200,"          Virtual Plot Status         ",GREEN,WHITE);
                setfillstyle(SOLID_FILL,GREEN);
                bar(200,75,500,190);

                count = 0;
                do
                {
                        vplotabunch(5000);        /* plots 1500 points */
                        count += 5000;

                        sprintf(sbuf,"Count = %ld",count);
                        putmsg_d(200,50,sbuf,BLUE,WHITE);

                        setfillstyle(SOLID_FILL,RED);
                        bar(200,75,min((300.0*count)/virt_target_size,300.0)+200,190);

                        rcode = mouse_press(&m);

                } while ((!rcode) && (!kbhit()) && (count < virt_target_size));
                if (count >= virt_target_size)
                        putmsg_d(290,130,"Plot Complete",RED,WHITE);
                if (kbhit()) getch();
                return(rcode);
	}
/*
        else if ((plot_type == 2) || (plot_type == 3))
        {
                pixel_max = 0;
                pal_switch = -2;                /* initial quantization */
                set_palette(pal_switch);
                do
                {
                        plotabunch_inc(500);            /* plots 500 points */
			if (-pixel_max < pal_switch)
                        {
				if (pal_switch > -256)
                                {
					pal_switch -= 2;
                                        set_palette(pal_switch);
                                }
                        }
                        mouse_get(&m);
                        if (color_shift != m.row)
                        {
                                color_shift = m.row;
				set_palette(pal_switch);
                        };
                        rcode = mouse_press(&m);
                } while ((!rcode) && (!kbhit()));
                if (kbhit()) getch();
                return(rcode);
	}
*/
	return(0);
}

