/******************************************************************************
        Printer Module
******************************************************************************/
#include <stdio.h>
#include <stdarg.h>
#include <bios.h>
#include <graphics.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>
#include "fdesplot.h"
#include "fdesvirt.h"
#include "fdesmenu.h"

#define ESC 033

int printer_type = 0;                   /* printer types:
                                                0: undefined
                                                1: HP laser jet II
                                                2: Epson 9 pin
                                                3: Epson 24 pin
                                        */
int print_abort;

/******************************************************************************
                        BIOS printer I/O
******************************************************************************/
int kb_throttle;           /* throttles checking for keyboard interrupt */
void pputc(char ch)
{
        do {
                if ((kb_throttle++ & 0xff) == 0)
                {
                if (kbhit())
                {
			if (getch() == 0) getch();
                        if (print_abort == 1)   /* really stuck, two keys hit */
                        {
                                restorecrtmode();
                                printf("Two keys hit during print, aborting program");
                                exit(0);
                        }
                        print_abort = 1;
                        printer_type = 0;
                        putmsg(150,150,"Print is being stopped",WHITE,RED);
                        delay(2000);
                        clrmsg();
                }
                }
        } while (biosprint(2,0,0) != 0x90) ;
        biosprint(0,ch,0);
}

int pprintf(char *format, ...)
{
char buf[133];
char *ptr;
va_list parmlist;

	va_start(parmlist,format);
	vsprintf(buf,format,parmlist);
	va_end(parmlist);
        ptr = buf;
        while (*ptr)
        {
                pputc(*ptr++);
        }
        return(0);
}
/*****************************************************************************
                HP Laser Jet II support
******************************************************************************/
void HPII_resolution(int res)
{
        pprintf("\033*t%dR",res);
}
void HPII_graphics(void)
{
        HPII_resolution(150);
/*        pprintf("\033E");       /* reset */
	  pprintf("\033*r3F");    /* image along width of page */
	  pprintf("\033*r0A");    /* left margin at x position 0 */
	  pprintf("\033*b0M");    /* no compression */
*/
}
void HPII_endpage(void)
{
        pprintf("\033*rB");             /* end raster graphics */
        pprintf("\033E");               /* printer reset */
}
void HPII_line_print(char *buf,int num_bytes)
{
int i;
        pprintf("\033*b%dW",num_bytes);  /* transfer raster graphics */
        for (i=0; i<num_bytes; i++)
        {
                pputc(buf[i]);
        }
}


void HPII_printscreen(void)
{
int row;
int col;
int databyte;
int i;
char buf[80];
char *bufptr;

        if (print_abort) return;

        HPII_graphics();

        for (row=0; row<=maxy; row++)
        {
                bufptr = buf;
                for (col=0; col <= maxx; col += 8)
                {
                        databyte = 0;
                        for (i=col; i<(col+8); i++)
                        {
                                databyte <<=1;
				if (getpixel(i,row)) databyte |= 1;
                        }
                        *bufptr++ = databyte;
                }
                HPII_line_print(buf,80);
                if (print_abort) return;
        }
}
void HPII_printvscreen(void)
{
int row;
int col;
int databyte;
int i;
char buf[VHEIGHT/8 + 1];
char *bufptr;

        HPII_graphics();

        for (col=0; col<VWIDTH; col++)
        {
                bufptr = buf;
                for (row=VHEIGHT; row >= 0; row -= 8)
                {
                        databyte = 0;
                        for (i=row; i>(row-8); i--)
                        {
                                databyte <<=1;
                                if (vgetpixel(col,i)) databyte |= 1;
                        }
                        *bufptr++ = databyte;
                }
		HPII_line_print(buf,VHEIGHT/8);
                if (print_abort) return;
        }
}
/*****************************************************************************
                Epson 9 pin support
******************************************************************************/
void E9_line_spacing(int height)
{
        pprintf("\033\063%c",height);      /* line spacing in units of 1/3 dot */
}
void E9_endpage(void)
{
        E9_line_spacing(12*3);            /* default line spacing */
        if (print_abort) return;
        pprintf("\014");                /* control-L (page feed) */
}

void E9_line_print(char *buf,int num_bytes)
{
int i;
        pprintf("\r\n\033L%c%c",(num_bytes&0xff),(num_bytes>>8));
                                        /* tell epson how many columns */
                                        /* 'L' is super-res, 'K' is normal-res */
        for (i=0; i<num_bytes; i++)
        {
                pputc(buf[i]);
        }
}

void E9_line_print_ovly(char *buf,int num_bytes)        /* 'double' print */
{
int i;
        pprintf("\033J\001\r\033L%c%c",(num_bytes&0xff),(num_bytes>>8));
                                        /* tell epson how many columns */
                                        /* 'L' is super-res, 'K' is normal-res */
        for (i=0; i<num_bytes; i++)
        {
                pputc(buf[i]);
        }
}


void E9_printscreen(void)
{
int row;
int col;
int databyte;
int i;
char buf[640];
char *bufptr;

        if (print_abort) return;

        E9_line_spacing(7*3-1);

        for (row=0; row<=maxy; row += 14)
        {
                bufptr = buf;
                for (col=0; col <= maxx; col++)
                {
                        databyte = 0;
                        for (i=row; i<(row+14); i += 2)
                        {
                                databyte <<=1;
                                if ((i <= maxy) && (getpixel(col,i) != 0))
                                        databyte |= 1;
                        }
                        *bufptr++ = databyte;
                }
                E9_line_print(buf,640);

                /* now do the 'overwrite' line (really it is one pixel down) */

                bufptr = buf;
                for (col=0; col <= maxx; col++)
                {
                        databyte = 0;
                        for (i=row+1; i<(row+14); i += 2)
                        {
                                databyte <<=1;
                                if ((i <= maxy) && (getpixel(col,i) != 0))
                                        databyte |= 1;
                        }
                        *bufptr++ = databyte;
                }
                E9_line_print_ovly(buf,640);
                if (print_abort) return;
        }
}
void E9_printvscreen(void)
{
int row;
int col;
int databyte;
int i;
char buf[VHEIGHT + 1];
char *bufptr;

        E9_line_spacing(7*3-1);

        for (col=0; col<VWIDTH; col += 14)
        {
                bufptr = buf;
                for (row=VHEIGHT; row >= 0; row--)
                {
                        databyte = 0;
                        for (i=col; i<(col+14); i += 2)
                        {
                                databyte <<=1;
                                if (vgetpixel(i,row)) databyte |= 1;
                        }
                        *bufptr++ = databyte;
                }
                E9_line_print(buf,VHEIGHT);

                /* now the overprint line */
                bufptr = buf;
                for (row=VHEIGHT; row >= 0; row--)
                {
                        databyte = 0;
                        for (i=col+1; i<(col+14); i += 2)
                        {
                                databyte <<=1;
                                if (vgetpixel(i,row)) databyte |= 1;
                        }
                        *bufptr++ = databyte;
                }
                E9_line_print_ovly(buf,VHEIGHT);
                if (print_abort) return;
        }
}

/*****************************************************************************
                Epson 24 pin support
******************************************************************************/
void E24_endpage(void)
{
        if (print_abort) return;
        pprintf("\014");                /* control-L (page feed) */
}

void E24_printscreen(void)
{
int row;
int col;
int databyte;
int i;

        if (print_abort) return;

        pprintf("\033\063\030");        /* 24/180 line spacing */

        for (row=0; row<=maxy; row += 24)
        {
                pprintf("\r\n\033*\047\0200\002");  /* triple density graphics
                                                   (180 dots/in), 640 columns */
                for (col=0; col <= maxx; col++)
                {
                        databyte = 0;
                        for (i=row; i<(row+8); i++)
                        {
                                databyte <<=1;
                                if ((i <= maxy) && (getpixel(col,i) != 0))
                                        databyte |= 1;
                        }
                        pputc(databyte);
                        databyte = 0;
                        for (i=row+8; i<(row+16); i++)
                        {
                                databyte <<=1;
                                if ((i <= maxy) && (getpixel(col,i) != 0))
                                        databyte |= 1;
                        }
                        pputc(databyte);
                        databyte = 0;
                        for (i=row+16; i<(row+24); i++)
                        {
                                databyte <<=1;
                                if ((i <= maxy) && (getpixel(col,i) != 0))
                                        databyte |= 1;
                        }
                        pputc(databyte);

                }
                if (print_abort) return;
        }
}
void E24_printvscreen(void)
{
int row;
int col;
int databyte;
int i;

        for (col=0; col<VWIDTH; col += 24)
        {
                pprintf("\r\n\033*\047\0260\004");  /* triple density graphics
                                                   (180 dots/in), 1200 columns */

                for (row=(VHEIGHT-1); row >= 0; row--)
                {
                        databyte = 0;
                        for (i=col; i<(col+8); i++)
                        {
                                databyte <<=1;
                                if (vgetpixel(i,row)) databyte |= 1;
                        }
                        pputc(databyte);
                        databyte = 0;
                        for (i=col+8; i<(col+16); i++)
                        {
                                databyte <<=1;
                                if (vgetpixel(i,row)) databyte |= 1;
                        }
                        pputc(databyte);
                        databyte = 0;
                        for (i=col+16; i<(col+24); i++)
                        {
                                databyte <<=1;
                                if (vgetpixel(i,row)) databyte |= 1;
                        }
                        pputc(databyte);
                }
                if (print_abort) return;
        }
}

/*****************************************************************************
                Printer selection
*****************************************************************************/

void (*printscreen)(void);              /* vectors pointing to printer handler */
void (*prn_endpage)(void);
void (*printvscreen)(void);

popmenu ptype = {
        4,
        "HP Laser Jet II", "Epson 9 pin", "Epson 24 pin", "Cancel Print"
        };

int printer_type_check(void)            /* returns 1 if print cancelled */
{
int select;
        if (printer_type != 0) return(0);

	select = popup(100,100,&ptype,WHITE,BLUE);
        switch (select) {
                case 1:
                        prn_endpage = HPII_endpage;
                        printscreen = HPII_printscreen;
                        printvscreen = HPII_printvscreen;
                        break;
                case 2:
                        prn_endpage = E9_endpage;
                        printscreen = E9_printscreen;
                        printvscreen = E9_printvscreen;
                        break;
                case 3:
                        prn_endpage = E24_endpage;
                        printscreen = E24_printscreen;
                        printvscreen = E24_printvscreen;
                        break;
                case 4:
                        return(1);
        }
        printer_type = select;
        return(0);
}

popmenu pconfirm = {
        2,
        "Continue", "Cancel Print"
        };

int print_confirm(void)                 /* returns 1 if user confirmed print */
{
int select;
	select = popup(100,100,&pconfirm,WHITE,BLUE);
        if (select == 1)
        {
                print_abort = 0;
                return(0);
        }
        else
        {
                printer_type = 0;
                return(1);
        }
}


