;   Copyright (C) 1996,99  Marian Krivos
;	nezmar@internet.alcatel.sk

;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.

;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.

;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;   engine.asm - graphics kernel   


section	.text
				extern	vga_setpage
				extern	 _cx_maxwork
				extern	 _cy_maxwork
				extern	 _cx_work
				extern	 _cy_work
				extern	 _set_palet1
				extern	 _miro0406
				extern	 _miro0816
				extern	 _miro0808
				extern	 _miro1220
				extern	 _miro1625
				extern	 _Y_width
				extern	 _X_width
				extern	_clip_x_min
				extern	_clip_y_min
				extern	_clip_x_max
				extern	_clip_y_max
				extern	_mmx_state
				extern	_Image
				extern	_cx_max
				extern	_cy_max
				extern	__CurrColor
				extern	__CurrBkColor
				extern	_fontw
				extern	_fonth
				extern	_fontn
				extern	_font
				extern	_driver
				extern	_mmx
				extern	_videobase
				extern	_videobasesegment
				extern	_VideoSelector
				extern	_lfb
				extern	_granularity
				extern	_ppop

				global 	_SetPalette256
				global 	_GetPalette256
				global	_test_mmx
				global	_set_mmx
				global	_reset_mmx
				global	_is_mmx
				global	_peek
				global	_poke
				global	LinuxInit
				global	_set_ppop
				global	_L1RamToRam
				global	_L1RamToRamPpop
				global	_L1RamToVideo8
				global	_L1RamToVideo2
				global	_draw_point
				global	_get_point
				global	_L1VideoToRam8
				global	_Line
				global	_draw_line
				global	__degraduj
				global	_drawto_line
				global	__expand_font
				global	_ScreentoRam
				global	_RamToScreen
				global	_CharOutClip
				global	_draw_hline
				global	draw_hline2
				global	__fill_rect
				global	_PaletteInit
				global	__setvideomode
				global	_L1Box
				global	_L1BoxX
				global	___dpmi_int
				global inpb
				global inpw
				global outpb
				global outpw
				global inpl
				global _inpl
				global outpl
				global _outpl
				global getesi

getesi:	mov	eax,esi
		ret

%ifdef LINUX
set_vga_banking:push	eax
		push	ebx
		push	ecx
		push	edx
		push	esi
		push	edi
		and	eax,255
		push	eax				
		call	vga_setpage
		pop		eax
		pop		edi
		pop		esi
		pop		edx
		pop		ecx
		pop		ebx
		pop		eax
		ret

LinuxInit:	mov		ax,ds
			mov		[_VideoSelector],ax
			call	__expand_font
			mov		eax,set_vga_banking
			mov		[set_bank_proc],eax
			ret
%endif

inpb:		push	edx
			mov	dx,[esp+8]
			in	al,dx
			pop	edx
			ret
		
inpw:		push	edx
			mov	dx,[esp+8]
			in	ax,dx
			pop	edx
			ret
_inpl:
inpl:		push	edx
			mov	dx,[esp+8]
			in	eax,dx
			pop	edx
			ret

outpb:		push	edx
			mov	dx,[esp+8]
			mov	al,[esp+12]
			out	dx,al
			pop	edx
			ret
		
outpw:		push	edx
			mov	dx,[esp+8]
			mov	ax,[esp+12]
			out	dx,ax
			pop	edx
			ret
_outpl:
outpl:		push	edx
			mov	dx,[esp+8]
			mov	eax,[esp+12]
			out	dx,eax
			pop	edx
			ret
ends

_SetPalette256:	mov		dx,0x3c8
				push	esi
				mov		esi,[esp+8]
				xor		al,al
				out		dx,al
				inc		dx
				mov		ecx,768
				rep		outsb
				pop		esi
				ret

_GetPalette256:	mov		dx,0x3c7
				push	edi
				mov		edi,[esp+8]
				xor		al,al
				out		dx,al
				inc		dx
				inc		dx
				mov		ecx,768
                push	es
                push	ds
                pop		es
				rep		insb
                pop		es
				pop		edi
				ret

_init_ds_alias:
				push	bx
				mov		bx,cs
				mov		ax,0x000a
				int		0x31
				jnc		ds_alias_ok
				mov		ah,0x4c
				int		0x21
ds_alias_ok:	mov		[_ds_alias],ax
				pop		bx
				ret
___dpmi_int:
___watcom_int:	push	ebp
				mov		ebp,esp
				push	ebx
				push	edi
				push	es
				mov		ebx,[ebp+8]
				mov		ax,[_ds_alias]
				cmp		ax,0
				jne		_int_1
				call	_init_ds_alias
_int_1:			mov		es,ax
				xor		ecx,ecx
				mov		edi,[ebp+12]
				mov		word  [edi+0x20],0		; eflags
				mov		dword [edi+0x2e],0		; esp
				mov		word  [edi+0x30],0		; ss
				mov		ax,0x300;
				stc
				int		0x31
				mov		eax,0
				jnc		__int_ok
				dec		eax
__int_ok:		pop		es
				pop		edi
				pop		ebx
				pop		ebp
				ret

; to call :	es:di  = source
;			ds:esi = destination
;			ecx	   = counter
; after	  :	es:di &	ds:esi -> current position
;			eax	& ecx changed
;			ebx	& edx unchanged
;			mm0	changed	if MMX extension enabled
toram8:			and		ecx,ecx
				jz		rtrn	 		; return if	nothing	to do
toram88:		test	edi,7			; round	to 8/16
				je		L30s
%ifdef LINUX
toram7:			mov		al,[es:edi]
%else
toram7:			mov		al,[es:di]
%endif
				mov		[esi],al
				inc		esi
				inc		edi
				dec		ecx
				jnz		toram8
rtrn:			ret

L30s:			cmp		ecx,8			; addr is rounded, less	than 8 byte?
				jb		toram7			; yes, back	to loop	without	test [edi]

				push	ebx
				mov		ebx,ecx
				call	_is_mmx
				jz		L30				; no, goto no MMX

				shr		ecx,3			; yes, run MMX routine
%ifdef LINUX
tram11:			movq	mm0,[es:edi]
%else
tram11:			movq	mm0,[es:di]
%endif
				movq	[esi],mm0
				add		esi,8
				add		edi,8
				dec		ecx
				jnz		tram11
				and		ebx,7			; do rest bytes
				jmp		tram22

L30:			shr		cx,2
%ifdef LINUX
L31:			mov		eax,[es:edi]
%else
L31:			mov		eax,[es:di]
%endif
				mov		[esi],eax
				add		esi,4
				add		edi,4
				dec		cx
				jne		L31
				and		ebx,3
tram22:			je		L33
%ifdef LINUX
tram33:			mov		al,[es:edi]
%else
tram33:			mov		al,[es:di]
%endif
				mov		[esi],al
				inc		esi
				inc		edi
				dec		ebx
				jnz		tram33
L33:			pop		ebx
				ret

; to call :	es:di  = dest
;			ds:esi = src
;			ecx	   = counter
; after	  :	es:di &	ds:esi -> current position
;			eax	& ecx changed
;			ebx	& edx unchanged
;			mm0	changed	if MMX extension enabled
tset:			and		ecx,ecx
				je		rtrn
tset88:			test	edi,7
				je		tset6
tset7:			mov		al,[esi]
%ifdef LINUX
				mov		[es:edi],al
%else
				mov		[es:di],al
%endif
				inc		esi
				inc		edi
				dec		ecx
				jnz		tset88
				ret

tset6:			cmp		ecx,8			; addr is rounded, less	than 8 byte?
				jb		tset7			; yes, back	to loop	without	test [edi]

tset0:			push	ebx
				mov		ebx,ecx
				call	_is_mmx
				jz		tset1			; no, goto no MMX

				shr		ecx,3			; yes, run MMX routine
tset11:			movq	mm0,[esi]
%ifdef LINUX
				movq	[es:edi],mm0
%else
				movq	[es:di],mm0
%endif
				add		esi,8
				add		edi,8
				dec		ecx
				jnz		tset11
				and		ebx,7			; do rest bytes
				jmp		tset22

tset1:			shr		ecx,2

; copy ecx*4 bytes from ds:esi -> es:edi

tset3:
;;				mov		eax,[esi]
;;%ifdef LINUX
;;				mov		[es:edi],eax
;;%else
;;				mov		[es:di],eax
;;%endif
;;				add		esi,4
;;				add		edi,4
;;				dec		ecx
;;				jnz		tset3
%ifndef LINUX
				push	edi
				and		edi,0xFFFF
%endif
				rep		movsd
%ifndef LINUX
				and		dword [esp],0xFFFF0000
				add		dword [esp],edi
				pop		edi
%endif
				and		ebx,3
tset22:			je		tset4
tset5:			mov		al,[esi]
%ifdef LINUX
				mov		[es:edi],al
%else
				mov		[es:di],al
%endif
				inc		esi
				inc		edi
				dec		ebx
				jnz		tset5
tset4:			pop		ebx
				ret


; to call :	es:di  = dest
;			ds:esi = src
;			ecx	   = counter
; after	  :	es:di &	ds:esi -> current position
;			eax	& ecx changed
;			ebx	& edx unchanged
;			mm0	changed	if MMX extension enabled

tand:			and		ecx,ecx
				je		rtrn4
tand88:			test	edi,7
				je		tand6
tand7:			mov		al,[esi]
%ifdef LINUX
				and		[es:edi],al
%else		
				and		[es:di],al
%endif		
				inc		esi
				inc		edi
				dec		ecx
				jnz		tand88
rtrn4:			ret

tand6:			cmp		ecx,8			; addr is rounded, less	than 8 byte?
				jb		tand7			; yes, back	to loop	without	test [edi]

tand0:			push	ebx
				mov		ebx,ecx
				call	_is_mmx
				jz		tand1			; no, goto no MMX

				shr		ecx,3			; yes, run MMX routine
tand11:			movq	mm0,[esi]
%ifdef LINUX
				pand	mm0,[es:edi]
				movq	[es:edi],mm0
%else		
				pand	mm0,[es:di]
				movq	[es:di],mm0
%endif		
				add		esi,8
				add		edi,8
				dec		ecx
				jnz		tand11
				and		ebx,7			; do rest bytes
				jmp		tand22

tand1:			shr		ecx,2
tand3:			mov		eax,[esi]
%ifdef LINUX
				and		[es:edi],eax
%else		
				and		[es:di],eax
%endif		
				add		esi,4
				add		edi,4
				dec		ecx
				jnz		tand3
				and		ebx,3
tand22:			je		tand4
tand5:			mov		al,[esi]
%ifdef LINUX
				and		[es:edi],al
%else				 
		and		[es:di],al
%endif		
				inc		esi
				inc		edi
				dec		ebx
				jnz		tand5
tand4:			pop		ebx
				ret


; to call :	es:di  = dest
;			ds:esi = src
;			ecx	   = counter
; after	  :	es:di &	ds:esi -> current position
;			eax	& ecx changed
;			ebx	& edx unchanged
;			mm0	changed	if MMX extension enabled

txor:			and		ecx,ecx
				je		rtrn6
txor88:			test	edi,7
				je		txor6
txor7:			mov		al,[esi]
%ifdef LINUX
				xor		[es:edi],al
%else		
				xor		[es:di],al
%endif		
				inc		esi
				inc		edi
				dec		ecx
				jnz		txor88
rtrn6:			ret

txor6:			cmp		ecx,8			; addr is rounded, less	than 8 byte?
				jb		txor7			; yes, back	to loop	without	test [edi]

txor0:			push	ebx
				mov		ebx,ecx
				call	_is_mmx
				jz		txor1			; no, goto no MMX

				shr		ecx,3			; yes, run MMX routine
txor11:			movq	mm0,[esi]
%ifdef LINUX
				pxor	mm0,[es:edi]
				movq	[es:edi],mm0
%else
				pxor	mm0,[es:di]
				movq	[es:di],mm0
%endif		
				add		esi,8
				add		edi,8
				dec		ecx
				jnz		txor11
				and		ebx,7			; do rest bytes
				jmp		txor22

txor1:			shr		ecx,2
				push	edx
txor3:			mov		eax,[esi]
				add		esi,4
%ifdef LINUX
				mov		edx,[es:edi]
				xor		eax,edx
				mov		[es:edi],eax
%else		
				mov		edx,[es:di]
				xor		eax,edx
				mov		[es:di],eax
%endif		
				add		edi,4
				dec		ecx
				jnz		txor3
				pop		edx
				and		ebx,3
txor22:			je		txor4
txor5:			mov		al,[esi]
%ifdef LINUX
				xor		[es:edi],al
%else		
				xor		[es:di],al
%endif		
				inc		esi
				inc		edi
				dec		ebx
				jnz		txor5
txor4:			pop		ebx
				ret

; to call :	es:di  = dest
;			ds:esi = src
;			ecx	   = counter
; after	  :	es:di &	ds:esi -> current position
;			eax	& ecx changed
;			ebx	& edx unchanged
;			mm0	changed	if MMX extension enabled

tor:			and		ecx,ecx
				je		rtrn5
tor88:			test	edi,7
				je		tor6
tor7:			mov		al,[esi]
%ifdef LINUX
				or	   [es:edi],al
%else		
				or	   [es:di],al
%endif		
				inc		esi
				inc		edi
				dec		ecx
				jnz		tor88
rtrn5:			ret

tor6:			cmp		ecx,8			; addr is rounded, less	than 8 byte?
				jb		tor7			; yes, back	to loop	without	test [edi]

tor0:			push	ebx
				mov		ebx,ecx
				call	_is_mmx
				jz		tor1			; no, goto no MMX

				shr		ecx,3			; yes, run MMX routine
tor11:			movq	mm0,[esi]
%ifdef LINUX
				por	mm0,[es:edi]
				movq	[es:edi],mm0
%else		
				por	mm0,[es:di]
				movq	[es:di],mm0
%endif		
				add		esi,8
				add		edi,8
				dec		ecx
				jnz		tor11
				and		ebx,7			; do rest bytes
				jmp		tor22

tor1:			shr		ecx,2
tor3:			mov		eax,[esi]
%ifdef LINUX
				or	   [es:edi],eax
%else		
				or	   [es:di],eax
%endif		
				add		esi,4
				add		edi,4
				dec		ecx
				jnz		tor3
				and		ebx,3
tor22:			je		tor4
tor5:			mov		al,[esi]
%ifdef LINUX
				or	   [es:edi],al
%else		
				or	   [es:di],al
%endif		
				inc		esi
				inc		edi
				dec		ebx
				jnz		tor5
tor4:			pop		ebx
				ret


freplace:		and		ecx,ecx
				je		near rtrn3	 		; return if	nothing	to do
freplace2:		cmp		byte [es:edi],16
				jc		freplace3
				mov		byte [es:edi],al		
freplace3:		inc		edi
				dec		ecx
				jnz		freplace2
				ret

ttransp:        and     ecx,ecx
                je      rtrn_x
ttransp2:       mov     al,[esi]
				and		al,al
				jz		ttransp3
%ifdef LINUX
                mov     [es:edi],al
%else
                mov     [es:di],al
%endif
ttransp3:       inc     esi
                inc     edi
                dec		ecx
				jnz		ttransp2
rtrn_x:			ret

;		MMX	state MUST BE ON before	call
;		set	(ecx) bytes	to (eax) value from	(es:edi)

fset:			and		ecx,ecx
				je		rtrn2	 		; return if	nothing	to do
fill88:			test	edi,7			; round	to 8/16
				je		fill1
fill2:			stosb
				dec		ecx
				jnz		fill88
rtrn2:			ret

fill1:			cmp		ecx,8
				jb		fill2
				push	ebx
				mov		ebx,ecx
				call	_is_mmx
				jz		fill3			; no, goto no MMX
				call	mmx_color
				shr		ecx,3			; yes, run MMX routine
fill4:			movq	[es:edi],mm0
				add		edi,8
				dec		ecx
				jnz		fill4
				and		ebx,7			; do rest bytes
				jmp		fill5

fill3:			shr		ecx,2
				rep		stosd
				and		ebx,3
fill5:			je		fill9
				mov		ecx,ebx
				repe	stosb
fill9:			pop		ebx
				ret

;		MMX	state MUST BE ON before	call
;		set	(ecx) bytes	to (eax) value from	(es:edi)

fxor:			and		ecx,ecx
				je		rtrn2	 		; return if	nothing	to do
fxor88:			test	edi,7			; round	to 8/16
				je		fxor1
fxor2:			xor		[es:edi],al
				inc		edi
				dec		ecx
				jnz		fxor88
				ret

fxor1:			cmp		ecx,8
				jb		fxor2
				push	ebx
				mov		ebx,ecx
				call	_is_mmx
				jz		fxor3			; no, goto no MMX
				call	mmx_color
				shr		ecx,3			; yes, run MMX routine
fxor4:			movq	mm1,[es:edi]
				pxor	mm1,mm0
				movq	[es:edi],mm1
				add		edi,8
				dec		ecx
				jnz		fxor4
				and		ebx,7			; do rest bytes
				jmp		fxor5

fxor3:			shr		ecx,2
fxor6:			xor		[es:edi],eax
				add		edi,4
				dec		ecx
				jnz		fxor6
				and		ebx,3
fxor5:			je		fxor9
fxor7:			xor		[es:edi],al
				inc		edi
				dec		ebx
				jnz		fxor7
fxor9:			pop		ebx
				ret

;		MMX	state MUST BE ON before	call
;		set	(ecx) bytes	to (eax) value from	(es:edi)

for:			and		ecx,ecx
				je		rtrn3	 		; return if	nothing	to do
for88:			test	edi,7			; round	to 8/16
				je		for1
for2:			or		[es:edi],al
				inc		edi
				dec		ecx
				jnz		for88
rtrn3:			ret

for1:			cmp		ecx,8
				jb		for2
				push	ebx
				mov		ebx,ecx
				call	_is_mmx
				jz		for3			; no, goto no MMX
				call	mmx_color
				shr		ecx,3			; yes, run MMX routine
for4:			movq	mm1,[es:edi]
				por		mm1,mm0
				movq	[es:edi],mm1
				add		edi,8
				dec		ecx
				jnz		for4
				and		ebx,7			; do rest bytes
				jmp		for5

for3:			shr		ecx,2
for6:			or	   [es:edi],eax
				add		edi,4
				dec		ecx
				jnz		for6
				and		ebx,3
for5:			je		for9
for7:			or	   [es:edi],al
				inc		edi
				dec		ebx
				jnz		for7
for9:			pop		ebx
				ret

;		MMX	state MUST BE ON before	call
;		set	(ecx) bytes	to (eax) value from	(es:edi)

fplus:			and		ecx,ecx
				je		rtrn3	 		; return if	nothing	to do
fplus88:		test	edi,7			; round	to 8/16
				je		fplus1
fplus2:			add		[es:edi],al
				inc		edi
				dec		ecx
				jnz		fplus88
				ret

fplus1:			cmp		ecx,8
				jb		fplus2
				push	ebx
				mov		ebx,ecx
				call	_is_mmx
				jz		fplus3			; no, goto no MMX
				call	mmx_color
				shr		ecx,3			; yes, run MMX routine
fplus4:			movq	mm1,[es:edi]
				paddb	mm1,mm0
				movq	[es:edi],mm1
				add		edi,8
				dec		ecx
				jnz		fplus4
				and		ebx,7			; do rest bytes
				jmp		fplus5

fplus3:			;shr	 ecx,2
fplus6:			add		[es:edi],al
				inc		edi
				dec		ecx
				jnz		fplus6
				jmp		fplus9
fplus5:			je		fplus9
fplus7:			add		[es:edi],al
				inc		edi
				dec		ebx
				jnz		fplus7
fplus9:			pop		ebx
				ret

;		MMX	state MUST BE ON before	call
;		set	(ecx) bytes	to (eax) value from	(es:edi)

fnot:			and		ecx,ecx
				je		near rtrn3	 		; return if	nothing	to do
fnot88:			test	edi,7			; round	to 8/16
				je		fnot1
fnot2:			not		byte [es:edi]
				inc		edi
				dec		ecx
				jnz		fnot88
				ret

fnot1:			cmp		ecx,8
				jb		fnot2
				push	ebx
				mov		ebx,ecx
				call	_is_mmx
				jz		fnot3			; no, goto no MMX
				movq	mm0,[minusone]
				shr		ecx,3			; yes, run MMX routine
fnot4:			movq	mm1,[es:edi]
				pxor	mm1,mm0
				movq	[es:edi],mm1
				add		edi,8
				dec		ecx
				jnz		fnot4
				and		ebx,7			; do rest bytes
				jmp		fnot5

fnot3:			shr		ecx,2
fnot6:			not		dword [es:edi]
				add		edi,4
				dec		ecx
				jnz		fnot6
				and		ebx,3
fnot5:			je		fnot9
fnot7:			not		byte [es:edi]
				inc		edi
				dec		ebx
				jnz		fnot7
fnot9:			pop		ebx
				ret

;		MMX	state MUST BE ON before	call
;		set	(ecx) bytes	to (eax) value from	(es:edi)

fminus:			and		ecx,ecx
				je		rtrn7	 		; return if	nothing	to do
fminus88:		test	edi,7			; round	to 8/16
				je		fminus1
fminus2:		sub		[es:edi],al
				inc		edi
				dec		ecx
				jnz		fminus88
rtrn7:			ret

fminus1:		cmp		ecx,8
				jb		fminus2
				push	ebx
				mov		ebx,ecx
				call	_is_mmx
				jz		fminus3			; no, goto no MMX
				call	mmx_color
				shr		ecx,3			; yes, run MMX routine
fminus4:		movq	mm1,[es:edi]
				psubb	mm1,mm0
				movq	[es:edi],mm1
				add		edi,8
				dec		ecx
				jnz		fminus4
				and		ebx,7			; do rest bytes
				jmp		fminus5

fminus3:	   ; shr	 ecx,2
fminus6:		sub		[es:edi],al
				inc		edi
				dec		ecx
				jnz		fminus6
				jmp		fminus9
fminus5:		je		fminus9
fminus7:		sub		[es:edi],al
				inc		edi
				dec		ebx
				jnz		fminus7
fminus9:		pop		ebx
				ret

;		MMX	state MUST BE ON before	call
;		set	(ecx) bytes	to (eax) value from	(es:edi)

fand:			and		ecx,ecx
				je		rtrn7	 		; return if	nothing	to do
fand88:			test	edi,7			; round	to 8/16
				je		fand1
fand2:			and		[es:edi],al
				inc		edi
				dec		ecx
				jnz		fand88
				ret

fand1:			cmp		ecx,8
				jb		fand2
				push	ebx
				mov		ebx,ecx
				call	_is_mmx
				jz		fand3			; no, goto no MMX
				call	mmx_color
				shr		ecx,3			; yes, run MMX routine
fand4:			movq	mm1,[es:edi]
				pand	mm1,mm0
				movq	[es:edi],mm1
				add		edi,8
				dec		ecx
				jnz		fand4
				and		ebx,7			; do rest bytes
				jmp		fand5

fand3:			shr		ecx,2
fand6:			and		[es:edi],eax
				add		edi,4
				dec		ecx
				jnz		fand6
				and		ebx,3
				push	ebx
fand5:			je		fand9
fand7:			and		[es:edi],al
				inc		edi
				dec		ebx
				jnz		fand7
fand9:			pop		ebx
				ret
;
; linux	ready
;
_L1RamToRam:	push	ebp
				mov		ebp,esp
				push	eax
				push	ebx
				push	ecx
				push	edx
				push	esi
				push	edi
				mov		ebx,[ebp+16]
				mov		ecx,[ebp+20]
				mov		esi,[ebp+8]
				mov		edi,[ebp+12]
				push	es
				push	ds
				pop		es
				cld
				call	_set_mmx
L34:			push	ecx
				push	ebx
				mov		ecx,ebx
				cmp		ecx,4
				jb		L35

				cmp		ecx,8			; minimum 16 bytes for mmx
				jc		L33x1
				call	_is_mmx
				jz		L33x1
				shr		ecx,3

L32x1:			movq	mm0,[esi]
				movq	[es:edi],mm0
				add		esi,8
				add		edi,8
				dec		ecx
				jnz		L32x1
				and		ebx,7
				jmp		L33x2

L33x1:			shr		cx,2
				repe	movsd
L35:			and		ebx,3
L33x2:			mov		ecx,ebx
				je		L36
				repe	movsb
L36:			add		esi,[ebp+28]
				add		edi,[ebp+24]
				pop		ebx
				pop		ecx
				dec		ecx
				jnz		L34
				call	_reset_mmx
				pop		es
				pop		edi
				pop		esi
				pop		edx
				pop		ecx
				pop		ebx
				pop		eax
				pop		ebp
				ret

_L1RamToRamPpop:push	ebp
				mov		ebp,esp
				push	eax
				push	ebx
				push	ecx
				push	edx
				push	esi
				push	edi
				mov		ebx,[ebp+16]
				mov		ecx,[ebp+20]
				mov		esi,[ebp+8]
				mov		edi,[ebp+12]
				push	es
				push	ds
				pop		es
				cld
				call	_set_mmx
L34p:			push	ecx
				push	ebx
				mov		ecx,ebx
				cmp		ecx,4
				jb		near L35p

				cmp		ecx,8			; minimum 16 bytes for mmx
				jc		near L33x1p
				call	_is_mmx
				mov		al,[_ppop]
				jz		near L33x1p
				shr		ecx,3
				cmp		al,1
				je		L32x1pxor
				cmp		al,2
				je		L32x1pand
				cmp		al,3
				je		L32x1por
                cmp     al,8
                je      near L35transpx

L32x1pset:		movq	mm0,[esi]
				movq	[es:edi],mm0
				add		esi,8
				add		edi,8
				dec		ecx
				jnz		L32x1pset
				and		ebx,7
				jmp		L33x2p

L32x1pxor:		movq	mm0,[esi]
				pxor	mm0,[es:edi]
				movq	[es:edi],mm0
				add		esi,8
				add		edi,8
				dec		ecx
				jnz		L32x1pxor
				and		ebx,7
				jmp		L33x2p

L32x1pand:		movq	mm0,[esi]
				pand	mm0,[es:edi]
				movq	[es:edi],mm0
				add		esi,8
				add		edi,8
				dec		ecx
				jnz		L32x1pand
				and		ebx,7
				jmp		L33x2p

L32x1por:		movq	mm0,[esi]
				por		mm0,[es:edi]
				movq	[es:edi],mm0
				add		esi,8
				add		edi,8
				dec		ecx
				jnz		L32x1por
				and		ebx,7
				jmp		L33x2p

L33x1p:			shr		cx,2
				cmp		al,1
				je		L35xor
				cmp		al,2
				je		L35and
				cmp		al,3
				je		L35or
                cmp     al,8
                je      L35transpx
; else set mode
				repe	movsd
				jmp		L35p

L35xor:			mov		eax,[esi]
				add		esi,4
				xor		eax,[es:edi]
				mov		[es:edi],eax
				add		edi,4
				dec		ecx
				jnz		L35xor
				jmp		L35p

L35and:			mov		eax,[esi]
				add		esi,4
				and		eax,[es:edi]
				mov		[es:edi],eax
				add		edi,4
				dec		ecx
				jnz		L35and
				jmp		L35p

L35or:			mov		eax,[esi]
				add		esi,4
				or		eax,[es:edi]
				mov		[es:edi],eax
				add		edi,4
				dec		ecx
				jnz		L35or
				jmp		L35p

L35transpx:     mov		ecx,ebx
				shr		ecx,2
L35transp:      mov     eax,[esi]
				mov     edx,[es:edi]
				cmp		eax,0
				je		nomove1

				cmp		al,0
				jne		nomove2
				mov		al,dl
nomove2:		cmp		ah,0
				jne		nomove3
				mov		ah,dh
nomove3:		rol		eax,16
				rol		edx,16
				cmp		al,0
				jne		nomove4
				mov		al,dl
nomove4:		cmp		ah,0
				jne		nomove5
				mov		ah,dh
nomove5:        rol		eax,16
				rol		edx,16
                mov     [es:edi],eax
nomove1:        add		esi,4
                add		edi,4
                dec		ecx
				jnz		L35transp
                jmp     L35p

L35p:			and		ebx,3
L33x2p:			mov		ecx,ebx
				je		L36p
				mov		ebx,[_ppop]
L355:			call	[rtable+ebx*4]
				inc		esi
				inc		edi
				dec		cx
				jnz		L355
L36p:			add		esi,[ebp+28]
				add		edi,[ebp+24]
				pop		ebx
				pop		ecx
				dec		ecx
				jnz		near L34p
				call	_reset_mmx
				pop		es
				pop		edi
				pop		esi
				pop		edx
				pop		ecx
				pop		ebx
				pop		eax
				pop		ebp
				ret
;
;
;
_L1RamToVideo8:	push	ebp
				mov		ebp,esp
				push	ebx
				push	ecx
				call	_set_mmx
				mov		ebx,[ebp+16]
				mov		ecx,[ebp+20]
				push	esi
				push	edi
				mov		esi,[ebp+8]
				mov		edi,[ebp+12]
%ifdef LINUX
				sub	edi,[_videobase]
%endif		
				rol		edi,10H
				mov		ax,di
				rol		edi,10H
				call	[set_bank_proc]
				push	es
				mov		es,[_VideoSelector]
				cld
L37x:			push	ecx	; edi =	full relativna adresa
				push	ebx
				mov		ecx,ebx
				add		di,cx
				mov		bx,di
				sub		di,cx
				jae		L38x
				sub		cx,bx	; tak a	makame na dvakrat
%ifdef LINUX
				push	edi
				and	edi,0xFFFF	;
				add	edi,[_videobase]
%endif		
				call	tset
%ifdef LINUX
				pop		edi
				and		edi,0xFFFF0000
				add		edi,0x10000
%endif		
				rol		edi,10H
				mov		ax,di
				rol		edi,10H
				call	[set_bank_proc]
				mov		cx,bx
%ifdef LINUX
				push	edi
				push	ecx
				and	edi,0xFFFF
				add	edi,[_videobase]
%endif		
				call	tset
				jmp		L39x
L38x:			
%ifdef LINUX
				push	edi
				push	ecx
				and	edi,0xFFFF
				add	edi,[_videobase]
%endif		
				call	tset
L39x:			
%ifdef LINUX
				pop		ecx
				pop		edi
				add		edi,ecx
%endif		
				add		di,[ebp+28]
				jae		L40x
				add		edi,0x10000
				rol		edi,10H
				mov		ax,di
				rol		edi,10H
				call	[set_bank_proc]
L40x:			add		esi,[ebp+24]
				pop		ebx
				pop		ecx
				dec		ecx
				jnz		near L37x
				call	_reset_mmx
				pop		es
				pop		edi
				pop		esi
				pop		ecx
				pop		ebx
				pop		ebp
				ret

_L1RamToVideo2:	push	ebp
				mov		ebp,esp
				push	ebx
				push	ecx
                                call    _set_mmx
				mov		ebx,[ebp+16]
				mov		ecx,[ebp+20]
				push	esi
				push	edi
				push	es
				mov		esi,[ebp+8]
				mov		edi,[ebp+12]
%ifdef LINUX
				sub	edi,[_videobase]
%endif		
				rol		edi,10H
				mov		ax,di
				rol		edi,10H
				call	[set_bank_proc]
				mov		es,[_VideoSelector]
				cld
L41:			push	ecx
				push	ebx
				mov		ecx,ebx
				add		di,cx
				mov		bx,di
				sub		di,cx
				jae		L42
				sub		cx,bx
%ifdef LINUX
				push	edi
				and	edi,0xFFFF	;
				add	edi,[_videobase]
%endif		
				call	[L243]
%ifdef LINUX
				pop		edi
				and		edi,0xFFFF0000
				add		edi,0x10000
%endif		
				rol		edi,10H
				mov		ax,di
				rol		edi,10H
				call	[set_bank_proc]
				mov		cx,bx
%ifdef LINUX
				push	edi
				push	ecx
				and	edi,0xFFFF
				add	edi,[_videobase]
%endif		
				call	[L243]
				jmp		L43
L42:
%ifdef LINUX
				push	edi
				push	ecx
				and	edi,0xFFFF
				add	edi,[_videobase]
%endif		
				call	[L243]
L43:
%ifdef LINUX
				pop		ecx
				pop		edi
				add		edi,ecx
%endif		
				add		di,[ebp+28]
				jae		L44
				add		edi,00010000H
				rol		edi,10H
				mov		ax,di
				rol		edi,10H
				call	[set_bank_proc]
L44:			add		esi,[ebp+24]
				pop		ebx
				pop		ecx
				dec		ecx
				jne		near L41
                                call            _reset_mmx
				pop		es
				pop		edi
				pop		esi
				pop		ecx
				pop		ebx
				pop		ebp
				ret

_L1VideoToRam8:	push	ebp
				mov		ebp,esp
				push	ebx
				push	ecx
				push	esi
				push	edi
				call	_set_mmx
				mov		ecx,[ebp+20]
				mov		ebx,[ebp+16]
				mov		edi,[ebp+8]
				mov		esi,[ebp+12]
%ifdef LINUX
				sub	edi,[_videobase]
%endif		
				rol		edi,10H
				mov		ax,di
				rol		edi,10H
				call	[set_bank_proc]
				push	es
				mov		es,[_VideoSelector]
				cld
L50:			push	ecx
				push	ebx
				mov		ecx,ebx
				add		di,cx
				mov		bx,di
				sub		di,cx
				jae		L51
				sub		cx,bx
%ifdef LINUX
				push	edi
				and	edi,0xFFFF	;
				add	edi,[_videobase]
%endif		
				call	toram8
%ifdef LINUX
				pop		edi
				and		edi,0xFFFF0000
				add		edi,0x10000
%endif		
				rol		edi,10H
				mov		ax,di
				rol		edi,10H
				call	[set_bank_proc]
				mov		cx,bx
%ifdef LINUX
				push	edi
				push	ecx
				and	edi,0xFFFF
				add	edi,[_videobase]
%endif		
				call	toram8
				jmp		L52
L51:
%ifdef LINUX
				push	edi
				push	ecx
				and	edi,0xFFFF
				add	edi,[_videobase]
%endif		
				call	toram8
L52:
%ifdef LINUX
				pop		ecx
				pop		edi
				add		edi,ecx
%endif		
				add		di,[ebp+28]
				jae		L53
				add		edi,00010000H
				rol		edi,10H
				mov		ax,di
				rol		edi,10H
				call	[set_bank_proc]
L53:			add		esi,[ebp+24]
				pop		ebx
				pop		ecx
				dec		ecx
				jne		near L50
				call	_reset_mmx
				pop		es
				pop		edi
				pop		esi
				pop		ecx
				pop		ebx
				pop		ebp
				ret

_draw_point:	push	ebp
				mov		ebp,esp
				mov		eax,[ebp+8]
				mov		edx,[ebp+12]
				mov		[oldx],eax
				mov		[oldy],edx
				cmp		eax,[_clip_x_min]
				jl		L45
				cmp		eax,[_clip_x_max]
				jae		L45
				cmp		edx,[_clip_y_min]
				jl		L45
				cmp		edx,[_clip_y_max]
				jae		L45
				push	ebx
				push	ecx
				push	edi
				mov		ebx,eax
				mov		ax,[_X_width]
				mul		dx
				add		ax,bx
				adc		dx,0000H
				mov		di,dx
				rol		edi,10H
				mov		di,ax
				push	es
				mov		es,[_VideoSelector]
				xchg	edi,ebp
				add		ebp,[_videobase]
				call	[L242]
				pop		es
				pop		edi
				pop		ecx
				pop		ebx
L45:			pop		ebp
				ret

gperr:                          mov     eax,256
                                ret
                                
_get_point:		mov		eax,[esp+4]
					 mov		edx,[esp+8]
                                         cmp            ax,[_X_width]
                                         jnc            gperr
                                         cmp            dx,[_Y_width]
                                         jnc            gperr
				push	ebx
				push	edi
		push	   es
				
		mov		es,[_VideoSelector]
				mov		ebx,eax
				mov		ax,[_X_width]
				mul		dx					; dx = sirka*y
				add		ax,bx
				adc		dx,0000H
				cmp		byte [_lfb],0
				jz		getpoint2
				rol		edx,16
				mov		dx,ax ;	edx	= ptr
				add		edx,[_videobase]
				xor		eax,eax
				mov		al,[edx]
				jmp		getpoint3
getpoint2:		mov		di,ax
				mov		ax,dx
				call	   [set_bank_proc]
				xor		eax,eax
				add		edi,[_videobase]
				mov		al,[es:di]
getpoint3:		pop		es
				pop		edi
				pop		ebx
				ret

ClipLine:		push	ebp
L54:			cmp		ebx,esi
				je		near L68
				cmp		ecx,edi
				je		near L71
				xor		al,al
				cmp		ecx,[_cy_work]
				jge		L55
				or		al,01H
				jmp		L56
L55:			cmp		ecx,[_cy_maxwork]
				jl		L56
				or		al,02H
L56:			cmp		ebx,[_cx_work]
				jge		L57
				or		al,04H
				jmp		L58
L57:			cmp		ebx,[_cx_maxwork]
				jl		L58
				or		al,08H
L58:			xor		ah,ah
				cmp		edi,[_cy_work]
				jge		L59
				or		ah,01H
				jmp		L60
L59:			cmp		edi,[_cy_maxwork]
				jl		L60
				or		ah,02H
L60:			cmp		esi,[_cx_work]
				jge		L61
				or		ah,04H
				jmp		L62
L61:			cmp		esi,[_cx_maxwork]
				jl		L62
				or		ah,08H
L62:			mov		dl,al
				and		dl,ah
				jne		near L67
				mov		dl,al
				or		dl,ah
				je		near L74
				test	al,al
				jne		L63
				mov		al,ah
				xchg	esi,ebx
				xchg	edi,ecx
L63:			mov		ebp,eax
				test	al,01H
				je		L64
				mov		eax,[_cy_work]
				sub		eax,ecx
				push	ecx
				mov		ecx,eax
				mov		eax,esi
				sub		eax,ebx
				imul	ecx
				pop		ecx
				neg		ecx
				add		ecx,edi
				idiv	ecx
				add		ebx,eax
				mov		ecx,[_cy_work]
				jmp		L65
L64:			test	ebp,00000002H
				je		L65
				mov		eax,esi
				sub		eax,ebx
				mov		edx,[_cy_maxwork]
				dec		edx
				sub		edx,ecx
				imul	edx
				neg		ecx
				add		ecx,edi
				idiv	ecx
				add		ebx,eax
				mov		ecx,[_cy_maxwork]
				dec		ecx
L65:			cmp		ebx,esi
				je		near L71
				test	ebp,00000004H
				je		near L66
				mov		eax,[_cx_work]
				sub		eax,ebx
				push	ebx
				mov		ebx,eax
				mov		eax,edi
				sub		eax,ecx
				imul	ebx
				pop		ebx
				neg		ebx
				add		ebx,esi
				idiv	ebx
				add		ecx,eax
				mov		ebx,[_cx_work]
				jmp		L54
L66:			test	ebp,00000008H
				je		near L54
				mov		eax,edi
				sub		eax,ecx
				mov		edx,[_cx_maxwork]
				dec		edx
				sub		edx,ebx
				imul	edx
				neg		ebx
				add		ebx,esi
				idiv	ebx
				add		ecx,eax
				mov		ebx,[_cx_maxwork]
				dec		ebx
				jmp		L54
L67:			mov		eax,00000001H
				jmp		L75
L68:			cmp		ecx,edi
				jle		L69
				xchg	edi,ecx
				xchg	esi,ebx
L69:			cmp		edi,[_cy_work]
				jl		L67
				cmp		ecx,[_cy_maxwork]
				jge		L67
				cmp		ebx,[_cx_work]
				jl		L67
				cmp		ebx,[_cx_maxwork]
				jae		L67
				cmp		edi,[_cy_maxwork]
				jl		L70
				mov		edi,[_cy_maxwork]
				dec		edi
L70:			cmp		ecx,[_cy_work]
				jge		L74
				mov		ecx,[_cy_work]
				jmp		L74
L71:			cmp		ebx,esi
				jle		L72
				xchg	esi,ebx
				xchg	edi,ecx
L72:			cmp		esi,[_cx_work]
				jl		L67
				cmp		ebx,[_cx_maxwork]
				jge		L67
				cmp		ecx,[_cy_work]
				jl		L67
				cmp		ecx,[_cy_maxwork]
				jae		L67
				cmp		esi,[_cx_maxwork]
				jl		L73
				mov		esi,[_cx_maxwork]
				dec		esi
L73:			cmp		ebx,[_cx_work]
				jge		L74
				mov		ebx,[_cx_work]
L74:			xor		eax,eax
L75:			pop		ebp
				ret

ClipLine2:		push	ebp
L76:			cmp		ebx,esi
				je		near L90
				cmp		ecx,edi
				je		near L93
				xor		al,al
				cmp		ecx,[_clip_y_min]
				jge		L77
				or		al,01H
				jmp		L78
L77:			cmp		ecx,[_clip_y_max]
				jl		L78
				or		al,02H
L78:			cmp		ebx,[_clip_x_min]
				jge		L79
				or		al,04H
				jmp		L80
L79:			cmp		ebx,[_clip_x_max]
				jl		L80
				or		al,08H
L80:			xor		ah,ah
				cmp		edi,[_clip_y_min]
				jge		L81
				or		ah,01H
				jmp		L82
L81:			cmp		edi,[_clip_y_max]
				jl		L82
				or		ah,02H
L82:			cmp		esi,[_clip_x_min]
				jge		L83
				or		ah,04H
				jmp		L84
L83:			cmp		esi,[_clip_x_max]
				jl		L84
				or		ah,08H
L84:			mov		dl,al
				and		dl,ah
				jne		near L89
				mov		dl,al
				or		dl,ah
				je		near L96
				test	al,al
				jne		L85
				mov		al,ah
				xchg	esi,ebx
				xchg	edi,ecx
L85:			mov		ebp,eax
				test	al,01H
				je		L86
				mov		eax,[_clip_y_min]
				sub		eax,ecx
				push	ecx
				mov		ecx,eax
				mov		eax,esi
				sub		eax,ebx
				imul	ecx
				pop		ecx
				neg		ecx
				add		ecx,edi
				idiv	ecx
				add		ebx,eax
				mov		ecx,[_clip_y_min]
				jmp		L87
L86:			test	ebp,00000002H
				je		L87
				mov		eax,esi
				sub		eax,ebx
				mov		edx,[_clip_y_max]
				dec		edx
				sub		edx,ecx
				imul	edx
				neg		ecx
				add		ecx,edi
				idiv	ecx
				add		ebx,eax
				mov		ecx,[_clip_y_max]
				dec		ecx
L87:			cmp		ebx,esi
				je		near L93
				test	ebp,00000004H
				je		L88
				mov		eax,[_clip_x_min]
				sub		eax,ebx
				push	ebx
				mov		ebx,eax
				mov		eax,edi
				sub		eax,ecx
				imul	ebx
				pop		ebx
				neg		ebx
				add		ebx,esi
				idiv	ebx
				add		ecx,eax
				mov		ebx,[_clip_x_min]
				jmp		L76
L88:			test	ebp,00000008H
				je		near L76
				mov		eax,edi
				sub		eax,ecx
				mov		edx,[_clip_x_max]
				dec		edx
				sub		edx,ebx
				imul	edx
				neg		ebx
				add		ebx,esi
				idiv	ebx
				add		ecx,eax
				mov		ebx,[_clip_x_max]
				dec		ebx
				jmp		L76
L89:			mov		eax,00000001H
				jmp		L97
L90:			cmp		ecx,edi
				jle		L91
				xchg	edi,ecx
				xchg	esi,ebx
L91:			cmp		edi,[_clip_y_min]
				jl		L89
				cmp		ecx,[_clip_y_max]
				jge		L89
				cmp		ebx,[_clip_x_min]
				jl		L89
				cmp		ebx,[_clip_x_max]
				jae		L89
				cmp		edi,[_clip_y_max]
				jl		L92
				mov		edi,[_clip_y_max]
				dec		edi
L92:			cmp		ecx,[_clip_y_min]
				jge		L96
				mov		ecx,[_clip_y_min]
				jmp		L96
L93:			cmp		ebx,esi
				jle		L94
				xchg	esi,ebx
				xchg	edi,ecx
L94:			cmp		esi,[_clip_x_min]
				jl		L89
				cmp		ebx,[_clip_x_max]
				jge		L89
				cmp		ecx,[_clip_y_min]
				jl		L89
				cmp		ecx,[_clip_y_max]
				jae		L89
				cmp		esi,[_clip_x_max]
				jl		L95
				mov		esi,[_clip_x_max]
				dec		esi
L95:			cmp		ebx,[_clip_x_min]
				jge		L96
				mov		ebx,[_clip_x_min]
L96:			xor		eax,eax
L97:			pop		ebp
				ret

_Line:			push	ebp
				mov		ebp,esp
				push	edi
				push	esi
				push	ebx
				push	es
				mov		eax,[ebp+16]
				mov		edx,[ebp+20]
				mov		ebx,[ebp+8]
				mov		ecx,[ebp+12]
				mov		esi,ebx
				mov		edi,ecx
				mov		ebx,eax
				mov		ecx,edx
				call	ClipLine
				test	eax,eax
				jne		near L109
				push	ds
				pop		es
				cmp		ebx,esi
				jle		L98
				xchg	ebx,esi
				xchg	ecx,edi
L98:			mov		eax,[_cx_max]
				mul		ecx
				mov		ebp,ebx
				add		ebp,eax
				add		ebp,[_Image]
				mov		eax,esi
				sub		eax,ebx
				mov		edx,edi
				sub		edx,ecx
				mov		edi,edx
				mov		ebx,[_cx_max]
				test	edx,edx
				je		near L107
				jns		L99
				neg		edi
				neg		ebx
L99:			test	eax,eax
				je		near L105
				cmp		eax,edi
				jbe		L102
				mov		ecx,eax
				inc		ecx
				mov		esi,edi
				shl		esi,1
				sub		edi,eax
				shl		edi,1
				mov		edx,esi
				sub		edx,eax
L100:			call	[MemPixel]
				inc		ebp
				test	edx,edx
				js		L101
				add		edx,edi
				add		ebp,ebx
				dec		ecx
				jne		L100
				jmp		L109
L101:			add		edx,esi
				dec		ecx
				jne		L100
				jmp		L109
L102:			mov		ecx,edi
				inc		ecx
				mov		esi,eax
				shl		esi,1
				neg		edi
				add		edi,eax
				shl		edi,1
				neg		edx
				add		edx,esi
L103:			call	[MemPixel]
				add		ebp,ebx
				test	edx,edx
				js		L104
				inc		ebp
				add		edx,edi
				dec		ecx
				jne		L103
				jmp		L109
L104:			add		edx,esi
				dec		ecx
				jne		L103
				jmp		L109
L105:			mov		ecx,edi
				inc		ecx
L106:			call	[MemPixel]
				add		ebp,ebx
				dec		ecx
				jne		L106
				jmp		L109
L107:			mov		ecx,eax
				inc		ecx
L108:			call	[MemPixel]
				inc		ebp
				dec		ecx
				jne		L108
L109:			pop		es
				pop		ebx
				pop		esi
				pop		edi
				pop		ebp
				ret

_drawto_line:	push	ebp
				mov		ebp,esp
				push	edi
				push	esi
				push	ebx
				push	es
				mov		eax,[ebp+8]
				mov		edx,[ebp+12]
				mov		ebx,[oldx]
				mov		ecx,[oldy]
				jmp		drw2

_draw_line:		push	ebp
				mov		ebp,esp
				push	edi
				push	esi
				push	ebx
				push	es
				mov		eax,[ebp+16]
				mov		edx,[ebp+20]
				mov		ebx,[ebp+8]
				mov		ecx,[ebp+12]
drw2:			mov		esi,ebx		; x2
		mov		edi,ecx		; y2
		mov		ebx,eax		; x1
		mov		ecx,edx		; y1
				call	ClipLine2
				test	eax,eax
				jne		near L121
				mov		ax,[_VideoSelector]
				mov		es,ax
				cmp		ebx,esi
				jle		L110
				xchg	ebx,esi
				xchg	ecx,edi
L110:			mov		eax,[_X_width]
				mul		ecx
				mov		ebp,ebx
				add		ebp,eax
				add		ebp,[_videobase]
				mov		eax,esi
				sub		eax,ebx
				mov		edx,edi
				sub		edx,ecx
				mov		edi,edx
				mov		ebx,[_X_width]
				test	edx,edx
				je		near L119
				jns		L111
				neg		edi
				neg		ebx
L111:			test	eax,eax
				je		near L117
				cmp		eax,edi
				jbe		L114
				mov		ecx,eax
				inc		ecx
				mov		esi,edi
				shl		esi,1
				sub		edi,eax
				shl		edi,1
				mov		edx,esi
				sub		edx,eax
L112:			call	[L242]
				inc		ebp
				test	edx,edx
				js		L113
				add		edx,edi
				add		ebp,ebx
				dec		ecx
				jne		L112
				jmp		L121
L113:			add		edx,esi
				dec		ecx
				jne		L112
				jmp		L121
L114:			mov		ecx,edi
				inc		ecx
				mov		esi,eax
				shl		esi,1
				neg		edi
				add		edi,eax
				shl		edi,1
				neg		edx
				add		edx,esi
L115:			call	[L242]
				add		ebp,ebx
				test	edx,edx
				js		L116
				inc		ebp
				add		edx,edi
				dec		ecx
				jne		L115
				jmp		L121
L116:			add		edx,esi
				dec		ecx
				jne		L115
				jmp		L121
L117:			mov		ecx,edi
				inc		ecx
L118:			call	[L242]
				add		ebp,ebx
				dec		ecx
				jne		L118
				jmp		L121
L119:			mov		ecx,eax
				inc		ecx
L120:			call	[L242]
				inc		ebp
				dec		ecx
				jne		L120
L121:			pop		es
				pop		ebx
				pop		esi
				pop		edi
				pop		ebp
				ret

; esi-edi zdroj-ciel
; bl = sirka znaku
_expand_font1_:	push	ecx
				mov		al,[esi]	; font
        		mov		cl,bl
				inc		esi         ;
L123y:			mov		bh,0
                shl		al,1
                sbb		bh,0
	       		inc		edi
				mov		[edi-1],byte bh
				dec		cl
				jnz		L123y
				pop		ecx
				dec		ecx
				jnz		_expand_font1_
				ret

_expand_font2_:	push	ecx
				mov		al,[esi]	; font
        		mov		cl,8
				inc		esi         ;
L123:			mov		bh,0
                shl		al,1
                sbb		bh,0
	       		inc		edi
				mov		[edi-1],byte bh
				dec		cl
				jnz		L123

				mov		al,[esi]	; font
        		mov		cl,4
				inc		esi         ;
L123x:			mov		bh,0
                shl		al,1
                sbb		bh,0
	       		inc		edi
				mov		[edi-1],byte bh
				dec		cl
				jnz		L123x

				pop		ecx
				dec		ecx
				jnz		_expand_font2_
				ret

_expand_font3_:	push	ecx
				mov		al,[esi]	; font
        		mov		cl,8
				inc		esi         ;
L123o:			mov		bh,0
                shl		al,1
                sbb		bh,0
	       		inc		edi
				mov		[edi-1],byte bh
				dec		cl
				jnz		L123o

				mov		al,[esi]	; font
        		mov		cl,8
				inc		esi         ;
L123m:			mov		bh,0
                shl		al,1
                sbb		bh,0
	       		inc		edi
				mov		[edi-1],byte bh
				dec		cl
				jnz		L123m

				pop		ecx
				dec		ecx
				jnz		_expand_font3_
				ret

__expand_font:	push	eax
				push	ebx
				push	ecx
				push	edx
				push	edi
				push	esi
				push	ds
				pop		es

				mov		esi,_miro0406
				mov		edi,_miro0406x
				mov		ecx,0x6*0x60
				mov		ebx,4
				call	_expand_font1_

				mov		esi,_miro0808
				mov		edi,_miro0808x
				mov		ecx,0x800
				mov		ebx,8
				call	_expand_font1_

				mov		esi,_miro0816
				mov		edi,_miro0816x
				mov		ecx,0x1000
				mov		ebx,8
				call	_expand_font1_

				mov		esi,_miro1220
				mov		edi,_miro1220x
				mov		ecx,0x14*0x60
				call	_expand_font2_

				mov		esi,_miro1625
				mov		edi,_miro1625x
				mov		ecx,0x19*0x60
				call	_expand_font3_

				mov		eax,_miro0808x
				mov		[_font],eax
				mov		eax,1
				mov		[_fontn],eax
				mov		eax,8
				mov		[_fonth],eax
				mov		[_fontw],eax
				pop		esi
				pop		edi
				pop		edx
				pop		ecx
				pop		ebx
				pop		eax
				ret

_CharOutClip:   cmp		byte [_fontw], 8
				jnz		near _CharOutClip12
				mov		edx,[esp+8]
				mov		eax,[esp+4]
				push	edi
				push	esi
				push	ebx
				push	ecx
				push	ebp
				cld
				mov		edi,eax		; font
				mov		esi,edx		; dst
				mov		ecx,[_fonth]; microline	counter
				xchg	eax,ebx
				mov		al,[__CurrColor]	; ebx
				mov		ah,al
				push	ax
				push	ax
				pop		eax
				xchg	eax,ebx
				xchg	eax,edx
				mov		al,[__CurrBkColor]	; edx
				mov		ah,al
				push	ax
				push	ax
				pop		eax
				xchg	eax,edx
				push	ds
				pop		es
				call	_is_mmx
				jz		L127		; no MMX
				mov		[mmxtmp],ebx
				mov		[mmxtmp+4],ebx
				movq	mm0,[mmxtmp]	; foreground
				mov		[mmxtmp],edx
				mov		[mmxtmp+4],edx
				movq	mm1,[mmxtmp]	; background
L127_2:			movq	mm3,[esi]		; get font 8 byte
				movq	mm5,mm3
				pand	mm3,mm0
				pandn	mm5,mm1
				por		mm3,mm5
				add		esi,8
				movq	[edi],mm3
				add		edi,[esp+32]
				dec		ecx
				jnz		L127_2
				jmp		L127_1

L127:			push	ecx
				push	edi
				lodsd
				mov		ebp,eax
				and		eax,ebx
				xchg	eax,ebp
				not		eax
				and		eax,edx
				or		eax,ebp
				stosd
				lodsd
				mov		ebp,eax
				and		eax,ebx
				xchg	eax,ebp
				not		eax
				and		eax,edx
				or		eax,ebp
				stosd
				pop		edi
				add		edi,[esp+36]
				pop		ecx
				dec		ecx
				jnz		L127
L127_1:			pop		ebp
				pop		ecx
				pop		ebx
				pop		esi
				pop		edi
				ret

_CharOutClip12:	mov		edx,[esp+8]
				mov		eax,[esp+4]
				push	edi
				push	esi
				push	ebx
				push	ecx
				push	ebp
				cld
				mov		edi,eax		; font
				mov		esi,edx		; dst
				mov		ecx,[_fonth]; microline	counter
				xchg	eax,ebx
				mov		al,[__CurrColor]	; ebx
				mov		ah,al
				push	ax
				push	ax
				pop		eax
				xchg	eax,ebx
				xchg	eax,edx
				mov		al,[__CurrBkColor]	; edx
				mov		ah,al
				push	ax
				push	ax
				pop		eax
				xchg	eax,edx
				push	ds
				pop		es
				mov		eax,[_fontw]
				shr		al,2   ; div 4
				mov		ch,al

L12712:			push	ecx
				push	edi
L12713:			lodsd
				mov		ebp,eax
				and		eax,ebx
				xchg	eax,ebp
				not		eax
				and		eax,edx
				or		eax,ebp
				stosd
				dec		ch
				jnz		L12713
				pop		edi
				pop		ecx
				add		edi,[esp+32]
				dec		cl
				jnz		L12712

       			pop		ebp
				pop		ecx
				pop		ebx
				pop		esi
				pop		edi
				ret

porr:			
%ifdef LINUX
		push	ebp
		sub	ebp,[_videobase]
%endif		
		rol		ebp,10H
				mov		ax,bp
				rol		ebp,10H
%ifdef LINUX
		and	ebp,0xFFFF
		add	ebp,[_videobase]
%endif		
				call	[set_bank_proc]
%ifdef LINUX
				mov		al,[es:ebp]
				or		al,[__CurrColor]
				mov		[es:ebp],al
		pop	ebp
%else		
				mov		al,[es:bp]
				or		al,[__CurrColor]
				mov		[es:bp],al
%endif		
				ret

lporr:		mov		al,[ds:ebp]
				or		al,[__CurrColor]
				mov		[ds:ebp],al
				ret

pandd:			
%ifdef LINUX
		push	ebp
		sub	ebp,[_videobase]
%endif		
		rol		ebp,10H
				mov		ax,bp
				rol		ebp,10H
%ifdef LINUX
		and	ebp,0xFFFF
		add	ebp,[_videobase]
%endif		
				call	[set_bank_proc]
%ifdef LINUX
				mov		al,[es:ebp]
				and		al,[__CurrColor]
				mov		[es:ebp],al
		pop	ebp
%else		
				mov		al,[es:bp]
				and		al,[__CurrColor]
				mov		[es:bp],al
%endif		
				ret

lpandd:		mov		al,[ds:ebp]
				and		al,[__CurrColor]
				mov		[ds:ebp],al
				ret

pset:			
%ifdef LINUX
		push	ebp
		sub	ebp,[_videobase]
%endif		
		rol		ebp,10H
				mov		ax,bp
				rol		ebp,10H
%ifdef LINUX
		and	ebp,0xFFFF
		add	ebp,[_videobase]
%endif		
				call	[set_bank_proc]
				mov		al,[__CurrColor]
%ifdef LINUX
				mov		[es:ebp],al
		pop	ebp
%else		
				mov		[es:bp],al
%endif		
				ret

lpset:			mov		al,[__CurrColor]
				mov		[ds:ebp],al
				ret

preplace:
%ifdef LINUX
		push	ebp
		sub	ebp,[_videobase]
%endif		
		rol		ebp,10H
				mov		ax,bp
				rol		ebp,10H
%ifdef LINUX
		and	ebp,0xFFFF
		add	ebp,[_videobase]
%endif		
				call	[set_bank_proc]
				mov		al,[__CurrColor]
%ifdef LINUX
				cmp		byte [es:ebp],16
				jc		prepl2
				mov		[es:ebp],al
		pop	ebp
%else		
				cmp		byte [es:bp],16
				jc		prepl2
				mov		[es:bp],al
%endif		
prepl2:			ret

lpreplace:		cmp		byte [ds:ebp],16
				jc		prepl2
				mov		al,[__CurrColor]
				mov		[ds:ebp],al
				ret

pxorr:			
%ifdef LINUX
		push	ebp
		sub	ebp,[_videobase]
%endif		
		rol		ebp,10H
				mov		ax,bp
				rol		ebp,10H
%ifdef LINUX
		and	ebp,0xFFFF
		add	ebp,[_videobase]
%endif		
				call	[set_bank_proc]
%ifdef LINUX
				mov		al,[es:ebp]
				xor		al,[__CurrColor]
				mov		[es:ebp],al
		pop	ebp
%else		
				mov		al,[es:bp]
				xor		al,[__CurrColor]
				mov		[es:bp],al
%endif		
				ret

lpxorr:		mov		al,[ds:ebp]
				xor		al,[__CurrColor]
				mov		[ds:ebp],al
				ret

ppluss:			
%ifdef LINUX
		push	ebp
		sub	ebp,[_videobase]
%endif		
		rol		ebp,10H
				mov		ax,bp
				rol		ebp,10H
%ifdef LINUX
		and	ebp,0xFFFF
		add	ebp,[_videobase]
%endif		
				call	[set_bank_proc]
%ifdef LINUX
				mov		al,[es:ebp]
				add		al,[__CurrColor]
				mov		[es:ebp],al
		pop	ebp
%else		
				mov		al,[es:bp]
				add		al,[__CurrColor]
				mov		[es:bp],al
%endif		
				ret

lppluss:	mov		al,[ds:ebp]
				add		al,[__CurrColor]
				mov		[ds:ebp],al
				ret

pminuss:		
%ifdef LINUX
		push	ebp
		sub	ebp,[_videobase]
%endif		
		rol		ebp,10H
				mov		ax,bp
				rol		ebp,10H
%ifdef LINUX
		and	ebp,0xFFFF
		add	ebp,[_videobase]
%endif		
				call	[set_bank_proc]
%ifdef LINUX
				mov		al,[es:ebp]
				sub		al,[__CurrColor]
				mov		[es:ebp],al
		pop	ebp
%else		
				mov		al,[es:bp]
				sub		al,[__CurrColor]
				mov		[es:bp],al
%endif		
				ret

lpminuss:	mov		al,[ds:ebp]
				sub		al,[__CurrColor]
				mov		[ds:ebp],al
				ret

pnott:			
%ifdef LINUX
		push	ebp
		sub	ebp,[_videobase]
%endif		
		rol		ebp,10H
				mov		ax,bp
				rol		ebp,10H
%ifdef LINUX
		and	ebp,0xFFFF
		add	ebp,[_videobase]
%endif		
				call	[set_bank_proc]
%ifdef LINUX
				not		byte [es:ebp]
		pop	ebp
%else
				not		byte [es:bp]
%endif		
				ret

lpnott:		mov		al,[ds:ebp]
				not		byte [ds:ebp]
				ret

worr:			mov		al,[es:ebp]
				or		al,byte	[__CurrColor]
				mov		[es:ebp],al
				ret

wandd:			mov		al,[es:ebp]
				and		al,byte	[__CurrColor]
				mov		[es:ebp],al
				ret

wset:			mov		al,byte	[__CurrColor]
				mov		[es:ebp],al
				ret

wxorr:			mov		al,[es:ebp]
				xor		al,byte	[__CurrColor]
				mov		[es:ebp],al
				ret

wpluss:			mov		al,[es:ebp]
				add		al,byte	[__CurrColor]
				mov		[es:ebp],al
				ret

wminuss:		mov		al,[es:ebp]
				sub		al,byte	[__CurrColor]
				mov		[es:ebp],al
				ret

wnott:			not		byte [es:ebp]
				ret

rorr:			mov		al,[esi]
				or		al,byte	[es:edi]
				mov		[es:edi],al
				ret

randd:			mov		al,[esi]
				and		al,byte	[es:edi]
				mov		[es:edi],al
				ret

rset:			mov		al,byte	[esi]
				mov		[es:edi],al
				ret

rxorr:			mov		al,[esi]
				xor		al,byte	[es:edi]
				mov		[es:edi],al
				ret

rpluss:			mov		al,[esi]
				add		al,byte	[es:edi]
				mov		[es:edi],al
				ret

rminuss:		mov		al,[esi]
				sub		al,byte	[es:edi]
				mov		[es:edi],al
				ret

rnott:			not		byte [es:edi]
				ret

rtransp:        mov     al,[esi]
                cmp		al,0
				je		rtransp1
                mov     [es:edi],al
rtransp1:       ret

L132:           cmp		byte [_lfb],0
				jnz		dumm
				mov		eax,[_driver]
				cmp		eax,15
				jae		L1341
				mov		eax,[eax*4+L257]
				mov		[set_bank_proc],eax
				cmp		word [vmode],256
				jnc		okpaging
dumm:			mov		eax,dummy
				mov		[set_bank_proc],eax
                ret
okpaging:		cmp		eax,[cs:L5]
				jne		L133
				mov		dx,03ceH
				mov		ax,0406H
				out		dx,al
				inc		dl
				in		al,dx
				and		al,0fbH
				or		al,ah
				out		dx,al
				jmp		L1341
L133:			cmp		eax,[cs:L3]
				jne		L1342
				mov		dx,03c4H
				mov		ax,1206H
				out		dx,ax
				jmp		L1341
L1342:
L1341:
L134:			ret

_draw_hline:	mov		eax,[esp+4]
				mov		edx,[esp+8]
				mov		ebx,[esp+12]
draw_hline2:	test	ebx,ebx
				je		near L147
				add		ebx,eax
				cmp		ebx,[_X_width]
				jnbe	near L147
				sub		ebx,eax
				cmp		byte [_lfb],0
				jz		bank_draw_line
				mov		ecx,ebx
				mov		ebx,eax
				mov		eax,[_X_width]
				mul		edx
				add		eax,[_videobase]
				add		eax,ebx
				push		edi
				mov		edi,eax
				mov		al,[__CurrColor]
				mov		ah,al
				push	ax
				push	ax
				pop		eax
				cld
                push	es
				mov		es,[_VideoSelector]
				call	[fill]
                pop		es
				pop	edi
				jmp		L147

bank_draw_line:	push	ebp
				push	es
				push	edi
				push	ebx
				mov		ebx,eax
				mov		ax,[_X_width]
				mul		dx
				add		ax,bx
				adc		dx,0
				mov		di,dx
				rol		edi,10H
				mov		di,ax
				mov		es,[_VideoSelector]

				mov		al,[__CurrColor]
				mov		ah,al
				push	ax
				push	ax
				pop		eax
				xchg	eax,edx
				push	eax
				call	[set_bank_proc]
				pop		eax
				xchg	eax,edx
				cld
				pop		ebx
				and		edi,0000ffffH
				add		di,bx
				movzx	ecx,di
				sub		di,bx
				jae		L141
				sub		ebx,ecx
				push	ecx
				xchg	ecx,ebx
				add	edi,[_videobase]
				call	[fill]
				pop		ebx
				inc		dl
				sub		edi,[_videobase]
%ifdef LINUX
				xor		edi,edi
%else
				xor		edi,edi
%endif
L141:			movzx	ecx,bx
				xchg	eax,edx
				call	[set_bank_proc]
				xchg	eax,edx
				add	edi,[_videobase]
				call	[fill]
				pop		edi
				pop		es
				pop		ebp
L147:			ret

__fill_rect:	push	ebx
				push	ecx
				call	_set_mmx
				mov		ecx,[esp+24]
				mov		ebx,[esp+20]
				mov		edx,[esp+16]
				mov		eax,[esp+12]
__fill_rect2:	push	eax
				push	ebx
				push	ecx
				push	edx
				call	draw_hline2
				pop		edx
				pop		ecx
				pop		ebx
				pop		eax
				inc		edx
				dec		ecx
				jnz		__fill_rect2
				call	_reset_mmx
				pop		ecx
				pop		ebx
				ret

_L1BoxX:		push	ebx
				push	edi
				call	_set_mmx
				mov		ebx,[esp+20]
				mov		ecx,[esp+16]
				mov		edi,[esp+12]
				mov		al,[__CurrColor]
				mov		ah,al
				push	ax
				push	ax
				pop		eax
;				push	es
				push	ds
				pop		es
_L1BoxX1:		push	ebx
				push	ecx
				call	[fill]
				pop		ecx
				pop		ebx
				add		edi,[esp+24]
				dec		ebx
				jnz		_L1BoxX1
				call	_reset_mmx
;				pop		es
				pop		edi
				pop		ebx
				ret

_L1Box:			push	ebx
				push	edi
				call	_set_mmx
				mov		ebx,[esp+20]
				mov		ecx,[esp+16]
				mov		edi,[esp+12]
				mov		al,[__CurrColor]
				mov		ah,al
				push	ax
				push	ax
				pop		eax
;				push	es
				push	ds
				pop		es
_L1Box1:		push	ebx
				push	ecx
				call	fset
				pop		ecx
				pop		ebx
				add		edi,[esp+24]
				dec		ebx
				jnz		_L1Box1
				call	_reset_mmx
;				pop		es
				pop		edi
				pop		ebx
				ret

L148:			push	ecx
				mov		cx,dx
				mov		dx,bx
				cmp		bx,[_clip_y_min]
				jl		L152
				cmp		bx,[_clip_y_max]
				jg		L152
				cmp		ax,[_clip_x_min]
				jge		L149
				mov		ax,[_clip_x_min]
L149:			cmp		cx,[_clip_x_max]
				jl		L150
				mov		cx,[_clip_x_max]
				dec		cx
L150:			mov		bx,cx
				sub		bx,ax
				movsx	edx,dx
				inc		bx
				cwde
				movsx	ebx,bx
				push	es
				test	bx,bx
				jle		L151
				call	draw_hline2
L151:			pop		es
L152:			pop		ecx
				ret

_PaletteInit:	push	ebx
				push	ecx
				push	edx
				push	esi
				enter	0004H,00H
				mov		ax,1010H
				mov		bx,0010H
				xor		cx,cx
				xor		dx,dx
				push	bp
				int		10H
				pop		bp
				mov		ax,1001H
				mov		bx,1000H
				xor		cx,cx
				xor		dx,dx
				xor		esi,esi
				push	bp
				int		10H
				pop		bp
				mov		ax,si
				shl		ax,08H
				mov		[ebp-4H],ax
L153:			mov		ax,1000H
				mov		bx,[ebp-4H]
				xor		cx,cx
				xor		dx,dx
				inc		byte [ebp-3H]
				or		bx,si
				inc		esi
				push	bp
				int		10H
				pop		bp
				cmp		esi,00000010H
				jl		L153
				push	dword L258
				push	dword 0
				push	dword 16
				call	_set_palet1
				add		esp,12
				leave
				pop		esi
				pop		edx
				pop		ecx
				pop		ebx
				ret
%ifndef LINUX
__setvideomode:	mov		ax,[esp+4]
				mov		[vmode],ax
				push	edi
				push	ebx
				mov		bx,ax
				cmp		ax,100h
				jnc		_setv2

				int		10h				; mode below 256
				mov		eax,1			; force	ok
				cmp		word [vmode],3	; is text mode?
				jz		_setv4			;
				jmp		L154 			; no, make fonts etc.

_setv2:			mov		ax,4f02H
				int		10H
				cmp		ax,004fH
				mov		eax,1
				je		L154
				dec		eax
				jmp		_setv4

L154:			push	eax
				push	es
				call	L132
				call	__expand_font
				call	L157			; do video selector
				pop		es
				pop		edx
				movzx	eax,ax
				test	ax,ax			; test;	zero->err
				jz		_setv4
_setv3:			mov		eax,edx
_setv4:			pop		ebx
				pop		edi
				ret		   	; return eax=0 if error

L157:			cmp		byte [_lfb],0
                jnz		seg_done
				push	ebx
				push	edx
				xor		ebx,ebx
				mov		ax,2
				mov		bx,word	[_videobasesegment]
				int		31h
				mov		[_VideoSelector],ax
				pop		edx
				pop		ebx
seg_done:		ret

_peek:			push	ebp
				mov		ebp,esp
				push	es
				push	edi
				mov		es,[ebp+8]
				mov		edi,[ebp+12]
				mov		eax,[es:edi]
				pop		edi
				pop		es
				pop		ebp
				ret

_poke:			push	ebp
				mov		ebp,esp
				push	es
				push	edi
				mov		es,[ebp+8]
				mov		edi,[ebp+12]
				mov		eax,[ebp+16]
				mov		[es:edi],eax
				pop		edi
				pop		es
				pop		ebp
				ret
%endif

L1:				cmp		al,[L253]
				je		L2
				mov		[L253],al
				push	ebx
				push	ecx
				push	edx
				xor		ah,ah
				mov		cl,[_granularity]
				rol		al,cl
				mov		dx,ax
				mov		ax,4f05H
				xor		bx,bx
				push	edx
				int		10H
				pop		edx
                mov     ax,4f05H
                mov     bx,1
                int     10H
				pop		edx
				pop		ecx
				pop		ebx
L2:				ret

matrox_page:	; Matrox series
				cmp		al,[L253]
				je		L4
				mov		[L253],al
				push	dx
				mov		dx,0x3de
				mov		ah,al
				mov		al,4
				out		dx,ax
				pop		dx
				ret

permedia_page:	; Permedia 2
				cmp		al,[L253]
				je		L4
				mov		[L253],al
				push	ax
				push	bx
				push	dx
				mov		bl,0xf8
				mov		bh,al
				and		bh,7	; page 0..7
				mov    dx,0x3CE
				mov    ah,9
				in     al,dx
				xchg   ah,al
				out    dx,al
				inc    dx
				in     al,dx
				and    al,bl
				or     al,bh
				out    dx,al
				dec    dx
				xchg   ah,al
				out    dx,al
				pop		dx
				pop		bx
				pop		ax
				ret

wd_page:		; Western digital / Paradise / Cirrus Logic
L3:				cmp		al,[L253]
				je		L4
				mov		[L253],al
				push	dx
				mov		dx,03ceH
				shl		al,04H
				mov		ah,al
				mov		al,09H
				out		dx,ax
				pop		dx
L4:				ret

L5:				cmp		al,[L253]
				je		L6
				mov		[L253],al
				mov		ah,al
				xor		ah,02H
				push	edx
				mov		dx,03c4H
				mov		al,0eH
				out		dx,al
				inc		dx
				in		al,dx
				and		al,0f0H
				or		al,ah
				out		dx,al
				pop		edx
L6:				ret

L7:				cmp		al,[L253]
				je		L8
				mov		[L253],al
				push	cx
				push	dx
				mov		dx,03d4H
				mov		ch,al
				and		al,0fH
				mov		cl,al
				mov		ax,4838H
				out		dx,ax
				mov		ax,0a539H
				out		dx,ax
				mov		al,31H
				out		dx,al
				inc		dl
				in		al,dx
				or		al,09H
				out		dx,al
				dec		dl
				mov		al,35H
				out		dx,al
				inc		dl
				in		al,dx
				and		al,0f0H
				or		al,cl
				out		dx,al
				dec		dl
				mov		al,51H
				out		dx,al
				inc		dl
				in		al,dx
				and		al,0f3H
				shr		ch,02H
				and		ch,0cH
				or		al,ch
				out		dx,al
				pop		dx
				pop		cx
L8:				ret

L9:				cmp		al,[L253]
				je		L10
				mov		[L253],al
				push	cx
				push	dx
				mov		dx,03d4H
				mov		cl,al
				mov		ax,4838H
				out		dx,ax
				mov		ax,0a539H
				out		dx,ax
				mov		al,6aH
				mov		ah,cl
				out		dx,ax
				pop		dx
				pop		cx
L10:			ret

L11:			cmp		al,[L253]
				je		L12
				mov		[L253],al
				push	dx
				mov		ah,al
				mov		dx,6002H
				out		dx,ax
				pop		dx
L12:			ret

L13:			cmp		al,[L253]
				je		L14
				mov		[L253],al
				mov		ah,al
				shl		ah,4
				or		al,ah
				push	edx
				mov		dx,03cdH
				out		dx,al
				pop		edx
L14:			ret

L15:			cmp		al,[L253]
				je		L16
				mov		[L253],al
				mov		ah,al
				cli
				push	edx
				mov		edx,000001ceH
				mov		al,0b2H
				out		dx,al
				inc		dl
				in		al,dx
				and		al,0e1H
				shl		ah,1
				or		ah,al
				mov		al,0b2H
				dec		dl
				out		dx,ax
				pop		edx
				sti
L16:			ret
L17:			cmp		al,[L253]
				je		L18
				mov		[L253],al
				mov		ah,al
				shl		ah,3
				or		al,ah
				or		al,40H
				push	edx
				mov		dx,03cdH
				out		dx,al
				pop		edx
L18:			ret

L19:			cmp		al,[L253]
				je		L20
				mov		[L253],al
				push	ecx
				mov		cl,[_granularity]
				shl		al,cl
				mov		ah,al
				push	edx
				mov		dx,03d6H
				mov		al,10H
				out		dx,al
				inc		dx
				in		al,dx
				and		al,0c0H
				or		al,ah
				out		dx,al
				pop		edx
				pop		ecx
L20:			ret

L21:			cmp		al,[L253]
				je		L23
				mov		[L253],al
L23:			ret

nVidia:			cmp		al,[L253]
				je		L23
				mov		[L253],al

				push   dx
				push   ax
				mov	   dx,0x3C4
				in	   al,dx
				push   ax
				push   dx
				mov	   dx,0x3D0
				in	   ax,dx
				cmp	   ax,0xffff
				jne	   nVidia4

				pop	   dx
				mov	   ax,0x5706
				out	   dx,ax
				pop	   ax
				out	   dx,al
				pop	   ax
				jp	   nVidia2

nVidia4:		mov	   ax,0x5706
				out	   dx,ax
				pop	   dx
				pop	   ax
				out	   dx,al
				pop	   ax

nVidia2:		push   	ax
				mov		ah,al
				shl	   	ah,1
				mov		dx,0x3d4
				in	   	al,dx
				push   	ax
				mov	   	al,0x1D
				out	   	dx,ax
				inc	   	ax
				out	   	dx,ax
				pop	   	ax
				out	   	dx,al
				pop	   	ax
				pop	   	dx
				ret

;
; Set draw mode
;
_set_ppop:		mov		ax,[esp+4]
				cmp		al,9
				jc		_set_ppop2
				xor		eax,eax
_set_ppop2:		push	dword [_ppop]
				mov		[_ppop],al
				movzx	eax,al
				mov		eax,[eax*4+L246]
				mov		[L243],eax
				cmp		al,8
				je		L25
				movzx	eax,byte [_ppop]
				cmp		byte[_lfb],0
				jz		ppop3
				mov		eax,[eax*4+lL245]
				mov		[L242],eax
				jmp		ppop4
ppop3:			mov		eax,[eax*4+L245]
				mov		[L242],eax
ppop4:			movzx	eax,byte [_ppop]
				mov		eax,[eax*4+ftable]
				mov		[fill],eax
				movzx	eax,byte [_ppop]
				mov		eax,[eax*4+wtable]
				mov		[MemPixel],eax
L25:			pop		eax
				ret

_test_mmx:		pushfd
				pop		eax
				push	ebx
				mov		edx,eax
				xor		eax,200000H
				push	eax
				popfd
				pushfd
				pop		eax
				cmp		eax,edx
				mov		eax,0
				jz		mmx2
				mov		eax,1
				cpuid
				test	edx,800000H
				mov		eax,0
				jz		mmx2
				inc		eax
				emms
				emms
mmx2:			mov		[_mmx],eax
				pop		ebx
				ret

_reset_mmx:		push	eax
				mov		eax,[_mmx]
				and		eax,eax
				jz		_set_mmx22
				emms
				dec		dword [_mmx_state]
_set_mmx22:		pop		eax
				ret

_set_mmx:		push	eax
				mov		eax,[_mmx]
				and		eax,eax
				jz		_set_mmx2
				emms
				inc		dword [_mmx_state]
_set_mmx2:		pop		eax
				ret

_is_mmx:		push	eax
				mov		eax,[_mmx]
				and		eax,eax
				pop		eax
				ret

mmx_color:		mov		ah,al
				push	ax
				push	ax
				pop		eax
				mov		[mmxtmp],eax
				mov		[mmxtmp+4],eax
				movq	mm0,[mmxtmp]
dummy:		ret

__degraduj:		push	edi
				push 	esi
				push 	ecx
				push 	ebx
				mov		edi,[esp+20] ; dynamika
				mov		esi,[esp+24] ; statika
				mov		ecx,[esp+28] ; bmp
				mov		ebx,[esp+32] ; kolko

degraduj2:		mov		eax,[edi]
				mov		edx,[esi]
				push	ebx
				mov		ebx,eax
				and		ebx,0xF0F0F0F0	; vymaskuj id 
				test	eax,eax	 	; je tam nejaka	dynamika ?
				jz		nieje2			; skok ak tam nieje	vobec nic
				and		al,0x0F		; je v 1 bajte dyn.	?
				jz		byte2		; nie zachovaj dl
				dec		al
				or		al,bl
				or		dl,dl
				jnz		byte2
				mov		dl,al
byte2:			and		ah,0x0F		; je v 1 bajte statika ?
				jz		byte3
				dec		ah
				or		ah,bh
				or		dh,dh
				jnz		byte3
				mov		dh,ah
byte3:			rol		eax,16
				rol		edx,16
				rol		ebx,16
				and		al,0x0F		; je v 1 bajte statika ?
				jz		byte4
				dec		al
				or		al,bl
				or		dl,dl
				jnz		byte4
				mov		dl,al
byte4:			and		ah,0x0F		; je v 1 bajte statika ?
				jz		byte5
				dec		ah
				or		ah,bh
				or		dh,dh
				jnz		byte5
				mov		dh,ah
byte5:			rol		edx,16
				rol		eax,16
nieje2:			mov		[ecx],edx		; urob vysledny	bajt
				mov		[edi],eax
				add		edi,4
				add		esi,4
				add		ecx,4
				pop		ebx
				dec		ebx
				jnz		degraduj2
				pop		ebx
				pop		ecx
				pop		esi
				pop		edi
				ret

Read3D4:        mov     dx,0x3d4
		        out     dx,al
		        mov     ah,al
		        inc     dx
		        in      al,dx
		        xchg    ah,al
		        dec     dx
		        ret

Write3D4:       mov     dx,0x3d4
                out     dx,al
				xchg    ah,al
				inc     dx
				out     dx,al
				xchg    ah,al
				dec     dx
				ret

FastBuffer:     mov     ax,0x4838        ; extensions enable (enable extended registers)
		        call    Write3D4        ; write(3d4h, 38h, 48h)
		        mov     ax,0xA039       ; extensions enable2
		        call    Write3D4        ; write(3d4h, 39h, a0h)
		        mov     al,0x40          ; bit 0: if set enables 8514/A mode
		        call    Read3D4         ;   * 3: (801,805,928) Fast Write Buffer ON *
		        or      ah,8          ;     6: (801,805,928) Zero Wait State OFF (EISA)
		        call    Write3D4        ; set bit 3 to ON
		        mov     ax,0x38        ; disable extended registers
		        call    Write3D4        ; write(3d4h, 38h, 00h)
		        mov     ax,0x39        ; disable2
		        call    Write3D4        ; write(3d4h, 39h, 00h)
				ret
				
section	.data
L242			DD		pset
L243			DD		tset
fill			dd		fset
MemPixel		dd		wset
lMemPixel		dd		wset

L245			DD		pset
				DD		pxorr
				DD		pandd
				DD		porr
				dd		ppluss
				dd		pminuss
				dd		pnott
				dd		preplace
				dd		pset

lL245			 DD		 lpset
				DD		lpxorr
				DD		lpandd
				DD		lporr
				dd		lppluss
				dd		lpminuss
				dd		lpnott
				dd		lpset
				dd		lpset

L246			DD		tset ; ppop	table
				DD		txor
				DD		tand
				DD		tor
				dd		tset
				dd		tset
				dd		tset
				dd		tset
				dd		ttransp

ftable			DD		fset
				DD		fxor
				DD		fand
				DD		for
				dd		fplus
				dd		fminus
				dd		fnot
				dd		freplace
				dd		fset

wtable			DD		wset
				DD		wxorr
				DD		wandd
				DD		worr
				dd		wpluss
				dd		wminuss
				dd		wnott
				dd		wset
				dd		wset

rtable			DD		rset
				DD		rxorr
				DD		randd
				DD		rorr
				dd		rpluss
				dd		rminuss
				dd		rnott
				dd		rset
				dd		rtransp

L247			DB		00H,00H,00H,00H
L248			DB		00H,00H,00H,00H
L249			DB		00H,00H,00H,00H
L250			DB		00H,00H,00H,00H
L251			DB		00H,00H,00H,00H
L252			DB		00H,00H,00H,00H,00H,00H,00H,00H
				DB		00H,00H,00H,00H,00H,00H,00H,00H
				DB		00H,00H,00H,00H,00H,00H,00H,00H
				DB		00H,00H,00H,00H

L253			DB		0ffH,00H,00H,00H
minusone		dd		-1,-1

set_bank_proc	DD		L1

L257			DD		L1
				DD		L3
				DD		L5
				DD		L7
				DD		L9
				DD		L11
				DD		L13
				DD		L15
				DD		L17
				DD		L19
				dd		wd_page
				dd		L1 ; L21
				dd		nVidia
				dd		matrox_page
				dd		permedia_page

L258			DB		00H,00H,00H,00H,00H,00H,2aH,00H
				DB		00H,2aH,00H,00H,00H,2aH,2aH,00H
				DB		2aH,00H,00H,00H,2aH,00H,2aH,00H
				DB		2aH,15H,00H,00H,2aH,2aH,2aH,00H
				DB		15H,15H,15H,00H,15H,15H,3fH,00H
				DB		15H,3fH,15H,00H,15H,3fH,3fH,00H
				DB		3fH,15H,15H,00H,3fH,15H,3fH,00H
				DB		3fH,3fH,15H,00H,3fH,3fH,3fH,00H
				DB		0ffH,0ffH,0ffH,0ffH,0ffH,0ffH,0ffH,0ffH
				DB		0ffH,0ffH,0ffH,0ffH,0ffH,0ffH,0ffH,0ffH
mmxtmp			dd		0,0
vmode			dd		0
oldx			dd		0
oldy			dd		0
_ds_alias		dw		0,0
temp			dd		0

section	.bss
				global	_miro0406x
				global	_miro0808x
				global	_miro0816x
				global	_miro1220x
				global	_miro1625x
_miro0406x		resb	4*6*0x60	; only 32 .. 126
_miro0808x		resb    8*8*256
_miro0816x		resb	8*16*256
_miro1220x		resb	12*20*256
_miro1625x		resb	16*25*0x60
				END

