;
;
; Filename     : STARS.ASM
; Included from: Main assembley module
; Description  : Font and cosmetic screen handling routines.
;                This basically draws backgound screens/opening menus.
;                Have you played Red Baron or Aces of the Pacific?  It's
;                kind of like that.
;
; Written by: John McCarthy
;             1316 Redwood Lane
;             Pickering, Ontario.
;             Canada, Earth, Milky Way (for those out-of-towners)
;             L1X 1C5
;
; Internet/Usenet:  BRIAN.MCCARTHY@CANREM.COM
;         Fidonet:  Brian McCarthy 1:229/15
;   RIME/Relaynet: ->CRS
;
; Home phone, (905) 831-1944, don't call at 2 am eh!
;
; Send me your protected mode source code!
; Send me your Objects!
; But most of all, Send me a postcard!!!!
;
; Display backgound stars, 1024 stars.  Routine is  de_sineed  so   only  stars
; which will be on the  screen  are  calculated.   This  is  first  done  with
; x angle indexing, then with y angle clipping, then with z distance clipping.
; this way, stars which most likely wont be visable are not _rotate_pointd with those
; time-consuming IMUL's.  a mode has also been added to  make  non-perfect  3d
; stars.  this mode requires that the constants xstar  and ystar  be  adjusted
; by the user the make the stars "look" the same as perfectly calculated stars
; however, when these values are adjusted correctly, this routine is about 40%
; faster. this can be done because the stars are at a constant  distance  from
; the camera.
;

         .386p
         jumps

code32   segment para public use32
         assume cs:code32, ds:code32

use_half_stars  equ no         ; use full stars or half stars. (full=set to no)
perfect_stars   equ no         ; fast star calculation if no, perfect if yes.

         include pmode.ext                  ; protected mode externals
         include xmode.ext                  ; include externals for xmode routines
         include 3d.ext
         include equ.inc
         include macros.inc

         public _star_plot
         public _star_colour
         public _star_halfpoint
         public _star_step

; angle tolerence (lower untill stars get clipped)
largest  equ 150                            ; this is good without using z rotations in 320x400

; this is only used when perfect_stars = yes
zdistance equ 13800                         ; z clipping parameter, 16384 = all stars clipped
if perfect_stars eq yes
shift = 14
endif
if perfect_stars eq no
shift = 16
endif

xstar    equ ratiox*4/128                   ; these are divided by 4 to give decimals.
ystar    equ ratioy*4/128                   ; used when perfect_stars=no

number_of_stars equ 1024                    ; must be 2^some_number
cut             equ 5

smatrix         dd 6 dup (0)                ; star matrix, _ematrix*xscale*yscale
angle_count     dw 0
_star_halfpoint dw 512          ;400,600?   ; lower cutoff if use_half_stars = yes
_star_colour    dd 00c0d0e0fh               ; colours for 4 stars
_star_step      dd 2                        ; density of stars, 1 = full, 2 = half

we_is_out_of_here:
         ret

_star_plot:
         mov si,_eyeax                      ; get camera x angle
         add esi,16384                      ; 1/4 quadrant
         shr esi,5                          ; 32768/2^5 = 1024
         and esi,000007ffh

         mov ebp,esi
         add ebp,largest                    ; sweep to bottom
         sub esi,largest                    ; start from top

         cmp ebp,number_of_stars-cut
         jle s okmax
         mov ebp,number_of_stars-cut
okmax:
         cmp esi,cut
         jge s ok_min
         mov esi,cut                        ; looking almost directly up
ok_min:
         movzx esi,xn1[esi]
         movzx ebp,xn1[ebp]

         mov eax,ebp
         sub eax,esi
         shl eax,2
         mov angle_count,ax

         shl esi,2

         ;mov angle_count,number_of_stars
         ;mov esi,0                         ; uncomment this!! (along with stuff below)

         if use_half_stars eq yes
         cmp esi,_star_halfpoint
         jae s we_is_out_of_here
         endif

         call set_star_matrix               ; pre-cal star matrix

more_stars:
         mov al,sya[esi]                    ; star_y_angle
         neg al
         sub al,byte ptr _eyeay+1

         mov bl,tol[esi]                    ; bx = tol *256
         mov cl,bl

         shr cl,1
         movsx ecx,cl
         add al,cl

         cmp al,bl
         ja skipit                          ; try removing these skipit jumps!!!
doit:
         push esi

         movsx ebx,sxl[esi]                 ; star_x_location
         movsx ecx,syl[esi]
         movsx ebp,szl[esi]

         if perfect_stars eq yes
         shl ebx,7                          ; * for some accuracy
         shl ecx,7
         shl ebp,7

         call s_rotate_pointz               ; star is eligable, calculate actual screen loc

         ;add esi,35000                     ; try this too! (this is the best part)

         cmp esi,zdistance                  ; clip if too close (not on apex of sphere)
         jl abort_s
         endif

         call s_rotate_pointx               ; check tolerence in parts (saves imul's)

         if perfect_stars eq yes
         mov eax,edi                        ; some code from _make3d routine (math.inc)
         cdq
         idiv esi                           ; if fast mode selected, avoid idiv's
         mov edi,eax
         endif

         cmp di,_xmins                      ; draw single point/bullet
         jl s abort_s
         cmp di,_xmaxs
         jge s abort_s

         call s_rotate_pointy               ; x is ok, solve for y

         if perfect_stars eq yes
         mov eax,ecx
         cdq
         idiv ebp
         mov ecx,eax
         endif

         cmp cx,_ymins
         jl s abort_s
         cmp cx,_ymaxs                      ; _ymaxs1 if larger star (for high res screens)
         jge abort_s

         mov edi, _current_page             ; point to active vga page
         add bx,_xcent
         add cx,_ycent

         movzx esi,cx
         mov eax,[esi*4+_fastimultable]     ; get offset to start of line

         mov cl, bl                         ; copy to extract plane # from
         shr bx, 2                          ; x offset (bytes) = xpos/4
         add ebx, eax                       ; offset = width*ypos + xpos/4

         mov ax, map_mask_plane1            ; map mask & plane select register
         and cl, plane_bits                 ; get plane bits
         shl ah, cl                         ; get plane select value
         out_16 sc_index, ax                ; select plane

         pop eax                            ; select colour for star
         push eax
         shr eax,1
         and eax,3                          ; four colours
         mov al,byte ptr _star_colour[eax]

         and ebx,0000ffffh
         mov b [edi+ebx],al                 ; draw pixel
;        add edi,xactual/4
;        mov b [edi+ebx],al      ; draw larger pixel

; if drawing larger star, change above code to this!
;        cmp cx,_ymaxs1
;        jge s abort_s
abort_s:
         pop esi
skipit:
         if use_half_stars eq yes
         cmp si,_star_halfpoint
         jae outhandle

         else
         cmp esi,number_of_stars-1-cut
         jae s outhandle
         endif

         mov eax,_star_step
         add esi,eax
         sub angle_count,ax
         jnl more_stars

outhandle:
         ret

; pre-multiply _ematrix_row*constant_for_row
; to generate new matrix

; this can be done because we don't have any
; camera location offsets (stars are at a
; fixed distance from the camera)

         align 4

         if perfect_stars eq yes

set_star_matrix:
         mov ebx,_ematrix+0
         cmul eax,ebx,ratiox
         mov smatrix+0,eax

         if usez eq yes                     ; if not using z rotation, _ematrix+4 =0
         mov ebx,_ematrix+4
         cmul eax,ebx,ratiox
         mov smatrix+4,eax
         endif

         mov ebx,_ematrix+8
         cmul eax,ebx,ratiox
         mov smatrix+8,eax

         mov ebx,_ematrix+12
         cmul eax,ebx,ratioy
         mov smatrix+12,eax

         mov ebx,_ematrix+16
         cmul eax,ebx,ratioy
         mov smatrix+16,eax

         mov ebx,_ematrix+20
         cmul eax,ebx,ratioy
         mov smatrix+20,eax

         ret

; if perfect_stars = no, stars will not go  through  correct  3d  calculation
; but will be calculated 40% faster. you  must  set  the  values  xstar   and
; ystar  to 3d  quick  multipliers  so  this  matrix  calculation  makes  the
; stars "look" the same.  I did this by moving the camera around and  testing
; if the stars moved the same as the objects.  I did this because the objects
; go through the correct 3d calculation and this gave me a base by  which  to
; adjust these numbers.

         else

set_star_matrix:
         mov ebx,_ematrix+0
         cmul eax,ebx,xstar
         mov smatrix+0,eax

         if usez eq yes                     ; if not using z rotation, _ematrix+4 =0
         mov ebx,_ematrix+4
         cmul eax,ebx,xstar
         mov smatrix+4,eax
         endif

         mov ebx,_ematrix+8
         cmul eax,ebx,xstar
         mov smatrix+8,eax

         mov ebx,_ematrix+12
         cmul eax,ebx,ystar
         mov smatrix+12,eax

         mov ebx,_ematrix+16
         cmul eax,ebx,ystar
         mov smatrix+16,eax

         mov ebx,_ematrix+20
         cmul eax,ebx,ystar
         mov smatrix+20,eax

         ret
         endif

; _rotate_point star using smatrix (imported from math.inc)

         align 4

s_rotate_pointx:
         mov eax,smatrix+8
         imul ebp
         shrd eax,edx,shift
         mov edi,eax
         if usez eq yes
         mov eax,smatrix+4
         imul ecx
         shrd eax,edx,shift
         add edi,eax
         endif
         mov eax,smatrix+0
         imul ebx
         shrd eax,edx,shift
         add edi,eax                        ; di = new x
         ret

         align 4

s_rotate_pointy:
         mov eax,smatrix+16
         imul ecx
         shrd eax,edx,shift
         mov ecx,eax
         mov eax,smatrix+20
         imul ebp
         shrd eax,edx,shift
         add ecx,eax
         mov eax,smatrix+12
         imul ebx
         shrd eax,edx,shift
         add ecx,eax                        ; cx = new y

         mov ebp,esi
         mov ebx,edi
         ret

         if perfect_stars eq yes
         align 4

s_rotate_pointz:
         mov eax,_ematrix+32
         imul ebp
         shrd eax,edx,shift
         mov esi,eax
         mov eax,_ematrix+28
         imul ecx
         shrd eax,edx,shift
         add esi,eax
         mov eax,_ematrix+24
         imul ebx
         shrd eax,edx,shift
         add esi,eax                        ; si = new z

         ret
         endif

;        include stardata.inc

; random stars list

sxl      db  -1,-1,1,0,-1,-5,1,2
         db  -1,-2,-4,-10,-10,9,10,10
         db  -7,13,1,-14,6,-17,8,18
         db  14,18,20,-22,-1,22,-10,-18
         db  -20,25,4,16,-21,-27,-26,-7
         db  -29,-31,-26,21,33,33,31,-32
         db  20,17,3,-38,-37,22,-37,8
         db  19,-34,6,21,15,-29,-42,-36
         db  -31,-37,21,20,-2,38,46,-42
         db  -51,33,-31,1,45,-47,-38,6
         db  0,-55,-13,4,-8,-53,-21,57
         db  -45,-51,-51,-4,52,37,-62,-39
         db  -24,61,-10,53,-4,-62,-41,-44
         db  -66,40,24,9,-30,-61,-31,19
         db  47,52,69,-21,22,-36,-61,-3
         db  -45,-17,54,16,73,-6,-53,60
         db  74,73,51,-54,35,56,-43,73
         db  66,-79,-71,-32,-33,4,35,-70
         db  70,-10,-83,72,55,59,-80,83
         db  -40,-15,84,-80,69,-24,86,-30
         db  63,-76,-27,-72,-55,-39,68,83
         db  29,18,46,85,90,-3,-53,82
         db  -24,43,-91,78,92,80,90,56
         db  84,-52,90,-7,-80,30,3,-89
         db  43,88,81,-72,1,69,65,-98
         db  -3,-93,-77,-96,-97,-56,98,-20
         db  -84,96,-31,-22,-58,50,-101,-20
         db  -17,-7,-91,-14,97,-99,93,100
         db  24,-75,98,-101,91,-105,88,25
         db  101,-97,-97,-94,34,-38,-6,106
         db  -53,89,-51,-69,102,-62,106,53
         db  -67,43,-106,-109,83,32,94,-72
         db  -104,-108,102,56,15,95,99,-110
         db  -4,-87,-39,-103,85,-100,-41,-80
         db  -111,-108,90,80,98,50,-17,108
         db  -28,26,-114,113,-44,67,110,94
         db  105,59,-18,2,29,61,-110,96
         db  113,-112,-69,106,-115,115,-37,-53
         db  2,-84,-71,-35,-70,-82,28,-110
         db  1,113,90,16,82,116,71,-83
         db  101,107,112,-10,77,118,97,64
         db  -47,93,101,-120,119,-5,-91,-45
         db  -87,-116,116,-69,-63,-67,-79,-112
         db  88,93,117,80,8,-119,106,-111
         db  -40,120,-18,-22,-119,103,-14,28
         db  -79,-36,-64,7,22,-121,-18,39
         db  -24,-122,-32,121,120,-3,-99,111
         db  -124,122,110,-45,-117,-102,-54,122
         db  123,45,-76,64,102,72,-94,24
         db  -32,-65,121,95,100,108,-124,-17
         db  -79,17,-122,-34,-72,-81,-65,108
         db  121,-124,-118,85,124,-77,33,-12
         db  -118,32,71,-94,116,125,99,-102
         db  120,-119,79,108,-122,40,29,51
         db  125,-125,98,-81,-119,25,-36,-121
         db  89,-2,9,-85,-111,101,-12,60
         db  -109,127,-107,95,102,5,-13,-105
         db  -53,66,31,84,-123,71,54,127
         db  -64,127,113,122,-41,124,92,81
         db  -115,84,125,123,24,-86,117,2
         db  123,125,-45,-49,95,-49,-29,105
         db  -128,-13,-128,20,-3,9,-16,28
         db  -32,-101,106,-123,82,-125,-73,-123
         db  102,104,-34,45,125,85,-73,121
         db  -103,100,-82,-87,38,112,-35,77
         if use_half_stars eq no
         db  127,-79,-104,-59,-52,-19,-58,-18
         db  -121,121,56,65,79,-117,-9,80
         db  -43,-68,83,74,101,-56,-9,13
         db  -2,-121,117,49,-122,29,72,126
         db  -10,111,32,-106,114,103,46,-77
         db  -100,90,110,118,-85,-121,23,57
         db  -119,22,-68,123,-124,-121,-104,114
         db  44,-12,-124,58,122,-87,25,42
         db  -80,-79,-28,-116,112,121,-31,47
         db  -18,-99,123,100,-115,-40,118,54
         db  108,-65,-90,39,-112,122,-126,113
         db  53,27,30,-82,50,59,-1,83
         db  -116,-3,123,-91,21,-116,-17,14
         db  120,-25,58,112,-89,-33,-2,-51
         db  80,-121,-86,67,77,-104,69,-22
         db  -22,21,120,24,90,86,30,-41
         db  -114,-117,-93,31,-120,-78,104,-88
         db  111,109,117,-123,-46,-95,-122,22
         db  -122,-87,4,72,110,115,-114,-104
         db  -122,36,-90,-118,117,26,-53,54
         db  -61,118,-114,94,94,100,-80,-25
         db  119,-55,106,40,-104,109,118,-52
         db  -113,79,-102,35,-9,111,72,-54
         db  -12,-15,87,-110,-109,65,7,22
         db  -66,-116,75,-95,-93,102,30,-23
         db  40,-6,62,32,-114,-111,91,-115
         db  -65,-28,-3,72,-82,-52,35,110
         db  112,9,52,-6,-75,-56,81,92
         db  44,-57,-31,-35,-43,80,-64,67
         db  110,-112,93,-105,-6,-14,-46,-60
         db  -83,-40,101,29,100,-97,-1,106
         db  108,-107,54,-89,-60,-107,77,-39
         db  -103,-81,-85,6,5,105,44,-91
         db  85,63,97,-21,61,9,-97,-45
         db  -55,-89,75,102,-104,-101,-55,29
         db  47,60,29,-98,-86,-20,-83,94
         db  -8,-86,44,-97,-63,14,-97,-78
         db  10,88,-88,-83,-81,89,-83,97
         db  77,37,-94,-64,37,85,80,88
         db  25,-76,-65,81,-93,39,73,-93
         db  -61,-93,9,90,63,20,-45,-10
         db  -84,88,-91,89,90,-90,-71,63
         db  -19,-8,-70,81,79,-83,29,49
         db  -40,-67,-84,41,-76,27,-71,-69
         db  -4,-84,-17,31,-49,-24,79,71
         db  65,-17,-42,80,6,16,-77,-79
         db  -77,-64,14,-41,-2,36,52,76
         db  36,71,73,10,30,70,-70,-28
         db  -43,45,-51,70,70,-61,-71,57
         db  66,32,5,-68,3,65,66,-62
         db  1,65,62,-65,28,16,60,40
         db  -14,-50,-22,39,-35,59,-46,-28
         db  55,13,50,-40,-24,52,47,-26
         db  -7,-39,-49,-47,43,-51,50,23
         db  10,20,-49,-46,35,44,35,37
         db  -35,-3,9,-37,-2,-32,-33,40
         db  2,-41,18,-21,-23,-25,30,22
         db  35,-9,34,12,20,-29,-31,-1
         db  30,30,-27,-27,-28,-13,-27,-23
         db  0,1,-14,-17,-14,-20,-17,-14
         db  14,2,17,9,12,15,11,12
         db  -11,-10,8,-9,6,-9,7,1
         db  5,2,-6,-5,1,-2,-1,-1
         endif

syl      db  -128,-128,-128,-128,-128,-128,-128,-128
         db  -128,-128,-128,-128,-128,-128,-128,-128
         db  -128,-128,-128,-128,-127,-127,-127,-127
         db  -127,-127,-127,-127,-127,-126,-126,-126
         db  -126,-126,-126,-126,-125,-125,-125,-125
         db  -125,-125,-124,-124,-124,-124,-124,-124
         db  -123,-123,-123,-123,-123,-122,-122,-122
         db  -122,-122,-121,-121,-121,-121,-120,-120
         db  -120,-120,-120,-119,-119,-119,-119,-118
         db  -118,-118,-118,-118,-117,-117,-117,-117
         db  -116,-116,-116,-116,-115,-115,-115,-115
         db  -114,-114,-114,-114,-113,-113,-113,-113
         db  -112,-112,-112,-112,-111,-111,-111,-110
         db  -110,-110,-110,-109,-109,-109,-109,-108
         db  -108,-108,-108,-107,-107,-107,-106,-106
         db  -106,-106,-105,-105,-105,-104,-104,-104
         db  -104,-103,-103,-103,-103,-102,-102,-102
         db  -101,-101,-101,-101,-100,-100,-100,-99
         db  -99,-99,-99,-98,-98,-98,-97,-97
         db  -97,-97,-96,-96,-96,-95,-95,-95
         db  -95,-94,-94,-94,-93,-93,-93,-93
         db  -92,-92,-92,-91,-91,-91,-91,-90
         db  -90,-90,-89,-89,-89,-89,-88,-88
         db  -88,-87,-87,-87,-87,-86,-86,-86
         db  -85,-85,-85,-85,-84,-84,-84,-83
         db  -83,-83,-83,-82,-82,-82,-81,-81
         db  -81,-81,-80,-80,-80,-79,-79,-79
         db  -79,-78,-78,-78,-77,-77,-77,-77
         db  -76,-76,-76,-75,-75,-75,-75,-74
         db  -74,-74,-73,-73,-73,-73,-72,-72
         db  -72,-71,-71,-71,-71,-70,-70,-70
         db  -70,-69,-69,-69,-68,-68,-68,-68
         db  -67,-67,-67,-66,-66,-66,-66,-65
         db  -65,-65,-64,-64,-64,-64,-63,-63
         db  -63,-63,-62,-62,-62,-61,-61,-61
         db  -61,-60,-60,-60,-60,-59,-59,-59
         db  -58,-58,-58,-58,-57,-57,-57,-57
         db  -56,-56,-56,-55,-55,-55,-55,-54
         db  -54,-54,-54,-53,-53,-53,-52,-52
         db  -52,-52,-51,-51,-51,-51,-50,-50
         db  -50,-50,-49,-49,-49,-48,-48,-48
         db  -48,-47,-47,-47,-47,-46,-46,-46
         db  -46,-45,-45,-45,-44,-44,-44,-44
         db  -43,-43,-43,-43,-42,-42,-42,-42
         db  -41,-41,-41,-41,-40,-40,-40,-39
         db  -39,-39,-39,-38,-38,-38,-38,-37
         db  -37,-37,-37,-36,-36,-36,-36,-35
         db  -35,-35,-35,-34,-34,-34,-33,-33
         db  -33,-33,-32,-32,-32,-32,-31,-31
         db  -31,-31,-30,-30,-30,-30,-29,-29
         db  -29,-29,-28,-28,-28,-28,-27,-27
         db  -27,-27,-26,-26,-26,-25,-25,-25
         db  -25,-24,-24,-24,-24,-23,-23,-23
         db  -23,-22,-22,-22,-22,-21,-21,-21
         db  -21,-20,-20,-20,-20,-19,-19,-19
         db  -19,-18,-18,-18,-18,-17,-17,-17
         db  -17,-16,-16,-16,-16,-15,-15,-15
         db  -15,-14,-14,-14,-14,-13,-13,-13
         db  -13,-12,-12,-12,-12,-11,-11,-11
         db  -11,-10,-10,-10,-10,-9,-9,-9
         db  -9,-8,-8,-8,-8,-7,-7,-7
         db  -7,-6,-6,-6,-6,-5,-5,-5
         db  -5,-4,-4,-4,-4,-3,-3,-3
         db  -3,-2,-2,-2,-2,-1,-1,-1
         db  0,0,0,0,1,1,1,1
         if use_half_stars eq no
         db  2,2,2,2,3,3,3,3
         db  4,4,4,4,5,5,5,5
         db  6,6,6,6,7,7,7,7
         db  8,8,8,8,9,9,9,9
         db  10,10,10,10,11,11,11,11
         db  12,12,12,12,13,13,13,13
         db  14,14,14,14,15,15,15,15
         db  16,16,16,16,17,17,17,17
         db  18,18,18,18,19,19,19,19
         db  20,20,20,20,21,21,21,21
         db  22,22,22,22,23,23,23,23
         db  24,24,24,24,25,25,25,26
         db  26,26,26,27,27,27,27,28
         db  28,28,28,29,29,29,29,30
         db  30,30,30,31,31,31,31,32
         db  32,32,32,33,33,33,34,34
         db  34,34,35,35,35,35,36,36
         db  36,36,37,37,37,37,38,38
         db  38,38,39,39,39,40,40,40
         db  40,41,41,41,41,42,42,42
         db  42,43,43,43,43,44,44,44
         db  45,45,45,45,46,46,46,46
         db  47,47,47,47,48,48,48,49
         db  49,49,49,50,50,50,50,51
         db  51,51,51,52,52,52,53,53
         db  53,53,54,54,54,54,55,55
         db  55,56,56,56,56,57,57,57
         db  57,58,58,58,59,59,59,59
         db  60,60,60,60,61,61,61,62
         db  62,62,62,63,63,63,63,64
         db  64,64,65,65,65,65,66,66
         db  66,67,67,67,67,68,68,68
         db  69,69,69,69,70,70,70,70
         db  71,71,71,72,72,72,72,73
         db  73,73,74,74,74,74,75,75
         db  75,76,76,76,76,77,77,77
         db  78,78,78,78,79,79,79,80
         db  80,80,80,81,81,81,82,82
         db  82,82,83,83,83,84,84,84
         db  84,85,85,85,86,86,86,86
         db  87,87,87,88,88,88,88,89
         db  89,89,90,90,90,90,91,91
         db  91,92,92,92,92,93,93,93
         db  94,94,94,94,95,95,95,96
         db  96,96,96,97,97,97,98,98
         db  98,98,99,99,99,100,100,100
         db  100,101,101,101,102,102,102,102
         db  103,103,103,103,104,104,104,105
         db  105,105,105,106,106,106,107,107
         db  107,107,108,108,108,108,109,109
         db  109,109,110,110,110,111,111,111
         db  111,112,112,112,112,113,113,113
         db  113,114,114,114,114,115,115,115
         db  115,116,116,116,116,117,117,117
         db  117,117,118,118,118,118,119,119
         db  119,119,119,120,120,120,120,121
         db  121,121,121,121,122,122,122,122
         db  122,123,123,123,123,123,123,124
         db  124,124,124,124,124,125,125,125
         db  125,125,125,125,126,126,126,126
         db  126,126,126,126,126,127,127,127
         db  127,127,127,127,127,127,127,127
         db  127,127,127,127,127,127,127,127
         endif

szl      db  -1,0,-1,-3,3,-2,-5,5
         db  6,7,-8,-2,1,5,5,7
         db  -12,5,-15,7,-15,-4,-16,2
         db  -13,-8,2,3,-23,-4,21,-18
         db  16,-5,-27,21,18,-11,-15,29
         db  -11,-7,19,-25,-4,3,-15,-17
         db  29,-32,-38,3,12,32,14,-40
         db  -37,24,-42,-38,-41,33,15,27
         db  -34,-29,-42,42,-48,29,15,-28
         db  1,38,41,-52,25,25,-39,-54
         db  -55,-5,54,55,55,21,53,7
         db  -39,-31,-31,59,-31,-49,1,-49
         db  -58,13,-63,-35,64,20,50,-50
         db  8,-53,62,66,-62,-31,61,66
         db  -51,-46,-9,-68,67,-63,-40,72
         db  -58,71,49,-72,-10,-75,-54,-46
         db  -15,20,56,55,-69,-54,-66,-27
         db  -43,11,-37,73,-74,-81,72,41
         db  -42,-82,-7,-41,61,57,26,11
         db  74,83,11,29,-50,82,-3,-82
         db  -60,42,-84,-51,69,-80,56,29
         db  84,-88,76,27,0,90,74,-40
         db  88,-81,-19,-49,-11,46,20,-75
         db  39,78,-27,94,-51,-91,-96,-37
         db  -86,-38,50,-65,-97,68,-72,5
         db  -98,-32,-62,25,-23,82,-7,97
         db  54,-25,-96,-99,-83,-88,-4,99
         db  100,101,-47,101,-32,-28,41,20
         db  100,71,-32,24,-49,0,55,-102
         db  -25,-43,-43,-50,99,98,105,2
         db  -93,-58,-94,82,32,-89,11,-94
         db  85,-99,-25,-5,-70,-104,53,-83
         db  35,-19,-38,94,-109,55,-47,14
         db  110,-70,-105,43,-71,49,103,-79
         db  14,32,66,-79,53,-101,-112,29
         db  -110,-110,2,-3,104,-92,-30,-64
         db  -45,97,-113,-115,110,96,-34,62
         db  19,31,-94,45,-16,-13,110,-104
         db  116,81,-93,111,-94,-84,-114,42
         db  -118,-30,75,-117,84,-15,-94,84
         db  60,48,-38,118,89,6,67,99
         db  -110,-74,61,2,-4,119,77,-112
         db  82,30,-27,-99,-103,100,91,-45
         db  -82,76,26,-91,120,23,-57,-50
         db  114,17,120,-120,27,-64,-122,118
         db  -94,-117,-105,-122,120,-23,-122,115
         db  120,13,-119,-20,22,123,-74,-53
         db  -7,16,-55,115,-41,-71,111,16
         db  -7,-116,98,105,70,100,-82,-122
         db  120,-107,27,-80,74,61,19,-124
         db  96,123,-30,120,-103,-97,-108,62
         db  29,19,43,92,-18,-100,120,125
         db  -46,121,-104,-85,-47,3,-77,74
         db  37,-44,-98,-66,-36,119,-123,-116
         db  14,19,79,-98,44,-124,-122,-39
         db  -90,126,126,94,62,-77,-127,-112
         db  66,0,69,83,-75,-127,-127,-73
         db  115,108,-124,-96,32,105,-116,-7
         db  -111,6,57,36,120,-29,-88,-99
         db  55,95,-25,33,-126,-95,48,127
         db  -34,-25,-120,-119,-85,-119,124,-73
         db  -5,127,12,-127,-128,127,-128,-125
         db  -125,-80,71,-36,97,27,105,-38
         db  76,-74,123,119,-24,94,105,38
         db  -77,-80,98,94,-122,61,-124,-102
         if use_half_stars eq no
         db  14,-101,-75,-114,117,-127,-115,-127
         db  -44,40,-115,110,-101,-53,127,99
         db  120,108,-97,-105,-78,-116,-128,-128
         db  -128,-43,50,117,-40,124,104,-19
         db  127,62,-124,-72,57,-75,-119,101
         db  -80,90,-64,-48,95,-41,-126,113
         db  46,125,107,32,29,-42,73,-55
         db  -120,-127,29,112,33,93,-125,-120
         db  -99,99,-124,-52,-58,34,122,117
         db  125,-80,26,-76,-54,-120,44,113
         db  -64,108,88,-120,-58,27,9,54
         db  113,122,121,95,114,-111,-126,-94
         db  -50,125,21,-87,-124,48,123,-125
         db  -34,122,-111,54,87,120,124,-114
         db  94,31,-90,104,96,68,102,-122
         db  121,-122,-27,-122,-84,-89,119,-117
         db  47,-40,80,-119,-27,95,-66,-86
         db  51,-55,-34,4,-114,-78,-15,120
         db  -10,85,-122,97,50,-38,-44,63
         db  -4,115,82,27,29,-118,108,-108
         db  -105,24,40,74,74,66,89,117
         db  8,106,53,112,59,-48,10,107
         db  39,-89,62,-114,118,-40,-94,-106
         db  117,117,78,43,-47,-98,117,-116
         db  -98,16,-89,-69,70,-56,-113,114
         db  108,115,-99,111,24,-35,-71,-13
         db  95,-112,114,88,-82,-103,108,28
         db  -22,-114,-102,-114,86,98,78,65
         db  -104,-98,108,106,104,77,92,88
         db  14,-5,-61,-39,-112,-111,101,93
         db  -74,-104,-42,106,45,52,-110,26
         db  14,25,94,63,90,-21,75,100
         db  -32,71,65,107,-107,-14,97,56
         db  -64,-85,-42,103,85,-105,41,95
         db  -90,-57,71,18,3,25,-89,99
         db  -92,83,-99,32,56,-101,59,-38
         db  101,54,-91,30,-79,-100,25,-63
         db  99,45,-48,54,-58,-42,52,-8
         db  -61,90,25,-74,-90,45,52,38
         db  -93,-59,70,-49,21,85,59,-17
         db  71,-14,92,-21,-68,-91,80,91
         db  38,-23,3,-18,-5,-6,56,-63
         db  -88,88,-55,34,-39,-30,82,71
         db  77,-56,-22,-76,40,80,47,-50
         db  84,-4,81,-78,67,79,-23,-41
         db  -49,79,69,-1,79,-79,-21,-8
         db  -17,-47,76,66,-78,67,55,0
         db  -67,-24,-16,73,67,22,24,-68
         db  58,56,-52,9,-7,-38,5,39
         db  18,-61,-69,-11,67,13,5,25
         db  -66,-8,-17,3,57,61,19,48
         db  -61,36,57,46,-50,6,38,52
         db  17,56,-27,-42,-52,-21,28,48
         db  54,37,22,-25,-29,-13,-12,44
         db  -50,45,7,-18,32,-16,30,26
         db  30,-46,43,-25,-44,28,27,11
         db  -41,1,-36,-34,31,-29,-22,29
         db  -4,-35,-2,31,26,-17,-11,31
         db  5,-2,12,-12,2,-25,3,13
         db  25,-25,19,-17,17,9,-13,14
         db  -13,-19,-1,14,-11,-4,8,7
         db  -8,-8,7,6,-8,2,-4,7
         db  -5,5,0,-2,3,-3,1,-1
         endif

sya      db  79,28,-85,-119,2,74,-117,-18
         db  1,6,110,70,58,-44,-43,-39
         db  106,-49,-123,42,-112,72,-107,-59
         db  -94,-79,-59,56,126,-71,17,96
         db  35,-71,-122,-26,33,79,85,8
         db  78,72,38,-99,-69,-60,-82,83
         db  -25,-108,-124,60,50,-25,48,-119
         db  -108,38,-123,-108,-114,28,49,36
         db  97,90,-109,-19,127,-38,-52,87
         db  63,-30,25,-127,-44,43,96,-124
         db  -128,67,8,-4,5,48,14,-59
         db  92,86,86,2,-86,-102,63,100
         db  112,-56,121,-88,2,50,27,98
         db  58,-102,-16,-6,109,83,18,-12
         db  -98,-94,-69,116,-14,106,87,1
         db  100,9,-34,-119,-70,125,96,-91
         db  -72,-53,-31,31,-109,-95,104,-79
         db  -88,58,83,16,110,-126,-19,41
         db  -86,123,67,-85,-30,-33,51,-59
         db  19,6,-59,49,-90,11,-66,113
         db  -95,42,115,89,27,109,-36,-51
         db  -14,-120,-23,-52,-64,1,25,-83
         db  10,-108,72,-87,-69,-43,-56,-102
         db  -47,23,-76,2,87,-115,-127,79
         db  -109,-81,-42,94,-128,-33,-98,61
         db  126,77,91,53,73,24,-67,8
         db  40,-75,115,119,102,-107,65,7
         db  6,2,83,5,-77,74,-47,-56
         db  -10,32,-77,54,-84,63,-41,-119
         db  -74,80,80,83,-14,14,1,-64
         db  106,-88,107,28,-52,103,-60,-107
         db  26,-112,73,65,-93,-116,-44,99
         db  50,70,-79,-22,-123,-43,-82,58
         db  1,91,113,47,-93,45,15,95
         db  58,52,-39,-96,-44,-110,121,-54
         db  118,-119,63,-66,16,-103,-75,-88
         db  -81,-23,121,-128,-11,-24,76,-41
         db  -58,52,102,-48,69,-69,12,109
         db  -1,32,101,12,101,96,-118,49
         db  -128,-75,-36,-123,-32,-69,-102,31
         db  -42,-47,-78,3,-30,-62,-40,-24
         db  111,-92,-42,63,-66,1,35,112
         db  33,53,-74,103,105,23,28,79
         db  -95,-36,-55,-99,-3,55,-84,81
         db  13,-59,5,120,54,-87,123,-10
         db  99,115,105,-126,-8,71,122,-14
         db  7,59,117,-71,-57,0,90,-82
         db  66,-59,-83,14,77,88,18,-59
         db  -67,-113,26,-23,-40,-26,93,-120
         db  10,105,-55,-93,-39,-43,57,122
         db  27,-6,73,10,103,99,105,-43
         db  -55,57,49,-31,-70,101,-12,3
         db  79,-11,-104,93,-80,-63,-91,38
         db  -52,78,-101,-87,75,-14,-119,-111
         db  -60,57,-37,99,49,-120,116,76
         db  -96,0,-3,29,42,-91,124,-108
         db  41,-64,40,-35,-90,-127,123,88
         db  17,-23,-118,-99,53,-25,-110,-66
         db  106,-62,-45,-53,13,-74,-95,-100
         db  45,-30,-72,-54,-121,97,-48,-1
         db  -75,-72,113,112,-94,112,9,-89
         db  65,3,59,-122,127,-3,123,-119
         db  117,91,-40,75,-29,55,24,76
         db  -38,-89,10,-15,-72,-30,24,-52
         db  89,-92,28,30,-116,-44,116,-102
         if use_half_stars eq no
         db  -60,100,89,108,16,121,108,122
         db  78,-51,-110,-22,-101,81,2,-28
         db  13,22,-100,-103,-91,109,125,-124
         db  127,77,-48,-17,76,-10,-25,-70
         db  2,-44,-118,88,-46,-90,-113,26
         db  91,-33,-86,-80,29,77,-121,-20
         db  48,-8,22,-54,54,77,38,-82
         db  -114,124,54,-20,-54,30,-120,-115
         db  100,27,118,80,-84,-53,9,-16
         db  5,91,-56,-91,81,115,-50,-19
         db  -86,21,32,-116,83,-56,61,-46
         db  -18,-9,-10,28,-17,-108,127,-99
         db  80,0,-57,95,-122,47,5,-124
         db  -75,7,-109,-46,32,10,0,111
         db  -29,53,96,-24,-28,40,-25,120
         db  7,-122,-73,-120,-95,-97,-11,114
         db  47,77,34,-118,73,27,-87,95
         db  -47,-83,-76,62,112,92,68,-8
         db  67,32,-127,-27,-47,-77,78,41
         db  65,-13,33,54,-55,-120,18,-110
         db  106,-56,49,-37,-37,-41,29,8
         db  -62,19,-45,-15,42,-81,-61,18
         db  50,-99,41,-116,2,-78,-102,108
         db  4,5,-35,48,80,-104,-3,-121
         db  103,58,-100,89,37,-85,-118,7
         db  -15,2,-106,-12,55,76,-91,68
         db  24,118,1,-28,96,108,-13,-54
         db  -72,-125,-109,126,28,20,-33,-39
         db  -112,106,11,12,15,-33,24,-27
         db  -59,65,-88,78,125,123,17,22
         db  93,113,-80,-11,-47,43,127,-54
         db  -59,54,-22,38,23,71,-33,14
         db  76,34,37,-3,-126,-70,-18,41
         db  -91,-102,-81,7,-26,-125,47,17
         db  105,87,-34,-57,62,53,105,-12
         db  -109,-26,-117,50,40,120,38,-80
         db  2,40,-110,51,100,-123,53,91
         db  -5,-45,84,40,89,-82,40,-68
         db  -92,-17,53,99,-112,-44,-41,-48
         db  -118,90,30,-87,54,-18,-37,71
         db  28,69,-5,-74,-98,-119,20,4
         db  46,-75,62,-72,-66,66,36,-96
         db  119,3,90,-48,-83,77,-14,-25
         db  19,92,74,-108,43,-14,39,89
         db  1,65,8,-113,25,11,-76,-85
         db  -90,8,22,-65,-4,-120,74,67
         db  72,89,-8,22,127,-21,-31,-64
         db  -108,-78,-73,-6,-18,-52,50,112
         db  25,-28,96,-59,-68,86,60,-40
         db  -53,-108,-125,70,-3,-56,-61,47
         db  -127,-69,-75,62,-20,-11,-52,-29
         db  118,37,14,-29,103,-60,35,19
         db  -52,-10,-84,96,110,-79,-43,19
         db  5,32,46,83,-88,74,-74,-20
         db  -120,-17,57,78,-34,-78,-35,-39
         db  34,125,-9,88,126,34,35,-53
         db  -126,62,-109,105,25,99,-89,-27
         db  -68,118,-66,-15,-27,85,76,0
         db  -57,-67,45,81,60,107,58,41
         db  -1,-126,25,95,27,45,89,30
         db  -93,-123,-66,-25,-92,-75,-39,-43
         db  88,92,-36,37,-100,50,-83,-11
         db  -92,-17,57,76,-18,105,11,91
         endif

xn1      db  0,0,0,0,0,0,0,0
         db  0,1,1,1,1,1,1,1
         db  1,1,2,2,2,2,2,2
         db  2,2,3,3,3,3,3,3
         db  3,3,4,4,4,4,4,4
         db  4,4,5,5,5,5,5,5
         db  5,5,6,6,6,6,6,6
         db  6,7,7,7,7,7,7,7
         db  7,8,8,8,8,8,8,8
         db  9,9,9,9,9,9,9,10
         db  10,10,10,10,10,10,11,11
         db  11,11,11,11,11,12,12,12
         db  12,12,12,12,13,13,13,13
         db  13,13,14,14,14,14,14,14
         db  14,15,15,15,15,15,15,16
         db  16,16,16,16,16,17,17,17
         db  17,17,17,18,18,18,18,18
         db  18,18,19,19,19,19,19,20
         db  20,20,20,20,20,21,21,21
         db  21,21,21,22,22,22,22,22
         db  23,23,23,23,23,23,24,24
         db  24,24,24,25,25,25,25,25
         db  25,26,26,26,26,26,27,27
         db  27,27,27,28,28,28,28,28
         db  29,29,29,29,29,30,30,30
         db  30,30,31,31,31,31,31,32
         db  32,32,32,32,33,33,33,33
         db  34,34,34,34,34,35,35,35
         db  35,36,36,36,36,36,37,37
         db  37,37,38,38,38,38,38,39
         db  39,39,39,40,40,40,40,41
         db  41,41,41,41,42,42,42,42
         db  43,43,43,43,44,44,44,44
         db  45,45,45,45,46,46,46,46
         db  47,47,47,47,48,48,48,48
         db  49,49,49,49,50,50,50,51
         db  51,51,51,52,52,52,52,53
         db  53,53,54,54,54,54,55,55
         db  55,55,56,56,56,57,57,57
         db  57,58,58,58,59,59,59,59
         db  60,60,60,61,61,61,61,62
         db  62,62,63,63,63,64,64,64
         db  64,65,65,65,66,66,66,67
         db  67,67,68,68,68,68,69,69
         db  69,70,70,70,71,71,71,72
         db  72,72,73,73,73,74,74,74
         db  75,75,75,76,76,76,77,77
         db  77,78,78,78,79,79,79,80
         db  80,80,81,81,81,82,82,82
         db  83,83,83,84,84,84,85,85
         db  85,86,86,87,87,87,88,88
         db  88,89,89,89,90,90,90,91
         db  91,92,92,92,93,93,93,94
         db  94,94,95,95,96,96,96,97
         db  97,97,98,98,98,99,99,100
         db  100,100,101,101,101,102,102,103
         db  103,103,104,104,104,105,105,106
         db  106,106,107,107,108,108,108,109
         db  109,109,110,110,111,111,111,112
         db  112,113,113,113,114,114,114,115
         db  115,116,116,116,117,117,118,118
         db  118,119,119,119,120,120,121,121
         db  121,122,122,123,123,123,124,124
         db  125,125,125,126,126,127,127,127
         db  128,128,128,129,129,130,130,130
         db  131,131,132,132,132,133,133,134
         db  134,134,135,135,136,136,136,137
         db  137,137,138,138,139,139,139,140
         db  140,141,141,141,142,142,142,143
         db  143,144,144,144,145,145,146,146
         db  146,147,147,147,148,148,149,149
         db  149,150,150,151,151,151,152,152
         db  152,153,153,154,154,154,155,155
         db  155,156,156,157,157,157,158,158
         db  158,159,159,159,160,160,161,161
         db  161,162,162,162,163,163,163,164
         db  164,165,165,165,166,166,166,167
         db  167,167,168,168,168,169,169,170
         db  170,170,171,171,171,172,172,172
         db  173,173,173,174,174,174,175,175
         db  175,176,176,176,177,177,177,178
         db  178,178,179,179,179,180,180,180
         db  181,181,181,182,182,182,183,183
         db  183,184,184,184,185,185,185,186
         db  186,186,186,187,187,187,188,188
         db  188,189,189,189,190,190,190,190
         db  191,191,191,192,192,192,193,193
         db  193,193,194,194,194,195,195,195
         db  196,196,196,196,197,197,197,198
         db  198,198,198,199,199,199,199,200
         db  200,200,201,201,201,201,202,202
         db  202,203,203,203,203,204,204,204
         db  204,205,205,205,205,206,206,206
         db  206,207,207,207,208,208,208,208
         db  209,209,209,209,210,210,210,210
         db  211,211,211,211,212,212,212,212
         db  213,213,213,213,213,214,214,214
         db  214,215,215,215,215,216,216,216
         db  216,217,217,217,217,217,218,218
         db  218,218,219,219,219,219,219,220
         db  220,220,220,221,221,221,221,221
         db  222,222,222,222,222,223,223,223
         db  223,224,224,224,224,224,225,225
         db  225,225,225,226,226,226,226,226
         db  227,227,227,227,227,228,228,228
         db  228,228,229,229,229,229,229,229
         db  230,230,230,230,230,231,231,231
         db  231,231,232,232,232,232,232,232
         db  233,233,233,233,233,234,234,234
         db  234,234,234,235,235,235,235,235
         db  235,236,236,236,236,236,236,237
         db  237,237,237,237,237,238,238,238
         db  238,238,238,239,239,239,239,239
         db  239,240,240,240,240,240,240,241
         db  241,241,241,241,241,241,242,242
         db  242,242,242,242,243,243,243,243
         db  243,243,243,244,244,244,244,244
         db  244,244,245,245,245,245,245,245
         db  245,246,246,246,246,246,246,246
         db  247,247,247,247,247,247,247,248
         db  248,248,248,248,248,248,248,249
         db  249,249,249,249,249,249,249,250
         db  250,250,250,250,250,250,251,251
         db  251,251,251,251,251,251,252,252
         db  252,252,252,252,252,252,253,253
         db  253,253,253,253,253,253,253,254
         db  254,254,254,254,254,254,254,255
         db  255,255,255,255,255,255,255,255

tol      db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,75
         db  75,74,74,73,73,73,72,72
         db  72,71,71,71,70,70,70,69
         db  69,69,68,68,68,68,67,67
         db  67,66,66,66,66,65,65,65
         db  65,64,64,64,64,64,63,63
         db  63,63,62,62,62,62,62,61
         db  61,61,61,61,60,60,60,60
         db  60,60,59,59,59,59,59,59
         db  58,58,58,58,58,58,57,57
         db  57,57,57,57,57,56,56,56
         db  56,56,56,56,56,55,55,55
         db  55,55,55,55,55,54,54,54
         db  54,54,54,54,54,54,53,53
         db  53,53,53,53,53,53,53,53
         db  52,52,52,52,52,52,52,52
         db  52,52,52,51,51,51,51,51
         db  51,51,51,51,51,51,51,50
         db  50,50,50,50,50,50,50,50
         db  50,50,50,50,50,49,49,49
         db  49,49,49,49,49,49,49,49
         db  49,49,49,49,49,48,48,48
         db  48,48,48,48,48,48,48,48
         db  48,48,48,48,48,48,48,48
         db  47,47,47,47,47,47,47,47
         db  47,47,47,47,47,47,47,47
         db  47,47,47,47,47,47,46,46
         db  46,46,46,46,46,46,46,46
         db  46,46,46,46,46,46,46,46
         db  46,46,46,46,46,46,46,46
         db  46,46,46,45,45,45,45,45
         db  45,45,45,45,45,45,45,45
         db  45,45,45,45,45,45,45,45
         db  45,45,45,45,45,45,45,45
         db  45,45,45,45,45,45,45,45
         db  45,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,43
         db  43,43,43,43,43,43,43,43
         db  43,43,43,43,43,43,43,43
         db  43,43,43,43,43,43,43,43
         db  43,43,43,43,43,43,43,43
         db  43,43,43,43,43,43,43,43
         if use_half_stars eq no
         db  43,43,43,43,43,43,43,43
         db  43,43,43,43,43,43,43,43
         db  43,43,43,43,43,43,43,43
         db  43,43,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  44,44,44,44,44,44,44,44
         db  45,45,45,45,45,45,45,45
         db  45,45,45,45,45,45,45,45
         db  45,45,45,45,45,45,45,45
         db  45,45,45,45,45,45,45,45
         db  45,45,45,45,45,45,46,46
         db  46,46,46,46,46,46,46,46
         db  46,46,46,46,46,46,46,46
         db  46,46,46,46,46,46,46,46
         db  46,46,46,47,47,47,47,47
         db  47,47,47,47,47,47,47,47
         db  47,47,47,47,47,47,47,47
         db  47,48,48,48,48,48,48,48
         db  48,48,48,48,48,48,48,48
         db  48,48,48,48,49,49,49,49
         db  49,49,49,49,49,49,49,49
         db  49,49,49,49,50,50,50,50
         db  50,50,50,50,50,50,50,50
         db  50,50,51,51,51,51,51,51
         db  51,51,51,51,51,51,52,52
         db  52,52,52,52,52,52,52,52
         db  52,53,53,53,53,53,53,53
         db  53,53,53,54,54,54,54,54
         db  54,54,54,54,55,55,55,55
         db  55,55,55,55,56,56,56,56
         db  56,56,56,56,57,57,57,57
         db  57,57,57,58,58,58,58,58
         db  58,59,59,59,59,59,59,60
         db  60,60,60,60,60,61,61,61
         db  61,61,62,62,62,62,62,63
         db  63,63,63,64,64,64,64,64
         db  65,65,65,65,66,66,66,66
         db  67,67,67,68,68,68,68,69
         db  69,69,70,70,70,71,71,71
         db  72,72,72,73,73,73,74,74
         db  75,75,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         db  255,255,255,255,255,255,255,255
         endif

code32   ends
         end
