{ VGATSR  Get Palette,Screen & Show Palette,Screen }
{$M 8192,0,0} {$F+}

uses Dos,SVGA256,Txt;

var OldInt9:procedure;
    OldSS,OldSP,MySS,MySP,Act:integer;
    Buf:array[0..4095] of byte;

{  Get_Palette  }
procedure Get_Palette;
var St:string;
begin
  Get(0,0,320,9,Buf);
  Bar(0,0,320,9,1);
  Print(0,0,14,'Pal-'); Input(32,0,14,1,32,St);
  Put(0,0,320,9,Buf);
  GetPalette(0,256,Buf);
  FileWrite(St,0,768,1,Buf);
end;
{  GetScreen  }
procedure GetScreen;
var I:integer;
    File1:file;
    St:string;
begin
  Get(0,0,320,9,Buf);
  Bar(0,0,320,9,1);
  Print(0,0,14,'Scr-'); Input(32,0,14,1,32,St);
  Put(0,0,320,9,Buf);
  GetPalette(0,256,Buf);
  Assign(File1,St); Rewrite(File1,1);
  BlockWrite(File1,Buf,768);
  for I:=0 to 24 do begin
    Get(0,I shl 3,320,8,Buf);
    BlockWrite(File1,Buf,2560);
  end;
  Close(File1);
end;
{  ShowPalette  }
procedure ShowPalette(X,Y:integer);    { 64x64 }
var I:integer;
begin
  Get(X,Y,64,64,Buf);
  for I:=0 to 255 do Bar(4*(I and 15)+X,4*(I shr 4)+Y,4,4,I);
  I:=Key;
  Put(X,Y,64,64,Buf);
end;
{  VGATSR  }
procedure VGATSR;
begin
  if Mem[0:$449]<>$13 then Exit;
  InstallFont(1,8,8,0,256,8,Mem[$F000:$FA6E]);
  case Act of
    1:Get_Palette;
    2:GetScreen;
    3:ShowPalette(128,68);
  end;
end;
{  MyInt9  }
procedure MyInt9; interrupt;
const Flag:byte=0;
var M:byte;
begin
  asm pushf end; OldInt9;
  if Flag=0 then begin
    M:=Mem[0:$417]; Act:=0;
    if M and 10=10 then Act:=1
      else if M and 9=9 then Act:=2
      else if M and 6=6 then Act:=3;
    if Act>0 then begin
      Flag:=1;
      OldSS:=SSeg; OldSP:=SPtr;
      asm cli; mov ss,MySS;  mov sp,MySP; sti end;
      VGATSR;
      asm cli; mov ss,OldSS; mov sp,OldSP; sti end;
      Flag:=0;
    end;
  end;
end;
{  InstallTSR  }
procedure InstallTSR;
begin
  if MemW[0:$180]=1001 then begin
    Writeln('VGATSR has installed');
    Writeln('Do not run it again !');
    Halt(1);
  end;
  Writeln;
  Writeln('VGATSR /320x200 256 Colors');
  Writeln('Copyright (C) 1994 by Jou-Nan Chen');
  Writeln;
  Writeln('Alt+L_Shift............Get Palette');
  Writeln('Alt+R_Shift.............Get Screen');
  Writeln('Ctrl+L_Shift..........Show Palette');
  Writeln('VGATSR Filename........Show Screen');
  MemW[0:$180]:=12346;
  GetIntVec(9,@OldInt9); SetIntVec(9,@MyInt9);
  MySS:=SSeg; MySP:=SPtr;
  Keep(ExitCode);
end;
{  ShowScreen  }
procedure ShowScreen(Name:string);
var I:integer;
    File1:file;
begin
  Assign(File1,Name); Reset(File1,1);
  BlockRead(File1,Buf,768);
  SetMode(1);
  SetPalette(0,256,Buf);
  for I:=0 to 24 do begin
    BlockRead(File1,Buf,2560);
    Put(0,I shl 3,320,8,Buf);
  end;
  Close(File1);
  I:=Key;
  SetMode(0);
end;

begin
  Width:=320;
  if ParamCount=0 then InstallTSR else begin
    if FileLen(ParamStr(1),1)<>64768 then begin
      Writeln('Picture file not found !');
      Halt(1);
    end;
    ShowScreen(ParamStr(1));
  end;
end.
