{ Show 24x24 Chinese Font }

uses SVGA256,Txt;

var FontAsc,FontSpc,FontSup:pointer;
    FileChn:string;      { 12288,29376,26280 bytes }

{  InitChinese  }
procedure InitChinese(Chn,Asc,Spc,Sup:string);
begin
  if (FileLen(Chn,1)<0) then
    begin Writeln; Writeln(''''+Chn+''' not found !'); Halt(1); end;
  if (FileLen(Asc,1)<0) then
    begin Writeln; Writeln(''''+Asc+''' not found !'); Halt(1); end;
  if (FileLen(Spc,1)<0) then
    begin Writeln; Writeln(''''+Spc+''' not found !'); Halt(1); end;
  if (FileLen(Sup,1)<0) then
    begin Writeln; Writeln(''''+Sup+''' not found !'); Halt(1); end;
  FileChn:=Chn;
  GetMem(FontAsc,12288); FileRead(Asc,0,256,48,FontAsc^);
  GetMem(FontSpc,29376); FileRead(Spc,0,408,72,FontSpc^);
  GetMem(FontSup,26280); FileRead(Sup,0,365,72,FontSup^);
end;
{  PrintC  }
procedure PrintC(Ty,X,Y,Color,BkColor,Space,Count:integer;St:string);
var Buf1,Buf2:array[0..575] of byte;    { Ty: 0=Mono, 1..4=Color }
    S1,O1,S2,O2,S3,O3,I,Hi,Lo,N,L,P:integer;
    C:word;
    File1:file;
begin
  S1:=Seg(FontAsc^); O1:=Ofs(FontSpc^);
  S2:=Seg(FontSpc^); O2:=Ofs(FontSpc^);
  S3:=Seg(FontSup^); O3:=Ofs(FontSup^);
  Assign(File1,FileChn); Reset(File1,72);
  L:=Length(St); P:=0;
  while P<L do begin
    Hi:=Ord(St[P+1]); Lo:=Ord(St[P+2]); C:=Hi shl 8+Lo;
    case C of
      $A440..$C67E,$C940..$F9FE:begin
	if Lo>$7E then Dec(Lo,34);
	N:=157*(Hi-$A4)+Lo-$40;	if N>5400 then Dec(N,408);
	if N<13094 then begin Seek(File1,N); BlockRead(File1,Buf1,1); end
	  else Move(Mem[S2:O2+6192],Buf1,72);
	Conv1to8(Buf1,Buf2,72,Color,BkColor);
	Hi:=24; Lo:=24+Space; N:=2;
      end;
      $A140..$A3BF:begin
	if Lo>$7E then Dec(Lo,34);
	N:=157*(Hi-$A1)+Lo-$40;
	Conv1to8(Mem[S2:O2+72*N],Buf2,72,Color,BkColor);
	Hi:=24; Lo:=24+Space; N:=2;
      end;
      $C6A1..$C8FE:begin
	N:=157*(Hi-$C6)+Lo-$A1;
	Conv1to8(Mem[S3:O3+72*N],Buf2,72,Color,BkColor);
	Hi:=24; Lo:=24+Space; N:=2;
      end else begin
	Conv1to8(Mem[S1:O1+48*Hi],Buf2,48,Color,BkColor);
	Hi:=16; Lo:=12+Space shr 1; N:=1;
      end;
    end;
    if Ty>0 then Colorize(Ty,Hi,24,Color,Count,Color,Buf2);
    Put(X,Y,Hi,24,Buf2);
    Inc(X,Lo); Inc(P,N);
  end;
  Close(File1);
end;

const St:array[0..3] of string[30]=
  ('wϥΥqt,',
   'qtάwkҦ,',
   'qзRϥθ귽!',
   ' Jou-Nan Chen 1994 ');
var I:integer;
begin
  SetMode(3);
  Bar(0,0,640,480,104);
  InitChinese('\et3\stdfont.24l','\et3\ascfont.24','\et3\spcfont.24',
    '\et3\spcfsupp.24');
  for I:=0 to 3 do PrintC(1,120,80+48*I,64+8*I,104,4,2,St[I]);
  I:=Key;
  SetMode(0);
end.
