REM ------------------------
REM Capital Gains Calculator
REM by Robert C. Moyers November 23, 1987
REM Modified to conform to Tax Reform of 1986
REM by C. V. Doreza April 1, 1989

	CLS
	LOCATE 4, 1
	PRINT SPACE$(23) + "Capital Gain/Loss Calculator"
	PRINT SPACE$(31) + "Version 1.09"
	LOCATE 10, 1
	PRINT SPACE$(19) + "-----------------------------------"
	PRINT SPACE$(19) + "|  Modified to conform to changes |"
	PRINT SPACE$(19) + "|  in the Tax Reform Act of 1986  |"
	PRINT SPACE$(19) + "|         by C. V. Doreza         |"
	PRINT SPACE$(19) + "|                                 |"
	PRINT SPACE$(19) + "| Copyright 1987 Robert C. Moyers |"
	PRINT SPACE$(19) + "-----------------------------------"
	LOCATE 20, 1
	PRINT SPACE$(16) + "Press Enter to acknowledge copyright notice"

	now! = TIMER
	DO WHILE (TIMER - now!) < 5
		c$ = INKEY$
		IF LEN(c$) <> 0 THEN
			IF ASC(c$) = 13 THEN
				EXIT DO
			END IF
		END IF
	LOOP
	CLS
       
REM ---------------------------------
REM 1-6 yymmdd transaction date
REM 8-28 description of transaction
REM 30-39 amount +buy -sell
REM 41-50 price per share always +
REM 52-60 number of shares +buy -sell
REM ---------------------------------

REM ---------------------------------
REM define arrays
REM ---------------------------------
	DIM pur.date$(100)
	DIM pur.amount#(100)
	DIM pur.price#(100)
	DIM pur.shares#(100)

	DIM liq.date$(100)
	DIM liq.amount#(100)
	DIM liq.price#(100)
	DIM liq.shares#(100)

	DIM stg.purdate$(50)
	DIM stg.liqdate$(50)
	DIM stg.shares#(50)
	DIM stg.liqamount#(50)
	DIM stg.puramount#(50)
	DIM stg.gain#(50)

	DIM ltg.purdate$(50)
	DIM ltg.liqdate$(50)
	DIM ltg.shares#(50)
	DIM ltg.liqamount#(50)
	DIM ltg.puramount#(50)
	DIM ltg.gain#(50)

	pur% = 0
	liq% = 0
	stg% = 0
	ltg% = 0

REM -------------------------------------
REM read input file into pur & liq arrays
REM +buy -sell

	inp.filespec$ = ""
	WHILE inp.filespec$ = ""
		LOCATE 1, 1
		PRINT SPACE$(28) + "Capital Gains Calculator"
		LOCATE 5, 1
		LINE INPUT "Input file spec (filename.ext) or END: ", inp.filespec$
		CLS
		IF inp.filespec$ = "end" OR inp.filespec$ = "END" THEN SYSTEM
		IF inp.filespec$ <> "" THEN
			GOSUB test.spec
			IF file.error% THEN
				SOUND 440, 5
				LOCATE 4, 1
				PRINT inp.filespec$ + " not found."
				inp.filespec$ = ""
			END IF
		ELSE
			SOUND 440, 5
			LOCATE 4, 1
			PRINT "Input file specification is required."
		END IF
	WEND

	OPEN inp.filespec$ FOR INPUT AS #1

	LOCATE 1, 1
	PRINT SPACE$(28) + " Capital Gains Calculator"

	old.date$ = "000000"
	WHILE NOT EOF(1)
		LINE INPUT #1, inp.record$

		IF LEN(inp.record$) < 60 THEN
			GOTO skiprec
		END IF

		inp.date$ = MID$(inp.record$, 1, 6)
		inp.year% = VAL(LEFT$(inp.date$, 2))
		inp.amount# = VAL(MID$(inp.record$, 30, 10))
		inp.price# = VAL(MID$(inp.record$, 41, 10))
		inp.shares# = VAL(MID$(inp.record$, 52, 9))

		IF (ABS(inp.amount#) < .005) OR (ABS(inp.price#)) < .005 OR (ABS(inp.shares#) < .0005) THEN
			GOTO skiprec
		END IF

		IF inp.date$ < old.date$ THEN
			err.message$ = "File is not in date order"
			GOSUB err.handler
		END IF

		old.date$ = inp.date$
		IF ((inp.shares# < 0) AND (inp.amount# > 0)) OR ((inp.shares# > 0) AND (inp.amount# < 0)) THEN
			err.message$ = "Amount and shares must have the same sign"
			GOSUB err.handler
		END IF

		IF inp.shares# < -.005 THEN
			liq% = liq% + 1
			IF liq% > 100 THEN
				CLS
				PRINT "Too many liquidations, program maximum is 100"
				SYSTEM
			END IF

			liq.date$(liq%) = inp.date$
			liq.amount#(liq%) = 0 - inp.amount#
			liq.price#(liq%) = inp.price#
			liq.shares#(liq%) = 0 - inp.shares#
		ELSE
			IF inp.shares# > .005 THEN
				pur% = pur% + 1
				IF pur% > 100 THEN
					CLS
					PRINT "Too many purchases, program maximum is 100"
					SYSTEM
				END IF
				pur.date$(pur%) = inp.date$
				pur.amount#(pur%) = inp.amount#
				pur.price#(pur%) = inp.price#
				pur.shares#(pur%) = inp.shares#
			END IF
		END IF
skiprec:
	WEND

	liqmax% = liq%
	purmax% = pur%
	purmin% = 1

REM ---------------------------------
REM first-in, first-out
REM short term if held for 6 months or less (purchased before 1988)
REM short term if held for 12 months or less (purchased after 1988)

	CLS
	LOCATE 1, 1
	PRINT SPACE$(28) + "Capital Gains Calculator"

	FOR liq% = 1 TO liqmax%
		liq.yy% = VAL(MID$(liq.date$(liq%), 1, 2))
		liq.mm% = VAL(MID$(liq.date$(liq%), 3, 2))
		liq.dd% = VAL(MID$(liq.date$(liq%), 5, 2))

		FOR pur% = purmin% TO purmax%
			pur.yy% = VAL(MID$(pur.date$(pur%), 1, 2))
			puryear% = pur.yy%
			pur.mm% = VAL(MID$(pur.date$(pur%), 3, 2))
			pur.dd% = VAL(MID$(pur.date$(pur%), 5, 2))

			IF liq.shares#(liq%) > pur.shares#(pur%) THEN
				trn.shares# = pur.shares#(pur%)
			ELSE
				trn.shares# = liq.shares#(liq%)
			END IF

			pur.shares#(pur%) = pur.shares#(pur%) - trn.shares#
			liq.shares#(liq%) = liq.shares#(liq%) - trn.shares#

			IF pur.shares#(pur%) < .0005 THEN
				purmin% = pur% + 1
				trn.puramount# = pur.amount#(pur%)
			ELSE
				trn.puramount# = pur.price#(pur%) * trn.shares#
				trn.puramount# = INT(trn.puramount# * 100 + .5) / 100
			END IF

			pur.amount#(pur%) = pur.amount#(pur%) - trn.puramount#

			IF liq.shares#(liq%) < .0005 THEN
				trn.liqamount# = liq.amount#(liq%)
			ELSE
				trn.liqamount# = liq.price#(liq%) * trn.shares#
				trn.liqamount# = INT(trn.liqamount# * 100 + .5) / 100
			END IF

			liq.amount#(liq%) = liq.amount#(liq%) - trn.liqamount#

			WHILE pur.yy% < liq.yy%
				pur.mm% = pur.mm% - 12
				pur.yy% = pur.yy% + 1
			WEND

			dif.x% = (liq.mm% - pur.mm%) * 100 + liq.dd% - pur.dd%
			IF dif.x% >= 1200 OR ((dif.x% >= 600) AND (puryear% < 88)) THEN
				ltg% = ltg% + 1
				ltg.purdate$(ltg%) = pur.date$(pur%)
				ltg.liqdate$(ltg%) = liq.date$(liq%)
				ltg.shares#(ltg%) = trn.shares#
				ltg.liqamount#(ltg%) = trn.liqamount#
				ltg.puramount#(ltg%) = trn.puramount#
				ltg.gain#(ltg%) = ltg.liqamount#(ltg%) - ltg.puramount#(ltg%)
			ELSE
				stg% = stg% + 1
				stg.purdate$(stg%) = pur.date$(pur%)
				stg.liqdate$(stg%) = liq.date$(liq%)
				stg.shares#(stg%) = trn.shares#
				stg.liqamount#(stg%) = trn.liqamount#
				stg.puramount#(stg%) = trn.puramount#
				stg.gain#(stg%) = stg.liqamount#(stg%) - stg.puramount#(stg%)
			END IF

			IF liq.shares#(liq%) < .0005 THEN
				GOTO nextliq
			END IF
		NEXT
nextliq:
	NEXT

REM -----------------------------------
REM Ask user if 1 year or for all

	select.by.year$ = ""
	WHILE select.by.year$ = ""
		LOCATE 5, 1
	       
		INPUT "Do you want limit computation of gains to a particular year"; select.by.year$
		select.by.year$ = LEFT$(select.by.year$, 1)
		IF select.by.year$ = "y" THEN select.by.year$ = "Y"
		IF select.by.year$ = "" THEN
			SOUND 440, 5
		END IF
	WEND

	tst.year% = 0
	WHILE (tst.year% <= 70) AND (select.by.year$ = "Y")
		LOCATE 6, 1
		INPUT "Please enter year for computation of gains: ", tst.year%
		IF tst.year% > 1900 THEN
			tst.year% = tst.year% - 1900
		END IF
		IF tst.year% <= 70 THEN
			SOUND 440, 5
		END IF
	WEND

REM ----------------------------------
REM print gains

	stgmin% = 1
	ltgmin% = 1
	stgmax% = stg%
	ltgmax% = ltg%

	IF stgmax% > 0 AND select.by.year$ = "Y" THEN
		stgmin% = 0
		FOR stg% = 1 TO stgmax%
			stg.year% = VAL(MID$(stg.liqdate$(stg%), 1, 2))
			IF stg.year% = tst.year% THEN
				stgmin% = stg%
				EXIT FOR
			END IF
		NEXT
		IF stgmin% > 0 THEN

			FOR stg% = stgmin% + 1 TO stgmax%
				stg.year% = VAL(MID$(stg.liqdate$(stg%), 1, 2))
				IF stg.year% > tst.year% THEN
					stgmax% = stg% - 1
					EXIT FOR
				END IF
			NEXT
	       
		END IF
	END IF

	IF ltgmax% > 0 AND select.by.year$ = "Y" THEN
		ltgmin% = 0
		FOR ltg% = 1 TO ltgmax%
			ltg.year% = VAL(MID$(ltg.liqdate$(ltg%), 1, 2))
			IF ltg.year% = tst.year% THEN
				ltgmin% = ltg%
				EXIT FOR
			END IF
		NEXT
		IF ltgmin% > 0 THEN
			FOR ltg% = ltgmin% + 1 TO ltgmax%
				ltg.year% = VAL(MID$(ltg.liqdate$(ltg%), 1, 2))
				IF ltg.year% > tst.year% THEN
					ltgmax% = ltg% - 1
					EXIT FOR
				END IF
			NEXT
		END IF
	END IF

	out.filespec$ = ""
	WHILE out.filespec$ = ""
		LOCATE 7, 1
		INPUT "Please enter output file spec : ", out.filespec$
		IF out.filespec$ = "" THEN
			SOUND 440, 5
		END IF
	WEND

	s$ = out.filespec$
	GOSUB lctouc
	out.filespec$ = s$

	IF (MID$(out.filespec$, 1, 3) = "CON") OR (MID$(out.filespec$, 1, 4) = "SCRN") THEN
		dis$ = "Y"
		pagesize% = 20
	ELSEIF MID$(out.filespec$, 1, 3) = "LPT" THEN
		lpt$ = "Y"
		pagesize% = 55
	ELSE
		pagesize% = 32000
	END IF
		
	OPEN out.filespec$ FOR OUTPUT AS #2
	lines% = pagesize%

	WHILE security$ = ""
		LOCATE 8, 1
		INPUT "Please enter name of security : ", security$
		IF security$ = "" THEN
			SOUND 440, 5
		END IF
	WEND

	tot.shares# = 0
	tot.liqamount# = 0
	tot.puramount# = 0
	tot.gain# = 0

	yer.shares# = 0
	yer.liqamount# = 0
	yer.puramount# = 0
	yer.gain# = 0

	sal.shares# = 0
	sal.liqamount# = 0
	sal.puramount# = 0
	sal.gain# = 0

REM ----------------------------------
REM Print Short Term Gain
       
	IF stgmin% > 0 THEN
		headtext$ = "Short Term Capital Gains for " + security$
		LET dc% = (71 - LEN(headtext$)) / 2
		LET header$ = STRING$(dc%, "-") + headtext$ + STRING$(dc%, "-")
		old.liqdate$ = stg.liqdate$(stgmin%)
		old.liqyear$ = LEFT$(old.liqdate$, 2)

		FOR stg% = stgmin% TO stgmax%
			stg.liqyear$ = LEFT$(stg.liqdate$(stg%), 2)

			IF old.liqdate$ <> stg.liqdate$(stg%) THEN
				GOSUB salefoot
				old.liqdate$ = stg.liqdate$(stg%)
			END IF

			IF old.liqyear$ <> stg.liqyear$ THEN
				GOSUB yearfoot
				old.liqyear$ = stg.liqyear$
			END IF

			GOSUB pagehead

			PRINT #2, USING "\    \    \    \ #######.### #########.## #########.## ##########.##"; stg.purdate$(stg%), stg.liqdate$(stg%), stg.shares#(stg%), stg.liqamount#(stg%), stg.puramount#(stg%), stg.gain#(stg%)

			sal.shares# = sal.shares# + stg.shares#(stg%)
			sal.liqamount# = sal.liqamount# + stg.liqamount#(stg%)
			sal.puramount# = sal.puramount# + stg.puramount#(stg%)
			sal.gain# = sal.gain# + stg.gain#(stg%)
		NEXT

		IF stgmax% > 0 THEN
			GOSUB salefoot
			GOSUB yearfoot
			GOSUB totlfoot
		END IF
	END IF

REM ----------------------------------
REM Print Long Term Gain

	IF ltgmin% > 0 THEN
		lines% = pagesize%
		headtext$ = "Long Term Capital Gains for " + security$
		LET dc% = (71 - LEN(headtext$)) / 2
		LET header$ = STRING$(dc%, "-") + headtext$ + STRING$(dc%, "-")
		old.liqdate$ = ltg.liqdate$(ltgmin%)
		old.liqyear$ = LEFT$(old.liqdate$, 2)

		FOR ltg% = ltgmin% TO ltgmax%
			ltg.liqyear$ = LEFT$(ltg.liqdate$(ltg%), 2)

			IF old.liqdate$ <> ltg.liqdate$(ltg%) THEN
				GOSUB salefoot
				old.liqdate$ = ltg.liqdate$(ltg%)
			END IF

			IF old.liqyear$ <> ltg.liqyear$ THEN
				GOSUB yearfoot
				old.liqyear$ = ltg.liqyear$
			END IF

			GOSUB pagehead

			PRINT #2, USING "\    \    \    \ #######.### #########.## #########.## ##########.##"; ltg.purdate$(ltg%), ltg.liqdate$(ltg%), ltg.shares#(ltg%), ltg.liqamount#(ltg%), ltg.puramount#(ltg%), ltg.gain#(ltg%)

			sal.shares# = sal.shares# + ltg.shares#(ltg%)
			sal.liqamount# = sal.liqamount# + ltg.liqamount#(ltg%)
			sal.puramount# = sal.puramount# + ltg.puramount#(ltg%)
			sal.gain# = sal.gain# + ltg.gain#(ltg%)
		NEXT

		IF ltgmax% > 0 THEN
			GOSUB salefoot
			GOSUB yearfoot
			GOSUB totlfoot
		END IF
	END IF
       
	GOSUB endpage

	CLOSE #1
	CLOSE #2

	SYSTEM

REM ----------------------------------
REM Subroutine to print total when liquidation date changes

salefoot:
	tot.shares# = tot.shares# + sal.shares#
	tot.liqamount# = tot.liqamount# + sal.liqamount#
	tot.puramount# = tot.puramount# + sal.puramount#
	tot.gain# = tot.gain# + sal.gain#

	yer.shares# = yer.shares# + sal.shares#
	yer.liqamount# = yer.liqamount# + sal.liqamount#
	yer.puramount# = yer.puramount# + sal.puramount#
	yer.gain# = yer.gain# + sal.gain#

	sal.shares# = INT(sal.shares# * 1000 + .5) / 1000
	sal.liqamount# = INT(sal.liqamount# * 100 + .5) / 100
	sal.puramount# = INT(sal.puramount# * 100 + .5) / 100
	sal.gain# = INT(sal.gain# * 100 + .5) / 100

	GOSUB pagehead
	PRINT #2, "          ------   ---------    ---------    ---------    ----------"
	PRINT #2, USING "          \    \########.### #########.## #########.## ##########.##"; old.liqdate$, sal.shares#, sal.liqamount#, sal.puramount#, sal.gain#
	PRINT #2, " "

	sal.shares# = 0
	sal.liqamount# = 0
	sal.puramount# = 0
	sal.gain# = 0

	lines% = lines% + 3
       
	RETURN

REM -----------------------------------
REM Subroutine to print total when liquidation year changes

yearfoot:
	yer.shares# = INT(yer.shares# * 1000 + .5) / 1000
	yer.liqamount# = INT(yer.liqamount# * 100 + .5) / 100
	yer.puramount# = INT(yer.puramount# * 100 + .5) / 100
	yer.gain# = INT(yer.gain# * 100 + .5) / 100

	GOSUB pagehead
	PRINT #2, "          ------   ---------    ---------    ---------    ----------"
	PRINT #2, USING "    Total \    \########.### #########.## #########.## ##########.##"; old.liqyear$, yer.shares#, yer.liqamount#, yer.puramount#, yer.gain#

	PRINT #2, " "

	yer.shares# = 0
	yer.liqamount# = 0
	yer.puramount# = 0
	yer.gain# = 0

	lines% = lines% + 3
      
	RETURN

REM ----------------------------------
REM Subroutine to print grand total

totlfoot:
	tot.shares# = INT(tot.shares# * 1000 + .5) / 1000
	tot.liqamount# = INT(tot.liqamount# * 100 + .5) / 100
	tot.puramount# = INT(tot.puramount# * 100 + .5) / 100
	tot.gain# = INT(tot.gain# * 100 + .5) / 100

	GOSUB pagehead
	PRINT #2, "                   =========    =========    =========    =========="
	PRINT #2, USING "    Grand Total ########.### #########.## #########.## ##########.##"; tot.shares#, tot.liqamount#, tot.puramount#, tot.gain#
	PRINT #2, " "

	tot.shares# = 0
	tot.liqamount# = 0
	tot.puramount# = 0
	tot.gain# = 0
       
	RETURN

REM ----------------------------------
REM Subroutine to print page heading

pagehead:
	IF lines% >= pagesize% THEN
		GOSUB endpage
		lines% = 0
		PRINT #2, header$
		PRINT #2, " "
		PRINT #2, " Date      Date      Shares       Sales       Purchase      Capital"
		PRINT #2, "Bought     Sold                   Amount       Amount        Gains"
		PRINT #2, "------    ------    --------    ---------    ---------    ----------"
	END IF

	lines% = lines% + 1
	RETURN

REM ----------------------------------
REM Subroutine to handle end of page

endpage:
	IF herebefore$ = "Y" THEN
		IF dis$ = "Y" THEN
			LOCATE 25, 1
			INPUT "Press ENTER to continue"; NULL$
			CLS
		ELSEIF lpt$ = "Y" THEN
			PRINT #2, CHR$(12)
		END IF
	ELSE
		IF dis$ = "Y" THEN
			CLS
		ELSEIF lpt$ = "Y" THEN
			PRINT "Ready " + out.filespec$ + " and set form to top of page"
			INPUT "Press ENTER when ready"; NULL$
		END IF
	END IF
	herebefore$ = "Y"
	RETURN

REM ----------------------------------
REM Subroutine to convert lower to upper case

lctouc:
	FOR c% = 1 TO LEN(s$)
		IF (ASC(MID$(s$, c%, 1)) >= 97) AND (ASC(MID$(s$, c%, 1)) <= 122) THEN
			MID$(s$, c%, 1) = CHR$(ASC(MID$(s$, c%, 1)) - 32)
		END IF
	NEXT
	RETURN

REM ----------------------------------
REM Subroutine to test for existence of filespec

test.spec:
	file.error% = 0
	ON ERROR GOTO open.error
	OPEN inp.filespec$ FOR INPUT AS #4
	GOTO test.close

open.error:
	file.error% = 1
	RESUME NEXT

test.close:
	ON ERROR GOTO 0
	CLOSE #4
	IF file.error% THEN
		file.found% = 0
	ELSE
		file.found% = 1
	END IF

	RETURN

REM ----------------------------------
REM Subroutine to handle errors

err.handler:
	CLS
	LOCATE 1, 1
	PRINT SPACE$(28) + "Capital Gains Calculator"
	LOCATE 3, 1
	PRINT "Error in the following transactions:"
	PRINT "YYMMDD DDDDDDDDDDDDDDDDDDDDD AAAAAAAAAA PPPPPPPPPP SSSSSSSSS"
	PRINT inp.record$
	PRINT
	PRINT err.message$
	PRINT

	INPUT "Ignore(I) or Cancel(C) ? ", action$
	action$ = LEFT$(action$, 1)
	IF (action$ = "C") OR (action$ = "c") THEN
		SYSTEM
	END IF

	inp.amount# = 0
	inp.price# = 0
	inp.shares# = 0

	RETURN













		



