**    Test program       **
**    19.6.96            **
**      Pavlic Bogdan    **
***************************
          org   0000
ZASLON    RMB   $20          ; Zaslon=Display Buffer (only DISPLAY functions writes directly to LCD)
TOFS      RMB   2            ; Timer overflow counter
OC1S      RMB   2            ; OC1 counter
CURSOR    RMB   1            ; Virtual cursor

vectors   EQU   $ffd6

RDATLCDI  EQU   $1602        ; LCD port: SIM11 presumes 1600h as LCD port
DATLCDI   EQU   $1600
DATLCDD   EQU   $1601

DIODE1    EQU   $1e00        ; We will write to diodes
DIODE2    EQU   $1c00
DIODE3    EQU   $1a00

          org   $e000

start     lds   #$ff
          jmp   main

          include 'display.s'

initialo: jsr   lcd_init
          ldaa  #%00001110
          jsr   lcd_wri
          jsr   ClrCOP
          ldx   #!1000
          jsr   lcd_dly
          jsr   lcd_clr
          ldab  #$E
          jsr   lcd_cof
Konecx    jsr   lcd_clr
          rts

COP                                 ; this version of SIM11 has COP always on
OPCODE    ldx   #$fffe              ; like 9h in CONFIG register
          jmp   0,x

InitCop   ldaa  $1039
          anda  #$ff-3
          oraa  #$a
          staa  $1039
          rts

ClrCOP    psha
          ldaa  #$55
          staa  $103A
          ldaa  #$AA
          staa  $103A
          pula
          rts

main      jsr   InitCOP          ; Initialize COP timer
          jsr   ClrCOP
          jsr   initialo         ; Initialize LCD
          jsr   ClrCOP

          ldaa  #$80             ; OC enable
          staa  $1022
          ldaa  #$80             ; TOF enable
          staa  $1024

          ldx   #0
          stx   TOFS
          stx   OC1S

          jsr   clrscr
          cli

mainloop  clr   CURSOR
          ldd   TOFS
          jsr   lcd_16dd        ; print number of Timer Overflow Interrupts
          ldab  #8
          stab  CURSOR
          ldd   OC1S
          jsr   lcd_16dd
          jsr   ClrCOP
          bra   mainloop

OCR1INT   ldx   #$1000
          bclr  $23,x,$7F
          ldd   #!50000         ; Interrupt every 25 ms
          addd  $1016
          std   $1016
          ldx   OC1S
          inx
          stx   OC1S
          ldaa  OC1S+1
          staa  DIODE1
nouse     rti

TOF       ldx   #$1000
          bclr  $25,x,$7F
          ldx   TOFS
          inx
          stx   TOFS
          ldaa  TOFS+1
          staa  DIODE2
          jsr   DISPLAY
          rti

          org   vectors
          fdb   nouse            ; SCI interrupt
          fdb   nouse
          fdb   nouse
          fdb   nouse
          fdb   TOF
          fdb   nouse
          fdb   nouse
          fdb   nouse
          fdb   nouse
          fdb   OCR1INT      ;e8
          fdb   nouse        ;ea
          fdb   nouse        ;ec
          fdb   nouse        ;ee
          fdb   nouse        ;f0
          fdb   nouse        ;f2
          fdb   nouse        ;f4
          fdb   nouse        ;f6
          fdb   OPCODE       ;f8
          fdb   COP          ;fa
          fdb   start        ;fc
          fdb   start        ;fe

          end
**********************************
