unit jppat;

{
This unit was written for JugglePro on March 17, 1993
}

Interface

function p(ha,ta:integer):integer; {transform from 2-d to 1-d}
function p3(ha,ma,ta:integer):integer; {transform from 3-d to 1-d}
procedure clear;      {clear pattern}
procedure zerohilite; {clear highlighted vectors}
procedure resetpw;    {reset pattern window vertical scroll pmtrs}
function findn:integer; {find number of balls being juggled}
procedure loadpattern;
procedure putpattern(filename:string);
procedure savepattern;
procedure permuteseq;   {permute a sequence of vectors}
procedure delpat(s,nn:integer);  {delete frames s+1 to nn-1}
procedure synctoasync;  {convert sync pattern to async by adding (0,0)'s}
procedure pwindow(hh,mm:byte);  {make window for pattern display}
procedure display;      {display pattern}
procedure getvectorseq(var x,y:byte);  {get vector sequence--start at x,y}
procedure permute; {allow user to perform permutation(s) on pattern}
procedure define;  {allow user to define pattern vectors}
procedure hands;   {user may change number of hands (h)}
procedure period;  {user may change period of pattern (l)}
procedure multiplex;  {user may change multiplexity (m)}
procedure editstartup;  {user may change startup and endup (repeat)}
procedure translate;  {allow user to perform local or global translation}
procedure conversions;  {allow user to enter pattern in other notation}
procedure asyncon;    {turn async mode on}
procedure syncon;     {turn async mode off}
procedure invertpattern;  {invert the pattern w.r.t. time}

Implementation
uses crt,graph,header,demoinput,jpdos,jpfcts,jphands,convert;

function p(ha,ta:integer):integer;
begin
  p:=(ha-1)*l+ta;
end;

function p3(ha,ma,ta:integer):integer;
begin
  p3:=p((ha-1)*m+ma,ta);
end;

procedure clear;
var
  i,j:byte;

begin
  n:=0;
  for i:=1 to h*m do
    for j:=1 to l do
      begin
        rh[p(i,j)]:=0;
        rt[p(i,j)]:=0;
      end;
end;

procedure zerohilite;
var
  i,j:byte;
begin
  for j:=1 to l do
    for i:=1 to h*m do
      hilite[i,j]:=false;
end;

procedure resetpw;
begin
  pw0:=1;                     {first row of pattern = 1}
  if h*m>9 then pwf:=9        {last row = 9}
            else pwf:=h*m;    {last row = h*m}
end;

function findn:integer;
var
  tmp:integer;
  i,j:byte;
                           {finds n, the number of balls}
begin
  if (l>0) and (h>0) and (m>0) then
  begin
    tmp:=0;
    for i:=1 to h*m do
      for j:=1 to l do
        tmp:=tmp+rt[p(i,j)];
    findn:=tmp div l;        {take average of throw-heights over period}
  end;
end;


procedure loadpattern;
var
  inn:text;
  filename:string[40];
  oldx,x,i,j,k:byte;
  line:string;
  e,v:integer;

begin
  window(1,2,79,25);
  clrscr;
  filename:=getfilename('pat');
  clrscr;
  if filename='.pat' then exit;
  assign(inn,path+filename);
  {$i-}
  reset(inn);
  {$i+}
  if ioresult<>0
   then hitenter('Pattern file missing!')
   else
     begin
       readln(inn,line);
       x:=pos('x',line);
       val(copy(line,1,x-1),h,e);
       val(copy(line,x+1,length(line)-x),l,e);
       v:=0;
       i:=0;
       startup:=1;
       repeat
         repeat
         readln(inn,line);
         if line[1]='m'
          then
           begin
             x:=1;
             k:=k+1;
           end
          else
           begin
            i:=i+1;
            x:=0;
            m:=k;
            k:=1;
           end;
         if (line[1]='m') or (line[1]='(') then
           begin
             for j:=1 to l do
               begin
                 v:=v+1;
                 repeat
                   x:=x+1;
                 until (line[x]='(') or (line[x]=' ');
                 if line[x]=' ' then
                   begin
                     if (i=1) and (k=1) then
                       begin
                         if startup=1 then startup:=v
                                      else endup:=v-1;
                       end;
                     repeat
                       x:=x+1;
                     until (line[x]='(');
                   end;
                 oldx:=x;
                 repeat
                   x:=x+1;
                 until line[x]=',';
                 val(copy(line,oldx+1,x-oldx-1),rh[v],e);
                 oldx:=x;
                 repeat
                   x:=x+1;
                 until line[x]=')';
                 val(copy(line,oldx+1,x-oldx-1),rt[v],e);
               end;
           end;
         until line[1]<>'m';
       until i>h;
       val(line,n,e);
       if startup=1 then endup:=l;
       close(inn);
       zerohilite;
       hact:=h;
       if asyncflag then hact:=h+h;
       resetpw;
       window(1,2,79,25);
       clrscr;
      end;
end;

procedure putpattern(filename:string);
var
  out:text;
  i,j,k:byte;

begin
  assign(out,filename);
  rewrite(out);
  writeln(out,h,'x',l);
  for i:=1 to h do
    begin
      for k:=1 to m do
        begin
          if k>1 then write(out,'m');
          for j:=1 to l do
            begin
              if (j=startup) and (j<>1) then write(out,' ');
              write(out,'(',rh[p3(i,k,j)],',',rt[p3(i,k,j)],')');
              if (j=endup) and (j<>l) then write(out,' ');
            end;
          writeln(out);
        end;
    end;
  writeln(out,n);
  close(out);
end;

procedure savepattern;
var
  filename:string[40];

begin
  window(1,2,79,8);
  clrscr;
  write('Filename:');
  readlndemo(filename);
  if pos('.',filename)=0 then filename:=filename+'.pat';
  putpattern(path+filename);
  clrscr;
end;

procedure permuteseq;
var
  th,tt,z1,z2:integer;
  oldvi,oldvj,k:byte;

begin
  th:=vi[1]+rh[p(vi[1],vj[1])];     {hold the first throw-vector in (th,tt)}
  tt:=vj[1]+rt[p(vi[1],vj[1])];
  oldvi:=vi[1];                     {also remember first position}
  oldvj:=vj[1];
  for k:=2 to seql do
    begin
      z1:=vi[k]+rh[p(vi[k],vj[k])]; {assign v[k] to z}
      z2:=vj[k]+rt[p(vi[k],vj[k])];
      rh[p(vi[k],vj[k])]:=th-vi[k]; {assign (th,tt) to v[k]}
      rt[p(vi[k],vj[k])]:=tt-vj[k];
      th:=z1;                       {assign z to (th,tt)}
      tt:=z2;
    end;
  rh[p(oldvi,oldvj)]:=th-oldvi;     {assign (th,tt) to oldv}
  rt[p(oldvi,oldvj)]:=tt-oldvj;
end;

procedure delpat(s,nn:integer);
var
  i,j:integer;

begin
  l:=l-nn;
  for i:=0 to h*m-1 do
    for j:=i*l+s to (l+nn)*h*m-nn do
      begin
        rh[j]:=rh[j+nn];
        rt[j]:=rt[j+nn];
      end;
end;

procedure synctoasync;
var
  ll,j,k,hh,mm,newhh,throwhm,throwh,throwm,throwt:integer;

function newrow(hh,ll:integer):integer;
begin
  newrow:=(hh-1)*2+(ll mod 2)+1;
end;

begin
  if ((startup=1) and (l mod 2 = 1))
  or ((startup>1) and ((endup-startup+1) mod 2 = 1)) then
    begin
      for ll:=1 to l do
        for j:=1 to h do
        begin
          hh:=h+1-j;
          for k:=1 to m do
            begin
              mm:=m+1-k;
              throwh:=rh[p3(hh,mm,ll)];
              throwt:=rt[p3(hh,mm,ll)];
              l:=l+l;
              rh[p3(hh,mm,ll)]:=throwh;
              rt[p3(hh,mm,ll)]:=throwt;
              rh[p3(hh,mm,ll+l div 2)]:=throwh;
              rt[p3(hh,mm,ll+l div 2)]:=throwt;
              l:=l div 2;
            end;
        end;
      l:=l+l;
      if (startup>1) then
        begin
          k:=endup+1;
          delpat(k,startup-1+l div 2-endup);
          endup:=endup+endup-startup+1;
        end
      else
          endup:=endup+endup;
    end;

  for ll:=1 to l do
  begin
    for j:=0 to h-1 do
    begin
      hh:=h-j;
      for mm:=1 to m do
      begin
        newhh:=newrow(hh,ll);
        throwhm:=rh[p3(hh,mm,ll)]+(hh-1)*m+mm;
        throwh:=(throwhm-1) div m +1;
        throwm:=(throwhm-1) mod m +1;
        throwt:=rt[p3(hh,mm,ll)]+ll;
        rh[p3(newhh,mm,ll)]:=(newrow(throwh,throwt)-1)*m+throwm-(newhh-1)*m-mm;
        rt[p3(newhh,mm,ll)]:=throwt-ll;
      end;
    end;
  end;
  h:=h+h;
  resetpw;
  hact:=hact+hact;
  for ll:=1 to l do
    for hh:=1 to h do
      for mm:=1 to m do
        begin
          if (hh+ll) mod 2 = 0
            then begin
                   rh[p3(hh,mm,ll)]:=0;
                   rt[p3(hh,mm,ll)]:=0;
                 end;
        end;
zerohilite;
end;

procedure pwindow(hh,mm:byte);
begin
  if hh*mm>9
   then window(1,14,79,25)
   else window(1,23-hh*mm,79,25);
end;

procedure display;
var
  i,j,k:byte;
  sgn,trt,trh:integer;
  c1,c2,s:string;

begin
  pwindow(h,m);
  textcolor(txt1);
  textbackground(colr1);
  setallpalette(ipt);
  clrscr;
  write('h=',h,'   l=',l,'   ');
  if asyncflag then write('a');
  write('sync / ');
  if not holdflag then write('no ');
  writeln('hold');
  textbackground(colr3);
  for i:=scroll to l do
    if i<scroll+10 then
      begin
        write('  ');
        if (i=startup) or (i=endup+1) then write(' | ')
                                      else write('   ');
        write(i:2);
      end;
  writeln('    ');
  for i:=pw0 to pwf do
    begin
      k:=(i-1) mod m +1;
      textbackground(colr3);
      if k=1 then write('h',((i-1) div m)+1:2,'|')
             else write('  m|');
      textbackground(colr1);
      for j:=scroll to l do
        if j<scroll+10 then
        begin
          if (j>=startup) and (j<=endup) then
          begin
            textcolor(txt1);
            textbackground(colr2);
          end;
          if hilite[i,j] then
          begin
            textcolor(txt1);
            textbackground(black);
          end;
          trt:=rt[p(i,j)];
          trh:=rh[p(i,j)];
          c1:='+';
          c2:=c1;
          sgn:=1;
          if trt<0 then
            begin
              c1:='-';
              sgn:=-1;
            end;
          c1:=c1+cvtnumtohex(sgn*trt);
          sgn:=1;
          if trh<0 then
            begin
              c2:='-';
              sgn:=-1;
            end;
          c2:=c2+cvtnumtohex(sgn*trh);
          write('(',c2,',',c1,')');
          textcolor(txt1);
          textbackground(colr1);
        end;
      writeln;
    end;
  write(n,' objects');
end;

procedure getvectorseq(var x,y:byte);
var
  ch1,ch2:char;
  ohilite:boolean;

begin
  window(1,20-(pwf-pw0),79,21-(pwf-pw0));
  textcolor(black);
  textbackground(white);
  clrscr;
  writeln('|Arrow keys move|Spacebar selects|Backspace deletes last selection|');
  write('|Esc clears all selections|Enter exits|');
  seql:=0;
  zerohilite;
  hilite[x,y]:=true;
  display;
  hilite[x,y]:=false;
  repeat
    ch1:=readkeydemo;
    if ch1=chr(0) then
      begin
        ch2:=readkeydemo;
        if ch2='H' then x:=x-1;
        if ch2='P' then x:=x+1;
        if ch2='M' then y:=y+1;
        if ch2='K' then y:=y-1;
        if x<1 then x:=h*m;
        if x>h*m then x:=1;
        if x<pw0 then
          begin
            pw0:=x;
            pwf:=x+8;
            if pwf>h*m then pwf:=h*m;
          end;
        if x>pwf then
          begin
            pwf:=x;
            pw0:=x-8;
          end;
        if y<1 then y:=l;
        if y>l then y:=1;
        if y<scroll then scroll:=y;
        if y>scroll+9 then scroll:=y-9;
      end
    else
      begin
        if ch1=chr(27) then
          begin
            seql:=0;
            zerohilite;
          end;
        if (ch1=chr(8)) and (seql>0) then
          begin
            hilite[vi[seql],vj[seql]]:=false;
            seql:=seql-1;
            if seql>0 then
              begin
                x:=vi[seql];
                y:=vj[seql];
              end;
          end;
        if ch1=' ' then
          begin
            seql:=seql+1;
            vi[seql]:=x;
            vj[seql]:=y;
            hilite[x,y]:=true;
          end;
      end;
    ohilite:=hilite[x,y];
    hilite[x,y]:=true;
    display;
    hilite[x,y]:=ohilite;
  until ch1=chr(13);
  zerohilite;
  window(1,20-(pwf-pw0),79,21-(pwf-pw0));
  clrscr;
end;

procedure permute;
var
  x,y:byte;

begin
  x:=1;
  y:=1;
  resetpw;
  window(1,2,79,8);
  clrscr;
  writeln('                           PERMUTE SEQUENCE');
  writeln('Select vector sequence to permute.');
  writeln('Type ENTER to exit.');
  repeat
  getvectorseq(x,y);
  if seql>1 then permuteseq;
  display;
  until seql=0;
  textbackground(colr1);
  window(1,2,79,8);
  clrscr;
end;

procedure define;
var
  i,j,s,x,y,z,k,xx,yy:byte;
  e,zz:integer;
  vector:string;
  okflag:boolean;

begin
  xx:=1;
  yy:=1;
  resetpw;
  window(1,2,79,8);
  clrscr;
  writeln('                         DEFINE PATTERN');
  writeln('This allows you to modify the pattern directly.');
  writeln('Type:  label=(newrh,newrt) EXAMPLE:  (1,3) and enter');
  writeln('Then select vectors.');
  writeln('CAUTION:  A pattern defined incorrectly will error upon show.');
  writeln('Type ENTER to exit');
  repeat
    window(1,9,79,10);
    clrscr;
    gotoxy(1,9);
    repeat
    write('vector:');
    readlndemo(vector);
    if length(vector)>0 then
      begin
        x:=pos('(',vector);
        y:=pos(',',vector);
        z:=pos(')',vector);
      end;
    if (x+1<y) and (y+1<z) then
      okflag:=true
    else begin
           okflag:=false;
           if length(vector)>0 then writeln('syntax error');
         end;
    until okflag or (length(vector)=0);
    if length(vector)>0 then
      begin
        getvectorseq(xx,yy);
        if seql>0 then
          begin
            for k:=1 to seql do
              begin
                i:=vi[k];
                j:=vj[k];
                val(copy(vector,x+1,y-1-x),rh[p(i,j)],e);
                if e<>0 then writeln('arg error');
                val(copy(vector,y+1,z-1-y),rt[p(i,j)],e);
                if e<>0 then writeln('arg error');
              end;
          end;
        display;
      end;
   until length(vector)=0;
   textbackground(colr1);
   window(1,2,79,10);
   clrscr;
   n:=findn;
end;


procedure hands;
var
  i,j,maxh,oldh:byte;

begin
  oldh:=h;
  window(1,2,79,8);
  clrscr;
  maxh:=20;
  if 40 div m < maxh then maxh:=40 div m;
  h:=changeval(h,'number of hands',1,maxh);
  if h*m*l>800 then
    begin
      errmsg:='Pattern memory exceeded';
      h:=oldh;
    end;
  if h>oldh then
    begin
      for i:=oldh*m+1 to h*m do
        for j:=1 to l do
          begin
            rh[p(i,j)]:=0;
            rt[p(i,j)]:=0;
          end;
    end;
  if asyncflag then hact:=h+h
               else hact:=h;
  if hact>20 then
    begin
      errmsg:='Too many hands; Sync mode entered';
      asyncflag:=false;
      hact:=h;
    end;
  if h<>oldh then setuphands;
  clrscr;
  zerohilite;
  pwindow(oldh,m);
  clrscr;
  resetpw;
end;

procedure period;
var
  tmph,tmpt:pattern;
  i,j,oldl:byte;
  idx1,idx2:integer;

begin
  window(1,2,79,8);
  clrscr;
  oldl:=l;
  l:=changeval(l,'period',1,50);
  if h*m*l>800 then
    begin
      errmsg:='Pattern memory exceeded';
      l:=oldl;
    end;
  if l<>oldl then
    begin
      for i:=1 to l do
        for j:=1 to m*h do
          begin
            idx1:=p(j,i);
            if i<=oldl then
             begin
               idx2:=i+(j-1)*oldl;
               tmph[idx1]:=rh[idx2];
               tmpt[idx1]:=rt[idx2];
             end
            else
             begin
               tmph[idx1]:=0;
               tmpt[idx1]:=0;
             end;
          end;
      for i:=1 to l do
        for j:=1 to m*h do
          begin
            idx1:=p(j,i);
            rh[idx1]:=tmph[idx1];
            rt[idx1]:=tmpt[idx1];
          end;
    end;
  zerohilite;
  startup:=1;
  endup:=l;
  clrscr;
end;

procedure multiplex;
var
  mmax,oldm:byte;

begin
  window(1,2,79,8);
  clrscr;
  oldm:=m;
  mmax:=10;
  if 40 div h < mmax then mmax:=40 div h;
  m:=changeval(m,'multiplex',1,mmax);
  if h*m*l>800 then
  begin
    errmsg:='Pattern memory exceeded';
    m:=oldm;
  end;
  clear;
  zerohilite;
  resetpw;
  clrscr;
  pwindow(h,oldm);
  clrscr;
end;

procedure editstartup;
begin
  window(1,2,79,8);
  clrscr;
  writeln('Current repeat is from frame ',startup,' to ',endup,'.');
  startup:=changeval(startup,'startup frame',1,l);
  if startup<l then
    endup:=changeval(endup,'endup frame',startup,l)
  else endup:=l;
  clrscr;
end;

procedure translate;
var
  x,y,s,k,i,j:byte;
  t,sign,z,e:integer;
  ch1,ch2:char;
  ohilite:boolean;
  seq:string;

begin
  window(1,2,79,8);
  writeln('                              TRANSLATE SYSTEM');
  writeln;
  writeln('You may translate in two ways: Global and Local.');
  writeln('Global causes all vectors to be translated by the entered number.');
  writeln('Local allows vectors to be changed singly by +-(0,',l,')');
  writeln('EXAMPLES: Type "G" and "1" and hit enter');
  writeln('          Type "L" and select vectors');
  writeln;
  write('Global or Local (G/L)?');
  ch:=readkeydemo;
  writeln(ch);
  if (ch<>'G') and (ch<>'g') then
      begin
        window(1,20-(pwf-pw0),79,21-(pwf-pw0));
        textcolor(black);
        textbackground(white);
        clrscr;
        writeln('|Arrow keys move|Spacebar or + increases vector|');
        write('|- decreases vector|Enter exits|');
        zerohilite;
        x:=pw0;
        y:=1;
        hilite[x,y]:=true;
        display;
        hilite[x,y]:=false;
        repeat
          ch1:=readkeydemo;
          if ch1=chr(0) then
            begin
              ch2:=readkeydemo;
              if ch2='H' then x:=x-1;
              if ch2='P' then x:=x+1;
              if ch2='M' then y:=y+1;
              if ch2='K' then y:=y-1;
              if x<1 then x:=h*m;
              if x>h*m then x:=1;
              if x<pw0 then
                begin
                  pw0:=x;
                  pwf:=x+8;
                  if pwf>h*m then pwf:=h*m;
                end;
              if x>pwf then
                begin
                  pwf:=x;
                  pw0:=x-8;
                end;
              if y<1 then y:=l;
              if y>l then y:=1;
              if y<scroll then scroll:=y;
              if y>scroll+9 then scroll:=y-9;
            end
          else
            begin
              if (ch1='-') or (ch1='+') or (ch1=' ') then
               begin
                 sign:=1;
                 if ch1='-' then sign:=-1;
                 rt[p(x,y)]:=rt[p(x,y)]+sign*l;
                 n:=n+sign;
               end;
            end;
          ohilite:=hilite[x,y];
          hilite[x,y]:=true;
          display;
          hilite[x,y]:=ohilite;
        until ch1=chr(13);
        zerohilite;
        scroll:=1;
        window(1,20-(pwf-pw0),79,21-(pwf-pw0));
        clrscr;
      end
 else begin
        write('Enter #:');
        readlndemo(seq);
        val(seq,t,e);
        for i:=1 to h*m do for j:=1 to l do
               rt[p(i,j)]:=rt[p(i,j)]+t;
        n:=n+h*m*t;
      end;
  display;
  textbackground(colr1);
  window(1,2,79,8);
  clrscr;
end;

procedure conversions;
var
  s:string;
  mode:char;

begin
  window(1,2,79,8);
  writeln('                  CONVERSIONS');
  writeln('Patterns given in Jack Boyce''s notation schemes for various modes');
  writeln('are converted to the multi-hand notation scheme used here (MHN).');
  writeln('Each throw''s air-time can be from 0 to 9.  Numbers greater than');
  writeln('9 are represented by A for 10, B for 11, etc.  For information on');
  writeln('Boyce''s notation please read the description in the help menu.');
  writeln;
  writeln('Modes                       Example Patterns');
  writeln('a = async or siteswap       441 or 24[45] or CAB');
  writeln('s = sync solo               (6x,4)(6x,2)(0,[4x2x])');
  writeln('p = passing                 <4p|3><2|3p>');
  writeln('c = custom                  <2|3:3|3:1><2:2|3:3|3:2><[3:3/2]|3|3:1>');
  writeln;
  write('Mode: ');
  mode:=readkeydemo;
  writeln(mode);
  write('Enter pattern: ');
  readlndemo(s);
  if length(s)>0 then anim(mode,s);
  resetpw;
  clrscr;
end;

procedure asyncon;
begin
  if h<11 then
    begin
      asyncflag:=true;
      hact:=h+h;
    end
  else errmsg:='Please reduce h so h<=10';
end;

procedure syncon;
begin
  asyncflag:=false;
  hact:=h;
end;

procedure invertpattern;
var
 i,j,q,r,idx1,idx2:integer;
 invh,invt:pattern;
 tmpx,tmpy,tmpz:array [1..3,1..400] of integer;
 o:byte;

begin
  for i:=1 to h*m do
    for j:=1 to l do
      begin
        q:=(rt[p(i,j)]+j-1) div l;
        r:=(rt[p(i,j)]+j-1)-l*q+1;
        idx1:=p(rh[p(i,j)]+i,r);
        invh[idx1]:=i;
        invt[idx1]:=j-l*q;
      end;
  for i:=1 to h*m do
    for j:=1 to l do
      begin
        idx1:=p(i,j);
        idx2:=p(i,l-j+1);
        rh[idx2]:=invh[idx1]-i;
        rt[idx2]:=-(invt[idx1]-j);
      end;
  startup:=1;
  endup:=l;
  if asyncflag then firstthrow:=1-firstthrow;
  if moveflag then
   begin
    for i:=1 to nt*ti do
      for j:=1 to hact do
        for o:=1 to 3 do
          begin
            tmpx[o,hi(j,i)]:=hpx[o,hi(j,i)];
            tmpy[o,hi(j,i)]:=hpy[o,hi(j,i)];
            tmpz[o,hi(j,i)]:=hpz[o,hi(j,i)];
          end;
    for i:=1 to nt*ti do
      for j:=1 to hact do
        for o:=1 to 3 do
          begin
            idx1:=2-i;
            if idx1<1 then idx1:=idx1+nt*ti;
            hpx[o,hi(j,i)]:=tmpx[o,hi(j,idx1)];
            hpy[o,hi(j,i)]:=tmpy[o,hi(j,idx1)];
            hpz[o,hi(j,i)]:=tmpz[o,hi(j,idx1)];
          end;
    i:=nt*ti+1;
    for j:=1 to hact do
     for o:=1 to 3 do
      begin
       hpx[o,hi(j,i)]:=hpx[o,hi(j,1)];
       hpy[o,hi(j,i)]:=hpy[o,hi(j,1)];
       hpz[o,hi(j,i)]:=hpz[o,hi(j,1)];
      end;
   end;
end;

begin
  scroll:=1;
  h:=2;
  l:=2;
  m:=1;
  startup:=1;
  endup:=l;
  n:=0;
  asyncflag:=false;
  holdflag:=true;
  zerohilite;
  resetpw;
  clear;
end.
