/*
 * These functions do the pop-up pull-down command menus.
 *
 * Being stupid, I can't remember what half the function keys do.
 *  Fortunately, it is very easy to write a pop-up pull-down command menu
 *  to run editor commands.  Being lazy, I didn't implement CUA style menus,
 *  because we can provide most of the CUA benefits with a single hot-key.
 *  Also, dumb UNIX terminals don't have a lot function keys to spare.
 *
 * New editor name:  TDE, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1991, version 1.0
 * Date:             July 29, 1991, version 1.1
 * Date:             October 5, 1991, version 1.2
 * Date:             January 20, 1992, version 1.3
 * Date:             February 17, 1992, version 1.4
 * Date:             April 1, 1992, version 1.5
 * Date:             June 5, 1992, version 2.0
 * Date:             October 31, 1992, version 2.1
 * Date:             April 1, 1993, version 2.2
 * Date:             June 5, 1993, version 3.0
 * Date:             August 29, 1993, version 3.1
 * Date:             November 13, 1993, version 3.2
 * Date:             June 5, 1994, version 4.0
 * Date:             December 5, 1998, version 5.0 (jmh)
 *
 * This code is released into the public domain, Frank Davis.
 *    You may distribute it freely.
 */

#include "tdestr.h"
#include "common.h"
#include "define.h"
#include "tdefunc.h"


static int saved_major = 0;

static int major_col[MAJOR];         /* jmh - made these global so it's only */
static int major_width[MAJOR];       /*  necessary to calculate them once */


/*
 * Name:    main_pull_down
 * Purpose: show pull down menu and call function if needed
 * Date:    November 13, 1993
 * Passed:  window:  current window
 * Notes:   keep a record of the last menu choice in local global variables.
 *
 * jmh 980826: record the function selected.
 */
int  main_pull_down( TDE_WIN *window )
{
int rc;
int ch;
int row;
int major_choice;
int minor_choice;
DISPLAY_BUFF;

   rc = ERROR;
   row = 0;
   major_choice = saved_major;
   minor_choice = menu[saved_major].current;
   save_screen_line( 0, row, display_buff );
   ch = lite_bar_menu( &major_choice, &minor_choice );
   restore_screen_line( 0, row, display_buff );
   saved_major = major_choice;
   if (ch == OK) {
      g_status.command = menu[major_choice].minor[minor_choice].minor_func;
      g_status.control_break = FALSE;
      if (g_status.command >= 0 && g_status.command < NUM_FUNCS) {
         record_key( 0, g_status.command );
         rc = (*do_it[g_status.command])( window );
      } else
         rc = ERROR;
   }
   return( rc );
}


/*
 * Name:    lite_bar_menu
 * Purpose: handle major menu choices
 * Date:    November 13, 1993
 * Passed:  maj: pointer to menu bar choice
 *          min: pointer to function under menu
 * Returns: OK if selected, ERROR if aborted.
 * Notes:   set the menu structures
 */
int  lite_bar_menu( int *maj, int *min )
{
int col;
int row;
int wid;
int ch;

   /*
    * put the pull-down menu on the first line of screen.
    */
   col = row = 0;
   eol_clear( col, row, g_display.head_color );
   draw_lite_head( row, major_col );

   xygoto( -1, -1 );
   ch = -1;
   while (ch != AbortCommand  &&  ch != Rturn) {
      if (ch == CharRight || ch == CharLeft) {
         hlight_line( major_col[*maj], row, major_width[*maj],
                      g_display.mode_color );
         if (ch == CharRight) {
            ++*maj;
            if (*maj >= MAJOR)
               *maj = 0;
         } else {
            --*maj;
            if (*maj < 0)
               *maj = MAJOR - 1;
         }
         *min = menu[*maj].current;
         ch = -1;
      }
      if (ch == -1) {
         hlight_line( major_col[*maj], row, major_width[*maj],
                      g_display.block_color );
#if defined( __UNIX__ )
         refresh( );
#endif
      }

      col = major_col[*maj];
      wid = menu[*maj].width;
      if (col + wid + 1 > g_display.ncols - 1)
         col = g_display.ncols - 1 - wid;
      *min = pull_me( *maj, *min, row+1, col, &ch );
   }
   return( (ch == AbortCommand) ? ERROR : OK );
}


/*
 * Name:    pull_me
 * Purpose: move cursor up and down the menu bar
 * Date:    November 13, 1993
 * Passed:  maj: main menu bar choice
 *          min: subfunction choice
 *          row: row to begin vertical choice
 *          col: column to begin vertical choice
 *          ch:  pointer to current function (key)
 * Returns: position within menu, or ERROR if it couldn't save the screen;
 *          ch is set to the function of the last key pressed
 * Notes:   save the text under the pulled down menu
 */
int  pull_me( int maj, int min, int row, int col, int *ch )
{
long key;
int  i;
int  minor_width;
int  cnt;
int  select;
int  begin;
int  end;
Char *buffer;

   cnt = menu[maj].minor_cnt;
   minor_width = menu[maj].width;
   begin = menu[maj].first;
   end   = menu[maj].last;

   select = min;
   if (menu[maj].minor[select].minor_func < 0)
      select = begin;

   buffer = (Char *)malloc( minor_width * cnt * sizeof(Char) );
   if (buffer != NULL) {
      save_area( buffer, minor_width, cnt, row, col );
      for (i = 0; i < cnt; i++)
         s_output( menu[maj].minor[i].minor_name, row+i, col,
                   g_display.help_color );

      hlight_line( col+1, row+select, minor_width-2, g_display.hilited_file );
      while (*ch != AbortCommand && *ch != Rturn &&
             *ch != CharRight    && *ch != CharLeft) {
         if (*ch == LineDown) {
            hlight_line( col+1, row+select, minor_width-2,
                         g_display.help_color );
            ++select;
            while (menu[maj].minor[select].minor_func < 0)
               ++select;
            if (select >= cnt)
               select = begin;
            hlight_line( col+1, row+select, minor_width-2,
                         g_display.hilited_file );
         } else if (*ch == LineUp) {
            hlight_line( col+1, row+select, minor_width-2,
                         g_display.help_color );
            --select;
            while (menu[maj].minor[select].minor_func < 0)
               --select;
            if (select < 0)
               select = end;
            hlight_line( col+1, row+select, minor_width-2,
                         g_display.hilited_file );
         }

#if defined( __UNIX__ )
         refresh( );
#endif

         key = getkey( );
         *ch = (key == RTURN) ? Rturn        :
               (key == ESC)   ? AbortCommand :
               getfunc( key );
      }
      restore_area( buffer, minor_width, cnt, row, col );
      free( buffer );
      menu[maj].current = select;
   } else {
      select = ERROR;
      *ch = AbortCommand;
   }
   return( select );
}


/*
 * Name:    get_bar_spacing
 * Purpose: calculate headings for main menu choices
 * Date:    November 13, 1993
 * Passed:  col: col of first menu choice
 *          major_col: column to display each menu heading
 *          major_width: width of each menu heading
 * Notes:   assume 6 spaces between the menu items
 */
void get_bar_spacing( int col, int major_col[], int major_width[] )
{
int i, j;

   for (i=j=0; i< MAJOR; i++) {
      major_col[i]   = col+j;
      major_width[i] = strlen( menu[i].major_name );
      j += major_width[i] + 6;
   }
}


/*
 * Name:    draw_lite_head
 * Purpose: slap the main menu choices on the lite bar
 * Date:    November 13, 1993
 * Passed:  row: lite bar row
 *          major_col: column to display each menu heading
 */
void draw_lite_head( int row, int major_col[] )
{
int i;

   for (i=0; i< MAJOR; i++)
      s_output( menu[i].major_name, row, major_col[i], g_display.mode_color );

#if defined( __UNIX__ )
   refresh( );
#endif
}


/*
 * Name:    get_minor_counts
 * Purpose: determine the first and last valid selections
 * Date:    November 13, 1993
 * jmh 980809: this used to count the number of selections in the menu,
 *              but that's now done with the sizeof operator.
 *             By the way, it assumes there's something in the menu.
 */
void get_minor_counts( void )
{
int i;
int cnt;

   for (i=0; i<MAJOR; i++) {
      /*
       * find first valid minor selection.
       */
      for (cnt = 0; menu[i].minor[cnt].minor_func < 0; cnt++) ;
      menu[i].first = cnt;

      /*
       * find last valid minor selection
       */
      for (cnt = menu[i].minor_cnt; menu[i].minor[cnt].minor_func < 0; cnt--) ;
      menu[i].last = cnt;
   }
}


/*
 * Name:    init_menu
 * Purpose: initialise some menu "constants" and find key definitions
 * Author:  Jason Hood
 * Date:    30 December, 1996
 * Notes:   If a function is defined twice, the first found will be used
 *          Makes a duplicate of the menu, inserting the key definition
 *
 * 980524:  Create the menu frame from scratch.
 * 980803:  Made keys an array, rather than dynamic allocation.
 * 980819:  Create an array of keys based on function (is that right?).
 *          Recognize two-keys.
 */
void init_menu( void )
{
long func_key[NUM_FUNCS+1];     /* one more for TwoCharKey */
char *keys[MAX_LINES];
char *new_name;
char *item;
int  cnt;
int  len;
int  width;
int  wid;
int  func;
long key;
int  parent, child;
int  i, j;

   get_bar_spacing( 1, major_col, major_width );
   get_minor_counts( );

   memset( func_key, 0, sizeof(func_key) );
   for (i = 0; i < MAX_KEYS; ++i)
      if (key_func.key[i] != 0)
         func_key[key_func.key[i]] = i;
   for (i = 1; i < NUM_FUNCS; ++i)
      if (func_key[i] == 0)
         func_key[i] = cfg_search_tree( i, key_tree.right );

   for (i = 0; i < MAJOR; ++i) {
      cnt   = menu[i].minor_cnt;
      width = 0;                          /* Length of the longest function */
      wid   = 0;                          /* Length of the longest key */
      memset( keys, 0, sizeof(keys) );
      for (j = cnt - 1; j >= 0; --j) {
         len = strlen( menu[i].minor[j].minor_name );
         if (len > width) width = len;
         func = menu[i].minor[j].minor_func;
         if (func > 0 && func_key[func] > 0) {
            key    = func_key[func];
            parent = PARENT_KEY( key );
            if (parent) {
               parent -= 256;
               child = CHILD_KEY( key );
               len = strlen( key_word[parent] ) + 1;
               if (child == ' ')
                  len += strlen( key_word[0] );
               else if (child < 256)
                  ++len;
               else
                  len += strlen( key_word[child - 256] );
               keys[j] = malloc( len + 2 );
               strcpy( keys[j], key_word[parent] );
               strcat( keys[j], " " );
               if (child == ' ')
                  strcat( keys[j], key_word[0] );
               else if (child >= 256)
                  strcat( keys[j], key_word[child - 256] );
               else {
                  keys[j][len-1] = child;
                  keys[j][len]   = '\0';
               }
            } else {
               keys[j] = key_word[(int)key];
               len = strlen( keys[j] );
            }
            if (len > wid) wid = len;
         }
      }
      /* frame + space, function, two spaces, key, space + frame, NUL */
      len = 2 + width + 2 + wid + 2 + 1;
      /* Allocate the new menu strings in one block */
      new_name = malloc( len * cnt );

      new_name[0] = CORNER_LEFT_UP;
      memset( new_name+1, HORIZONTAL_LINE, len-3 );
      new_name[len-2] = CORNER_RIGHT_UP;
      new_name[len-1] = 0;
      menu[i].minor[0].minor_name = new_name;
      for (new_name += len, j = 1; j < cnt-1;
           new_name += len, ++j) {
         item = menu[i].minor[j].minor_name;
         if (*item == 0 || *item == HORIZONTAL_LINE) {
            new_name[0] = LEFT_T;
            memset( new_name+1, HORIZONTAL_LINE, len-3 );
            new_name[len-2] = RIGHT_T;
            if (*item == HORIZONTAL_LINE) {
               wid = strlen( item+1 );
               memcpy( new_name + (len-1-wid) / 2, item+1, wid );
            }
         } else {
            new_name[0] = new_name[len-2] = VERTICAL_LINE;
            memset( new_name+1, ' ', len-3 );
            memcpy( new_name+2, item, strlen( item ) );
            if (keys[j] != NULL) {
               wid = strlen( keys[j] );
               memcpy( new_name + len-3-wid, keys[j], wid );
               if (strchr( keys[j], ' ' ))
                  free( keys[j] );
            }
         }
         new_name[len-1] = 0;
         menu[i].minor[j].minor_name = new_name;
      }
      new_name[0] = CORNER_LEFT_DOWN;
      memset( new_name+1, HORIZONTAL_LINE, len-3 );
      new_name[len-2] = CORNER_RIGHT_DOWN;
      new_name[len-1] = 0;
      menu[i].minor[j].minor_name = new_name;

      menu[i].width = len-1;
   }
}
